<?php
function check_recaptcha(){
	$captcha=false;
	$sider_recaptcha=get_option( 'sider_recaptcha' );
	if($sider_recaptcha=='yes'){
		$captcha=true;
	}
	return $captcha;

}
function check_recaptcha_style(){
	$style='';
	$sider_recaptcha=get_option( 'sider_recaptcha' );
	if($sider_recaptcha=='yes'){
		$style='none';
	}
	return $style;
}
function encrypt($plainText, $key) {
	$secretKey = md5($key);
	$iv = substr( hash( 'sha256', "corsair2020" ), 0, 16 );
	$encryptedText = openssl_encrypt($plainText, 'AES-128-CBC', $secretKey, OPENSSL_RAW_DATA, $iv);
	return base64_encode($encryptedText);
}

    //Decrypt Function
function decrypt($encryptedText, $key) {
	$key = md5($key);
	$iv = substr( hash( 'sha256', "corsair2020" ), 0, 16 );
	$decryptedText = openssl_decrypt(base64_decode($encryptedText), 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $iv);
	return $decryptedText;
}
function get_all_user_role() {
	global $wp_roles;

	$all_roles = $wp_roles->roles;
	$editable_roles = apply_filters('editable_roles', $all_roles);

	return $editable_roles;

}

function get_user_roll_option(){
	$html='';
	$all_role=get_all_user_role();
	foreach ($all_role as $role => $details) {
		$html.='<option value="'. esc_attr($role).'">'.translate_user_role($details['name']).'</option>';
	}
	return $html;

}

function get_all_wp_user_list(){
	$user_list = array(
		'orderby' => 'user_email',
		'order' => 'ASC'
	);
	$lists = get_users($user_list);
	return $lists;
}
function get_wp_user_options($user_email='')
{
	$html='';
	$all_wp_user_list=get_all_wp_user_list();
	if(!empty($all_wp_user_list)){
		foreach ($all_wp_user_list as $key => $valueuser) {
			if($user_email==$valueuser->user_email){
				$selected='selected';
			}
			else{
				$selected='';
			}
			$html.='<option value="'.$valueuser->user_email.'" '.$selected.'>'.$valueuser->user_email.'</option>';
		}
	}
	else{
		$html.='<option value="">'.__("No email address found" , "corsair-login").'</option>';
	}
	return $html;
}

function get_selected_user_role($user_role=''){
	$html='';
	$all_role=get_all_user_role();
	foreach ($all_role as $role => $details) {
		if(esc_attr($role)==$user_role){
			$selected='selected';

		}
		else{
			$selected='';
		}
		$html.='<option value="'. esc_attr($role).'" '.$selected.'>'.translate_user_role($details['name']).'</option>';
	}
	return $html;
}

function get_menu_list($menu_name=''){
	$html='';
	$all_menu=get_terms( 'nav_menu', array( 'hide_empty' => true ) );

	if(!empty($all_menu)){
		$html.='<option value="">Select Menu</option>';
		foreach ($all_menu as $key_menu => $value_menu) {
			if($menu_name==$value_menu->slug){
				$selected='selected';

			}
			else{
				$selected='';
			}
			$html.='<option value="'. $value_menu->slug.'" '.$selected.'>'.$value_menu->name.'</option>';
		}
	}
	return $html;
}

function get_all_redirection_link(){
	$defualt_redirection_link=home_url();
	$all_rules=get_all_rules();
	$redirection_link=array();
	if(!empty($all_rules)){
		foreach ($all_rules as $key_rules => $value_rules) {
			$link=($value_rules->url_source == 'internal') ? get_the_permalink($value_rules->redirection_url) : $value_rules->redirection_url;
			if($value_rules->status==1){
				$redirection_link[$value_rules->user_role]= $link;
			}
			else{
				$redirection_link[$value_rules->user_role]= $defualt_redirection_link;
			}
			
			
		}
		

	}
	return $redirection_link;
}



function get_redirect_url($user_id){
	$url=home_url();
	$user_meta = get_userdata($user_id);
	$user_roles = $user_meta->roles;
	$redirection_array=get_all_redirection_link();
	if(!empty($redirection_array)){
		if (array_key_exists(strval($user_roles[0]), $redirection_array)) {
			$url= $redirection_array[$user_roles[0]];
		}
	}
	return $url;
}

function get_login_url(){
	$url=admin_url();
	$login_page_url=get_option( 'login_page_url' );
	if($login_page_url!=''){
		$url=get_the_permalink($login_page_url);
	}
	return $url;
}
function get_logout_redirect_url(){
	$url=home_url();
	$logout_redirect_link=get_option( 'logout_redirect' );
	if($logout_redirect_link!=''){
		$url=get_the_permalink($logout_redirect_link);
	}
	return $url;
}
function get_login_request_url(){
	$url='';
	$login_request_link=get_option( 'login_request_redirect' );
	if($login_request_link!=''){
		$url=get_the_permalink($login_request_link);
	}
	return $url;
}
function get_login_error_url(){
	$url='';
	$login_error_link=get_option( 'login_error_redirect' );
	if($login_error_link!=''){
		$url=get_the_permalink($login_error_link);
	}
	return $url;
}
function get_logout_error_url(){
	$url='';
	$logout_link=get_option( 'logout_redirect' );
	if($logout_link!=''){
		$url=get_the_permalink($logout_link);
	}
	return $url;
}


function check_local_user(){
	$result=false;
	$check_local_user=get_option( 'local_user' );
	if($check_local_user=='yes'){
		$result=true;	
	}
	return $result;
}

function check_local_custom_user(){
	$result=false;
	$local_custom_user=get_option( 'local_custom_user' );
	if($local_custom_user=='yes'){
		$result=true;	
	}
	return $result;
}
function check_login_source($source_value){
	$active_class='none';
	
	if($source_value=='yes'){
		$active_class='';	
	}
	return $active_class;
}

function check_external_source(){
	$active_class='none';
	$external_user=get_option( 'external_user' );
	if($external_user=='yes'){
		$active_class='';
	}
	return $active_class;
}

function get_login_email_address(){
	$login_email=CUSTOM_EMAIL_ADDRESS;
	$default_email_id=get_option( 'default_email_id' );
	if($default_email_id!=''){
		$login_email=$default_email_id;	
	}
	return $login_email;
}
function get_sourse_api_url(){
	$check_external_user=get_option( 'external_user' );
	$sourceUrl='';
	if($check_external_user=='yes'){
		$sourceUrl=get_option('corsair_apisource');	
	}
	return $sourceUrl;
}
function check_external_user(){
	$result=false;
	$external_user=get_option( 'external_user' );
	if($external_user=='yes'){
		$result=true;	
	}
	return $result;
}

function corsair_get_users_from_sourceapi($email = '' ){
	$sourceUrl = get_sourse_api_url();
	$result = false;

	if( empty( $sourceUrl ) ){
		return false;
	}
	
	$request_url = add_query_arg( 'email', urlencode( $email ), $sourceUrl );
	$response = wp_remote_get( $request_url );
	if( is_wp_error( $response ) ) {
		return false;
	}
	$response_body = wp_remote_retrieve_body( $response );
	$data = json_decode( $response_body );
	if( is_object( $data ) && isset( $data->Status ) && ( $data->Status === 'active' || $data->Status === 'abandoned' || $data->Status === 'deleted' || $data->Status === 'lockout' || $data->Status === 'external' ) ){
		$result = true;
	}
	return $result;
}
function corsair_get_users_from_sourceapi_data($email = '' ){
	$sourceUrl = get_sourse_api_url();
	$responseData = array(
		'result'	=> false,
		'Username'	=> '',
		'Email'		=> '',
	);
	if( empty( $sourceUrl ) ){
		return $responseData;
	}
	
	$request_url = add_query_arg( 'email', urlencode( $email ), $sourceUrl );
	$response = wp_remote_get( $request_url );
	if( is_wp_error( $response ) ) {
		return $responseData;
	}
	$response_body = wp_remote_retrieve_body( $response );
	$data = json_decode( $response_body );
	if( is_object( $data ) && isset( $data->Status ) && ( $data->Status === 'active' || $data->Status === 'abandoned' || $data->Status === 'deleted' || $data->Status === 'lockout' || $data->Status === 'external' ) ){
		$responseData = array(
			'result'	    => true,
			'Username'	    => $data->Username,
			'Email'		    => $data->Email,
			'first_name'	=> $data->user_first_name,
			'last_name'		=> $data->user_last_name,
		);
	}
	return $responseData;
}