<?php
//shortcode for user info & login-logout
add_shortcode( 'CIP-HELPER', 'cip_helprt_userinfo_login_logout_cb' );
function cip_helprt_userinfo_login_logout_cb( $attr ){
	$args = shortcode_atts( array(
		'type' => 'link'
	), $attr );
	$type = $args['type'];
	$html = "";
	ob_start();
	if( $type == 'info' ){
		if( is_user_logged_in() ){
			global $current_user;
			$user_name = $current_user->user_login ;
			$user_email = $current_user->user_email ;
			$user_roles = $current_user->roles;
			$user_role = array_shift($user_roles);
			$UserData = get_user_by( 'id', get_current_user_id() );
			if( in_array( "member", $UserData->roles ) ){
				$userEmail=$_SESSION['refAccount'];
				if(!$_SESSION['refAccount'] && count($UserData->roles) == 1){
					$user = wp_get_current_user();
					$logs = sprintf( __('%s logged-out ( at shortcode role check ) %s', 'corsair-login'), $user->user_email, date_i18n('d/m/Y H:i A') );
					create_cip_logs_entery( $user->ID, 'loggedout', '','member', $logs, true );
					wp_logout();
					$url=site_url();
					wp_redirect( $url );
					exit;
				}
				if($userEmail=="csrholder@gmail.com"){
					$_SESSION['refAccount']	= "";
					$user = wp_get_current_user();
					$logs = sprintf( __('%s logged-out ( at shortcode csrholder email check ) %s', 'corsair-login'), $user->user_email, date_i18n('d/m/Y H:i A') );
					create_cip_logs_entery( $user->ID, 'loggedout', '','member', $logs, true );
					wp_logout();
					$url=site_url();
					wp_redirect( $url );
					exit;
				}


				if($userEmail){
					?><p class='ciphelper_user_info' style="color:#fff;text-align:right;"><?php echo sprintf( __('Welcome %s ', CIP_TXTDOMAIN), $_SESSION['refAccount'] ); ?></p><?php
				}
				else{
					?><p class='ciphelper_user_info' style="color:#fff;text-align:right;"><?php echo sprintf( __('Welcome %s ', CIP_TXTDOMAIN), $user_email ); ?></p><?php
				}
			}else{
			?><p class='ciphelper_user_info' style="color:#fff;text-align:right;"><?php echo sprintf( __('Welcome %s (%s)', CIP_TXTDOMAIN), $user_email, $user_role ); ?></p><?php
			}
		}
	}else{
		?><div class="ciphelper_loginlog"><?php
		if( is_user_logged_in() ){
			?><a class="ciphelper_link_button" href="<?php echo get_permalink( 1067 ); ?>"><?php _e('Login', CIP_TXTDOMAIN); ?></a><?php
		}else{
			?><a class="ciphelper_link_button" href="<?php echo wp_logout_url( site_url() ); ?>"><?php _e('Logout', CIP_TXTDOMAIN); ?></a><?php
		}
		?></div><?php
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CIP-TOKEN-IMPORT','cip_token_import_cb');
function cip_token_import_cb(){
	$html = "";
	ob_start();
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	?>
	<div class="container-fluid">
	    <div class="row justify-content-center">
	        <div class="col-10 col-sm-9 col-md-7 col-lg-10 col-xl-10 text-center p-0 mt-3 mb-2">
	            <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
	                <h2 id="heading"><?php _e('Import Token Holders',CIP_TXTDOMAIN); ?></h2>
	                <p><a class="page-title-action" href="<?php echo CIP_PLUGIN_FOLDER.'sample.csv'; ?>" download>Download Sample CSV</a></p>
	                <form name="import_tokenholder_frm" class="import_tokenholder_frm" id="msform">
	                    <!-- progressbar -->
	                    <ul id="progressbar">
	                        <li class="active" id="fileupload"><strong><?php _e('Choose file',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="fieldmapping"><strong><?php _e('Field Mapping',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="confirm"><strong><?php _e('Finish',CIP_TXTDOMAIN) ?></strong></li>
	                    </ul>
	                    <div class="progress">
	                        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
	                    </div> <br> <!-- fieldsets -->
	                    <fieldset>
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 1, 3); ?></h2>
	                                </div>
	                            </div>

	                            <label class="fieldlabels"><?php _e('Update existing token holders'); ?></label>
	                            <p><label for="update_existing"><input type="checkbox" name="update_existing" id="update_existing" value="1" /> Existing holders that match by reference will be updated.</label></p>

	                            <label class="fieldlabels"><?php _e('Choose file',CIP_TXTDOMAIN); ?></label> <input type="file" name="th_csv_file" accept=".csv"  required />
	                        </div>
	                        <input type="button" name="next" class="next action-button" value="Next" />
	                    </fieldset>
	                    <fieldset>
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 2, 3); ?></h2>
	                                </div>
	                            </div>
	                        	<section class="columns_mapping_section"></section>

	                        </div>
	                        <input type="button" name="next" class="next action-button" value="Submit" /> <input type="button" name="previous" class="previous action-button-previous" value="Previous" />
	                    </fieldset>
	                    <fieldset>
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 3, 3); ?></h2>
	                                </div>
	                            </div>
	                            <div class="row justify-content-center">
	                                <div class="col-12 text-center import_update_response"></div>
	                            </div>
	                            <?php
	                            $user_id = get_current_user_id();
	                            $filename = $user_id . '_' . 'cip_import.log';
								$logFile = CIP_PLUGIN_BASE.$filename;
								?>
	                            <div class="row justify-content-center">
	                            	<a class="btn btn-success mr-5" href="<?php echo get_permalink(); ?>"><?php echo __('Reupload file',CIP_TXTDOMAIN); ?></a>
		                            <?php if( file_exists( $logFile ) ){ ?>
		                            	<a class="btn btn-info" href="<?php echo CIP_PLUGIN_FOLDER.$filename; ?>" download><?php echo __('Download log',CIP_TXTDOMAIN); ?></a>
		                            <?php } ?>
	                            </div>
	                        </div>
	                    </fieldset>
	                    <input type="hidden" name="action" value="cip_import_csv_act" />
	                    <input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxthimportxCIP_'); ?>" />
	                </form>
	            </div>
	        </div>
	    </div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
//#4966
add_shortcode('CIP-MEMBER-TOKEN-DATA-VIEW','cip_member_token_data_view_cb');
function cip_member_token_data_view_cb(){
	$html = "";
	global $wpdb;
	$tableName = $wpdb->prefix.'token_holder';
	$tableNameCol = $wpdb->prefix.'token_holder_columns';
	$tableAddressPending = $wpdb->prefix.'csr_address_pending';
	$refAccount = ( isset( $_SESSION['refAccount'] ) && $_SESSION['refAccount'] != "" ) ? $_SESSION['refAccount'] : '-';
	$getCurrentMembers = $wpdb->get_results("SELECT COUNT(*) FROM $tableName WHERE email = '".$refAccount."' ");
	wp_enqueue_style( 'cip-css' );
	// wp_enqueue_style( 'bs-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'bs-datepicker' );
	// wp_enqueue_script('bs-popper');
	// wp_enqueue_script('bs-js');
	wp_enqueue_script( 'notify-js' );
	wp_enqueue_script('cip-abi');
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('tbl-ex-js');
	wp_enqueue_script('jspdf');
	wp_enqueue_script('pdf-autotable-js');
	wp_enqueue_script('ex-js');
	wp_enqueue_script('bs-datepicker');
	wp_enqueue_script('jszip');
	ob_start();
	?>
	<?php if( $getCurrentMembers || ( (isset( $_GET['fromdate'] ) && isset( $_GET['todate'] )) && (!empty( $_GET['fromdate'] ) && !empty( $_GET['todate'] )) ) ){ ?>
	<form id="my_csr_table_date_filter" name="my_csr_table_date_filter">
		<div class="filter_area">
			<div class="input-daterange input-group" id="datepicker">
		    <input type="text" class="input-sm form-control" name="fromdate" value="<?php echo $_GET['fromdate'] ?>" placeholder="From Date"/>

		    <input type="text" class="input-sm form-control" placeholder="To Date" name="todate" value="<?php echo $_GET['todate'] ?>" />
			</div>
		</div>
		<button type="submit"><?php _e('Filter',CIP_TXTDOMAIN); ?></button>
		<a class="filter_area_clear" href="javascript:void(0);"><?php _e('Clear',CIP_TXTDOMAIN); ?></a>
	</form>
	<?php } ?>
	<div class="table-responsive">
	<?php
	if( $getCurrentMembers ){
			global $defaultColumnsArr;

			$getMembersColumns = $wpdb->get_row("SELECT * FROM $tableNameCol WHERE email = '".$refAccount."' ");

			$columnOrders = (array)get_option('cip_sm_column_order');
			$columnsLabelArr = (array)get_option('cip_sm_column_labels');
			$columnsTHColumnOption = (array)get_option('cip_column_th_toggle_columns');
			$columnsTHToggleArr = (array)maybe_unserialize( $getMembersColumns->columns );
			$columnsArr = array();
			if( !empty( $columnsTHToggleArr ) ){
				if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
					foreach( $columnOrders as $columnOrder ){
						if( isset( $columnsTHToggleArr[$columnOrder] ) ){
							$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
						}
					}
				}
			}else{
				if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
					foreach( $columnOrders as $columnOrder ){
						if( isset( $columnsTHColumnOption[$columnOrder] ) ){
							$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
						}
					}
				}
			}
	?>
	<!-- member my csr -->
	<button type="button" class="btn btn-primary my_csr_export" title="Download"><i class="fa fa-download"></i></button>
    <table id="my_csr_token_holder_table" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="true" data-show-export="false" class="table table-bordered"  data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">

	<?php
	$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableName WHERE email = '".$refAccount."' AND amount_due > 0 AND ( saved_amount IS NULL OR saved_amount = '' ) AND sign_verify = 1");
	/* if( $total_items ){
		?><div class="row"><div class="col-md-12 text-right"><button type="button" id="save_all_unissued_csr"><?php echo __('Save All My CSR',CIP_TXTDOMAIN); ?></button></div></div><?php
	} */
	/* $total_cancel_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableName WHERE email = '".$refAccount."' AND ( saved_amount IS NOT NULL AND saved_amount != '' AND saved_amount != 0 ) AND ( saving_start_date IS NULL OR saving_start_date = '' ) AND sign_verify = 1");
	if( $total_cancel_items ){
		?><div class="row"><div class="col-md-12 text-right"><button type="button" id="unsave_all_unissued_csr"><?php echo __('Unsave all un-issued CSR',CIP_TXTDOMAIN); ?></button></div></div><?php
	} */
  	?>
		<thead>
		<tr>
			<th data-field="id" class="id" data-switchable="false"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
			<?php
			if( $columnsArr ){
				foreach( $columnsArr as $columnKey => $columnsVal ){
					$columnTooltip = "";
					$filter_attr = 'data-filter-control="input"';
					if( $columnKey == '_user_status' || $columnKey == 'kyc_status' || $columnKey == 'corp_approved' ){
						$filter_attr = 'data-filter-control="select" data-filter-custom-search="BsTableFilterStatus"';
					}
					if( $columnKey == 'token' ){
						$filter_attr = 'data-filter-control="select" data-filter-data="var:withdrawalProcessToken"';
					}

					if( $columnKey == 'corp_approved' ){
						$filter_attr = 'data-filter-control="select" data-filter-data="var:corpApprovedByUser"';
						$columnTooltip = __('Distribution status of redemption record', CIP_TXTDOMAIN);
					}else if( $columnKey == 'notes_external' ){
						$columnTooltip = __('Comments/notifications applicable for redemption record', CIP_TXTDOMAIN);
					}else if( $columnKey == 'pool_ref' ){
						$columnTooltip = __('Distribution pool identifier', CIP_TXTDOMAIN);
					}else if( $columnKey == 'text_10' ){
						$columnTooltip = __('Distribution week number for redemption record', CIP_TXTDOMAIN);
					}else if( $columnKey == 'reference' ){
						$columnTooltip = __('Unique redemption reference number', CIP_TXTDOMAIN);
					}else if( $columnKey == 'eth_address' ){
						$columnTooltip = __('External CSR Wallet address for CSR distribution', CIP_TXTDOMAIN);
					}else if( $columnKey == 'csr_amount_initial' ){
						$columnTooltip = __('Initial CSR amount of redemption records', CIP_TXTDOMAIN);
					}else if( $columnKey == 'csr_amount_issued' ){
						$columnTooltip = __('Amount of CSR distributed / delivered for particular redemption record', CIP_TXTDOMAIN);
					}else if( $columnKey == 'amount_due' ){
						$columnTooltip = __('Amount of CSR yet to be distributed / delivered for particular redemption record', CIP_TXTDOMAIN);
					}else if( $columnKey == 'date_1' ){
						$columnTooltip = __('Date of distribution for particular redemption record', CIP_TXTDOMAIN);
					}else if( $columnKey == 'saved_amount' ){
						$columnTooltip = __('Amount of CSR set to saving / staking', CIP_TXTDOMAIN);
					}else if( $columnKey == 'saving_date' ){
						$columnTooltip = __('Date when saving / staking application was submitted', CIP_TXTDOMAIN);
					}else if( $columnKey == 'saving_start_date' ){
						$columnTooltip = __('Date when saving / staking application was activated in CSRnow.com system', CIP_TXTDOMAIN);
					}else if( $columnKey == 'saving_interest' ){
						$columnTooltip = __('Interest amount selected for saving / staking period in percentage', CIP_TXTDOMAIN);
					}else if( $columnKey == 'saving_periods' ){
						$columnTooltip = __('Period selected for saving / staking in days', CIP_TXTDOMAIN);
					}
				?>
				<th data-field="<?php echo $columnKey ?>" data-sortable="true" <?php echo $filter_attr; ?> class="<?php echo $columnKey ?>"><?php echo $columnsVal; ?> <?php echo cipColumnHeaderTooltip( $columnTooltip ); ?> </th>
				<?php
				}
			}
			?>
			<th data-field="action" class="action" data-switchable="false"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
		</tr>
		</thead>
		<tbody>
		</tbody>
	</table>
	<div class="modal fade" id="editEthModal" tabindex="-1" role="dialog" aria-hidden="true">
	  <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content">
			<div class="modal-header-"><button type="button" class="close" data-dismiss="modal">×</button></div>
		  <div class="modal-body">
		  </div>
		</div>
	  </div>
	</div>
	<div class="modal fade" id="choosePlanModal" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
		  		<div class="modal-body">

		  		</div>
			</div>
	  	</div>
	</div>
	<div class="modal fade" id="choosePlanAllModal" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
		  		<div class="modal-body">

		  		</div>
			</div>
	  	</div>
	</div>
	<div class="modal fade" id="viewMoreModal" tabindex="-1" role="dialog" aria-labelledby="viewMoreModalTitle" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-body">
			</div>
			<div class="modal-footer">
			<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
			</div>
		</div>
		</div>
	</div>

	<?php }else{ ?>
	<h2 class="csr_central_title"><?php _e('You have no CSR Distribution Records',CIP_TXTDOMAIN); ?><br/>
		<small> <?php _e('Purchases can take up to 14 days to show.',CIP_TXTDOMAIN); ?></small> <br/>
		<!--small> <?php //echo sprintf( __('If you have changed your registered Email address <a href="%s">click here</a>', CIP_TXTDOMAIN), get_permalink( 5009 ) ); ?></small-->
	</h2>
	<?php } ?>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
// Check CSR Holder Record while changing old email to new one
add_shortcode( 'check-csr-record', 'cors_autologinverify_via_url' );
function cors_autologinverify_via_url()
{
 global $wpdb,$table_prefix;
if(is_user_logged_in())
{
 session_start();
 $current_username=$_SESSION['refAccount'];
 $randomnumber=$_SESSION['random'];
// echo $current_username;
if( isset( $_GET['nonce'] ) && $_GET['uname'] && $_GET['rand'])
{
 $random_number_generate=$_GET['rand'];
 if($random_number_generate==$randomnumber)
 {
 $nonce=$_GET['nonce'];
 $Email=$_GET['uname'];
 $mytableName = $table_prefix.'token_holder';
 $mysql = "SELECT * FROM wpm5_token_holder WHERE email='$Email'";
 $results = $wpdb->get_results($mysql);
 if($results)
 {
	 ?>
    <table border="1" style="display:none;">
		<tr>
			<th>Id</th>
			<th>Reference</th>
			<th>Eth Address</th>
			<th>Occur Time</th>
		    <th>Email</th>
		</tr>
    <?php
	foreach($results as $recorddisplay)
	{
		?>
    <tr>
<td><?php echo $recorddisplay->id;?></td>
<td><?php echo $recorddisplay->reference;?></td>
<td><?php echo $recorddisplay->eth_address;?></td>
<td><?php echo $recorddisplay->occurs_times;?></td>
<td><?php echo $recorddisplay->email;?></td>
</tr>
<?php
	}
	 ?>
</table>
<p class="csr_distribution_info_text"><?php echo __('Do you wants to migrate your CSR Distribution records from '.$Email.' to '.$current_username,CIP_TXTDOMAIN); ?></p>
<form method="post" action="">
<input type="submit" class="btn btn-primary" value="Migrate Data To New Email" name="migrate">
</form>
<?php
if( isset( $_POST['migrate'] ) )
{
  $update_account = $wpdb->update(
    $mytableName,
    array(
        'email'   => 	$current_username,
    ),
    array( 'email' => $Email )
);
if($update_account)
{
   wp_redirect(get_permalink( get_page_by_title( 'CSR Holder Dashboard' )));
}
}
   //  echo "record is available";
 }
 else
 {
     echo "<h1 style='text-align:center;padding:50px 0px;'>You have no record with this account</h1>";
 }
 // echo $nonce;
//	echo $email;
//
 }
else
{
	echo "<h1 style='text-align:center;'>You are not authorized to view this page</h1>";
}
}
	else
	{
			echo "<h1 style='text-align:center;>You are not authorized to view this page</h1>";
	}
}
}
add_shortcode('CIP-SA-TOKEN-HOLDERS-LIST','cip_sa_token_holders_list_cb');
function cip_sa_token_holders_list_cb(){
	$html = "";
	if( is_user_logged_in() ){
		global $wpdb;
		$tableName = $wpdb->prefix.'token_holder';
		$user_id = get_current_user_id();
		$user_id = -1;

		wp_enqueue_style( 'cip-css' );
		wp_enqueue_style( 'bs-table' );
		wp_enqueue_style( 'bs-sticky-header' );
		wp_enqueue_style( 'bs-datepicker' );
		wp_enqueue_style( 'daterangepicker-style' );
		wp_enqueue_script('bs-table');
		wp_enqueue_script('bs-sticky-header');
		wp_enqueue_script('bs-table-filter-control');
		wp_enqueue_script('tbl-ex-js');
		wp_enqueue_script('jspdf');
		wp_enqueue_script('pdf-autotable-js');
		wp_enqueue_script('ex-js');
		wp_enqueue_script('bs-datepicker');
		wp_enqueue_style( 'select2' );
		wp_enqueue_script('select2');
		wp_enqueue_script('dr-moment');
		wp_enqueue_script('daterangepicker-script');
		wp_enqueue_script('jszip');
		ob_start();
		if( ( isset($_GET['action']) && $_GET['action'] === 'edit' ) && ( isset($_GET['id']) && is_numeric( $_GET['id'] ) ) ){
			global $wpdb;
			$getMember = $wpdb->get_row("SELECT * FROM $tableName WHERE id = ".$_GET['id']."");
			if( $getMember ){
				global $defaultColumnsArr;
				unset( $defaultColumnsArr['imported_by'] );
				unset( $defaultColumnsArr['import_at'] );
				unset( $defaultColumnsArr['last_update_at'] );
				$columnOrders = get_option('cip_sm_column_order');
				$columnsArr = array();
				if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
					foreach( $columnOrders as $columnOrder ){
						$columnsArr[$columnOrder] = $defaultColumnsArr[$columnOrder];
					}
				}
				if( empty( $columnsArr ) ){
					$columnsArr = $defaultColumnsArr;
				}
				$saEditColOption = (array)get_option('cip_column_sa_toggle_columns');
			?>
			<div class="container">
			<form name="sa_member_update" id="sa_member_update">
				<div class="row">
				<?php
				if( $columnsArr ){
					$column_count = 0;
					foreach( $columnsArr as $columnKey => $columnLbl ){
						if( isset( $defaultColumnsArr[ $columnKey ] ) ){
							$attr = "readonly disabled";
							if( isset( $saEditColOption[ $columnKey ] ) ){
								$attr = 'id="'.$columnKey.'" name="'.$columnKey.'"';
							}else{
								continue;
							}
						?>
						<div class="col-md-4">
							<div class="form-group">
						    	<label for="<?php echo $columnKey ?>"><?php echo $columnKey; ?></label>
						    	<?php if( $columnKey == 'notes_internal' || $columnKey == 'notes_external' ){ ?>
						    		<textarea <?php echo $attr; ?>><?php echo $getMember->$columnKey; ?></textarea>
						    	<?php }else{ ?>
						    		<input type="text" class="form-control" <?php echo $attr; ?> value="<?php echo $getMember->$columnKey; ?>" />
						    	<?php } ?>
						  	</div>
						</div>
						<?php
						}
					}
				}
				?>
				</div>
				<div class="row">
				<div class="col-md-4">
					<div class="form-check">
						<input class="form-check-input" type="checkbox" value="1" name="update_all_match" id="update_all_match">
						<label class="form-check-label" for="update_all_match" style="margin-bottom: 0.5rem;padding-top: 0px !important;"><?php _e('Update all',CIP_TXTDOMAIN); ?></label>
					</div>
					<div class="form-group update_all_option_section" style="display: none;">
						<label for="update_all_option"><?php _e('Update all options', CIP_TXTDOMAIN); ?></label>
						<select class="form-control" name="update_all_option" id="update_all_option">
							<option value="single_row_update"><?php _e('Single row update', CIP_TXTDOMAIN); ?></option>
							<option value="all_username_update"><?php _e('All rows with this username', CIP_TXTDOMAIN); ?></option>
							<option value="all_email_update"><?php _e('All rows with this email', CIP_TXTDOMAIN); ?></option>
							<option value="all_reference_update"><?php _e('All rows with this reference number', CIP_TXTDOMAIN); ?></option>
							<option value="all_wallet_address_update"><?php _e('All rows with this wallet address', CIP_TXTDOMAIN); ?></option>
						</select>
					</div>
					<div class="form-group reference_update_section" style="display: none;">
						<label for="reference_update_field"><?php _e('Reference*', CIP_TXTDOMAIN); ?></label>
						<input type="text" class="form-control" name="reference_update_field" id="reference_update_field" />
					</div>
				</div>
				</div>
				<input type="hidden" name="action" value="sa_update_th_tp1_act" />
				<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_Xupdatethtp1X_'); ?>" />
				<input type="hidden" name="sathid" value="<?php echo $_GET['id']; ?>">
		  		<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#smEditTokenHolderG2FAModal"><?php _e('Update',CIP_TXTDOMAIN); ?></button>
		  		<p><span class="form_response"></span></p>

				<div class="modal fade" id="smEditTokenHolderG2FAModal" tabindex="-1" role="dialog" aria-labelledby="smEditTokenHolderG2FAModalTitle" aria-hidden="true">
					<div class="modal-dialog modal-dialog-centered" role="document">
						<div class="modal-content">
							<div class="modal-body">
								<div class="otp_section pb-3">
									<label for="sasm_ga_otp"><?php echo __('Please enter the authentication code', CIP_TXTDOMAIN); ?></label>
									<input type="text" name="sm_editth_ga_otp" id="sm_editth_ga_otp" class="input mb-1" maxlength="6" pattern="{0-9}+" />
									<small class="form-text text-muted"><?php _e('Enter the 6-digit code generated by the Authenticator App.') ?></small>
								</div>
								<button type="submit" class="btn btn-primary"><?php _e('Submit',CIP_TXTDOMAIN); ?></button>
								<input type="button" name="cancel" class="btn btn-primary" data-dismiss="modal" value="<?php _e('Cancel', CIP_TXTDOMAIN); ?>" />
							</div>
						</div>
					</div>
				</div>

			</form>
			</div>
			<div class="modal fade" id="update_warning" tabindex="-1" role="dialog" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title"><span class="fa fa-exclamation-circle"></span> <?php _e('Warning', CIP_TXTDOMAIN); ?></h5>
				</div>
				<div class="modal-body">
					<h5><?php _e('Exercise caution and double check any updates',CIP_TXTDOMAIN); ?></h5>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Close',CIP_TXTDOMAIN); ?></button>
				</div>
				</div>
			</div>
			</div>
			<?php
			}
		}else{
		    $getCurrentMembers = $wpdb->get_results("SELECT * FROM $tableName WHERE 1 ORDER BY `id` DESC LIMIT 1");
		?>
		<div class="container-fluid">
		<div class="filter_seleted"></div>

		
		<div class="table-responsive">
		<?php if( $getCurrentMembers ){
			$user_id = get_current_user_id();
			if( !metadata_exists( 'user', $user_id, 'cip_sagent_toggle_columns' ) ){
				$columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
				update_user_meta( $user_id, 'cip_sagent_toggle_columns', $columnsSAColumnOption );
			}
			$saUserData = get_user_by( 'id', $user_id );
			global $defaultColumnsArr;
			if( $saUserData && in_array( "supportagent", $saUserData->roles ) ){
				$columnOrders = (array)get_option('cip_sm_column_order');
				$columnsLabelArr = (array)get_option('cip_sm_column_labels');
				$columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
				$columnsSAToggleArr = (array)get_user_meta( $user_id, 'cip_sagent_toggle_columns', true );
				$columnsArr = array();
				if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
					foreach( $columnOrders as $columnOrder ){
						if( isset( $columnsSAToggleArr[$columnOrder] ) ){
							$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
						}
					}
					if( empty( $columnsArr ) ){
						foreach( $columnOrders as $columnOrder ){
							if( isset( $columnsSAColumnOption[$columnOrder] ) ){
								$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
							}
						}
					}
				}else{
					unset( $defaultColumnsArr['imported_by'] );
					unset( $defaultColumnsArr['import_at'] );
					unset( $defaultColumnsArr['last_update_at'] );
					$columnsArr = $defaultColumnsArr;
				}
			}else{
				unset( $defaultColumnsArr['imported_by'] );
				unset( $defaultColumnsArr['import_at'] );
				unset( $defaultColumnsArr['last_update_at'] );
				$columnsArr = $defaultColumnsArr;
			}
			$data_url = add_query_arg( array(
				'action' => 'tokenholder_loader',
			), admin_url( 'admin-ajax.php' ) );
			$_SESSION['sessionSaCsrSelectionData'] = array();
		?>
		<!--data-search-time-out=""-->
		<div class="d-flex justify-content-between align-items-center all_holder_buttons">
			<div class="text-left sa_csr_holder_btns">
				<button type="button" class="btn edit_csr_holder" style="display: none;"><?php _e('Edit', CIP_TXTDOMAIN); ?></button>
				<button type="button" class="btn clear_all_csr_holder" style="display: none;" onclick="window.location.href='<?php echo get_the_permalink( 9099 ); ?>'"><?php _e('Clear', CIP_TXTDOMAIN); ?></button>
			</div>

			<div class="text-right">
				<?php if( ( isset( $_REQUEST['filteraction'] ) && $_REQUEST['filteraction'] == 'advanced_bulk_filter' && !empty( $_REQUEST['bulk_usernames'] ) )  || ( isset( $_GET['action'] ) && $_GET['action'] == 'advanced_filter' && !empty( $_GET['usernames'] ) ) ){ ?>
				<button type="button" id="advanced_filter" data-toggle="modal" data-target="#advancedFilterModal"><i class="fa fa-filter" aria-hidden="true"></i> <?php _e('Edit Advanced Filter', CIP_TXTDOMAIN); ?></button>
				<button type="button" onclick="location.href = '<?php echo get_the_permalink(); ?>';"><i class="fa fa-times-circle" aria-hidden="true"></i> <?php _e('Clear Advanced Filter', CIP_TXTDOMAIN); ?></button>
				<?php }else{ ?>
				<!-- 237 -Advance filter -->
				<button type="button" class="btn btn-primary csr_token_holder_advance_filter" title="Advance Filter"><i class="fa fa-filter"></i></button>
				<button type="button" class="btn btn-primary holder_data_legecy_export" title="Download"><i class="fa fa-download"></i></button>
				<!-- 237 -Advance filter END -->

				<!-- <button type="button" id="advanced_filter" data-toggle="modal" data-target="#advancedFilterModal"><i class="fa fa-filter" aria-hidden="true"></i> <?php _e('Advanced Filter', CIP_TXTDOMAIN); ?></button> -->
				<?php } ?>
			</div>
		</div>

	    <table id="tokenholder_table_sa" class="sa_own_holder" data-search-time-out="800" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="true" data-show-columns-toggle-all="true" data-show-export="false"  data-click-to-select="true" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">

			<thead>
			<tr>
				<th data-field="rowiddata" data-switchable="false"><input type="checkbox" name="toggleWDAll" id="toggleWDAll" /></th>
				<th data-field="id" class="id"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
				<?php
				if( $columnsArr ){
					foreach( $columnsArr as $columnKey => $columnsVal ){
						$filter_attr = 'data-filter-control="input"';
						$filterData_attr = '';
						if( $columnKey == '_user_status' || $columnKey == 'kyc_status' || $columnKey == 'corp_approved'  ){
							if( $columnKey == '_user_status' ){
								$filterData_attr = ' data-filter-data="var:filterUserStatus"';
							}
							if( $columnKey == 'kyc_status' ){
								$filterData_attr = ' data-filter-data="var:filterKycStatus"';
							}
							if( $columnKey == 'corp_approved' ){
								$filterData_attr = ' data-filter-data="var:filterCorpApproved"';
							}
							$filter_attr = 'data-filter-control="select" class="status" data-filter-custom-search="BsTableFilterStatus"'.$filterData_attr;
						}
					?>
					<th data-field="<?php echo $columnKey ?>" data-sortable="true" <?php echo $filter_attr; ?> class="<?php echo $columnKey ?>"><?php echo $columnsVal; ?></th>
					<?php
					}
				}
				?>
				<th data-field="action" class="action"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
			</tr>
			</thead>
			<tbody>
			</tbody>
		</table>
		<div class="modal fade" id="csrEditProcessModal">
			<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-body">
						<div class="container-fluid">
							<span class="withdrawal_close_btn close" data-dismiss="modal">&times;</span>
							<div class="csrEditProcessBody"></div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="modal fade" id="editNoteElementModal">
			<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-body">

						<span class="withdrawal_close_btn editNoteElementModalClose close" data-dismiss="modal">×</span>
						<div class="form-group">
							<h5><?php _e('Edit Note', CIP_TXTDOMAIN); ?> <!--span class="editElementNoteText"></span--></h5>
						</div>
						<form class="editNoteElementNotesFrm" name="editNoteElementNotesFrm" id="editNoteElementNotesFrm">
							<div class="form-group">
								<input type="text" class="form-control" id="note_element_notes" name="note_element_notes" maxlength="100" />
							</div>
							<input type="hidden" name="note_element_notes_hidden" />
							<button type="submit" class="btn btn-secondary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
							<button type="button" class="btn btn-secondary editNoteElementModalClose"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
							<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XyEditNoteElementNotesyX_'); ?>" />
							<input type="hidden" name="action" value="editnoteelementnotes_act" />
						</form>
					</div>
				</div>
			</div>
		</div>
		
		<div class="modal fade" id="viewMoreModal" tabindex="-1" role="dialog" aria-labelledby="viewMoreModalTitle" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">
		      <div class="modal-body">
		      </div>
		      <div class="modal-footer">
		        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
		      </div>
		    </div>
		  </div>
		</div>
		<?php }else{ ?>
		<h2><?php _e('No results found',CIP_TXTDOMAIN); ?></h2>
		<?php } ?>
		</div>

		<!-- 237 - advance filter -->
		<div class="modal fade" id="csrtokenholderadvanceFilterModal" tabindex="-1" role="dialog" aria-labelledby="csrtokenholderadvanceFilterModal" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-body">
						<div class="modal-header p-3 d-flex justify-content-between align-self-center"><h3>Advance Filter</h3> <div class="d-flex justify-content-between align-self-center"><button type="button" class="btn btn-secondary filter_csr_clear mr-2"><?php _e('Clean Filters', CIP_TXTDOMAIN); ?></button><button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Apply Filters', CIP_TXTDOMAIN); ?></button><button type="button" class="close" data-dismiss="modal">×</button></div></div>
						<div class="form-group m-0">

							<div id="csr_advancefilter" class="px-3">
								<div class="row">
									<?php
									global $defaultColumnsArr;
									$needColumns = array('username', 'email', 'pool_ref', 'corp_approved', 'reference', 'eth_address', 'csr_amount_initial', 'csr_amount_issued', 'amount_due', 'notes_external', 'notes_internal', 'coin');
									$columnOrders = (array)get_option('cip_sm_column_order');
									$columnsLabelArr = (array)get_option('cip_sm_column_labels');
									$columnsArr = array();
									$i = 0;
									if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
										foreach( $columnOrders as $columnOrder ){
											$columnsArr[$columnOrder] = $defaultColumnsArr[$columnOrder];
										}
									}
									if( empty( $columnsArr ) ){
										$columnsArr = $defaultColumnsArr;
									}
									?>
									<div class="col-12 col-lg-4 py-3  ">
										<?php
										foreach( $columnsArr as $columnKey => $columnLabel ){
											if( in_array( $columnKey, $needColumns ) ){
											$cLabel = ( !empty( $columnsLabelArr[ $columnKey ] ) ) ? $columnsLabelArr[ $columnKey ] : $columnLabel;
											?>
											<a href="javascript:void(0);" class="ad_filter_label bg-light d-flex justify-content-between align-items-center <?php echo ($i == 0) ? 'active' : '' ; ?>" advance-filter="accodian_<?php echo $columnKey; ?>"><div><?php echo $cLabel; ?></div><span class="filter-changed-indicator active_<?php echo $columnKey; ?>" style="display: none;">*</span><i class="fa fa-angle-right"></i></a>
											<?php
											$i++;
											}
										}
										?>
									</div>
									<div class="col-12 col-lg-8 py-3 ad_filter_body_container bg-light">
										<?php
											$i = 0;
											global $wpdb;
											$tableName = $wpdb->prefix.'token_holder';

											foreach( $columnsArr as $columnKey => $columnLabel ){
												if( in_array( $columnKey, $needColumns ) ){
												$cLabel = ( !empty( $columnsLabelArr[ $columnKey ] ) ) ? $columnsLabelArr[ $columnKey ] : $columnLabel;
												?>
												<div id="accodian_<?php echo $columnKey; ?>" class="ad_filter_body <?php echo ($i == 0) ? 'show' : '' ; ?>">
													<div class="form-group">
														<label for="<?php echo $columnKey; ?>" class="heading-ad-filter mr-sm-2"><?php echo $cLabel; ?></label>
														<?php if( $columnKey == 'pool_ref' || $columnKey == 'corp_approved' || $columnKey == 'username' || $columnKey == 'email' ){ ?>
															<form class="filter_by_<?php echo $columnKey; ?>" name="filter_by_<?php echo $columnKey; ?>" id="filter_by_<?php echo $columnKey; ?>">
																<select class="mb-2 mr-sm-2" name="<?php echo $columnKey; ?>[]" id="<?php echo $columnKey; ?>"  multiple>
																	<option></option>
																</select>
															</form>

														<?php }elseif($columnKey == 'coin'){ ?>
														<form class="filter_by_<?php echo $columnKey; ?>" name="filter_by_<?php echo $columnKey; ?>" id="filter_by_<?php echo $columnKey; ?>">
														<select class="form-control" name="filter_condition_type" id="filter_condition_value">
															<option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
															<option value="csr">CSR</option>
															<option value="csr25">CSR25</option>
														</select>

													</form>
													<?php }else{ ?>
														<form class="filter_by_<?php echo $columnKey; ?>" name="filter_by_<?php echo $columnKey; ?>" id="filter_by_<?php echo $columnKey; ?>">
															<div class="form-group">
																<label for="filter_by_condition">Filter by condition</label>
																<?php
																	if ($columnKey == 'csr_amount_initial' || $columnKey == 'csr_amount_issued' || $columnKey == 'amount_due') {
																?>
																	<select class="form-control" name="filter_condition_type" id="filter_condition_value">
																		<option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
																		<option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
																		<option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
																		<option value="greater_than">></option>
																		<option value="greater_than_equal">>=</option>
																		<option value="less_than"><</option>
																		<option value="less_than_equal"><=</option>
																		<option value="equal_to">=</option>
																	</select>

																<?php } else { ?>
																	<select class="form-control form-control-filter" name="filter_condition_type" id="filter_condition_value">
																		<option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
																		<option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
																		<option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
																		<option value="contains_text"><?php _e('Contains Text', CIP_TXTDOMAIN); ?></option>
																		<option value="does_not_contains_text"><?php _e('Does not Contain Text', CIP_TXTDOMAIN); ?></option>
																		<option value="starts_with"><?php _e('Starts with', CIP_TXTDOMAIN); ?></option>
																		<option value="ends_with"><?php _e('Ends with', CIP_TXTDOMAIN); ?></option>
																		<option value="is_exactly"><?php _e('Is exactly', CIP_TXTDOMAIN); ?></option>
																	</select>
																	<?php
																		//reference is excatly
																		if($columnKey == 'reference'){ ?>
																		<div class= "<?php echo $columnKey.'_isexactly_wrapper'; ?>" style="display: none;">
																			<select  class="mb-2 mr-sm-2" name="<?php echo $columnKey; ?>[]" id="<?php echo $columnKey.'_isexactly'; ?>"  multiple style="display: none;">

																		</select>
																		</div>
																	<?php } ?>
																<?php
																	// wallet is excatly
																	if($columnKey == 'eth_address'){ ?>
																	<div class= "<?php echo $columnKey.'_isexactly_wrapper'; ?>" style="display: none;">

																		<select class="mb-2 mr-sm-2" name="<?php echo $columnKey; ?>[]" id="<?php echo $columnKey.'_isexactly'; ?>"  multiple style="display: none;">

																		</select>
																		</div>
																	<?php } ?>
																<?php } ?>


																<input type="text" class="form-control mt-2" name="filter_condition_value" id="filter_condition_value" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
															</div>
														</form>
														<?php } ?>
													</div>
												</div>
												<?php
												$i++;
												}
											}
										?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- 237 - advance filter END -->
	</div>
	<?php } ?>
	<?php
	}else{
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('SM-ALL-USERS-LISTING','sm_all_users_listing_cb');
function sm_all_users_listing_cb(){
	$html = "";
	ob_start();
	$args = array(
	    'role__in'  =>	array('supportagent','supportmanager'),
	  /*  'exclude'	=>	array( get_current_user_id() ), */
	);
	$users = get_users( $args );
	if( ( isset($_GET['action']) && $_GET['action'] === 'edit' ) && ( isset($_GET['uid']) && is_numeric( $_GET['uid'] ) ) ){ //edit user
		$getEditUser = get_user_by( 'id', $_GET['uid'] );
		if( $getEditUser && ( in_array( "supportmanager", $getEditUser->roles ) || in_array( "supportagent", $getEditUser->roles ) ) ){
			$role = $getEditUser->roles;
			$cip_user_status = get_user_meta( $getEditUser->ID, 'cip_user_status', true );
			$phonenumber = get_user_meta( $getEditUser->ID, 'phonenumber', true );
			$user_status = 1;
			$user_status_label = __('Active', CIP_TXTDOMAIN);
			if( $cip_user_status === 'deactive' ){
				$user_status = 0;
				$user_status_label = __('Deactive', CIP_TXTDOMAIN);
			}
		?>
		<form name="smsa_update_usr" id="smsa_update_usr">
			<div class="row">
				<div class="col">
					<div class="form-group">
				    	<label for="firstname"><?php _e('First Name',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="firstname" name="firstname" value="<?php echo $getEditUser->first_name; ?>" >
				  	</div>
				</div>
				<div class="col">
					<div class="form-group">
				    	<label for="lastname"><?php _e('Last Name',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="lastname" name="lastname" value="<?php echo $getEditUser->last_name; ?>" >
				  	</div>
				</div>
			</div>
			<div class="row">
				<div class="col">
					<div class="form-group">
				    	<label for="phonenumber"><?php _e('Phone Number',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="phonenumber" name="phonenumber" value="<?php echo $phonenumber; ?>" >
				  	</div>
				</div>
				<div class="col">
					<div class="form-group">
				    	<label for="status"><?php _e('Status',CIP_TXTDOMAIN) ?></label>
				    	<select name="user_status">
							<option value="active" <?php selected( $user_status , 1 ); ?>><?php _e('Active',CIP_TXTDOMAIN); ?></option>
							<option value="deactive" <?php selected( $user_status , 0 ); ?>><?php _e('Deactive',CIP_TXTDOMAIN); ?></option>
						</select>
				  	</div>
				</div>
			</div>
			<div class="row">
				<div class="col">
					<div class="form-group">
				    	<label for="email"><?php _e('Email',CIP_TXTDOMAIN) ?></label>
				    	<input type="email" class="form-control" id="email" name="email" value="<?php echo $getEditUser->user_email; ?>" disabled>
				  	</div>
				</div>
				<div class="col">
					<div class="form-group">
				    	<label for="userrole"><?php _e('Role',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="userrole" name="userrole" value="<?php echo $role[0]; ?>" disabled>
				  	</div>
				</div>
			</div>
			<input type="hidden" name="action" value="sasm_update_profile_act" />
			<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XupdatesasmprofX_'); ?>" />
			<input type="hidden" name="sasmuid" value="<?php echo $_GET['uid']; ?>">
	  		<button type="submit" class="btn btn-primary"><?php _e('Update',CIP_TXTDOMAIN); ?></button>
	  		<p><span class="form_response"></span></p>
		</form>
		<?php
		}
	}else{ // listing users
		if( $users && ( current_user_can('supportmanager') || current_user_can('supportagent') ) ){
			wp_enqueue_style( 'cip-css' );
			// wp_enqueue_style( 'bs-css' );
			wp_enqueue_style( 'bs-table' );
			wp_enqueue_style( 'bs-sticky-header' );
			wp_enqueue_style( 'bs-datepicker' );
			// wp_enqueue_script('bs-popper');
			// wp_enqueue_script('bs-js');
			wp_enqueue_script('bs-table');
			wp_enqueue_script('bs-sticky-header');
			wp_enqueue_script('bs-table-filter-control');
			wp_enqueue_script('tbl-ex-js');
			wp_enqueue_script('jspdf');
			wp_enqueue_script('pdf-autotable-js');
			wp_enqueue_script('ex-js');
			wp_enqueue_script('bs-datepicker');
			?>
			<div class="add_btn_action_wrapper">
				<a href="<?=get_permalink(1118)?>" class="btn btn-primary" id="add_user_button_action">Add User</a>
			</div>
			<table id="cip_sasm_table"
		  data-filter-control="true"
		  data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="true" data-show-columns-toggle-all="true" data-show-export="true" data-click-to-select="true" class="table table-bordered">
		  <thead>
				<tr>
					<th data-field="firstname" data-sortable="true" data-filter-control="input" class="firstname"><?php _e('First Name',CIP_TXTDOMAIN); ?></th>
					<th data-field="lastname" data-sortable="true" data-filter-control="input" class="lastname"><?php _e('Last Name',CIP_TXTDOMAIN); ?></th>
					<th data-field="email" data-sortable="true" data-filter-control="input" class="email"><?php _e('Email',CIP_TXTDOMAIN); ?></th>
					<th data-field="user_role" data-sortable="true" data-filter-control="input" class="user_role"><?php _e('Role',CIP_TXTDOMAIN); ?></th>
					<th data-field="status" data-sortable="true" data-filter-control="select" class="status" data-filter-custom-search="BsTableFilterStatus"><?php _e('Status',CIP_TXTDOMAIN); ?></th>
					<th data-field="action" class="action" data-force-hide="true"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
				</tr>
			</thead>
		  	<?php
			foreach( $users as $user ){
				$role = $user->roles;
				$editLink = add_query_arg( array(
				    'action' => 'edit',
				    'uid' => $user->ID,
				), get_the_permalink() );
				$cip_user_status = get_user_meta( $user->ID, 'cip_user_status', true );
				$user_status = 1;
				$user_status_label = __('Active', CIP_TXTDOMAIN);
				if( $cip_user_status === 'deactive' ){
					$user_status = 0;
					$user_status_label = __('Deactive', CIP_TXTDOMAIN);
				}
			?><tr>
				<td><?php echo $user->first_name; ?></td>
				<td><?php echo $user->last_name; ?></td>
				<td><?php echo $user->user_email; ?></td>
				<td><?php echo  implode(', ', $role); ?></td>
				<td><?php echo $user_status_label; ?></td>
				<td>
					<a href="<?php echo $editLink; ?>" title="edit"><i class="fas fa-edit"></i></a>
				</td>
			</tr><?php
			}
			?>
		</table>
		<?php }else{
		?><h2><?php _e('No records found', CIP_TXTDOMAIN); ?></h2><?php
		}
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CIP-SMSA-PROFILE-VIEW','cip_smsa_profile_view');
function cip_smsa_profile_view(){
	$html = "";
	ob_start();
	$getEditUser = wp_get_current_user();
	$role = $getEditUser->roles;
	$cip_user_status = get_user_meta( $getEditUser->ID, 'cip_user_status', true );
	$phonenumber = get_user_meta( $getEditUser->ID, 'phonenumber', true );
	$user_status = 1;
	$user_status_label = __('Active', CIP_TXTDOMAIN);
	if( $cip_user_status === 'deactive' ){
		$user_status = 0;
		$user_status_label = __('Deactive', CIP_TXTDOMAIN);
	}
	wp_enqueue_style( 'cip-css' );
	?>
	<div class="container">
		<form name="smsaown_update_usr" id="smsaown_update_usr">
			<div class="row">
				<div class="col">
					<div class="form-group">
				    	<label for="firstname"><?php _e('First Name',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="firstname" name="firstname" value="<?php echo $getEditUser->first_name; ?>" >
				  	</div>
				</div>
				<div class="col">
					<div class="form-group">
				    	<label for="lastname"><?php _e('Last Name',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="lastname" name="lastname" value="<?php echo $getEditUser->last_name; ?>" >
				  	</div>
				</div>
			</div>
			<div class="row">
				<div class="col">
					<div class="form-group">
				    	<label for="phonenumber"><?php _e('Phone Number',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="phonenumber" name="phonenumber" value="<?php echo $phonenumber; ?>" >
				  	</div>
				</div>
				<div class="col">
					<div class="form-group">
				    	<label for="status"><?php _e('Status',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="userrole" name="userrole" value="<?php echo $user_status_label; ?>" disabled>
				  	</div>
				</div>
			</div>
			<div class="row">
				<div class="col">
					<div class="form-group">
				    	<label for="email"><?php _e('Email',CIP_TXTDOMAIN) ?></label>
				    	<input type="email" class="form-control" id="email" name="email" value="<?php echo $getEditUser->user_email; ?>" disabled>
				  	</div>
				</div>
				<div class="col">
					<div class="form-group">
				    	<label for="userrole"><?php _e('Role',CIP_TXTDOMAIN) ?></label>
				    	<input type="text" class="form-control" id="userrole" name="userrole" value="<?php echo $role[0]; ?>" disabled>
				  	</div>
				</div>
			</div>
			<input type="hidden" name="action" value="own_update_profile_act" />
			<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XupdateownprofX_'); ?>" />
	  		<button type="submit" class="btn btn-primary"><?php _e('Update',CIP_TXTDOMAIN); ?></button>
	  		<p><span class="form_response"></span></p>
		</form>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
// Register a new Support Manager shortcode: [cr_support_manager_registration]
add_shortcode( 'cr_support_manager_registration', 'cors_support_manager_register' );
function cors_support_manager_register(){
    require("support_registrationmanager.php");

    //Calling Register Support Manager Function
    cors_support_manager_registration_function();
}
// Register a new Support Agent shortcode: [cr_support_agent_registration]
add_shortcode( 'cr_support_agent_registration', 'cors_support_agent_register' );
function cors_support_agent_register() {
    require("support_registrationagent.php");

    //Calling Register Support Agent Function
    cors_support_agent_registration_function();
}
// Verify CSR Holder shortcode: [cr_holder_verify_login]
add_shortcode( 'cr_holder_verify_login', 'cors_csr_verifylogin' );
function cors_csr_verifylogin(){
	session_start();
	$random=wp_rand( 10,2000 );
    $_SESSION['random']=$random;
    require("verify_login.php");

    //Calling CSR login verify
    corsair_verify_function();
}
//support manager column managment shortcode
add_shortcode('SM-COLUMNS-MANAGER','cip_sm_columns_manager_cb');
function cip_sm_columns_manager_cb(){
	wp_enqueue_script( 'jquery-ui-sortable' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	$smUserData = get_user_by( 'id', get_current_user_id() );
	if( $smUserData && ( in_array( "supportmanager", $smUserData->roles ) || in_array( "supportagent", $smUserData->roles ) ) ){
		global $defaultColumnsArr;
		$columnOrders = get_option('cip_sm_column_order');
		if( count( $defaultColumnsArr ) !== count( $columnOrders ) ){
			$columnOrders = array();
		}
		$columnsArr = array();
		if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
			foreach( $columnOrders as $columnOrder ){
				$columnsArr[$columnOrder] = $defaultColumnsArr[$columnOrder];
			}
		}
	?>
	<style>#sm_column_options .custom-control-label { line-height: unset; text-transform: none; }#sm_column_options tr td:first-child { cursor: move; }</style>
	<form name="sm_column_options" id="sm_column_options">
	<div style="overflow-x:auto;">
	<table class="table">
		<thead>
			<tr>
				<th>#</th>
				<th><?php _e('Column Name',CIP_TXTDOMAIN); ?></th>
				<th><?php _e('Field Name',CIP_TXTDOMAIN); ?></th>
				<th><?php _e('SAs Columns View/Edit',CIP_TXTDOMAIN); ?></th>
				<th><?php _e('CSR Holders Columns',CIP_TXTDOMAIN); ?></th>
				<?php /*<th><?php _e('SA's Editable Columns',CIP_TXTDOMAIN); ?></th>*/ ?>
			</tr>
		</thead>
		<tbody>
		<?php
		$columnsLabelArr = (array)get_option('cip_sm_column_labels');
		$columnsSAToggleArr = (array)get_option('cip_column_sa_toggle_columns');
		$columnsTHToggleArr = (array)get_option('cip_column_th_toggle_columns');
		// $columnsSAEditToggleArr = (array)get_option('cip_column_saedit_toggle_columns');
		// $columnsArr = array();
		if( empty( $columnsArr ) ){
			$columnsArr = $defaultColumnsArr;
		}
		if( $columnsArr ){
			$column_count = 0;
			foreach( $columnsArr as $columnKey => $columnLbl ){
				?>
				<tr id="column_order=<?php echo str_replace('_', '.', $columnKey); ?>">
					<td><span class="ui-icon ui-icon-caret-2-n-s"></span> <?php echo $column_count + 1; ?></td>
					<td><?php echo $columnKey; ?></td>
					<td>
				    	<input type="text" class="form-control" name="column_label[<?php echo $columnKey; ?>]" value="<?php echo $columnsLabelArr[$columnKey]; ?>" />
					</td>
					<td>
						<div class="custom-control custom-switch">
					      <input type="checkbox" class="custom-control-input" id="sa<?php echo $columnKey; ?>" name="column_sa_toggle[<?php echo $columnKey; ?>]" value="1" <?php echo checked( $columnsSAToggleArr[$columnKey], 1 ); ?> />
					      <label class="custom-control-label" for="sa<?php echo $columnKey; ?>"><?php _e('Enable/Disable',CIP_TXTDOMAIN); ?></label>
					    </div>
					</td>
					<td>
						<div class="custom-control custom-switch">
					      <input type="checkbox" class="custom-control-input" id="th<?php echo $columnKey; ?>" name="column_th_toggle[<?php echo $columnKey; ?>]" value="1"  <?php echo checked( $columnsTHToggleArr[$columnKey], 1 ); ?>/>
					      <label class="custom-control-label" for="th<?php echo $columnKey; ?>"><?php _e('Enable/Disable',CIP_TXTDOMAIN); ?></label>
					    </div>
					</td>
					<?php /*<td>
						<div class="custom-control custom-switch">
					      <input type="checkbox" class="custom-control-input" id="saedt<?php echo $columnKey; ?>" name="column_saedt_toggle[<?php echo $columnKey; ?>]" value="1"  <?php echo checked( $columnsSAEditToggleArr[$columnKey], 1 ); ?>/>
					      <label class="custom-control-label" for="saedt<?php echo $columnKey; ?>"><?php _e('Yes/No',CIP_TXTDOMAIN); ?></label>
					    </div>
					</td>*/ ?>
		    	</tr>
				<?php
				$column_count++;
			}
		}
		?>
		</tbody>
	</table>
	</div>
	<input type="hidden" name="action" value="sm_column_manage_act" />
	<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XsmcolumnmanageX_'); ?>" />
	<div class="row setting-btn">
		<button type="submit" class="btn btn-primary"><?php _e('Save',CIP_TXTDOMAIN); ?></button>
	</div>
	<div class="row">
		<p><span class="form_response"></span></p>
	</div>
    </form>
	<?php
	}
}
add_shortcode('SA-COLUMNS-MANAGER','cip_sa_columns_manager_cb');
function cip_sa_columns_manager_cb(){
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	$user_id = get_current_user_id();
	$saUserData = get_user_by( 'id', $user_id );
	if( $saUserData && in_array( "supportagent", $saUserData->roles ) ){
		global $defaultColumnsArr;
		$columnOrders = (array)get_option('cip_sm_column_order');
		$columnsLabelArr = (array)get_option('cip_sm_column_labels');
		$columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
		$columnsSAToggleArr = (array)get_user_meta( $user_id, 'cip_sagent_toggle_columns', true );
		$columnsArr = array();
		if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
			foreach( $columnOrders as $columnOrder ){
				if( isset( $columnsSAColumnOption[$columnOrder] ) ){
					$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
				}
			}
		}
	?>
	<style>#sa_column_options .custom-control-label { line-height: unset; text-transform: none; }</style>
	<form name="sa_column_options" id="sa_column_options">
	<div style="overflow-x: auto;">

	<table class="table">
		<thead>
			<tr>
				<th>#</th>
				<th><?php _e('Column Name',CIP_TXTDOMAIN); ?></th>
				<th>
					<div class="custom-control custom-switch">
				    	<input type="checkbox" class="custom-control-input" id="selectallsaprofile" name="selectallsaprofile">
				    	<label class="custom-control-label" for="selectallsaprofile"><?php _e('Column hide/show (select all)',CIP_TXTDOMAIN); ?></label>
				  	</div>
				</th>
			</tr>
		</thead>
		<tbody>
		<?php
		if( empty( $columnsArr ) ){
			$columnsArr = array();
		}
		if( $columnsArr ){
			$column_count = 0;
			foreach( $columnsArr as $columnKey => $columnLbl ){
				?>
				<tr>
					<td><span class="ui-icon ui-icon-caret-2-n-s"></span> <?php echo $column_count + 1; ?></td>
					<td><?php echo $columnKey; ?> <p><?php echo $columnLbl; ?></p></td>
					<td>
						<div class="custom-control custom-switch">
					      <input type="checkbox" class="custom-control-input sa_alltoggle" id="sa_<?php echo $columnKey; ?>" name="column_sa_toggle[<?php echo $columnKey; ?>]" value="1" <?php echo checked( $columnsSAToggleArr[$columnKey], 1 ); ?> />
					      <label class="custom-control-label" for="sa_<?php echo $columnKey; ?>"><?php _e('Enable/Disable',CIP_TXTDOMAIN); ?></label>
					    </div>
					</td>
		    	</tr>
				<?php
				$column_count++;
			}
		}
		?>
		</tbody>
	</table>
	</div>
	<input type="hidden" name="action" value="sa_column_manage_act" />
	<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XsacolumnmanageX_'); ?>" />
	<div class="row .setting-btn-1">
		<button type="submit" class="btn btn-primary"><?php _e('Save',CIP_TXTDOMAIN); ?></button>
	</div>
	<div class="row">
		<p><span class="form_response"></span></p>
	</div>
    </form>
	<?php
	}
}
add_shortcode('TH-COLUMNS-MANAGER','cip_th_columns_manager_cb');
function cip_th_columns_manager_cb(){
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	global $wpdb;
	$tableName = $wpdb->prefix.'token_holder';
	$tableNameCol = $wpdb->prefix.'token_holder_columns';
	$refAccount = $_SESSION['refAccount'];
	$getCurrentMembers = $wpdb->get_row("SELECT id FROM $tableName WHERE email = '".$refAccount."' ");
	if( $getCurrentMembers ){
		global $defaultColumnsArr;

		$getMembersColumns = $wpdb->get_row("SELECT * FROM $tableNameCol WHERE email = '".$refAccount."' ");
		$columnOrders = (array)get_option('cip_sm_column_order');
		$columnsLabelArr = (array)get_option('cip_sm_column_labels');
		$columnsTHColumnOption = (array)get_option('cip_column_th_toggle_columns');
		$columnsTHToggleArr = (array)maybe_unserialize( $getMembersColumns->columns );
		$columnsArr = array();
		if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
			foreach( $columnOrders as $columnOrder ){
				if( isset( $columnsTHColumnOption[$columnOrder] ) ){
					$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
				}
			}
		}
	?>
	<style>#th_column_options .custom-control-label { line-height: unset; text-transform: none; }</style>
	<form name="th_column_options" id="th_column_options">
	<div style="overflow-x: auto;">
	<table class="table">
		<thead>
			<tr>
				<th>#</th>
				<th><?php _e('Column Name',CIP_TXTDOMAIN); ?></th>
				<th>
					<div class="custom-control custom-switch">
				    	<input type="checkbox" class="custom-control-input" id="selectallthprofile" name="selectallthprofile">
				    	<label class="custom-control-label" for="selectallthprofile"><?php _e('Column hide/show (select all)',CIP_TXTDOMAIN); ?></label>
				  	</div>
				</th>
			</tr>
		</thead>
		<tbody>
		<?php
		if( empty( $columnsArr ) ){
			$columnsArr = array();
		}
		if( $columnsArr ){
			$column_count = 0;
			foreach( $columnsArr as $columnKey => $columnLbl ){
				?>
				<tr>
					<td><span class="ui-icon ui-icon-caret-2-n-s"></span> <?php echo $column_count + 1; ?></td>
					<td><?php echo $columnKey; ?> <p><?php echo $columnLbl; ?></p></td>
					<td>
						<div class="custom-control custom-switch">
					      <input type="checkbox" class="custom-control-input th_alltoggle" id="th_<?php echo $columnKey; ?>" name="column_th_toggle[<?php echo $columnKey; ?>]" value="1" <?php echo checked( $columnsTHToggleArr[$columnKey], 1 ); ?> />
					      <label class="custom-control-label" for="th_<?php echo $columnKey; ?>"><?php _e('Enable/Disable',CIP_TXTDOMAIN); ?></label>
					    </div>
					</td>
		    	</tr>
				<?php
				$column_count++;
			}
		}
		?>
		</tbody>
	</table>
	</div>
	<input type="hidden" name="action" value="th_column_manage_act" />
	<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XthcolumnmanageX_'); ?>" />
	<div class="row .setting-btn-1">
		<button type="submit" class="btn btn-primary"><?php _e('Save',CIP_TXTDOMAIN); ?></button>
	</div>
	<div class="row">
		<p><span class="form_response"></span></p>
	</div>
    </form>
	<?php
	}
}
add_shortcode('SM-IMPORT-EXPORT-CLEAR-TH','sm_import_export_clear_th_cb');
function sm_import_export_clear_th_cb(){
	$html = "";
	ob_start();
	$smUserData = get_user_by( 'id', get_current_user_id() );
	if( $smUserData && ( in_array( "supportmanager", $smUserData->roles ) || in_array( "supportagent", $smUserData->roles ) ) ){
		if( $_GET['importth'] == 'yes' ){
			echo do_shortcode( '[CIP-SM-TOKEN-HOLDER-IMPORT]' );
		}else if( $_GET['importprocess'] == 'yes' ){
			echo do_shortcode( '[CIP-SM-TOKEN-HOLDER-IMPORT-PROCESS]' );
		}else if( $_GET['importmi'] == 'yes' ){
			echo do_shortcode( '[CIP-SM-MEMBER-INVOICE-IMPORT]' );
		}else if( $_GET['partialexport'] == 'yes' ){
			echo do_shortcode( '[CIP-PARTIAL-EXPORT]' );
		}else if( $_GET['partialclear'] == 'yes' ){
			echo do_shortcode( '[CIP-PARTIAL-CLEAR]' );
		}elseif( $_GET['partialimportth'] == 'yes' ){
			echo do_shortcode( '[CIP-SM-PARTIAL-TOKEN-HOLDER-IMPORT]' );
		}else{
			$exportLink = add_query_arg( 'action', 'export_smtokenholder_act', admin_url('admin-post.php') );
			$exportMILink = add_query_arg( 'action', 'export_smmemberinvoice_act', admin_url('admin-post.php') );
			$importLink = add_query_arg( 'importth', 'yes', get_permalink() );
			$importMILink = add_query_arg( 'importmi', 'yes', get_permalink() );

			$partialExportPage = add_query_arg( 'partialexport', 'yes', get_permalink() );
			$partialClearPage = add_query_arg( 'partialclear', 'yes', get_permalink() );
			$partialImportPage = add_query_arg( 'partialimportth', 'yes', get_permalink() );
		?>
		<style>.routine_maintenance_mode .custom-control-label { line-height: unset; text-transform: none; }</style>
		<div class="row">
			<div class="col-lg-3 col-md-6 text-center">
				<div class="boxDiv">
                    <a href="<?php echo $exportLink; ?>" class="btn btn-outline-primary" target="_blank"><?php _e('Export CSR Holders',CIP_TXTDOMAIN); ?></a>
				</div>
				<br/>
				<div class="boxDiv">
                    <a href="<?php echo $partialExportPage; ?>" class="btn btn-outline-primary"><?php _e('Partial Export',CIP_TXTDOMAIN); ?></a>
				</div>
			</div>
			<div class="col-lg-3 col-md-6 text-center">
                <div class="boxDiv">
                    <a href="<?php echo $importLink; ?>" class="btn btn-outline-primary"><?php _e('Import CSR Holders',CIP_TXTDOMAIN); ?></a>
                </div>
				<br/>
                <div class="boxDiv">
                    <a href="<?php echo $partialImportPage; ?>" class="btn btn-outline-primary"><?php _e('Partial Import',CIP_TXTDOMAIN); ?></a>
                </div>
            </div>
			<div class="col-lg-3 col-md-6 text-center">
                <div class="boxDiv">
                    <form class="smclearth_frm" id="smclearth_frm">
                        <input type="hidden" name="action" value="smthclearmember_act">
                        <input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XYclearsmMembersYX_'); ?>">
                        <button type="submit" class="btn btn-outline-primary"><?php _e('Clear all CSR Holders',CIP_TXTDOMAIN); ?></button>
                    </form>
                    <span><span class="form_response"></span></span>
                </div>
				<br/>
				<div class="boxDiv">
                    <a href="<?php echo $partialClearPage; ?>" class="btn btn-outline-primary"><?php _e('Partial Clear',CIP_TXTDOMAIN); ?></a>
				</div>
			</div>
			<div class="col-lg-3 col-md-6 text-center">
                <div class="boxDiv">
                <form class="routine_maintenance_frm" id="routine_maintenance_frm">
					<p style="margin-bottom:0;"><?php _e('Live Site Maintenance Mode',CIP_TXTDOMAIN); ?></p>
					<div class="custom-control custom-switch routine_maintenance_mode pl-0">
				      <input type="checkbox" class="custom-control-input" id="routine_maintenance_mode" name="routine_maintenance_mode" value="1" <?php echo checked( get_option('cip_routine_maintenance_mode'), 1 ); ?> />
				      <label class="custom-control-label" for="routine_maintenance_mode"><?php _e('Enable/Disable',CIP_TXTDOMAIN); ?></label>
				    </div>
					<input type="hidden" name="action" value="routine_maintenance_mode_act">
					<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XYroutinemaintenancemodeYX_'); ?>">
					<p><span class="form_response"></span></p>
				</form>
				<form class="site_maintenance_frm" id="site_maintenance_frm">
					<div class="custom-control custom-switch site_maintenance_frm pl-0">
					<p style="margin-bottom:0;"><?php _e('Whole Site Maintenance Mode',CIP_TXTDOMAIN); ?></p>
					  <input type="checkbox" class="custom-control-input" id="site_maintenance_mode" name="site_maintenance_mode" value="1" <?php echo checked( get_option('cip_site_maintenance_mode'), 1 ); ?> />
				      <label class="custom-control-label" for="site_maintenance_mode"><?php _e('Enable/Disable',CIP_TXTDOMAIN); ?></label>
				    </div>
					<input type="hidden" name="action" value="site_maintenance_mode_act">
					<input type="hidden" name="_sitemicro" value="<?php echo wp_create_nonce('_XYsite_maintenance_modeYX_'); ?>">
					<p><span class="form_response"></span></p>
				</form>

				<form class="retirement_maintenance_frm" id="retirement_maintenance_frm">
					<div class="custom-control custom-switch retirement_maintenance_frm pl-0">
					<p style="margin-bottom:0;"><?php _e('Retirement Maintenance Mode',CIP_TXTDOMAIN); ?></p>
					  <input type="checkbox" class="custom-control-input" id="retirement_maintenance_mode" name="retirement_maintenance_mode" value="1" <?php echo checked( get_option('cip_retirement_maintenance_mode'), 1 ); ?> />
				      <label class="custom-control-label" for="retirement_maintenance_mode"><?php _e('Enable/Disable',CIP_TXTDOMAIN); ?></label>
				    </div>
					<input type="hidden" name="action" value="retirement_maintenance_mode_act">
					<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XYretirement_maintenance_modeYX_'); ?>">
					<p><span class="form_response"></span></p>
				</form>
                </div>
			</div>

			<div class="col-lg-3 col-md-6 text-center">
                <div class="boxDiv">
                    <a href="<?php echo $exportMILink; ?>" class="btn btn-outline-primary" target="_blank"><?php _e('Export Member Invoices',CIP_TXTDOMAIN); ?></a>
                </div>
            </div>
			<div class="col-lg-3 col-md-6 text-center">
                <div class="boxDiv">
                    <a href="<?php echo $importMILink; ?>" class="btn btn-outline-primary"><?php _e('Import Member Invoices',CIP_TXTDOMAIN); ?></a>
                </div>
            </div>
			<div class="col-lg-3 col-md-6 text-center">
                <div class="boxDiv">
                    <form class="smclearmi_frm" id="smclearmi_frm">
                        <input type="hidden" name="action" value="smclearmemberinvoice_act">
                        <input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XYclearsmMembersInvoiceYX_'); ?>">
                        <button type="submit" class="btn btn-outline-primary"><?php _e('Clear all Member Invoices',CIP_TXTDOMAIN); ?></button>
                        <p><span class="form_response"></span></p>
                    </form>
                </div>
			</div>
			<div class="col-lg-3 col-md-6 text-center">
                <div class="boxDiv">
                    <?php $support_mode = ( !empty( get_option('cip_support_ticket_mode') ) ) ? get_option('cip_support_ticket_mode') : 'test' ; ?>
                    <form class="smsupport_endpoint" id="smsupport_endpoint" style="padding:10px;">
                        <input type="hidden" name="action" value="smsupport_endpoint_act">
                        <input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XYsmsupportendpointYX_'); ?>">
                        <div class="form-group">
                            <label for="support_ticket_mode"><?php _e('Support Ticket Mode'); ?></label>
                            <select class="form-control" name="support_ticket_mode" id="support_ticket_mode">
                                <option value="disable" <?php echo selected( $support_mode, 'disable' ); ?>><?php _e('Disable', CIP_TXTDOMAIN); ?></option>
                                <option value="live" <?php echo selected( $support_mode, 'live' ); ?>><?php _e('Live', CIP_TXTDOMAIN); ?></option>
                                <option value="test" <?php echo selected( $support_mode, 'test' ); ?>><?php _e('Test', CIP_TXTDOMAIN); ?></option>
                            </select>
                        </div>
                        <p><span class="form_response"></span></p>
                    </form>
                </div>
			</div>
		</div>
		<?php
		}
	}
	$html .= ob_get_clean();
	return $html;
}
//cip partial export
add_shortcode( 'CIP-PARTIAL-EXPORT', 'cip_partial_export_callback' );
function cip_partial_export_callback(){
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_style( 'select2' );
	wp_enqueue_script('select2');
	$html = "";
	global $defaultColumnsArr;
	$needColumns = array('reference', 'username', 'email', 'eth_address', 'pool_ref', 'text_10', 'corp_approved');

	ob_start();
	?>
	<div id="partial-export-filter-loader">
	<form name="partial_export_filter" id="partial_export_filter">
	<div class="row">
	<?php
	$columnOrders = (array)get_option('cip_sm_column_order');
	$columnsLabelArr = (array)get_option('cip_sm_column_labels');
	$columnsArr = array();
	if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
		foreach( $columnOrders as $columnOrder ){
			$columnsArr[$columnOrder] = $defaultColumnsArr[$columnOrder];
		}
	}
	if( empty( $columnsArr ) ){
		$columnsArr = $defaultColumnsArr;
	}
	foreach( $columnsArr as $columnKey => $columnLabel ){
		if( in_array( $columnKey, $needColumns ) ){
		$cLabel = ( !empty( $columnsLabelArr[ $columnKey ] ) ) ? $columnsLabelArr[ $columnKey ] : $columnLabel;
		// $cLabel = ( !empty( $columnsLabelArr[ $columnKey ] ) ) ? $columnsLabelArr[ $columnKey ] .' ('.$columnKey.')' : $columnLabel;
		?>
		<div class="<?php echo  ( $columnKey == 'corp_approved' ) ? 'col-sm-6' : 'col-sm-3' ; ?>">
		<div class="form-group">
			<label for="<?php echo $columnKey; ?>" class="mr-sm-2"><?php echo $cLabel; ?></label>
			<?php if( $columnKey == 'pool_ref' || $columnKey == 'corp_approved' || $columnKey == 'username' ){ ?>
					<select class="mb-2 mr-sm-2" name="<?php echo $columnKey; ?>[]" id="<?php echo $columnKey; ?>" multiple>
						<?php if( $columnKey == 'corp_approved' ){ ?>
							<option selected>Hold</option>
							<option selected>Issued</option>
							<option selected>Delivered</option>
							<option selected>Deleted</option>
							<option selected>Saved CSR</option>
							<option selected>Security Hold</option>
							<option selected>Rejected</option>
							<option selected>Pending</option>
							<option selected>Under review</option>
							<option selected>Application received</option>
							<option selected>In Process</option>
							<option selected>Partially Delivered</option>
							<option selected>CSR Retirement</option>
						<?php } ?>
						<?php
						global $wpdb;
						$tableName = $wpdb->prefix.'token_holder';
							if( $columnKey == 'username' ){
								$fillterusernames = $wpdb->get_results("SELECT DISTINCT `username` FROM $tableName WHERE 1", ARRAY_A); // Fetching as an associative array
								// print_r($fillterusernames);
								array_unique($fillterusernames);
								// Check if fillterusernames were found
								if (!empty($fillterusernames)) {
									foreach ($fillterusernames as $fillteruser) {
										// Process each username. $user['username'] is your distinct username
										echo "<option>" . $fillteruser['username'] . "</option>";
										// Your option processing logic here
									}
								}
							}
						?>
						<?php
							if( $columnKey == 'pool_ref' ){

								$fillterpool_refs = $wpdb->get_results("SELECT DISTINCT `pool_ref` FROM $tableName WHERE 1", ARRAY_A); // Fetching as an associative array
								// print_r($fillterpool_refs);
								array_unique($fillterpool_refs);
								// Check if fillterpool_refs were found
								if (!empty($fillterpool_refs)) {
									foreach ($fillterpool_refs as $fillteruser) {
										// Process each pool_ref. $user['pool_ref'] is your distinct pool_ref
										echo "<option>" . $fillteruser['pool_ref'] . "</option>";
										// Your option processing logic here
									}
								}
							}
						?>
					</select>
			<?php }else{ ?>
			<input type="text" class="form-control-plaintext mb-2 mr-sm-2" name="<?php echo $columnKey; ?>" id="<?php echo $columnKey; ?>" />
			<?php } ?>
		</div>
		</div>
		<?php
		}
	}
	?>
	</div>
	<div class="row">
		<div class="col-md-12 export_button_toggle">
			<button type="submit" class="btn btn-primary"><?php _e('Filter', CIP_TXTDOMAIN); ?></button>
			<input type="hidden" name="action"	value="partial_export_act" />
			<input type="hidden" name="_micro"	value="<?php echo wp_create_nonce( 'CIP_partial_export_CIP' ) ?>" />
			<a href="javascript:void(0);" class="btn btn-primary remove-fillter" onclick="clearFieldsExceptOne()"><?php _e('Clear', CIP_TXTDOMAIN); ?></a>
			<button type="button" class="btn btn-primary export_toggle_btn" style="display:none;"><?php _e('Export', CIP_TXTDOMAIN); ?></button>
		</div>
	</div>
	<div class="row">
		<div class="col-md-12">
		<p class="form_response"></p>
		</div>
	</div>
	</form>
	<div class="row">
		<div class="filterd_data_section col-12" style="display:none;">
		<?php
				global $defaultColumnsArr;

				$needColumns = array('reference', 'username', 'email', 'eth_address', 'pool_ref', 'text_1', 'text_2', 'text_3', 'text_4', 'text_5', 'text_6', 'text_7', 'text_8', 'text_9', 'text_10', 'corp_approved');

				$columnOrders = (array)get_option('cip_sm_column_order');

				$columnsLabelArr = (array)get_option('cip_sm_column_labels');

				$columnsArr = array();

				if( !empty( $columnOrders ) && is_array( $columnOrders ) ){

					foreach( $columnOrders as $columnOrder ){

						if( in_array( $columnOrder, $needColumns ) ){

							$columnsArr[$columnOrder] = $defaultColumnsArr[$columnOrder];

						}

					}

				}

				if( empty( $columnsArr ) ){

					$columnsArr = $defaultColumnsArr;

				}
			?>
		<!-- <p class="form_response"> -->
			<table id="partial_filtered_table_responce"  data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-show-columns="true" data-show-toggle="false" data-click-to-select="true" data-show-columns-toggle-all="true" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
				<thead>
					<tr>
						<th data-field="id" class="id" data-switchable="false"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
						<th data-field="username" class="username" data-sortable="true" data-filter-control="input"><?php _e('Username',CIP_TXTDOMAIN); ?></th>
						<th data-field="corp_approved" class="corp_approved" data-sortable="true" data-filter-control="input"><?php _e('Delivery status',CIP_TXTDOMAIN); ?></th>
						<th data-field="reference" class="reference" data-sortable="true" data-filter-control="input"><?php _e('Reference',CIP_TXTDOMAIN); ?></th>
						<th data-field="token" class="token" data-sortable="true" data-filter-control="input"><?php _e('Token Type',CIP_TXTDOMAIN); ?></th>
						<th data-field="csr_amount_initial" class="csr_amount_initial" data-sortable="true" data-filter-control="input"><?php _e('CSR Amount Initial',CIP_TXTDOMAIN); ?></th>
						<th data-field="csr_amount_issued" class="csr_amount_issued" data-sortable="true" data-filter-control="input"><?php _e('CSR Amount Issued',CIP_TXTDOMAIN); ?></th>
						<th data-field="amount_due" class="amount_due" data-sortable="true" data-filter-control="input"><?php _e('Amount Due',CIP_TXTDOMAIN); ?></th>
						<th data-field="pool_ref" class="pool_ref" data-sortable="true" data-filter-control="input"><?php _e('Pool reference',CIP_TXTDOMAIN); ?></th>
						<th data-field="text_10" class="text_10" data-sortable="true" data-filter-control="input"><?php _e('Distribution week',CIP_TXTDOMAIN); ?></th>
						<th data-field="email" class="email" data-sortable="true" data-filter-control="input"><?php _e('Email',CIP_TXTDOMAIN); ?></th>
						<th data-field="eth_address" class="eth_address" data-sortable="true" data-filter-control="input"><?php _e('CSR wallet address',CIP_TXTDOMAIN); ?></th>
					</tr>
				</thead>
			</table>
		<!-- </p> -->
		</div>
	</div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
//cip partial clear
add_shortcode( 'CIP-PARTIAL-CLEAR', 'cip_partial_clear_callback' );
function cip_partial_clear_callback(){
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_style( 'select2' );
	wp_enqueue_script('select2');
	$html = "";
	global $defaultColumnsArr;
	$needColumns = array('reference', 'username', 'email', 'eth_address', 'pool_ref', 'text_1', 'text_2', 'text_3', 'text_4', 'text_5', 'text_6', 'text_7', 'text_8', 'text_9', 'text_10');
	ob_start();
	?>
	<form name="partial_clear_filter" id="partial_clear_filter">
	<div class="row">
	<?php
	$columnOrders = (array)get_option('cip_sm_column_order');
	$columnsLabelArr = (array)get_option('cip_sm_column_labels');
	$columnsArr = array();
	if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
		foreach( $columnOrders as $columnOrder ){
			$columnsArr[$columnOrder] = $defaultColumnsArr[$columnOrder];
		}
	}
	if( empty( $columnsArr ) ){
		$columnsArr = $defaultColumnsArr;
	}
	foreach( $columnsArr as $columnKey => $columnLabel ){
		if( in_array( $columnKey, $needColumns ) ){
		$cLabel = ( !empty( $columnsLabelArr[ $columnKey ] ) ) ? $columnsLabelArr[ $columnKey ] .' ('.$columnKey.')' : $columnLabel;
		?>
		<div class="col-sm-3">
		<div class="form-group">
			<label for="<?php echo $columnKey; ?>" class="mr-sm-2"><?php echo $cLabel; ?></label>
			<?php if( $columnKey == 'pool_ref' ){ ?>
			<select class="mb-2 mr-sm-2" name="<?php echo $columnKey; ?>[]" id="<?php echo $columnKey; ?>" multiple></select>
			<?php }else{ ?>
			<input type="text" class="form-control-plaintext mb-2 mr-sm-2" name="<?php echo $columnKey; ?>" id="<?php echo $columnKey; ?>" />
			<?php } ?>
		</div>
		</div>
		<?php
		}
	}
	?>
	</div>
	<div class="row">
		<div class="col-md-12 clear_button_toggle">
			<button type="submit" class="btn btn-primary"><?php _e('Filter', CIP_TXTDOMAIN); ?></button>
			<input type="hidden" name="action"	value="partial_clear_act" />
			<input type="hidden" name="_micro"	value="<?php echo wp_create_nonce( 'CIP_partial_clear_CIP' ); ?>" />
			<button type="button" class="btn btn-primary clear_toggle_btn" style="display:none;"><?php _e('Clear', CIP_TXTDOMAIN); ?></button>
		</div>
	</div>
	<div class="row">
		<div class="col-md-12">
		<p class="form_response"></p>
		</div>
	</div>
	</form>
	<div class="row">
		<div class="filterd_data_section"></div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
//support manager import token holders
add_shortcode('CIP-SM-TOKEN-HOLDER-IMPORT','cip_sm_token_holder_import_cb');
function cip_sm_token_holder_import_cb(){
	$html = "";
	ob_start();
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	?>
	<div class="container-fluid">
	    <div class="row justify-content-center">
	        <div class="col-10 col-sm-9 col-md-7 col-lg-10 col-xl-10 text-center p-0 mt-3 mb-2">
	            <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
	                <h2 id="heading"><?php _e('Import Token Holders',CIP_TXTDOMAIN); ?></h2>
	                <!--p><a class="page-title-action" href="<?php //echo CIP_PLUGIN_FOLDER.'sample.csv'; ?>" download>Download Sample CSV</a></p-->
	                <form name="sm_import_th_frm" class="sm_import_th_frm" id="msform">
	                    <!-- progressbar -->
	                    <ul id="progressbar">
	                        <li class="active" id="fileupload"><strong><?php _e('Choose file',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="fieldmapping"><strong><?php _e('Field Mapping',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="confirm"><strong><?php _e('Finish',CIP_TXTDOMAIN) ?></strong></li>
	                    </ul>
	                    <div class="progress">
	                        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
	                    </div> <br> <!-- fieldsets -->
	                    <fieldset>
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 1, 3); ?></h2>
	                                </div>
	                            </div>

	                            <label class="fieldlabels"><?php _e('Choose file',CIP_TXTDOMAIN); ?></label> <input type="file" name="th_csv_file" accept=".csv"  required />
	                        </div>
	                        <input type="button" name="next" class="next action-button" value="Next" />
	                    </fieldset>
	                    <fieldset>
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 2, 3); ?></h2>
	                                </div>
	                            </div>
	                        	<section class="columns_mapping_section"></section>

	                        </div>
	                        <input type="button" name="next" class="next action-button" value="Submit" /> <input type="button" name="previous" class="previous action-button-previous" value="Previous" />
	                    </fieldset>
	                    <fieldset>
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 3, 3); ?></h2>
	                                </div>
	                            </div>
	                            <!--div class="row justify-content-center">
	                                <div class="col-12 text-center import_update_response"></div>
	                            </div-->
	                            <?php
	                            $user_id = get_current_user_id();
	                            $filename = $user_id . '_' . 'cip_import.log';
								$logFile = CIP_PLUGIN_BASE.$filename;

								$filename_failed = $user_id . '_' . 'cip_import_faild.log';
								$logFile_failed = CIP_PLUGIN_BASE.$filename_failed;
								$importLink = add_query_arg( 'importth', 'yes', get_permalink() );
								?>
	                            <div class="row justify-content-center">
	                            	<a class="btn btn-success mr-5" href="<?php echo $importLink; ?>"><?php echo __('Reupload file',CIP_TXTDOMAIN); ?></a>
		                            <?php if( file_exists( $logFile ) ){ ?>
		                            	<a class="btn btn-info" href="<?php echo CIP_PLUGIN_FOLDER.$filename; ?>" download><?php echo __('Download log',CIP_TXTDOMAIN); ?></a>
		                            <?php } ?>
									<?php if( file_exists( $logFile_failed ) ){ ?>
		                            	<a class="btn btn-info failed_log_btn ml-5" style="display:none;" href="<?php echo CIP_PLUGIN_FOLDER.$filename_failed; ?>" download><?php echo __('Download failed log',CIP_TXTDOMAIN); ?></a>
		                            <?php } ?>
	                            </div>
	                        </div>
	                    </fieldset>
	                    <input type="hidden" name="action" value="cip_sm_import_csv_act" />
	                    <input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxYSMthimportMSYxCIP_'); ?>" />
	                </form>
					<div class="row justify-content-center">
						<div class="col-12 text-center import_update_response"></div>
					</div>
	            </div>
	        </div>
	    </div>
	</div>
	<?php $import_process_url = add_query_arg( 'importprocess', 'yes', get_permalink( 1088 ) ); ?>
	<form name="sm_import_th_process_frm" target="_blank" method="post" id="sm_import_th_process_frm" action="<?php echo $import_process_url; ?>">
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxYSMthimportProcessMSYxCIP_'); ?>" />
	</form>
	<?php
	$html .= ob_get_clean();
	return $html;
}
//support manager import token holders partial
add_shortcode('CIP-SM-PARTIAL-TOKEN-HOLDER-IMPORT','cip_sm_partial_token_holder_import_cb');
function cip_sm_partial_token_holder_import_cb(){
	$html = "";
	ob_start();
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	?>
	<div class="container-fluid">
	    <div class="row justify-content-center">
	        <div class="col-10 col-sm-9 col-md-7 col-lg-10 col-xl-10 text-center p-0 mt-3 mb-2">
	            <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
	                <h2 id="heading"><?php _e('Partial Import Token Holders',CIP_TXTDOMAIN); ?></h2>
	                <!--p><a class="page-title-action" href="<?php //echo CIP_PLUGIN_FOLDER.'sample.csv'; ?>" download>Download Sample CSV</a></p-->
	                <form name="sm_partial_import_th_frm" class="sm_partial_import_th_frm" id="msform">
	                    <!-- progressbar -->
	                    <ul id="progressbar">
	                        <li class="active" id="fileupload"><strong><?php _e('Choose file',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="fieldmapping"><strong><?php _e('Field Mapping',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="confirm"><strong><?php _e('Finish',CIP_TXTDOMAIN) ?></strong></li>
	                    </ul>
	                    <div class="progress">
	                        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
	                    </div> <br> <!-- fieldsets -->
	                    <fieldset>
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 1, 3); ?></h2>
	                                </div>
	                            </div>

	                            <label class="fieldlabels"><?php _e('Choose file',CIP_TXTDOMAIN); ?></label> <input type="file" name="th_csv_file" accept=".csv"  required />
	                        </div>
	                        <input type="button" name="next" class="next action-button" value="Next" />
	                    </fieldset>
	                    <fieldset>
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 2, 3); ?></h2>
	                                </div>
	                            </div>
	                        	<section class="columns_mapping_section"></section>

	                        </div>
	                        <input type="button" name="next" class="next action-button" value="Submit" /> <input type="button" name="previous" class="previous action-button-previous" value="Previous" />
	                    </fieldset>
	                    <fieldset>
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 3, 3); ?></h2>
	                                </div>
	                            </div>
	                            <!--div class="row justify-content-center">
	                                <div class="col-12 text-center import_update_response"></div>
	                            </div-->
	                            <?php
	                            $user_id = get_current_user_id();
	                            $filename = $user_id . '_' . 'cip_import.log';
								$logFile = CIP_PLUGIN_BASE.$filename;

								$filename_failed = $user_id . '_' . 'cip_import_faild.log';
								$logFile_failed = CIP_PLUGIN_BASE.$filename_failed;
								$importLink = add_query_arg( 'partialimportth', 'yes', get_permalink() );
								?>
	                            <div class="row justify-content-center">
	                            	<a class="btn btn-success mr-5" href="<?php echo $importLink; ?>"><?php echo __('Reupload file',CIP_TXTDOMAIN); ?></a>
		                            <?php if( file_exists( $logFile ) ){ ?>
		                            	<a class="btn btn-info" href="<?php echo CIP_PLUGIN_FOLDER.$filename; ?>" download><?php echo __('Download log',CIP_TXTDOMAIN); ?></a>
		                            <?php } ?>
									<?php if( file_exists( $logFile_failed ) ){ ?>
		                            	<a class="btn btn-info failed_log_btn ml-5" style="display:none;" href="<?php echo CIP_PLUGIN_FOLDER.$filename_failed; ?>" download><?php echo __('Download failed log',CIP_TXTDOMAIN); ?></a>
		                            <?php } ?>
	                            </div>
	                        </div>
	                    </fieldset>
	                    <input type="hidden" name="action" value="cip_sm_partial_import_csv_act" />
	                    <input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxYSMPartialthimportMSYxCIP_'); ?>" />
	                </form>
					<div class="row justify-content-center">
						<div class="col-12 text-center import_update_response"></div>
					</div>
	            </div>
	        </div>
	    </div>
	</div>
	<?php $import_process_url = add_query_arg( 'importpartialprocess', 'yes', get_permalink( 1088 ) ); ?>
	<form name="sm_import_partial_th_process_frm" target="_blank" method="post" id="sm_import_partial_th_process_frm" action="<?php echo $import_process_url; ?>">
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxYSMParitalthimportProcessMSYxCIP_'); ?>" />
	</form>
	<?php
	$html .= ob_get_clean();
	return $html;
}
//support manager import token holders
add_shortcode('CIP-SM-TOKEN-HOLDER-IMPORT-PROCESS','cip_sm_token_holder_import_process_cb');
function cip_sm_token_holder_import_process_cb(){
	$html = "";
	ob_start();
	wp_enqueue_style( 'cip-css' );
	$wait_time = $_POST['highestRow'] * 5 / 10000;
	// $wait_time = 5000 * 5 / 10000;
	$wait_minutes = ceil( $wait_time );
	?>
	<div class="container-fluid">
	    <div class="row justify-content-center import_process_logs_section">
	        <div class="col-10 col-sm-9 col-md-7 col-lg-10 col-xl-10 text-center p-0 mt-3 mb-2">
				<div class="import_process_logs">
				<?php if( is_null( $_SESSION['countTotalRun'] ) && is_null( $_SESSION['countSuccess'] ) && is_null( $_SESSION['countError'] ) ){ ?>
					<h3><?php echo sprintf( __('Please wait and click check process button after %s minutes',CIP_TXTDOMAIN), $wait_minutes ); ?></h3>
				<?php }else{ ?>
					<p>countTotalRun : <?php echo $_SESSION['countTotalRun'] ?></p>
					<p>countSuccess : <?php echo $_SESSION['countSuccess'] ?></p>
					<p>countError : <?php echo $_SESSION['countError'] ?></p>
					<?php
					$user_id = get_current_user_id();
					$filename = $user_id . '_' . 'cip_import.log';
					$filenameFailed = $user_id . '_' . 'cip_import_faild.log';
					$logFile = CIP_PLUGIN_BASE.$filename;
					$logFileFailed = CIP_PLUGIN_BASE.$filenameFailed;
					?>
					<div class="row justify-content-center">
						<?php if( file_exists( $logFile ) ){ ?>
							<a class="btn btn-info mr-5" href="<?php echo CIP_PLUGIN_FOLDER.$filename; ?>" download><?php echo __('Download log',CIP_TXTDOMAIN); ?></a>
						<?php } ?>
						<?php if( file_exists( $logFileFailed ) ){ ?>
							<a class="btn btn-info" href="<?php echo CIP_PLUGIN_FOLDER.$filenameFailed; ?>" download><?php echo __('Download Failed log',CIP_TXTDOMAIN); ?></a>
						<?php } ?>
					</div>
				<?php } ?>
				</div>
				<button class="mt-3" onclick="window.location.reload();">Check Process</button>
	        </div>
	    </div>
	</div>
	<script>
	/*jQuery(document).ready(function($){
		if(!window.location.hash) {
			setTimeout(function () {
				window.location = window.location + '#loaded';
				window.location.reload();
			 }, 30000);
		}
	});*/
	</script>
	<?php /*<script>
	jQuery(document).ready(function($){
		var ajax_url = "<?php echo admin_url( 'admin-ajax.php' ); ?>";
		var data = {'action' : 'get_th_import_process_count'};
		var block_config = { message: null,overlayCSS:{ backgroundColor: '#fff',opacity:0.8} };
		function importProcess(){
			$('.import_process_logs_section').block( block_config );
			$.post(ajax_url, data, function(response){
				var obj = JSON.parse( response );
				console.log( obj );
				$('.import_process_logs').html( '<p>countTotalRun : '+ obj.countTotalRun +'</p><p>countSuccess : '+ obj.countSuccess +'</p><p>countError : '+ obj.countError +'</p>' );
				$('.import_process_logs_section').unblock();
			});
		}
		setTimeout(function(){ importProcess(); }, 10000);
		// setInterval( importProcess, 30000 );
	});
	</script>*/ ?>
	<?php
	$html .= ob_get_clean();
	return $html;
}
//support manager import member invoice
add_shortcode('CIP-SM-MEMBER-INVOICE-IMPORT','cip_sm_member_invoice_import_cb');
function cip_sm_member_invoice_import_cb(){
	$html = "";
	ob_start();
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	?>
	<div class="container-fluid">
	    <div class="row justify-content-center">
	        <div class="col-10 col-sm-9 col-md-7 col-lg-10 col-xl-10 text-center p-0 mt-3 mb-2">
	            <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
	                <h2 id="heading"><?php _e('Import Member Invoice',CIP_TXTDOMAIN); ?></h2>
	                <form name="sm_import_mi_frm" class="sm_import_mi_frm" id="msform">
	                    <!-- progressbar -->
	                    <ul id="progressbar">
	                        <li class="active" id="fileupload" style="width:48%"><strong><?php _e('Choose file',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="confirm" style="width:48%"><strong><?php _e('Finish',CIP_TXTDOMAIN) ?></strong></li>
	                    </ul>
	                    <div class="progress">
	                        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
	                    </div> <br> <!-- fieldsets -->
	                    <fieldset>
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 1, 2); ?></h2>
	                                </div>
	                            </div>

	                            <label class="fieldlabels"><?php _e('Choose file',CIP_TXTDOMAIN); ?></label> <input type="file" name="mi_csv_file" accept=".csv"  required />
	                        </div>
	                        <input type="button" name="next" class="next action-button" value="Next" />

	                    </fieldset>
	                    <fieldset>
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 2, 2); ?></h2>
	                                </div>
	                            </div>
	                            <div class="row justify-content-center">
	                                <div class="col-12 text-center import_update_response"></div>
	                            </div>
	                            <?php
	                            $user_id = get_current_user_id();
	                            $filename = $user_id . '_' . 'cip_import.log';
								$logFile = CIP_PLUGIN_BASE.$filename;
								$importLink = add_query_arg( 'importmi', 'yes', get_permalink() );
								?>
	                            <div class="row justify-content-center">
	                            	<a class="btn btn-success mr-5" href="<?php echo $importLink; ?>"><?php echo __('Reupload file',CIP_TXTDOMAIN); ?></a>
		                            <?php if( file_exists( $logFile ) ){ ?>
		                            	<a class="btn btn-info" href="<?php echo CIP_PLUGIN_FOLDER.$filename; ?>" download><?php echo __('Download log',CIP_TXTDOMAIN); ?></a>
		                            <?php } ?>
	                            </div>
	                        </div>
	                    </fieldset>
	                    <input type="hidden" name="action" value="cip_sm_import_mi_csv_act" />
	                    <input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxYSMmiimportMSYxCIP_'); ?>" />
	                </form>
	            </div>
	        </div>
	    </div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
//support manager import token holders
add_shortcode('CIP-SM-LOGS-VIEW','cip_sm_logs_view_cb');
function cip_sm_logs_view_cb(){
	$html = "";
	ob_start();
	global $wpdb;
	$logTable = $wpdb->prefix.'cip_logs';
	$getLogs = $wpdb->get_results( "SELECT * FROM $logTable WHERE log_type != 'api_track' ORDER BY id desc LIMIT 10" );
	if( ( current_user_can('supportmanager') || current_user_can('supportagent') ) && $getLogs ){
			wp_enqueue_style( 'cip-css' );
			wp_enqueue_style( 'bs-table' );
			wp_enqueue_style( 'bs-sticky-header' );
			wp_enqueue_style( 'daterangepicker-style' );
			wp_enqueue_script('bs-table');
			wp_enqueue_script('bs-sticky-header');
			wp_enqueue_script('bs-table-filter-control');
			wp_enqueue_script('dr-moment');
			wp_enqueue_script('daterangepicker-script');
			?>
			<table id="cip_logs_table" data-show-search-clear-button="true" data-filter-control="true" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="true" data-show-columns-toggle-all="true" data-show-export="false" data-click-to-select="true" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
		  <thead>
				<tr>
					<th data-field="logs"  data-filter-control="input" class="logs"><?php
						_e(' ',CIP_TXTDOMAIN);
						_e('Log Details',CIP_TXTDOMAIN);;
					?><div class="log_data"><div></th>
					<th data-field="user_type"  data-filter-control="select" class="user_type" data-filter-data="var:filterLogType"><?php
					_e(' ',CIP_TXTDOMAIN);
					_e('User Type',CIP_TXTDOMAIN);
					?></th>
					<!--th data-field="user_type" data-sortable="true" data-filter-control="select" class="user_type" data-filter-custom-search="BsTableFilterStatus"><?php //_e('User Type',CIP_TXTDOMAIN); ?></th-->
					<th data-field="_date" data-sortable="true" data-filter-control="input" class="_date"><?php _e('Date',CIP_TXTDOMAIN); ?></th>
				</tr>
			</thead>
	  	<?php
			/* foreach( $getLogs as $getLog ){
				$user_type = '—';
				if( $getLog->user_type  == 'sm' ){
					$user_type = __('Support Manager',CIP_TXTDOMAIN);
				}else if( $getLog->user_type  == 'sa' ){
					$user_type = __('Support Agent',CIP_TXTDOMAIN);
				}
			?><tr>
				<td><?php echo $getLog->logs; ?></td>
				<td><?php echo $getLog->log_type; ?></td>
				<td><?php echo $user_type; ?></td>
				<td><?php echo date_i18n( 'd/m/Y H:i A', strtotime( $getLog->_date ) ); ?></td>
			</tr><?php
			} */
			?>
		</table>

		<div class="modal fade" id="logsFilterModal" tabindex="-1" role="dialog" aria-labelledby="logsFilterModal" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">
			<form class="filter_by_logs" name="filter_by_logs" id="filter_by_logs">
				<div class="modal-body">
					<div class="form-group">
						<label for="filter_by_condition_logs">Filter by condition</label>
						<select class="form-control" name="filter_condition_type_logs" id="filter_condition_type_logs">
							<option value=""><?php _e(' ', CIP_TXTDOMAIN); ?></option>
							<option value="Member"><?php _e('Member', CIP_TXTDOMAIN); ?></option>
							<option value="Login"><?php _e('Login', CIP_TXTDOMAIN); ?></option>
							<option value="Routine maintenance"> <?php _e('Routine maintenance', CIP_TXTDOMAIN); ?></option>
							<option value="SMS Alert"> <?php _e('SMS Alert', CIP_TXTDOMAIN); ?></option>
							<option value="Partial CSR Delivered"> <?php _e('Partial CSR Delivered', CIP_TXTDOMAIN); ?></option>
							<option value="Withdrawal"> <?php _e('Withdrawal', CIP_TXTDOMAIN); ?></option>
							<!-- <option value="logged"> <?php _e('Logged', CIP_TXTDOMAIN); ?></option> -->
							<option value="Deposit"> <?php _e('Deposit', CIP_TXTDOMAIN); ?></option>
							<option value="Withdrawal"> <?php _e('Withdrawal', CIP_TXTDOMAIN); ?></option>
							<option value="KYC status"> <?php _e('KYC status', CIP_TXTDOMAIN); ?></option>
							<option value="2FA"> <?php _e('2FA', CIP_TXTDOMAIN); ?></option>
							<option value="OTP"> <?php _e('OTP', CIP_TXTDOMAIN); ?></option>
							<option value="Complete your KYC"> <?php _e('Complete your KYC', CIP_TXTDOMAIN); ?></option>
							<option value="2FA google"> <?php _e('2FA google', CIP_TXTDOMAIN); ?></option>
							<option value="CSR Wallet Delivered"> <?php _e('CSR Wallet Delivered', CIP_TXTDOMAIN); ?></option>
							<option value="CSR fee added"> <?php _e('CSR fee added', CIP_TXTDOMAIN); ?></option>
							<option value="Request for a withdrawal"> <?php _e('Request for a withdrawal', CIP_TXTDOMAIN); ?></option>
							<option value="csr withdrawal"> <?php _e('csr withdrawal', CIP_TXTDOMAIN); ?></option>
							<option value="update holder"> <?php _e('update holder', CIP_TXTDOMAIN); ?></option>
							<option value="country disabled"> <?php _e('country disabled', CIP_TXTDOMAIN); ?></option>
							<option value="Retirement Banners"> <?php _e('Retirement Banners', CIP_TXTDOMAIN); ?></option>
							<option value="Retirement confirmation"> <?php _e('Retirement confirmation', CIP_TXTDOMAIN); ?></option>
							<option value="Live API"> <?php _e('Live API', CIP_TXTDOMAIN); ?></option>
							<option value="Live token"> <?php _e('Live token', CIP_TXTDOMAIN); ?></option>
							<option value="Test API"> <?php _e('Test API', CIP_TXTDOMAIN); ?></option>
							<option value="Test token"> <?php _e('Test token', CIP_TXTDOMAIN); ?></option>
							<option value="Mode"> <?php _e('Mode', CIP_TXTDOMAIN); ?></option>
							<option value="Saving"> <?php _e('Saving', CIP_TXTDOMAIN); ?></option>
							<option value="CSR retire"> <?php _e('CSR retire', CIP_TXTDOMAIN); ?></option>
							<option value="CSR Address"> <?php _e('CSR Address', CIP_TXTDOMAIN); ?></option>
							<option value="Company"> <?php _e('Company', CIP_TXTDOMAIN); ?></option>
							<option value="MetaMask"> <?php _e('MetaMask', CIP_TXTDOMAIN); ?></option>
							<option value="requested"> <?php _e('requested', CIP_TXTDOMAIN); ?></option>
							<option value="Security"> <?php _e('Security', CIP_TXTDOMAIN); ?></option>
						</select>
						<textarea name="filter_condition_value_logs_bulk" id="filter_condition_value_logs_bulk" class="form-control mt-2" rows="3" placeholder="<?php _e('Write Here', CIP_TXTDOMAIN ); ?>"></textarea>
					</div>
				</div>
				<div class="modal-footer">
		        	<button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
		        	<button type="button" class="btn btn-secondary filter_csr_cancel" onclick="jQuery('#logsFilterModal').modal('hide');"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
				</div>
			</form>
			<script>
				jQuery(window).on("load",function(){
					jQuery(".logs .filter-control").on("click",function(){
						jQuery('#logsFilterModal').modal({
							show: true
						});
					});
					function log_data_update() {
						var $pool_ref = jQuery('input.bootstrap-table-filter-control-logs[type="search"]');
						let eve = jQuery.Event("keyup");
						console.log("test2");
						eve.which = 13
						eve.keyCode = 13
						$pool_ref.trigger(eve);
						jQuery('#logsFilterModal').modal('hide');
						var filterNoteForm = jQuery('#filter_by_logs');
						var condition_type_text = filterNoteForm.find('select[name="filter_condition_type_logs"] option:selected').text();
						var condition_type = filterNoteForm.find('select[name="filter_condition_type_logs"] option:selected').val();
						var condition_type_value = filterNoteForm.find('select#filter_condition_value_logs_bulk').val();
						var condition_type_value_bulk = filterNoteForm.find('textarea#filter_condition_value_logs_bulk').val();
						var filterText = condition_type_text;
						if( condition_type_value != "" || condition_type_value_bulk != '' ){
							if( condition_type == 'is_exactly_simple' ){
								filterText += ': '+condition_type_value_bulk;
							}else{
								filterText += ': '+condition_type_value_bulk;
							}
						}
						if( condition_type_text == 'None' ){
							filterText = "";
						}
						jQuery('body').find('.log_data').text( filterText );
					};
					jQuery(".log-cs-table [name='clearSearch']").on("click",function(e){
						document.getElementById("filter_by_logs").reset();
						log_data_update();
					});
					jQuery(document).on('click', '.filter_by_logs .filter_csr_ok', function(){ //pool ref
						log_data_update();
					});
				});
			</script>
		    </div>
		  </div>
		</div>
	<?php }
	echo do_shortcode('[API-WALLET-CHANGE-LOG]');
	$html .= ob_get_clean();
	return $html;
}
//support manager import token holders
add_shortcode('CIP-SM-VATAPI-LOGS-VIEW','cip_sm_euvatapi_logs_view_cb');
function cip_sm_euvatapi_logs_view_cb(){
	$html = "";
	ob_start();
	global $wpdb;
	$logTable = $wpdb->prefix.'cip_logs';
	$getLogs = $wpdb->get_var( "SELECT COUNT(id) FROM $logTable WHERE log_type = 'api_track' ORDER BY id desc" );
	if( (current_user_can('supportmanager') || current_user_can('supportagent')) && $getLogs ){
			wp_enqueue_style( 'cip-css' );
			wp_enqueue_style( 'bs-table' );
			wp_enqueue_style( 'bs-sticky-header' );
			wp_enqueue_style( 'bs-datepicker' );
			wp_enqueue_script('bs-table');
			wp_enqueue_script('bs-sticky-header');
			wp_enqueue_script('bs-table-filter-control');
			?>
			<table id="euvatapi_logs_table" data-filter-control="false" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
			<thead>
				<tr>
					<th data-field="id" data-sortable="true" data-filter-control="input" class="id"><?php _e('ID',CIP_TXTDOMAIN); ?></th>
					<th data-field="logs" data-sortable="true" data-filter-control="input" class="logs"><?php _e('Logs',CIP_TXTDOMAIN); ?></th>
					<th data-field="log_type" data-sortable="true" data-filter-control="select" class="log_type" data-filter-custom-search="BsTableFilterStatus"><?php _e('Log Type',CIP_TXTDOMAIN); ?></th>
					<th data-field="_date" data-sortable="true" data-filter-control="input" class="_date"><?php _e('Date',CIP_TXTDOMAIN); ?></th>
				</tr>
			</thead>
			<tbody>
			</tbody>
		</table>
	<?php }
	$html .= ob_get_clean();
	return $html;
}
//REGISTER USER SHORTCODE
add_shortcode( 'CIP_user_register', 'CIP_user_register' );
function CIP_user_register() {
    require("user_registration.php");
    //Calling Register User Function
    CIP_user_registration_function();
}
//REGISTER BUY PACKAGE SHORTCODE
add_shortcode( 'CIP_buy_package', 'CIP_buy_package' );
function CIP_buy_package() {
    require("buy.php");
    //Calling Register User Function
    cip_buy_package_function();
}
//REGISTER CREATE BANK ACCOUNT BY SM SHORTCODE
add_shortcode( 'SM_add_bank_account', 'SM_add_bank_account' );
function SM_add_bank_account() {
    require("SM_Bank_Accounts_management/create_account_form.php");
    //Calling CREATE BANK ACCOUNT Function
    sm_create_account_form();
}
//REGISTER MANAGE/UPDATE BANK ACCOUNT BY SM SHORTCODE
add_shortcode( 'SM_manage_bank_account', 'SM_manage_bank_account' );
function SM_manage_bank_account() {
    require("SM_Bank_Accounts_management/sm_manage_account_details.php");
    //Calling CREATE BANK ACCOUNT Function
    sm_manage_account_details();
}
//REGISTER CREATE BANK ACCOUNT BY SM SHORTCODE
add_shortcode( 'sm_show_account_details', 'sm_show_account_details_function' );
function sm_show_account_details_function() {
    require("SM_Bank_Accounts_management/show_account_details.php");
    //Calling CREATE BANK ACCOUNT Function
    sm_show_account_details();
}
//REGISTER Show Single BANK ACCOUNT Details BY SM SHORTCODE
add_shortcode( 'sm_view_single_account', 'sm_show_single_account_details_function' );
function sm_show_single_account_details_function() {
    require("SM_Bank_Accounts_management/sm_view_single_account.php");
    //Calling CREATE BANK ACCOUNT Function
    sm_view_single_account();
}
//REGISTER Show Member Invoices  BY SA SHORTCODE
add_shortcode( 'sa_view_member_invoice', 'sa_view_member_invoice' );
function sa_view_member_invoice() {
    require("SA_pro_forma_invoices/sa_show_invoices.php");
    sa_member_invoice();
}
// REDIRECTION TO DIFFERENT PAGES AFTER LOGIN BASED ON USER ROLE
add_action('template_redirect', 'cors_after_login_redirect');
function cors_after_login_redirect() {
	$current_user = wp_get_current_user();
    $user_roles = $current_user->roles;
    $user_role = array_shift($user_roles);
	$sa_url = get_permalink( get_page_by_title( 'Support Agent Dashboard' ) );
	$sm_url = get_permalink( get_page_by_title( 'Support Manager Dashboard' ) );
	$member_url = get_permalink( get_page_by_title( 'CSR Holder Dashboard' ) );
	$site = get_site_url();
    if ( is_user_logged_in() ) {
   	  if( is_page('Lobby')) {
   		  if ($user_role == 'supportagent') {
   			  wp_redirect($sa_url);
   		  }
   		 else if($user_role == 'supportmanager'){
   			  wp_redirect($sm_url);
   		  }
   		  else if($user_role == 'member'){
   			  wp_redirect($member_url);
   		  }
   		//   else{
   		// 	   wp_redirect($site);
  		//   }
  	  }
    }
}
// END CODE SECTION
// Register a cip_member_invoice shortcode: [cip_member_invoice]
add_shortcode( 'cip_member_invoice', 'cip_member_invoice_function' );
function cip_member_invoice_function(){
    require("member_invoices.php");
    //Calling Register Support Manager Function
    cip_member_invoice();
}
// Register a cip_member_paid_invoice shortcode: [cip_member_paid_invoice]
add_shortcode( 'cip_member_paid_invoice', 'cip_member_paid_invoice_function' );
function cip_member_paid_invoice_function(){
    require("member_paid_invoices.php");
    //Calling Register Support Manager Function
    cip_member_paid_invoice();
}
// Register a view_invoice shortcode: [view_invoice]
add_shortcode( 'view_invoice', 'view_invoice_function' );
function view_invoice_function(){
   if(isset($_GET['key'])){
	$id = $_GET['key'];
	?>
	<div style="text-align:center;">
		<a class="ml-2" title="View Invoice" target="_blank" href="<?php echo $path; ?>/wp-content/plugins/cip-helper/includes/pdf/download_pdf.php/?key=<?php echo $id; ?>" style="color:#fff;text-decoration:none;">View Purchase Order</a>
	</div>
	<script type = "text/javascript" >
		function preventBack() { window.history.forward(); }
		setTimeout("preventBack()", 0);
		window.onunload = function () { null };
	</script>
	<?php
	}
}
//support manager api control
add_shortcode('SM-VAT-API-SETTING-OPTION','cip_sm_vat_api_setting_option_cb');
function cip_sm_vat_api_setting_option_cb(){
	$html = "";
	ob_start();
	if( current_user_can('supportmanager') || current_user_can('supportagent') ){
		$euvatapi_access_key = ( !empty( get_option('euvatapi_access_key') ) ) ? get_option('euvatapi_access_key') : '9d5cb137a12069fb87aada7a82dc21a3' ;
		$euvatapi_ip_address = ( !empty( get_option('euvatapi_ip_address') ) ) ? get_option('euvatapi_ip_address') : '' ;

		$amplivo_api_mode = ( !empty( get_option('amplivo_api_mode') ) ) ? get_option('amplivo_api_mode') : '' ;
		$selling_price_csr = ( !empty( get_option('selling_price_csr') ) ) ? get_option('selling_price_csr') : '' ;
		$amplivo_api_live_source_url = ( !empty( get_option('amplivo_api_live_source_url') ) ) ? get_option('amplivo_api_live_source_url') : '' ;

		$amplivo_api_test_source_url = ( !empty( get_option('amplivo_api_test_source_url') ) ) ? get_option('amplivo_api_test_source_url') : '' ;
		$amplivo_api_auth_username = ( !empty( get_option('amplivo_api_auth_username') ) ) ? get_option('amplivo_api_auth_username') : '' ;
		$amplivo_api_auth_pwd = ( !empty( get_option('amplivo_api_auth_pwd') ) ) ? get_option('amplivo_api_auth_pwd') : '' ;
		$hall_of_fame_price_type = ( !empty( get_option('hall_of_fame_price_type') ) ) ? get_option('hall_of_fame_price_type') : 'csr' ;
		$selling_price_csr = ( !empty( get_option('selling_price_csr') ) ) ? get_option('selling_price_csr') : 0.025 ;
		$selling_price_csr25 = ( !empty( get_option('selling_price_csr25') ) ) ? get_option('selling_price_csr25') : 0.025 ;
		$selling_kgs = ( !empty( get_option('selling_kgs') ) ) ? get_option('selling_kgs') : 1;
		$selling_price_csr_inc = ( !empty( get_option('selling_price_csr_inc') ) ) ? get_option('selling_price_csr_inc') : 0;
		//echo $selling_price_csr_inc;
	?>
	<form name="sm_api_settings" id="sm_api_settings">
		<h4 class="mb-3"><?php _e('Euvatapi', CIP_TXTDOMAIN); ?></h4>
		<div class="form-group">
			<label for="euvatapi_access_key"><?php _e('Euvatapi Access key', CIP_TXTDOMAIN); ?></label>
			<input type="text" class="form-control" name="euvatapi_access_key" id="euvatapi_access_key" value="<?php echo $euvatapi_access_key; ?>">
		</div>
		<div class="form-group">
			<label for="euvatapi_ip_address"><?php _e('IP Address', CIP_TXTDOMAIN); ?></label>
			<input type="text" class="form-control" name="euvatapi_ip_address" id="euvatapi_ip_address" value="<?php echo $euvatapi_ip_address; ?>">
		</div>

		<!-- <div class="form-group">
			<label for="selling_price_csr"><?php _e('Selling Price of CSR', CIP_TXTDOMAIN); ?></label>
			<input type="number" class="form-control" step="0.00001" name="selling_price_csr" id="selling_price_csr" value="<?php echo $selling_price_csr; ?>" readonly disabled>
		</div> -->
		<div class="form-group" style="display:none;">
			<label for="selling_kgs"><?php _e('Kgs by 1 EUR', CIP_TXTDOMAIN); ?></label>
			<input type="number" class="form-control" step="0.01" name="selling_kgs" id="selling_kgs" value="<?php echo $selling_kgs; ?>">
		</div>
		<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="cip_sm_api_settings_act" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsmapisettingxCIP_'); ?>" />
		<p class="form_response"></p>
	</form>
	<form name="sm_hall_of_fame_price_type_settings" id="sm_hall_of_fame_price_type_settings">
		<h4 class="mb-3"><?php _e('Token', CIP_TXTDOMAIN); ?></h4>
		<div class="form-group">
			<label for="hall_of_fame_price_type"><?php _e('Select Price Type', CIP_TXTDOMAIN); ?></label>
			<select class="form-control" name="hall_of_fame_price_type" id="hall_of_fame_price_type">
				<option <?php echo ($hall_of_fame_price_type == 'csr') ? 'selected' : '' ;?> value="csr">CSR</option>
				<option <?php echo ($hall_of_fame_price_type == 'csr25') ? 'selected' : '' ;?> value="csr25">CSR25</option>
			</select>
		</div>
		<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="cip_hall_of_fame_price_type_settings_act" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxhall_of_fame_price_typesettingxCIP_'); ?>" />
		<p class="form_response"></p>
	</form>
	<br/>
	<hr class="pt-1 pb-1">
	<div class="row">
		<div class="col-6">
			<h4 class="mb-3"><?php _e('CSR price', CIP_TXTDOMAIN); ?></h4>
			<div class="form-group">
				<label for="selling_price_csr"><?php _e('Current Active Selling Price of CSR', CIP_TXTDOMAIN); ?></label>
				<input type="number" class="form-control" step="0.00001" name="selling_price_csr" id="selling_price_csr" value="<?php echo $selling_price_csr; ?>" readonly disabled>
			</div>
		</div>
	</div>
	<hr class="pt-1 pb-1">
	<div class="row">
		<div class="col-6">
			<h4 class="mb-3"><?php _e('CSR25 price', CIP_TXTDOMAIN); ?></h4>
			<div class="form-group">
				<label for="selling_price_csr"><?php _e('Current Active Selling Price of CSR25', CIP_TXTDOMAIN); ?></label>
				<input type="number" class="form-control" step="0.00001" name="selling_price_csr" id="selling_price_csr" value="<?php echo $selling_price_csr25; ?>" readonly disabled>
			</div>
		</div>
	</div>
	<?php
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CSR-HOLDER-OWN-WALLET-AMOUNT','cip_csr_holder_own_wallet_amount_cb');
function cip_csr_holder_own_wallet_amount_cb(){
	$html = "";
	ob_start();
	global $wpdb;
	$tableCsrSavings = $wpdb->prefix.'csr_savings';
	$refAccount = ( isset( $_SESSION['refAccount'] ) ) ? $_SESSION['refAccount'] : '-';
	$getSavings = $wpdb->get_results("SELECT * FROM $tableCsrSavings WHERE `email` = '".$refAccount."'");
	if( current_user_can('member') && $getSavings ){
			wp_enqueue_style( 'cip-css' );
			wp_enqueue_style( 'bs-table' );
			wp_enqueue_style( 'bs-sticky-header' );
			wp_enqueue_style( 'bs-datepicker' );
			wp_enqueue_script('bs-table');
			wp_enqueue_script('bs-sticky-header');
			wp_enqueue_script('bs-table-filter-control');
			wp_enqueue_script('dr-moment');
			wp_enqueue_script('daterangepicker-script');

			?>
			<h5 style="text-align: left;"><?php _e('CSR Savings', CIP_TXTDOMAIN); ?></h5>
			<table id="cip_amount_wallet_table" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
		  <thead>
				<tr>
					<th data-field="id" data-sortable="false" class="id"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
					<th data-field="status" data-sortable="true" data-filter-control="select" data-filter-data="var:filterSavingsStatus" class="status"><?php _e('Status',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Status of savings', CIP_TXTDOMAIN) ); ?></th>
					<th data-field="reference" data-sortable="true" data-filter-control="input" class="reference"><?php _e('Reference number',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Unique redemption reference number', CIP_TXTDOMAIN) ); ?></th>
					<th data-field="saved_amount" data-sortable="true" data-filter-control="input" class="saved_amount"><?php _e('CSR Saved Amount',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Amount of CSR set to saving / staking', CIP_TXTDOMAIN) ); ?></th>
					<th data-field="accrued_interest" data-sortable="false" class="accrued_interest"><?php _e('Accrued Interest',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Amount of CSR earned in interest until today', CIP_TXTDOMAIN) ); ?></th>
					<th data-field="interest_due" data-sortable="false" class="interest_due"><?php _e('Interest Due',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __(' Calculated interest amount in CSR earned at the end of saving / staking period', CIP_TXTDOMAIN) ); ?></th>
					<th data-field="saving_interest" data-sortable="true" data-filter-control="input" class="saving_interest"><?php _e('Saving interest',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Interest amount selected for saving / staking period in percentage', CIP_TXTDOMAIN) ); ?></th>
					<th data-field="saving_periods" data-sortable="true" data-filter-control="input" class="saving_periods"><?php _e('Saving Period',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Period selected for saving / staking in days', CIP_TXTDOMAIN) ); ?></th>
					<th data-field="saving_start_date" data-sortable="true" data-filter-control="input" class="saving_start_date"><?php _e('Saving Start Date',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Date when saving / staking application was activated in CSRnow.com system', CIP_TXTDOMAIN) ); ?></th>
					<th data-field="saving_end_date" data-sortable="true" data-filter-control="input" class="saving_end_date"><?php _e('Date of maturity',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Date of maturity', CIP_TXTDOMAIN) ); ?></th>
				</tr>
			</thead>
			<tbody>
		</tbody>
		</table>
	<?php }else{
		// echo '<h5>'.__('CSR Savings', CIP_TXTDOMAIN).'</h5>';
		echo '<h4 class="csr_central_title text-center">'.__('You do not have any saving',CIP_TXTDOMAIN).'</h4>';
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CIP-SA-HOLDERS-ADDRESS-STATUS-VIEW','cip_sa_holders_address_status_view_cb');
function cip_sa_holders_address_status_view_cb(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'bs-datepicker' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	ob_start();
	if( is_user_logged_in() && current_user_can('supportagent') ){
		global $wpdb;
		$tableName = $wpdb->prefix.'token_holder';
		$user_id = -1;
		$getCurrentMembers = $wpdb->get_results("SELECT id FROM $tableName WHERE (imported_by != ".$user_id." OR imported_by IS NULL) ORDER BY `id` DESC");
		if( $getCurrentMembers ){
			$filter_attr = 'data-filter-control="input"';
		?>
		<div class="table-responsive">
			<table id="tokenholder_sa_addresslist" class="tokenholder_sa_addresslist" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-show-columns="true" data-show-toggle="false" data-click-to-select="true" data-show-columns-toggle-all="true" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
				<thead>
					<tr>
						<th data-field="id" class="id"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
						<th data-field="email" data-sortable="true" <?php echo $filter_attr; ?> class="email"><?php echo __('Email',CIP_TXTDOMAIN); ?></th>
						<th data-field="eth_address" data-sortable="true" <?php echo $filter_attr; ?> class="eth_address"><?php echo __('CSR Wallet Address',CIP_TXTDOMAIN); ?></th>
						<th data-field="eth_address_status" data-sortable="true" data-filter-control="select" data-filter-custom-search="BsTableFilterStatus" data-filter-data="var:AddressVerifyStatus" class="eth_address_status"><?php echo __('CSR address status',CIP_TXTDOMAIN); ?></th>
					</tr>
				</thead>
				<tbody>

				</tbody>
			</table>
		</div>
		<?php
		}else{ ?>
		<h2><?php _e('No results found',CIP_TXTDOMAIN); ?></h2>
		<?php }
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('SM-CSR-WALLET-SETTINGS','cip_sm_csr_wallet_settings_cb');
function cip_sm_csr_wallet_settings_cb(){
	$html = "";
	$csr_wallet_api_mode = ( !empty( get_option('csr_wallet_api_mode') ) ) ? get_option('csr_wallet_api_mode') : 'test' ;
	$csr25_wallet_api_mode = ( !empty( get_option('csr25_wallet_api_mode') ) ) ? get_option('csr25_wallet_api_mode') : 'test' ;
	$csr_wallet_api_mode_test_tkn = ( !empty( get_option('csr_wallet_api_mode_test_tkn') ) ) ? get_option('csr_wallet_api_mode_test_tkn') : '' ;
	$csr25_wallet_api_mode_test_tkn = ( !empty( get_option('csr25_wallet_api_mode_test_tkn') ) ) ? get_option('csr25_wallet_api_mode_test_tkn') : '' ;
	$csr_wallet_api_mode_test_api = ( !empty( get_option('csr_wallet_api_mode_test_api') ) ) ? get_option('csr_wallet_api_mode_test_api') : '' ;
	$csr25_wallet_api_mode_test_api = ( !empty( get_option('csr25_wallet_api_mode_test_api') ) ) ? get_option('csr25_wallet_api_mode_test_api') : '' ;
	$csr_wallet_api_mode_live_tkn = ( !empty( get_option('csr_wallet_api_mode_live_tkn') ) ) ? get_option('csr_wallet_api_mode_live_tkn') : '' ;
	$csr25_wallet_api_mode_live_tkn = ( !empty( get_option('csr25_wallet_api_mode_live_tkn') ) ) ? get_option('csr25_wallet_api_mode_live_tkn') : '' ;
	$csr_wallet_api_mode_live_api = ( !empty( get_option('csr_wallet_api_mode_live_api') ) ) ? get_option('csr_wallet_api_mode_live_api') : '' ;
	$csr25_wallet_api_mode_live_api = ( !empty( get_option('csr25_wallet_api_mode_live_api') ) ) ? get_option('csr25_wallet_api_mode_live_api') : '' ;
	$test_mode_style = ( $csr_wallet_api_mode == 'test' ) ? 'display:block' : 'display:none';
	$live_mode_style = ( $csr_wallet_api_mode == 'live' ) ? 'display:block' : 'display:none';
	$test_mode_style_25 = ( $csr25_wallet_api_mode == 'test' ) ? 'display:block' : 'display:none';
	$live_mode_style_25 = ( $csr25_wallet_api_mode == 'live' ) ? 'display:block' : 'display:none';
	$csr_wallet_fund_receiver_address = ( !empty( get_option('csr_wallet_fund_receiver_address') ) ) ? get_option('csr_wallet_fund_receiver_address') : '' ;
	$retirement_csr_address = ( !empty( get_option('retirement_csr_address') ) ) ? get_option('retirement_csr_address') : '' ;
	$retirement_csr25_address = ( !empty( get_option('retirement_csr25_address') ) ) ? get_option('retirement_csr25_address') : '' ;
	$csr_retirement_confirmation_block = ( !empty( get_option('csr_retirement_confirmation_block') ) ) ? get_option('csr_retirement_confirmation_block') : '' ;
	$csr_retirement_banner_initial_delay = ( !empty( get_option('csr_retirement_banner_initial_delay') ) ) ? get_option('csr_retirement_banner_initial_delay') : 60 ;
	$csr_retirement_banner_interval = ( !empty( get_option('csr_retirement_banner_interval') ) ) ? get_option('csr_retirement_banner_interval') : 300 ;
	$csr_retirement_banner_display_time = ( !empty( get_option('csr_retirement_banner_display_time') ) ) ? get_option('csr_retirement_banner_display_time') : 3 ;
	ob_start();
	?>

	    <div class="main-container-wrapper">
	        <nav class="nav nav-tabs nav-justified">
	            <a class="nav-item nav-link active" data-toggle="tab" href="#csr_wallet_api_mode"><i class='fas fa-cog'></i> <?php _e('CSR Wallet API Mode',CIP_TXTDOMAIN); ?></a>
	            <a class="nav-item nav-link" data-toggle="tab" href="#retirement_banners"><i class='fas fa-cog'></i> <?php _e('Retirement Banners',CIP_TXTDOMAIN); ?></a>
	            <a class="nav-item nav-link" data-toggle="tab" href="#retirement_settings"><i class='fas fa-cog'></i> <?php _e('Retirement Settings',CIP_TXTDOMAIN); ?></a>
	            <a class="nav-item nav-link" data-toggle="tab" href="#csr_saving_address"><i class='fas fa-cog'></i> <?php _e('CSR Saving Address',CIP_TXTDOMAIN); ?></a>
	            <a class="nav-item nav-link" data-toggle="tab" href="#csr_withdrawals_setting"><i class='fas fa-cog'></i> <?php _e('CSR Withdrawals Setting',CIP_TXTDOMAIN); ?></a>
	            <a class="nav-item nav-link" data-toggle="tab" href="#csr_25_wallet_api_mode"><i class='fas fa-cog'></i> <?php _e('CSR 25 Wallet API Mode',CIP_TXTDOMAIN); ?></a>
	        </nav>
	        <div></div>
	        <div class="tab-content">
	            <div id="csr_wallet_api_mode" class="tab-pane fade in active show">
	            	<form name="sm_csr_api_setting_form" id="sm_csr_api_setting_form">
	            		<div class="form-group">
							<h5><?php _e('CSR Wallet API Mode', CIP_TXTDOMAIN); ?></h5>
							<div class="d-flex">
								<div class="form-check-inline">
									<label class="form-check-label d-flex"><input type="radio" name="csr_wallet_api_mode" class="form-check-input" value="test" <?php echo checked( $csr_wallet_api_mode, 'test' ); ?>><?php _e('Test', CIP_TXTDOMAIN); ?></label>
								</div>
								<div class="form-check-inline">
									<label class="form-check-label d-flex"><input type="radio" name="csr_wallet_api_mode" class="form-check-input" value="live" <?php echo checked( $csr_wallet_api_mode, 'live' ); ?>><?php _e('Live', CIP_TXTDOMAIN); ?></label>
								</div>								
							</div>
						</div>
						<div class="form-group csr_wallet_api_mode_test" style="<?php echo $test_mode_style; ?>">
							<label for="csr_wallet_api_mode_test_tkn"><?php _e('Token Address CSR', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" name="csr_wallet_api_mode_test_tkn" id="csr_wallet_api_mode_test_tkn" value="<?php echo $csr_wallet_api_mode_test_tkn; ?>">
						</div>
						<div class="form-group csr_wallet_api_mode_test" style="<?php echo $test_mode_style; ?>">
							<label for="csr_wallet_api_mode_test_api"><?php _e('TestNet API', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" name="csr_wallet_api_mode_test_api" id="csr_wallet_api_mode_test_api" value="<?php echo $csr_wallet_api_mode_test_api; ?>">
						</div>
						<div class="form-group csr_wallet_api_mode_live" style="<?php echo $live_mode_style; ?>">
							<label for="csr_wallet_api_mode_live_tkn"><?php _e('Token Address CSR', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" name="csr_wallet_api_mode_live_tkn" id="csr_wallet_api_mode_live_tkn" value="<?php echo $csr_wallet_api_mode_live_tkn; ?>">
						</div>
						<div class="form-group csr_wallet_api_mode_live" style="<?php echo $live_mode_style; ?>">
							<label for="csr_wallet_api_mode_live_api"><?php _e('MainNet API', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" name="csr_wallet_api_mode_live_api" id="csr_wallet_api_mode_live_api" value="<?php echo $csr_wallet_api_mode_live_api; ?>">
						</div>

						<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
						<input type="hidden" name="action" value="cip_sm_csr_api_setting_form_act" />
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsm_API_settings_xCIP_'); ?>" />
						<p class="form_response"></p>
	            	</form>
	            </div>
	            <div id="retirement_banners" class="tab-pane fade in">
					<form name="retirement_banners_setting_frm" id="retirement_banners_setting_frm">
						<h5><?php _e('Retirement Banners', CIP_TXTDOMAIN); ?></h5>
						<div class="form-group csr_retirement_banner_initial_delay">
							<label for="csr_retirement_banner_initial_delay"><?php _e('Initial Delay (in sec)', CIP_TXTDOMAIN); ?></label>
							<input type="number" class="form-control" min="1" step="1" name="csr_retirement_banner_initial_delay" id="csr_retirement_banner_initial_delay" value="<?php echo $csr_retirement_banner_initial_delay; ?>">
						</div>
						<div class="form-group csr_retirement_banner_interval">
							<label for="csr_retirement_banner_interval"><?php _e('Interval (in sec)', CIP_TXTDOMAIN); ?></label>
							<input type="number" class="form-control" min="1" step="1" name="csr_retirement_banner_interval" id="csr_retirement_banner_interval" value="<?php echo $csr_retirement_banner_interval; ?>">
						</div>
						<div class="form-group csr_retirement_banner_display_time">
							<label for="csr_retirement_banner_display_time"><?php _e('Display time (in sec)', CIP_TXTDOMAIN); ?></label>
							<input type="number" class="form-control" min="1" step="1" name="csr_retirement_banner_display_time" id="csr_retirement_banner_display_time" value="<?php echo $csr_retirement_banner_display_time; ?>">
						</div>
						
						<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
						<input type="hidden" name="action" value="cip_sm_retirement_banners_settings_act" />
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsm_retirement_BANNERS_settings_xCIP_'); ?>" />
						<p class="form_response"></p>
					</form>
	            </div>
	            <div id="retirement_settings" class="tab-pane fade in">
	            	<form name="retirement_settings_form" id="retirement_settings_form">
						<h5><?php _e('Retirement Settings', CIP_TXTDOMAIN); ?></h5>

						<div class="form-group retirement_confirmation_block_section">
							<label for="csr_retirement_confirmation_block"><?php _e('Retirement confirmation block', CIP_TXTDOMAIN); ?></label>
							<input type="number" class="form-control" min="0" step="1" name="csr_retirement_confirmation_block" id="csr_retirement_confirmation_block" value="<?php echo $csr_retirement_confirmation_block; ?>">
						</div>
						
						<h5><?php _e('Address for the retirement of CSR', CIP_TXTDOMAIN); ?></h5>
						<div class="form-group">
							<label for="retirement_csr_address"><?php _e('Retirement of CSR', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" name="retirement_csr_address" id="retirement_csr_address" value="<?php echo $retirement_csr_address; ?>">
						</div>

						<h5><?php _e('Address for the retirement of CSR25', CIP_TXTDOMAIN); ?></h5>
						<div class="form-group">
							<label for="retirement_csr25_address"><?php _e('Retirement of CSR25', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" name="retirement_csr25_address" id="retirement_csr25_address" value="<?php echo $retirement_csr25_address; ?>">
						</div>


						<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
						<input type="hidden" name="action" value="cip_sm_retirement_settings_act" />
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsm_retirement_SETTINGS_xCIP_'); ?>" />
						<p class="form_response"></p>

	            	</form>
	            	<!-- <form name="sm_csr_retirement_mm_transfer_frm" id="sm_csr_retirement_mm_transfer_frm" method="post" onsubmit="verify_mm_retirement_address(); return false;">
						<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
						<input type="hidden" name="action" value="cip_sm_cse_retirement_mm_transfer_settings_act" />
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsm_csrretirement_MM_transfer_settingxCIP_'); ?>" />
						<p class="form_response"></p>
					</form> -->
	            </div>

	            <div id="csr_saving_address" class="tab-pane fade in">
	            	<form name="sm_csr_wallet_mm_transfer_frm" id="sm_csr_wallet_mm_transfer_frm" method="post" onsubmit="verify_mm_address(); return false;">
						<h5><?php _e('CSR Saving Wallet Fund Receiver Address', CIP_TXTDOMAIN); ?></h5>
						<div class="form-group">
							<label for="csr_wallet_fund_receiver_address"><?php _e('Fund receiver address', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" name="csr_wallet_fund_receiver_address" id="csr_wallet_fund_receiver_address" value="<?php echo $csr_wallet_fund_receiver_address; ?>">
						</div>
						<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
						<input type="hidden" name="action" value="cip_sm_cse_wallet_mm_transfer_settings_act" />
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsm_csrwallet_MM_transfer_settingxCIP_'); ?>" />
						<p class="form_response"></p>
					</form>
					
	            </div>

	            <div id="csr_withdrawals_setting" class="tab-pane fade in">
           			<?php
					$csr_withdrawals_report_amount = ( !empty( get_option('csr_withdrawals_report_amount') ) ) ? get_option('csr_withdrawals_report_amount') : 50000;
					$userCancelWithdrawalSwitch = ( !empty( get_option('csr_user_cancel_withdrawal_switch_stop') ) ) ? get_option('csr_user_cancel_withdrawal_switch_stop') : 0;
					?>
					<form name="csr_withdrawals_report_amount_settings_frm" id="csr_withdrawals_report_amount_settings_frm" method="post">
						<h5><?php _e('CSR Withdrawals Report Amount', CIP_TXTDOMAIN); ?></h5>
						<div class="form-group">
							<label for="csr_withdrawals_report_amount"><?php _e('CSR Withdrawals Report Amount', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" min="1" step="1" name="csr_withdrawals_report_amount" id="csr_withdrawals_report_amount" value="<?php echo $csr_withdrawals_report_amount; ?>">
						</div>

						<h5><?php _e('Users cancelling withdrawals', CIP_TXTDOMAIN); ?></h5>
						<div class="form-group">
							<div class="custom-control custom-switch">
								<input type="checkbox" class="custom-control-input" name="user_cancel_withdrawal_switch" id="user_cancel_withdrawal_switch" value="1" <?php checked( 1, $userCancelWithdrawalSwitch, true ); ?>>
								<label class="custom-control-label" for="user_cancel_withdrawal_switch"><?php _e('Enabled / Disabled', CIP_TXTDOMAIN); ?></label>
							</div>
						</div>
						
						<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
						<input type="hidden" name="action" value="cip_csr_withdrawals_report_amount_settings_act" />
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxcsrWithdrawalsReportAmountxCIP_'); ?>" />
						<p class="form_response"></p>
					</form>
					
	            </div>

	            <div id="csr_25_wallet_api_mode" class="tab-pane fade in">
	            	<form name="sm_csr25_wallet_settings" id="sm_csr25_wallet_settings">
						<div class="form-group">
							<h5><?php _e('CSR 25 Wallet API Mode', CIP_TXTDOMAIN); ?></h5>
							<div class="d-flex">
								<div class="form-check-inline">
									<label class="form-check-label d-flex"><input type="radio" name="csr25_wallet_api_mode" class="form-check-input" value="test" <?php echo checked( $csr25_wallet_api_mode, 'test' ); ?>><?php _e('Test', CIP_TXTDOMAIN); ?></label>
								</div>
								<div class="form-check-inline">
									<label class="form-check-label d-flex"><input type="radio" name="csr25_wallet_api_mode" class="form-check-input" value="live" <?php echo checked( $csr25_wallet_api_mode, 'live' ); ?>><?php _e('Live', CIP_TXTDOMAIN); ?></label>
								</div>
							</div>
						</div>
						<div class="form-group csr25_wallet_api_mode_test" style="<?php echo $test_mode_style_25; ?>">
							<label for="csr25_wallet_api_mode_test_tkn"><?php _e('Token Address CSR 25', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" name="csr25_wallet_api_mode_test_tkn" id="csr25_wallet_api_mode_test_tkn" value="<?php echo $csr25_wallet_api_mode_test_tkn; ?>">
						</div>
						<div class="form-group csr25_wallet_api_mode_test" style="<?php echo $test_mode_style_25; ?>">
							<label for="csr25_wallet_api_mode_test_api"><?php _e('TestNet API 25', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" name="csr25_wallet_api_mode_test_api" id="csr25_wallet_api_mode_test_api" value="<?php echo $csr25_wallet_api_mode_test_api; ?>">
						</div>
						<!-- Live -->
						<div class="form-group csr25_wallet_api_mode_live" style="<?php echo $live_mode_style_25; ?>">
							<label for="csr25_wallet_api_mode_live_tkn"><?php _e('Token Address CSR 25', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" name="csr25_wallet_api_mode_live_tkn" id="csr25_wallet_api_mode_live_tkn" value="<?php echo $csr25_wallet_api_mode_live_tkn; ?>">
						</div>
						<div class="form-group csr25_wallet_api_mode_live" style="<?php echo $live_mode_style_25; ?>">
							<label for="csr25_wallet_api_mode_live_api"><?php _e('MainNet API 25', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" name="csr25_wallet_api_mode_live_api" id="csr25_wallet_api_mode_live_api" value="<?php echo $csr25_wallet_api_mode_live_api; ?>">
						</div>
						<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
						<input type="hidden" name="action" value="cip_sm_cse_wallet_settings_act_25" />
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsm_csrwallet_settingxCIP_'); ?>" />
						<p class="form_response"></p>
					</form>
	            </div>
	        </div>  
    	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('SM-SAVING-PLANS-SETTINGS','cip_sm_saving_plans_settings_cb');
function cip_sm_saving_plans_settings_cb(){
    if( current_user_can( 'supportmanager' ) || current_user_can( 'supportagent' ) ){
	$html = "";
	global $wpdb;
	$tablePlans = $wpdb->prefix.'saving_plans';
	ob_start();
	$add_plan_url = $importLink = add_query_arg( 'action', 'add', get_permalink() );
	if( isset( $_GET['action'] ) && $_GET['action'] == 'add' ){	// add saving plans
	?>
	<div class="row">
	<div class="col-12">
		<form name="cip_saving_plans" id="cip_saving_plans">
		<div class="form-row">
			<div class="form-group col-md-4">
				<label for="plan_name"><?php _e('Plan Name*',CIP_TXTDOMAIN); ?></label>
				<input type="text" class="form-control" name="plan_name" id="plan_name" />
			</div>
			<div class="form-group col-md-4">
				<label for="locking_period"><?php _e('Locking period*',CIP_TXTDOMAIN); ?></label>
				<select name="locking_period" class="form-select">
					<option value="365"><?php _e('12 Months (365 days)',CIP_TXTDOMAIN); ?></option>
					<option value="182"><?php _e('6 Months (182 days)',CIP_TXTDOMAIN); ?></option>
				</select>
			</div>
			<div class="form-group col-md-4">
				<label for="plan_interest"><?php _e('Plan Interest*',CIP_TXTDOMAIN); ?></label>
				<input type="number" class="form-control" name="plan_interest" id="plan_interest" />
			</div>
		</div>
		<button type="submit" class="btn btn-primary"><?php _e('Add', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="cip_addsaving_plan" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsmsavingplanaddxCIP_'); ?>" />
		<p class="form_response"></p>
		</form>
	</div>
	</div>
	<?php
	}else if( isset( $_GET['action'] ) && $_GET['action'] == 'edit' && $_GET['pid'] != "" ){	// add saving plans
		$getPlan = $wpdb->get_row("SELECT * FROM $tablePlans WHERE id=".$_GET['pid']."");
		if( $getPlan ){
		?>
		<div class="row">
		<div class="col-12">
			<form name="cip_saving_plans_edit" id="cip_saving_plans_edit">
			<div class="form-row">
				<div class="form-group col-md-4">
					<label for="plan_name"><?php _e('Plan Name*',CIP_TXTDOMAIN); ?></label>
					<input type="text" class="form-control" name="plan_name" id="plan_name" value="<?php echo $getPlan->plan_name; ?>" />
				</div>
				<div class="form-group col-md-4">
					<label for="locking_period"><?php _e('Locking period*',CIP_TXTDOMAIN); ?></label>
					<select name="locking_period" class="form-select">
						<option value="365" <?php echo selected( '365', $getPlan->plan_periods ); ?>><?php _e('12 Months (365 days)',CIP_TXTDOMAIN); ?></option>
						<option value="182" <?php echo selected( '182', $getPlan->plan_periods ); ?>><?php _e('6 Months (182 days)',CIP_TXTDOMAIN); ?></option>
					</select>
				</div>
				<div class="form-group col-md-4">
					<label for="plan_interest"><?php _e('Plan Interest*',CIP_TXTDOMAIN); ?></label>
					<input type="number" class="form-control" name="plan_interest" id="plan_interest" value="<?php echo $getPlan->plan_interest; ?>" />
				</div>
			</div>
			<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
			<a href="<?php echo get_permalink(); ?>" type="button" class="btn btn-primary"><?php _e('Cancel', CIP_TXTDOMAIN); ?></a>
			<input type="hidden" name="action" value="cip_addsaving_plan_edit" />
			<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsmsavingplaneditxCIP_'); ?>" />
			<p class="form_response"></p>
			</form>
		</div>
		</div>
		<?php
		}
	}else{ //display added saving plans
	?>
		<div id="custom_toolbar">
			<a href="<?php echo $add_plan_url; ?>" class="btn btn-primary"><?php _e('Add New',CIP_TXTDOMAIN); ?></a>
		</div>
	<?php
		$getPlans = $wpdb->get_results("SELECT * FROM $tablePlans WHERE plan_status = 1");
		wp_enqueue_style( 'cip-css' );
		wp_enqueue_style( 'bs-table' );
		wp_enqueue_style( 'bs-sticky-header' );
		wp_enqueue_style( 'bs-datepicker' );
		wp_enqueue_script('bs-table');
		wp_enqueue_script('bs-sticky-header');
		wp_enqueue_script('bs-table-filter-control');
		wp_enqueue_script('bs-datepicker');
		?>

		<table id="cip_saving_plans_table"
		data-filter-control="true" data-toolbar="#custom_toolbar"
		data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="true" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered">
		<thead>
			<tr>
				<th data-field="plan_id" data-sortable="false" class="plan_id"><?php _e('Plan Id',CIP_TXTDOMAIN); ?></th>
				<th data-field="plan_name" data-sortable="true" data-filter-control="input" class="plan_name"><?php _e('Plan Name',CIP_TXTDOMAIN); ?></th>
				<th data-field="plan_periods" data-sortable="true" data-filter-control="input" class="plan_periods"><?php _e('Plan Period(days)',CIP_TXTDOMAIN); ?></th>
				<th data-field="plan_interest" data-sortable="true" data-filter-control="input" class="plan_interest"><?php _e('Plan Interest(%)',CIP_TXTDOMAIN); ?></th>
				<th data-field="action" data-sortable="false" data-filter-control="false" class="action"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
			</tr>
		</thead>
	<?php
		if( $getPlans ){
			foreach( $getPlans as $getPlan ){
				$edit_plan_url = add_query_arg( ['action' => 'edit','pid' => $getPlan->id], get_permalink() );
				$edit_link = '<a class="mr-2" href="'.$edit_plan_url.'" data-toggle-tt="tooltip" data-placement="top" title="'.__('Edit',CIP_TXTDOMAIN).'"><i class=" fa fa-edit"></i></a>';
			?>
			<tr>
				<td><?php echo $getPlan->id; ?></td>
				<td><?php echo $getPlan->plan_name; ?></td>
				<td><?php echo $getPlan->plan_periods; ?></td>
				<td><?php echo $getPlan->plan_interest; ?></td>
				<td class="d-flex"><?php echo $edit_link; ?></td>
			</tr>
			<?php
			}
		}
		?>
	</table>
	<?php
	}
	$html .= ob_get_clean();
	return $html;
    }
}
add_shortcode('CIP-MEMBER-TOKEN-RETIRMENT-DATA-VIEW','cip_member_token_retirment_data_view_cb');
function cip_member_token_retirment_data_view_cb(){
	$html = "";
	global $wpdb;
	$tableName = $wpdb->prefix.'token_holder';
	$tableNameCol = $wpdb->prefix.'token_holder_columns';
	$tableRetirement = $wpdb->prefix.'retirement_data';
	$refAccount = $_SESSION['refAccount'];
	if( (isset( $_GET['fromdate'] ) && isset( $_GET['todate'] )) && (!empty( $_GET['fromdate'] ) && !empty( $_GET['todate'] )) ){
		$getCurrentMembers = $wpdb->get_results("SELECT * FROM $tableName WHERE email = '".$refAccount."' AND ( ( STR_TO_DATE(redemption_date,'%d/%m/%Y') >= STR_TO_DATE('" . $_GET['fromdate'] . "', '%d/%m/%Y') AND STR_TO_DATE(redemption_date,'%d/%m/%Y') <= STR_TO_DATE('" . $_GET['todate'] . "', '%d/%m/%Y') ) OR ( STR_TO_DATE(claim_date,'%d/%m/%Y') >= STR_TO_DATE('" . $_GET['fromdate'] . "', '%d/%m/%Y') AND STR_TO_DATE(claim_date,'%d/%m/%Y') <= STR_TO_DATE('" . $_GET['todate'] . "', '%d/%m/%Y') ) ) ");
	}else{
		$getCurrentMembers = $wpdb->get_results("SELECT * FROM $tableName WHERE `email` = '".$refAccount."' AND `eth_address` <> '' AND `token` <> '' GROUP BY `eth_address`, `token`");
	}
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'bs-datepicker' );
	wp_enqueue_script('cip-abi');
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('tbl-ex-js');
	wp_enqueue_script('jspdf');
	wp_enqueue_script('pdf-autotable-js');
	wp_enqueue_script('ex-js');
	wp_enqueue_script('bs-datepicker');
	ob_start();
	?>
	<div class="table-responsive">
	<?php
	if( $getCurrentMembers ){
		global $defaultColumnsArr;
	
	?>
	<table id="tokenholder_table_retirment_loader" class="table table-bordered" data-filter-control="false" data-show-search-clear-button="false" data-pagination="true" data-show-columns="false" data-show-toggle="false" data-click-to-select="true" data-show-columns-toggle-all="false" data-side-pagination="server" data-pagination="false" data-show-footer="false">
		<thead>
			<tr>
				<th data-field="id" class="id" data-switchable="false"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
				<th data-field="plastic_credit" class="plastic_credit" data-switchable="false"><?php _e('Plastic Credit',CIP_TXTDOMAIN); ?></th>
				<th data-field="eth_address" data-sortable="false" data-switchable="false" class="eth_address"><?php _e('CSR Wallet Address',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('External CSR Wallet address for CSR distribution', CIP_TXTDOMAIN) ); ?></th>
				<th data-field="eth_balance" class="eth_balance" data-sortable="false" data-switchable="false"><?php _e('Balance',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Amount of CSR in the External CSR wallet address available for retirement', CIP_TXTDOMAIN) ); ?></th>
				<th data-field="action" class="action" data-switchable="false"><?php _e('Action',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Actions that can be performed with this External CSR wallet address', CIP_TXTDOMAIN) ); ?></th>
			</tr>
		</thead>
		<tbody>
		</tbody>
	</table>

	<div class="modal fade" id="chooseRetireAmount" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-body">
					
				</div>
			</div>
		</div>
	</div>
	
	<div class="modal fade" id="showRetireDetails" tabindex="-1" role="dialog" aria-hidden="true" style="font-family: 'Montserrat';">
		<div class="modal-dialog modal-dialog-centered modal-xl text-left" role="document">
			<div class="modal-content">
				<div class="modal-body">
					
				</div>
			</div>
		</div>
	</div>
	
	<?php }else{ ?>
	<h2 class="csr_central_title"><?php _e('You have no CSR Retirement Records',CIP_TXTDOMAIN); ?></h2>
	<?php } ?>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CSR-HALL-OF-FAME','cip_csr_hall_of_fame_callback');
function cip_csr_hall_of_fame_callback(){
	$html = "";
	global $wpdb;
	$tableRetirement = $wpdb->prefix.'retirement_data';
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'bs-datepicker' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('bs-datepicker');
	$getRetirements = $wpdb->get_results("SELECT * FROM $tableRetirement");
	ob_start();
	?>
	<table id="retirement_table" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
		<thead>
			<tr>
				<th data-field="member_logo" class="member_logo"></th>
				<th data-field="fullname" data-sortable="false" data-filter-control="input" data-switchable="false" class="fullname"><?php _e('Name',CIP_TXTDOMAIN); ?></th>
				<th data-field="eth_address" data-sortable="false" data-filter-control="input" data-switchable="false" class="eth_address"><?php _e('CSR address',CIP_TXTDOMAIN); ?></th>
				<th data-field="retire_transhash" data-filter-control="input" class="retire_transhash" data-switchable="false"><?php _e('Transaction hash',CIP_TXTDOMAIN); ?></th>
				<th data-field="retire_amount" class="retire_amount" data-filter-control="input" data-sortable="true" data-switchable="false"><?php _e('Amount',CIP_TXTDOMAIN); ?></th>
				<th data-field="retire_confirm_date" class="retire_confirm_date" data-filter-control="input" data-sortable="true" data-switchable="false"><?php _e('Age',CIP_TXTDOMAIN); ?></th>
			</tr>
		</thead>
		<tbody>
		</tbody>
	</table>
	<?php
	$html = ob_get_clean();
	return $html;
}
add_shortcode('HOLDERS-CSR-RETIREMENT-LIST','cip_holders_csr_retirement_list_cb');
function cip_holders_csr_retirement_list_cb(){
	$html = "";
	global $wpdb;
	$tableRetirement = $wpdb->prefix.'retirement_data';
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'bs-datepicker' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('bs-datepicker');
	ob_start();
	?>
	<table id="holders_retirement_table" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
		<thead>
			<tr>
				<th data-field="fullname" data-sortable="false" data-filter-control="input" data-switchable="false" class="fullname"><?php _e('Name',CIP_TXTDOMAIN); ?></th>
				<th data-field="eth_address" data-sortable="false" data-filter-control="input" data-switchable="false" class="eth_address"><?php _e('CSR Wallet Address',CIP_TXTDOMAIN); ?></th>
				<th data-field="retire_transhash" data-filter-control="input" class="retire_transhash" data-switchable="false"><?php _e('Transaction hash',CIP_TXTDOMAIN); ?></th>
				<th data-field="retire_amount" class="retire_amount" data-filter-control="input" data-sortable="true" data-switchable="false"><?php _e('Number of CSR',CIP_TXTDOMAIN); ?></th>
				<th data-field="retire_confirm_date" class="retire_confirm_date" data-filter-control="input" data-sortable="true" data-switchable="false"><?php _e('Age',CIP_TXTDOMAIN); ?></th>
				<th data-field="token" class="token" data-sortable="false" data-switchable="true"><?php _e('Token',CIP_TXTDOMAIN); ?></th>
			</tr>
		</thead>
		<tbody>
		</tbody>
	</table>
	<?php
	$html = ob_get_clean();
	return $html;
}
add_shortcode('SM-CSR-SCHEDULER','cip_sm_csr_scheduler_cb');
function cip_sm_csr_scheduler_cb(){
    if( current_user_can( 'supportmanager' ) || current_user_can( 'supportagent' ) ){
	$html = "";
	global $wpdb;
	$tableScheduler = $wpdb->prefix.'csr_scheduler';
	wp_enqueue_style( 'jquery-ui-style' );
	wp_enqueue_style( 'jquery-ui-timepicker-style' );
	wp_enqueue_script('jquery-ui');
	wp_enqueue_script('jquery-ui-timepicker');
	wp_enqueue_script('jquery-ui-sliderAccess');
	wp_enqueue_script('moment');
	wp_enqueue_style( 'bs-table' );
	ob_start();
	$add_csr_url = add_query_arg( 'action', 'add', get_permalink() );
	if( isset( $_GET['action'] ) && $_GET['action'] == 'add' ){	// add csr plans
	?>
	<div class="row">
	<div class="col-12">
		<form name="cip_schedule_changer" id="cip_schedule_changer">
		<div class="form-row">
			<div class="form-group col-md-12">
				<label for="selling_price_csr"><?php _e('Selling Price of CSR*',CIP_TXTDOMAIN); ?></label>
				<input type="number" step="0.00001" class="form-control" name="selling_price_csr" id="selling_price_csr" />
			</div>
			<div class="form-group col-md-12">
				<label for="price_type"><?php _e('Type*',CIP_TXTDOMAIN); ?></label>
				<select name="price_type" class="form-select">
					<option value="" selected disabled><?php _e('Choose option',CIP_TXTDOMAIN); ?></option>
					<option value="prompt"><?php _e('Prompt',CIP_TXTDOMAIN); ?></option>
					<option value="scheduled"><?php _e('Scheduled',CIP_TXTDOMAIN); ?></option>
				</select>
			</div>
			<div class="form-group col-md-8 time_schedule" style="display:none;">
				<label for="schedule_time"><?php _e('Schedule date*',CIP_TXTDOMAIN); ?></label>
				<input type="text" class="form-control" name="schedule_time" id="schedule_time" />
				<input type="hidden" class="form-control" name="schedule_time_alt" id="schedule_time_alt" />
			</div>
			<div class="form-group col-md-2 time_schedule" style="display:none;">
				<label for="schedule_hours"><?php _e('Hours*',CIP_TXTDOMAIN); ?></label>
				<select name="schedule_hours" class="form-control">
					<?php for ($h = 0; $h < 24; $h++) printf("<option value=\"%02d\"" . (!$h ? " selected" : "") . ">%02d</option>", $h, $h); ?>
				</select>
			</div>
			<div class="form-group col-md-2 time_schedule" style="display:none;">
				<label for="schedule_minutes"><?php _e('Minutes*',CIP_TXTDOMAIN); ?></label>
				<select name="schedule_minutes" class="form-control">
					<?php for ($m = 0; $m < 60; $m++) printf("<option value=\"%02d\"" . (!$m ? " selected" : "") . ">%02d</option>", $m, $m); ?>
				</select>
			</div>
		</div>
		<button type="submit" class="btn btn-primary"><?php _e('Add', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="cip_add_csr_scheduler" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsmCSRScheduleraddxCIP_'); ?>" />
		<p class="form_response"></p>
		</form>
	</div>
	</div>
	<?php
	}else if( isset( $_GET['action'] ) && $_GET['action'] == 'edit' && $_GET['pid'] != "" ){	// add saving plans
		/*$getPlan = $wpdb->get_row("SELECT * FROM $tablePlans WHERE id=".$_GET['pid']."");
		if( $getPlan ){
		?>
		<div class="row">
		<div class="col-12">
			<form name="cip_saving_plans_edit" id="cip_saving_plans_edit">
			<div class="form-row">
				<div class="form-group col-md-4">
					<label for="plan_name"><?php _e('Plan Name*',CIP_TXTDOMAIN); ?></label>
					<input type="text" class="form-control" name="plan_name" id="plan_name" value="<?php echo $getPlan->plan_name; ?>" />
				</div>
				<div class="form-group col-md-4">
					<label for="locking_period"><?php _e('Locking period*',CIP_TXTDOMAIN); ?></label>
					<select name="locking_period" class="form-select">
						<option value="365" <?php echo selected( '365', $getPlan->plan_periods ); ?>><?php _e('12 Months (365 days)',CIP_TXTDOMAIN); ?></option>
						<option value="182" <?php echo selected( '182', $getPlan->plan_periods ); ?>><?php _e('6 Months (182 days)',CIP_TXTDOMAIN); ?></option>
					</select>
				</div>
				<div class="form-group col-md-4">
					<label for="plan_interest"><?php _e('Plan Interest*',CIP_TXTDOMAIN); ?></label>
					<input type="number" class="form-control" name="plan_interest" id="plan_interest" value="<?php echo $getPlan->plan_interest; ?>" />
				</div>
			</div>
			<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
			<a href="<?php echo get_permalink(); ?>" type="button" class="btn btn-primary"><?php _e('Cancel', CIP_TXTDOMAIN); ?></a>
			<input type="hidden" name="action" value="cip_addsaving_plan_edit" />
			<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsmsavingplaneditxCIP_'); ?>" />
			<p class="form_response"></p>
			</form>
		</div>
		</div>
		<?php
		}*/
	}else{ //display added saving plans
	?>
	<div class="row">
		<div class="col-12 text-right mt-3">
			<a href="<?php echo $add_csr_url; ?>" class="btn btn-primary"><?php _e('Add New',CIP_TXTDOMAIN); ?></a>
		</div>
	</div>
	<?php
		$getSchedulers = $wpdb->get_results("SELECT * FROM $tableScheduler order by id desc");
		wp_enqueue_style( 'cip-css' );
		wp_enqueue_style( 'bs-table' );
		wp_enqueue_style( 'bs-sticky-header' );
		wp_enqueue_script('bs-table');
		wp_enqueue_script('bs-sticky-header');
		wp_enqueue_script('bs-table-filter-control');
		?>
		<table id="cip_saving_plans_table"
		data-filter-control="true"
		data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="true" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered">
		<thead>
			<tr>
				<th data-field="id" data-sortable="false" class="plan_id"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
				<th data-field="csr_price" data-sortable="true" data-filter-control="input" class="csr_price"><?php _e('CSR Price',CIP_TXTDOMAIN); ?></th>
				<th data-field="type" data-sortable="true" data-filter-control="input" class="type"><?php _e('Type',CIP_TXTDOMAIN); ?></th>
				<th data-field="create_date" data-sortable="true" data-filter-control="input" class="create_date"><?php _e('Created',CIP_TXTDOMAIN); ?></th>
				<th data-field="start_date" data-sortable="true" data-filter-control="input" class="start_date"><?php _e('Start date',CIP_TXTDOMAIN); ?></th>
				<th data-field="status" data-sortable="false" data-filter-control="false" class="status"><?php _e('Status',CIP_TXTDOMAIN); ?></th>
				<th data-field="action" data-sortable="false" data-filter-control="false" class="action"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
			</tr>
		</thead>
	<?php
		$loopCount = 1;
		if( $getSchedulers ){
			foreach( $getSchedulers as $getScheduler ){
				$delete_link = '';
				$edit_plan_url = add_query_arg( ['action' => 'edit','sid' => $getPlan->id], get_permalink() );
				if( $getScheduler->status == 'pending' ){
					$delete_link = '<a class="mr-2 del_scheduler" href="javascript:void(0);" data-toggle-tt="tooltip" data-placement="top" title="'.__('Delete',CIP_TXTDOMAIN).'"><i class=" fa fa-trash"></i></a>';
				}

				$create_date = '-';
				try {
					$createDateObj = DateTime::createFromFormat( 'Y-m-d H:i', $getScheduler->create_date );
					$create_date = $createDateObj->format('d/m/Y H:i');
				} catch (\Throwable $th) {
					$create_date = '-';
				}
				$start_date = '-';
				try {
					$startDateObj = DateTime::createFromFormat( 'Y-m-d H:i', $getScheduler->start_date );
					$start_date = $startDateObj->format('d/m/Y H:i');
				} catch (\Throwable $th) {
					$start_date = '-';
				}

			?>
			<tr data-schedular="<?php echo $getScheduler->id; ?>">
				<td><?php echo $loopCount; ?></td>
				<td><?php echo $getScheduler->csr_price; ?></td>
				<td><?php echo $getScheduler->price_type; ?></td>
				<td><?php echo $create_date; ?></td>
				<td><?php echo $start_date; ?></td>
				<td><?php echo $getScheduler->status; ?></td>
				<td><?php echo $delete_link; ?></td>
			</tr>
			<?php
			$loopCount++;
			}
		}
		?>
	</table>
	<?php
	}
	$html .= ob_get_clean();
	return $html;
    }
}
add_shortcode('RETIREMENT-OF-CSR-SETTING', 'cip_retirement_of_csr_setting_cb');
function cip_retirement_of_csr_setting_cb(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	global $wpdb;
	$tableRetirementSetting = $wpdb->prefix.'retirement_setting';
	$tableTokenHolder = $wpdb->prefix.'token_holder';
	$tableLSHPending = $wpdb->prefix.'csr_lsh_pending';
	$refAccount = ( isset( $_SESSION['refAccount'] ) && $_SESSION['refAccount'] != "" ) ? $_SESSION['refAccount'] : '-';
	$getRetirementSetting = $wpdb->get_row("SELECT * FROM $tableRetirementSetting WHERE email = '".$refAccount."' ");
	// $amplivo_username = $getRetirementSetting->amplivo_username;

	$getTokenHolderData = $wpdb->get_row("SELECT `username`,`first_name`,`last_name` FROM $tableTokenHolder WHERE `email` = '". $refAccount ."' ORDER BY `id` DESC LIMIT 1");
	if( $getTokenHolderData ){
		$first_name = $getTokenHolderData->first_name;
		$last_name = $getTokenHolderData->last_name;
		$amplivo_username = $getTokenHolderData->username;
	}else{
		$user_info = get_user_by( 'email', $refAccount );
		if( $user_info ){
			if( $user_info->user_email != $user_info->user_login ){
				$first_name = $user_info->first_name;
				$last_name = $user_info->last_name;
				$amplivo_username = $user_info->user_login;
			}else{
				$body = ['email'	=>	$refAccount];
				$response = amplivo_api_send_requests( $body, 'get-user-data');
				if( $response['success'] == true ){
					$result = $response['result'];
					$amplivo_username = $result['Username'];
					$first_name = $result['user_first_name'];
					$last_name = $result['user_last_name'];

					/* $wpdb->update(
						$wpdb->users,
						['user_login' => $amplivo_username],
						['ID' => $user_info->ID]
					); */
					wp_update_user([
						'ID' => $user_info->ID, // this is the ID of the user you want to update.
						'first_name' => $first_name,
						'last_name' => $last_name,
					]);
				}
			}
		}
	}
	$email = $refAccount;

	$company_name = $getRetirementSetting->company_name;
	$company_name_toggle = $getRetirementSetting->company_name_toggle;
	$member_url = $getRetirementSetting->member_url;
	$status = $getRetirementSetting->status;
	$member_logo = $getRetirementSetting->member_logo;
	$url_logo_status = $getRetirementSetting->status;
	$rejection_msg = $getRetirementSetting->rejection_msg;
	if( empty( $rejection_msg ) ){
		$rejection_msg = __('<strong>Logo & url are pending for review</strong><br/>It will take up to 7 days to approve the url & logo. You should check back regularly.', CIP_TXTDOMAIN);
	}
	ob_start();
	?>
	<div class="row">
	<div class="col-md-12 p-3 rounded">
	<form name="retirement_setting_frm" id="retirement_setting_frm">

		<div class="row">
			<div class="col-md-6">
				<div class="form-group">
					<label for="amplivo_username"><?php _e('Amplivo username', CIP_TXTDOMAIN); ?></label>
					<input type="text" class="form-control" name="amplivo_username" id="amplivo_username" value="<?php echo $amplivo_username; ?>" disabled readonly>
				</div>
			</div>
			<div class="col-md-6">
				<div class="form-group">
					<label for="email"><?php _e('Email', CIP_TXTDOMAIN); ?></label>
					<input type="text" class="form-control" name="email" id="email" value="<?php echo $email; ?>" readonly>
				</div>
			</div>
			<div class="col-md-6">
				<div class="form-group">
					<label for="first_name"><?php _e('First name', CIP_TXTDOMAIN); ?></label>
					<input type="text" class="form-control" name="first_name" id="first_name" value="<?php echo $first_name; ?>" <?php echo 'disabled readonly';?>>
				</div>
			</div>
			<div class="col-md-6">
				<div class="form-group">
					<label for="last_name"><?php _e('Last name', CIP_TXTDOMAIN); ?></label>
					<input type="text" class="form-control" name="last_name" id="last_name" value="<?php echo $last_name; ?>" <?php echo 'disabled readonly';?>>
				</div>
			</div>

			<div class="col-12">
				<div class="alert alert-danger" role="alert">
					Changes to your name are temporarily unavailable. <a href='/content/learnings/tutorials/support/'>Please contact support.</a>
				</div>
			</div>


			<div class="col-md-6">

				<div class="form-group retirement_confirmation_block_section">
					<label for="company_name"><?php _e('Company name', CIP_TXTDOMAIN); ?> <!--i class="fa fa-info-circle" data-toggle="tooltip" data-placement="top" title="<?php //_e('Company name displayed on retirement certificates instead of an individuals name',CIP_TXTDOMAIN); ?>" ></i--> </label>
					<input type="text" class="form-control" name="company_name" id="company_name" value="<?php echo $company_name; ?>">
					<div class="form-check">
						<label class="form-check-label" style="line-height: unset;">
							<input type="checkbox" class="form-check-input" name="company_name_toggle" id="company_name_toggle" value="1" <?php echo checked( $company_name_toggle, 1); ?>><?php _e('Display company name on retirement certificates instead of an individuals name', CIP_TXTDOMAIN); ?>
						</label>
					</div>
				</div>
			</div>
			<div class="col-md-6">
				<div class="form-group">
					<label for="member_url"><?php _e('Company url', CIP_TXTDOMAIN); ?></label>
					<?php if( $status == 2 ){ ?>
						<p class="form-control"><?php echo $member_url ?></p>
					<?php }else{ ?>
						<input type="text" class="form-control" id="member_url" name="member_url" value="<?php echo $member_url ?>" />
						<i><?php _e('e.g. http://example.com or https://example.com', CIP_TXTDOMAIN); ?></i>
					<?php } ?>
				</div>
			</div>
			<div class="col-md-6">
				<?php if( $status != 2 ){ ?>
					<div class="form-group">
						<label for="member_logo"><?php _e('Company logo', CIP_TXTDOMAIN); ?></label>
						<input type="file" class="form-control-file border" id="member_logo" name="member_logo" />
						<i><?php _e('Only jpg,jpeg,png files are valid, max dimension 250*250px, and max size 100KB will be allowed', CIP_TXTDOMAIN); ?></i>
					</div>
				<?php } ?>
				<?php if( $status == 2 ){ ?>
					<div class="form-group">
						<label for="member_logo"><?php _e('Company logo', CIP_TXTDOMAIN); ?></label>
						<input type="file" class="form-control-file border" id="logo_disabled" name="logo_disabled" disabled readonly />
						<i><?php _e('Only jpg,jpeg,png files are valid, max dimension 250*250px, and max size 100KB will be allowed', CIP_TXTDOMAIN); ?></i>
					</div>
				<?php } ?>
				<?php if( !empty( $member_logo ) ){ ?>
					<div class="form-group">
						<img src="data:image/jpg;charset=utf8;base64,<?php echo base64_encode($member_logo); ?>" class="img-responsive company_logo_preview" />
					</div>
				<?php } ?>
			</div>
		</div>

		<?php if( $url_logo_status != 1 && ( !empty( $member_url ) || !empty( $member_logo ) ) ){ ?>
		<div class="alert alert-info">
		<?php echo $rejection_msg; ?>
		</div>
		<?php } ?>
		<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="cip_retirement_setting_act" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxRetirement_SettingxCIP_'); ?>" />
		<p class="form_response"></p>
	</form>
	</div>
	</div>

	<br/>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CIP-SA-REVIEW-PENDING-MEMBER-URL-LOGO', 'cip_sa_review_pending_member_url_logo_callback');
function cip_sa_review_pending_member_url_logo_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'magnify' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'daterangepicker-style' );
	wp_enqueue_script( 'notify-js' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('magnify');
	wp_enqueue_script('dr-moment');
	wp_enqueue_script('daterangepicker-script');

	global $wpdb;

	$args = array(
		'role' => 'supportagent',
		'number' => -1,
	);
	$supportAgentQuery = new WP_User_Query( $args );
	$supportAgentData = $supportAgentQuery->get_results();
	$supportAgentArr = array();
	if( !empty( $supportAgentData ) ){
		foreach( $supportAgentData as $saData ){
			$supportAgentArr[$saData->ID] = $saData->user_email;
		}
	}
	$supportAgentJson = json_encode( $supportAgentArr );
	ob_start();
	?>
	<script>var filterLogoPendingStatus = {'2': "Pending review",'0': "Rejected", '1': "Approved"}; var filterSAList = <?php echo $supportAgentJson; ?>;</script>
	<table id="sa_pending_review_logourl" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
		<thead>
			<tr>
				<th data-field="id" class="id"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
				<th data-field="username" data-sortable="true" data-filter-control="input" data-switchable="false" class="username"><?php _e('Username',CIP_TXTDOMAIN); ?></th>
				<th data-field="first_name" data-sortable="true" data-filter-control="input" data-switchable="false" class="first_name"><?php _e('First Name',CIP_TXTDOMAIN); ?></th>
				<th data-field="last_name" data-sortable="true" data-filter-control="input" data-switchable="false" class="last_name"><?php _e('Last Name',CIP_TXTDOMAIN); ?></th>
				<th data-field="email" data-sortable="true" data-filter-control="input" data-switchable="false" class="email"><?php _e('Email',CIP_TXTDOMAIN); ?></th>
				<th data-field="member_url" data-sortable="true" data-filter-control="input" data-switchable="false" class="member_url"><?php _e('Company url',CIP_TXTDOMAIN); ?></th>
				<th data-field="member_logo" class="member_logo"><?php _e('Company logo',CIP_TXTDOMAIN); ?></th>
				<th data-field="rejection_msg" data-sortable="true" data-filter-control="input" data-switchable="false" class="rejection_msg" ><?php _e('Rejection message',CIP_TXTDOMAIN); ?></th>
				<th data-field="last_update" data-sortable="true" data-filter-control="input" data-switchable="false" class="last_update"><?php _e('Latest action date',CIP_TXTDOMAIN); ?></th>
				<th data-field="sa_user_id" class="sa_user_id" data-sortable="false" data-filter-control="select" data-filter-data="var:filterSAList"><?php _e('Admin',CIP_TXTDOMAIN); ?></th>
				<th data-field="status" data-sortable="true" data-filter-control="select" data-filter-data="var:filterLogoPendingStatus" class="status"><?php _e('Status',CIP_TXTDOMAIN); ?></th>
				<th data-field="action" class="action"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
			</tr>
		</thead>
		<tbody>
		</tbody>
	</table>
	<div class="modal fade" id="view_retarment_img" tabindex="-1" role="dialog" aria-labelledby="view_retarment_img" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-lg">
			<div class="modal-content">
			<div class="modal-body">
				<img data-src="" data-magnify="gallery" src="" id="imagepreview" />
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
			</div>
			</div>
		</div>
	</div>
	<script>
		jQuery('body').on('click', '.view_attachments_img', function(){
			var block_config = { css: { backgroundColor: 'transparent', border: 'none' }, message: '<div class="blockUIspinner"></div>', baseZ: 1500, overlayCSS: { backgroundColor: '#FFFFFF', opacity: 0.8, cursor: 'wait' } };
			var img_url = jQuery(this).attr('logo-src');
			jQuery('#imagepreview').attr('src', img_url);
			jQuery('#imagepreview').attr('data-src', img_url);
			jQuery('#imagepreview').magnify({
				resizable: false,
				footerToolbar: ['zoomIn','zoomOut','fullscreen','actualSize','rotateRight'],
				multiInstances: false,
				initMaximized: true
			});
			jQuery('#imagepreview').click();
		});
	</script>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('API-WALLET-CHANGE-LOG','cip_api_change_log_callback');
function cip_api_change_log_callback(){
	$html = "";
	$filename = 'cip_wallet_option.log';
	$wallet_file_log = file_get_contents( CIP_PLUGIN_BASE.'/'.$filename );
	ob_start();
	?>
	<section class="wallet_api_log">
	<h2><?php _e('Wallet setting changes logs', CIP_TXTDOMAIN); ?></h2>
	<textarea id="wallet_api_log" style="height: 400px;"><?php echo $wallet_file_log; ?></textarea>
	</section>
	<script>
		var textarea = document.getElementById('wallet_api_log');
		textarea.scrollTop = textarea.scrollHeight;
	</script>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CIP-MA-ADD-NEW-USER','cip_ma_add_new_user_callback');
function cip_ma_add_new_user_callback(){
	$html = "";
	ob_start();
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	?>
	<form class="create_member_frm" id="create_member_frm" name="create_member_frm">
		<div class="form-group">
			<h5><?php _e('Add Member', CIP_TXTDOMAIN); ?></h5>
		</div>
		<div class="form-group">
			<input type="text" class="form-control" id="member_username" name="member_username" placeholder="<?php _e('Username *', CIP_TXTDOMAIN); ?>" />
		</div>
		<div class="form-group">
			<input type="email" class="form-control" id="member_email" name="member_email" placeholder="<?php _e('Email *', CIP_TXTDOMAIN); ?>" />
		</div>
		<button type="submit" class="btn btn-secondary"><?php _e('Submit', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="create_member_act" />
		<input type="hidden" name="pageid" value="<?php echo get_the_id(); ?>" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_YCIPcreate_memberCIPY_'); ?>" />
		<p><span class="form_response"></span></p>
	</form>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CIP-SA-CSR-RETIREMENTS','cip_sa_csr_retirements_callback');
function cip_sa_csr_retirements_callback(){
	$html = "";
	ob_start();
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	global $wpdb;
	$tableRetirement = $wpdb->prefix.'retirement_data';
	$tableTokenHolder = $wpdb->prefix.'token_holder';
	$getEmptyUsernames = $wpdb->get_results("SELECT * FROM $tableRetirement WHERE `username` IS NULL OR `username` = ''");
	if( $getEmptyUsernames ){
		foreach( $getEmptyUsernames as $getEmptyUsername ){
			$getUsername = $wpdb->get_row("SELECT * FROM $tableTokenHolder WHERE `email` = '". $getEmptyUsername->email ."' ORDER BY `id` DESC");
			if( $getUsername && $getUsername->username ){
				$data = [ 'username' => $getUsername->username ];
				$where = ['id' => $getEmptyUsername->id];
				$updating = $wpdb->update( $tableRetirement, $data, $where );
			}
		}
	}
	?>
	<script>
		var filtertokenoptions = {
			CSR: "CSR",
			CSR25: "CSR25"
		};
	</script>
	<table id="tokenholder_sa_retirement_table" data-toolbar="false" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" class="table table-bordered" data-side-pagination="server" data-page-list="[10, 20, 50, 100]">
		<thead>
			<tr>
			<th data-field="id" class="id"><?php _e('#',CIP_TXTDOMAIN); ?></th>
			<th data-field="username" data-sortable="true" data-filter-control="input" class="username"><?php echo __('Username',CIP_TXTDOMAIN); ?></th>
			<th data-field="first_name" data-sortable="true" data-filter-control="input" class="first_name"><?php echo __('First name',CIP_TXTDOMAIN); ?></th>
			<th data-field="last_name" data-sortable="true" data-filter-control="input" class="last_name"><?php echo __('Last name',CIP_TXTDOMAIN); ?></th>
			<th data-field="token" data-sortable="true" data-filter-control="select" data-filter-data="var:filtertokenoptions" class="token"><?php echo __('Token',CIP_TXTDOMAIN); ?></th>
			<th data-field="retire_amount" data-sortable="true" data-filter-control="input" class="retire_amount"><?php echo __('Retired amount',CIP_TXTDOMAIN); ?></th>
			<th data-field="retire_date" data-sortable="true" data-filter-control="input" class="retire_date"><?php echo __('Retirement date',CIP_TXTDOMAIN); ?></th>
			<th data-field="email" data-sortable="true" data-filter-control="input" class="email"><?php echo __('Email',CIP_TXTDOMAIN); ?></th>
			<th data-field="eth_address" data-sortable="true" data-filter-control="input" class="eth_address"><?php echo __('Wallet address',CIP_TXTDOMAIN); ?></th>
			<th data-field="name_on_the_certificate" data-sortable="true" data-filter-control="input" class="name_on_the_certificate"><?php echo __('Name on the Certificate(s)',CIP_TXTDOMAIN); ?></th>
			<th data-field="retire_visibility" data-sortable="true" data-filter-control="select" data-filter-data="var:filterVisibilityStatus" class="retirement_visibility"><?php echo __('Retirement visibility',CIP_TXTDOMAIN); ?></th>
			<th data-field="action" data-sortable="false" class="action"><?php echo __('Action',CIP_TXTDOMAIN); ?></th>
			</tr>
		</thead>
		<tbody></tbody>
	</table>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CIP-SM-ADD-CIP-CIRCULATION','cipSupportManagerAddCsrCirculationCallback');
function cipSupportManagerAddCsrCirculationCallback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	ob_start();
	global $wpdb;
	$tableCirculationData = $wpdb->prefix.'circulation_data';
	$getCirculationsData = $wpdb->get_results("SELECT * FROM $tableCirculationData WHERE 1 ORDER BY id DESC");
	if( current_user_can('supportmanager') || current_user_can('supportagent') ){

	?>
	<div class="row">
		<div class="col-md-12 mb-2 text-right">
			<button type="button" id="create_member_popup" class="btn" data-toggle="modal" data-target="#createCirculationModal"><i class="fa fa-plus" aria-hidden="true"></i> <?php _e('Add wallet address', CIP_TXTDOMAIN); ?></button>
		</div>
	</div>
	<table class="table table-bordered csrCirculationListDataTable">
		<thead>
			<tr>
				<th colspan="3"><h2><?php _e('CSR holders details', CIP_TXTDOMAIN); ?></h2></th>
			</tr>
			<tr>
				<th><?php _e('Description', CIP_TXTDOMAIN); ?></th>
				<th><?php _e('Address', CIP_TXTDOMAIN); ?></th>
				<th>
					<?php _e('Token', CIP_TXTDOMAIN); ?>
					<select id="tokenFilter" class="form-control">
						<option value="all"></option>
						<option value="CSR"><?php _e('CSR', CIP_TXTDOMAIN); ?></option>
						<option value="CSR25"><?php _e('CSR25', CIP_TXTDOMAIN); ?></option>
					</select>
				</th>
				<th><?php _e('Action', CIP_TXTDOMAIN); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			if( $getCirculationsData ){
				foreach( $getCirculationsData as $CirculationData ){
					$encryptID = base64_encode($CirculationData->id . 'CirculationsData');
				?>
				<tr>
					<td class="wallet_name"><?php echo $CirculationData->description; ?></td>
					<td class="eth_address"><a href="https://etherscan.io/address/<?php echo $CirculationData->address; ?>" target="_blank"><?php echo $CirculationData->address; ?></a></td>
					<td class="token"><?php echo $CirculationData->token; ?></td>
					<td>
						<a class="fa fa-edit mr-2 ml-2 edit_circulation_data" href="javascript:void(0);" data-id="<?php echo $encryptID; ?>" data-toggle="tooltip" data-placement="top" title="<?php _e('Edit record',CIP_TXTDOMAIN); ?>"></a>
						<a class="fa fa-trash mr-2 ml-2 delete_circulation_data" href="javascript:void(0);" data-id="<?php echo $encryptID; ?>" data-toggle="tooltip" data-placement="top" title="<?php _e('Delete record',CIP_TXTDOMAIN); ?>"></a>
					</td>
				</tr>
				<?php
				}
			}else{
				?>
				<tr>
					<td colspan="2"><?php _e('No Circulation Data Found', CIP_TXTDOMAIN); ?></td>
				</tr>
				<?php
			}
			?>
		</tbody>
	</table>
	<div class="modal fade" id="createCirculationModal" tabindex="-1" role="dialog">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">
		      	<div class="modal-body">
					<form class="create_circulationModal_frm" id="create_circulationModal_frm" name="create_circulationModal_frm">
						<div class="form-group">
							<h5><?php _e('Add wallet address', CIP_TXTDOMAIN); ?></h5>
						</div>
						<div class="form-group">
							<input type="text" class="form-control" id="description" name="description" placeholder="<?php _e('Description *', CIP_TXTDOMAIN); ?>" />
						</div>
						<div class="form-group">
							<input type="text" class="form-control" id="address" name="address" placeholder="<?php _e('Address *', CIP_TXTDOMAIN); ?>" />
						</div>
						<div class="form-group">
							<select class="form-control" id="token" name="token">
								<option value="">Please select Token</option>
								<option value="CSR">CSR</option>
								<option value="CSR25">CSR25</option>
							</select>
						</div>
						<button type="submit" class="btn btn-secondary"><?php _e('Submit', CIP_TXTDOMAIN); ?></button>
						<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
						<input type="hidden" name="action" value="create_smcirculation_act" />
						<input type="hidden" name="pageid" value="<?php echo get_the_id(); ?>" />
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_YxCIPcreate_circulationCIPXy_'); ?>" />
						<p><span class="form_response"></span></p>
					</form>
				</div>
		    </div>
		  </div>
	</div>
	<div class="modal fade" id="EidtCirculationModal" tabindex="-1" role="dialog">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">
		      	<div class="modal-body">

				</div>
		    </div>
		  </div>
	</div>
	<?php
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CIP-CSR-CIRCULATION','cipCsrCirculationCallback');
function cipCsrCirculationCallback(){
	$html = "";
	ob_start();
	global $wpdb;
	$tableCirculationData = $wpdb->prefix.'circulation_data';
	$tableCsrMintTxn = $wpdb->prefix.'mint_transaction';
	$getCirculationsData = $wpdb->get_results("SELECT * FROM $tableCirculationData WHERE 1 ORDER BY id DESC");

	$csr25_wallet_api_mode = ( !empty( get_option('csr25_wallet_api_mode') ) ) ? get_option('csr25_wallet_api_mode') : 'test' ;
	$whereMode = " AND `mode` = '". $csr25_wallet_api_mode."'";

	$csr25MintTotal = $wpdb->get_row("SELECT SUM(mintAmount) AS total_mint_amount FROM $tableCsrMintTxn WHERE 1 $whereMode;");

	$csrAddressList = array();
	if( $getCirculationsData ){
		foreach( $getCirculationsData as $circulationsData ){
			/* if($circulationsData->token == 'CSR'){
				$csrAmount = cip_get_circulation_balance( $circulationsData->address );
			}else{
				$csrAmount = cip_get_circulation_balance_csr25( $circulationsData->address );
			} */
			$csrAmount = cip_get_ether_balance( $circulationsData->address, $circulationsData->token );
			$csrAddressList[] = array(
				'description'	=>	$circulationsData->description,
				'address'		=>	$circulationsData->address,
				'token'			=>	$circulationsData->token,
				'amount'		=> 	$csrAmount,
			);
			// krsort( $csrAddressList );
		}

		usort($csrAddressList, function ($a, $b) {
			return $b['amount'] <=> $a['amount'];
		});

	}
	$totalAmount = 0;
	$totalCSR25Amount = 0;
	$tenBillions = 10000000000;
	$tenBillionsCsr25 = $csr25MintTotal->total_mint_amount;
	?>
	<table class="table table-bordered csrCirculationTable-">
		<thead>
			<tr>
				<th colspan="3"><h2><?php _e('CSR holders details', CIP_TXTDOMAIN); ?></h2></th>
			</tr>
			<tr>
				<th><?php _e('Description', CIP_TXTDOMAIN); ?></th>
				<th><?php _e('Address', CIP_TXTDOMAIN); ?></th>
				<th>
					<?php _e('Token', CIP_TXTDOMAIN); ?>
					<select id="tokenFilter" class="form-control">
						<option value="all"></option>
						<option value="CSR"><?php _e('CSR', CIP_TXTDOMAIN); ?></option>
						<option value="CSR25"><?php _e('CSR25', CIP_TXTDOMAIN); ?></option>
					</select>
				</th>
				<th><?php _e('Amount', CIP_TXTDOMAIN); ?></th>
			</tr>
		</thead>
		<tbody>
			<?php
			if( $csrAddressList ){
				foreach( $csrAddressList as $key => $csrAddress ){
					// echo "<pre>"; print_r( $csrAddress ); echo "</pre>";
					// $csrAddress = $csrAddress[$key];
					$csrAmount = $csrAddress['amount'];
					if($csrAddress['token'] == 'CSR'){
						$totalAmount += $csrAmount;
					}else{
						$totalCSR25Amount += $csrAmount;
					}
				?>
				<tr data-amount="<?php echo $csrAmount; ?>">
					<td><?php echo $csrAddress['description']; ?></td>
					<td class="eth_address"><a href="https://etherscan.io/address/<?php echo $csrAddress['address']; ?>" target="_blank"><?php echo $csrAddress['address']; ?></a></td>
					<td class="token"><?php echo $csrAddress['token']; ?></td>
					<td><?php echo number_format( $csrAmount, 2, '.', ',' ); ?></td>
				</tr>
				<?php
				}
			}else{
				?><tr><td colspan="3"><?php _e('No Circulation Data Found', CIP_TXTDOMAIN); ?></td></tr><?php
			}
			?>
		</tbody>
		<?php if( $csrAddressList ){ ?>
		<tfoot>
		<tr class="CSR-row">
			<td colspan="2"><?php _e('Open distribution', CIP_TXTDOMAIN) ?></td>
			<td>-</td>
			<td><?php if( $totalAmount > 0 ){ echo number_format( $tenBillions - $totalAmount, 2, '.', ',' ); } ?></td>
		</tr>
		<tr class="CSR25-row">
			<td colspan="2"><?php _e('CSR25 Open distribution', CIP_TXTDOMAIN) ?></td>
			<td>-</td>
			<td><?php if( $totalCSR25Amount > 0 ){ echo number_format( $tenBillionsCsr25 - $totalCSR25Amount, 2, '.', ',' ); } ?></td>
		</tr>
		</tfoot>
		<?php } ?>
	</table>
	<?php
	$html .= ob_get_clean();
	return $html;
}
//#5077 code
add_shortcode( 'WEEKLY-REDEMPTIONS-IMPORT-WIZARD', 'cip_weekly_redemptions_import_wizard_callback' );
function cip_weekly_redemptions_import_wizard_callback(){
	$html = "";
	global $wpdb;
	ob_start();
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	$total_step = 7;
	?>
	<div class="container-fluid">
	    <div class="row justify-content-center">
			<div class="col-10 col-sm-9 col-md-7 col-lg-10 col-xl-10 text-center p-0 mt-3 mb-2">
				<div class="card px-0 pt-4 pb-0 mt-3 mb-3">
					<form name="weekly_redemptions_import_wizard_frm" class="weekly_redemptions_import_wizard_frm" id="msform">
					<!-- progressbar -->
					<ul id="progressbar">
	                        <li class="active" id="fileupload"><strong><?php _e('Choose file',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="logging"><strong><?php _e('Logs',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="fieldmapping"><strong><?php _e('Review',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="fieldmapping"><strong><?php _e('Split 10% Distribution',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="fieldmapping"><strong><?php _e('Review 10% Distribution',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="codemerge"><strong><?php _e('Append New CSR Holders',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="confirm"><strong><?php _e('Finish',CIP_TXTDOMAIN) ?></strong></li>
	                    </ul>
	                    <div class="progress">
	                        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
	                    </div> <br> <!-- fieldsets -->
	                    <fieldset class="step_0">
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 1, $total_step); ?></h2>
	                                </div>
	                            </div>
	                            <label class="fieldlabels"><?php _e('Choose file',CIP_TXTDOMAIN); ?></label> <input type="file" name="th_csv_file" accept=".csv"  required />
								<div class="pool_ref_toogle" style="display: none;">
									<label class="fieldlabels"><?php _e('Pool Reference',CIP_TXTDOMAIN); ?></label> <input type="text" name="pool_reference" required />
									<label class="fieldlabels"><?php _e('CSR Segmentation',CIP_TXTDOMAIN); ?></label> <input type="number" name="csr_segmentation" min="10" value="100" placeholder="<?php _e('Default will be 100', CIP_TXTDOMAIN); ?>" required />
								</div>
	                        </div>
	                        <input type="button" name="next" class="next action-button first_step invisible" value="Next" />
	                    </fieldset>

						<fieldset class="step_1">
							<div class="form-card">
								<div class="row">
									<div class="col-12">
										<h2 class="steps"><?php echo sprintf('Step %s - %s', 2, $total_step); ?></h2>
									</div>
								</div>

								<div class="row">
									<div class="col-12">
										<ul class="list-group list-group-flush process_log" id="process_log"></ul>
										<div class="csr_spinner" style="display: none;">
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
										</div>
									</div>
								</div>
							</div>
							<input type="button" name="next" class="next action-button" value="Review New CSR Holders Data" style="display: none;" disabled /> <input type="button" name="previous" class="previous action-button-previous" value="Previous" style="display: none;" />
						</fieldset>
	                    <fieldset class="step_2">
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 3, $total_step); ?></h2>
	                                </div>
	                            </div>

								<div class="row justify-content-center">
									<div class="col-12 text-center import_update_response"></div>
									<div class="col-12 text-center distribution_section_table" style="display:none;">
										<p class="text-left total_import_label"></p>
										<table id="tokenholder_distribution_table" data-toolbar="false" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" class="table table-bordered" data-side-pagination="server" data-page-list="[10, 20, 50, 100]" data-response-handler="responseImportHandler">
											<thead>
												<tr>
												<th data-field="id" class="id"><?php _e('#',CIP_TXTDOMAIN); ?></th>
												<th data-field="username" data-sortable="true" data-filter-control="input" class="username"><?php echo __('Username',CIP_TXTDOMAIN); ?></th>
												<th data-field="reference" data-sortable="true" data-filter-control="input" class="reference"><?php echo __('Reference Number',CIP_TXTDOMAIN); ?></th>
												<th data-field="eth_address" data-sortable="true" data-filter-control="input" class="eth_address"><?php echo __('CSR wallet address',CIP_TXTDOMAIN); ?></th>
												<th data-field="csr_amount_initial" data-sortable="true" data-filter-control="input" class="csr_amount_initial"><?php echo __('CSR Amount Initial',CIP_TXTDOMAIN); ?></th>
												<!--th data-field="csr_amount_issued" data-sortable="true" data-filter-control="input" class="csr_amount_issued"><?php //echo __('CSR Amount Issued',CIP_TXTDOMAIN); ?></th-->
												<!--th data-field="amount_due" data-sortable="true" data-filter-control="input" class="amount_due"><?php //echo __('Amount Due',CIP_TXTDOMAIN); ?></th-->
												<th data-field="first_name" data-sortable="true" data-filter-control="input" class="first_name"><?php echo __('First name',CIP_TXTDOMAIN); ?></th>
												<th data-field="last_name" data-sortable="true" data-filter-control="input" class="last_name"><?php echo __('Last name',CIP_TXTDOMAIN); ?></th>
												<th data-field="created" data-sortable="true" data-filter-control="input" class="created"><?php echo __('Created',CIP_TXTDOMAIN); ?></th>
												<th data-field="email" data-sortable="true" data-filter-control="input" class="email"><?php echo __('Email',CIP_TXTDOMAIN); ?></th>
												<th data-field="distribution_status" data-sortable="true" data-filter-control="input" class="distribution_status"><?php echo __('Distribution Status',CIP_TXTDOMAIN); ?></th>
												<th data-field="member_status" data-sortable="true" data-filter-control="input" class="member_status"><?php echo __('Member Status',CIP_TXTDOMAIN); ?></th>
												<!--th data-field="corp_approved" data-sortable="true" data-filter-control="input" class="corp_approved"><?php //echo __('corp_approved',CIP_TXTDOMAIN); ?></th-->
												<!--th data-field="notes_external" data-sortable="true" data-filter-control="input" class="notes_external"><?php //echo __('Notes External',CIP_TXTDOMAIN); ?></th-->
												<th data-field="pool_ref" data-sortable="true" data-filter-control="input" class="pool_ref"><?php echo __('Pool Reference ',CIP_TXTDOMAIN); ?></th>
												</tr>
											</thead>
											<tbody></tbody>
										</table>
									</div>
								</div>

	                        </div>
							<input type="button" name="next" class="next action-button" value="Split 10% Distribution Data" /> <input type="button" name="previous" class="previous action-button-previous back_disable" value="Previous" />
	                    </fieldset>
						<fieldset class="step_3">
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 4, $total_step); ?></h2>
	                                </div>
	                            </div>
	                            <div class="row">
									<div class="col-12">
										<ul class="list-group list-group-flush process_split_log" id="process_split_log"></ul>
										<div class="csr_split_spinner" style="display: none;">
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
										</div>
									</div>
								</div>
	                        </div>
							<input type="button" name="next" class="next action-button" value="Review 10% Distribution Data" />
							<input type="button" name="previous" class="previous action-button-previous" value="Previous" />
	                    </fieldset>
						<fieldset class="step_4">
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 5, $total_step); ?></h2>
	                                </div>
	                            </div>
	                            <div class="row justify-content-center">
									<div class="col-12 text-center import_update_response"></div>
									<div class="col-12 text-center distribution_10_section_table" style="display:none;">
										<p class="text-left total_distribution_label"></p>
										<table id="tokenholder_distribution_10_table" data-toolbar="false" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" class="table table-bordered" data-side-pagination="server" data-page-list="[10, 20, 50, 100]" data-response-handler="responseHandler">
											<thead>
												<tr>
												<th data-field="id" class="id"><?php _e('#',CIP_TXTDOMAIN); ?></th>
												<th data-field="username" data-sortable="true" data-filter-control="input" class="username"><?php echo __('Username',CIP_TXTDOMAIN); ?></th>
												<th data-field="reference" data-sortable="true" data-filter-control="input" class="reference"><?php echo __('Reference Number',CIP_TXTDOMAIN); ?></th>
												<th data-field="eth_address" data-sortable="true" data-filter-control="input" class="eth_address"><?php echo __('CSR wallet address',CIP_TXTDOMAIN); ?></th>
												<th data-field="csr_amount_initial" data-sortable="true" data-filter-control="input" class="csr_amount_initial"><?php echo __('CSR Amount Initial',CIP_TXTDOMAIN); ?></th>
												<th data-field="csr_amount_issued" data-sortable="true" data-filter-control="input" class="csr_amount_issued"><?php echo __('CSR Amount Issued',CIP_TXTDOMAIN); ?></th>
												<th data-field="amount_due" data-sortable="true" data-filter-control="input" class="amount_due"><?php echo __('Amount Due',CIP_TXTDOMAIN); ?></th>
												<th data-field="first_name" data-sortable="true" data-filter-control="input" class="first_name"><?php echo __('First name',CIP_TXTDOMAIN); ?></th>
												<th data-field="last_name" data-sortable="true" data-filter-control="input" class="last_name"><?php echo __('Last name',CIP_TXTDOMAIN); ?></th>
												<th data-field="created" data-sortable="true" data-filter-control="input" class="created"><?php echo __('Created',CIP_TXTDOMAIN); ?></th>
												<th data-field="email" data-sortable="true" data-filter-control="input" class="email"><?php echo __('Email',CIP_TXTDOMAIN); ?></th>
												<th data-field="distribution_status" data-sortable="true" data-filter-control="input" class="distribution_status"><?php echo __('Distribution Status',CIP_TXTDOMAIN); ?></th>
												<th data-field="corp_approved" data-sortable="true" data-filter-control="input" class="corp_approved"><?php echo __('Corp Approved',CIP_TXTDOMAIN); ?></th>
												<th data-field="week_number" data-sortable="true" data-filter-control="input" class="week_number"><?php echo __('Week Number',CIP_TXTDOMAIN); ?></th>
												<th data-field="member_status" data-sortable="true" data-filter-control="input" class="member_status"><?php echo __('Member Status',CIP_TXTDOMAIN); ?></th>
												<th data-field="pool_ref" data-sortable="true" data-filter-control="input" class="pool_ref"><?php echo __('Pool Reference ',CIP_TXTDOMAIN); ?></th>
												<th data-field="source" data-sortable="true" data-filter-control="input" class="source"><?php echo __('Source ',CIP_TXTDOMAIN); ?></th>
												</tr>
											</thead>
											<tbody></tbody>
										</table>
									</div>
								</div>
	                        </div>
							<?php $exportDistributionLink = add_query_arg( 'action', 'export_distribution_act', admin_url('admin-post.php') ); ?>
							<?php /*<a class="next action-button" href="<?php echo $exportDistributionLink; ?>"><?php echo __('Save 10% Distribution Data',CIP_TXTDOMAIN); ?></a>*/ ?>
							<input type="button" name="next" class="next action-button" value="Append Data" />
							<input type="button" name="previous" class="previous action-button-previous back_disable" value="Previous" />
	                    </fieldset>
	                    <fieldset class="step_5">
							<?php
								$tableDistribution = $wpdb->prefix.'token_holder_distribution';
								$getDistributions = $wpdb->get_var("SELECT COUNT(id) FROM $tableDistribution WHERE `append_status` = 1");
								$getDistributionsSummary = $wpdb->get_row("SELECT * FROM $tableDistribution WHERE `append_status` = 1 ORDER BY `id` DESC");
								$getDistributionsData = $wpdb->get_results("SELECT * FROM $tableDistribution WHERE `append_status` = 1 AND `csr_amount_issued` > 0");
								$totalRedemptions = 0;
								$totalCsr = 0;
								if( $getDistributionsData ){
									foreach( $getDistributionsData as $distribution ){
										$totalCsr += $distribution->csr_amount_initial;
										$totalRedemptions++;
									}
								}
							?>
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 6, $total_step); ?></h2>
	                                </div>
	                            </div>
	                            <div class="row justify-content-center">
									<div class="col-12 text-center">
									<h4><?php _e('Append New CSR Holders Data', CIP_TXTDOMAIN); ?></h4>
									<div class="summary_data_at_append_step">
										<?php if( $getDistributions > 0 && $getDistributionsSummary->import_by && $getDistributionsSummary->import_date ){
											$userData = get_user_by( 'id', $getDistributionsSummary->import_by );
											if( $userData ){
												echo '<p>'. sprintf( __('Data imported by : %s', CIP_TXTDOMAIN), $userData->user_login ) .'</p>';
											}
											$import_date = '—';
											try {
												$import_date_obj = DateTime::createFromFormat('Y-m-d H:i:s', $getDistributionsSummary->import_date);
												$import_date = $import_date_obj->format('d/m/Y H:i');
											} catch (\Throwable $th) {
												$import_date = '—';
											}
											echo '<p>'. sprintf( __('Import date : %s', CIP_TXTDOMAIN), $import_date ) .'</p>';
											/* echo '<p>'. sprintf( __('Total redemptions : %s', CIP_TXTDOMAIN), number_format($totalRedemptions) ) .'</p>';
											echo '<p>'. sprintf( __('Total CSR : %s', CIP_TXTDOMAIN), number_format($totalCsr) ) .'</p>'; */
										} ?>
									</div>
									<button type="button" class="btn btn-outline-primary append_new_csr_holders_data_button"><?php _e('Confirm Append Data',CIP_TXTDOMAIN); ?></button>
									<button type="button" class="btn btn-outline-primary append_cancel"><?php _e('Cancel',CIP_TXTDOMAIN); ?></button>
									</div>
									<div class="col-12">
										<ul class="list-group list-group-flush process_split_append_log" id="process_split_append_log"></ul>
										<div class="csr_split_append_spinner" style="display: none;">
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
										</div>
									</div>
									<div class="col-12">
										<ul class="list-group list-group-flush process_split_append_user_status_log" id="process_split_append_user_status_log"></ul>
										<div class="csr_split_append_user_status_spinner" style="display: none;">
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
										</div>
									</div>
								</div>
	                        </div>
							<input type="button" name="next" class="next action-button finish_step d-none invisible" value="Next" />
							<input type="button" name="previous" class="previous action-button-previous" value="Previous" />
							<!--a class="previous action-button-previous" href="" /><?php //_e('Cancel', CIP_TXTDOMAIN); ?></a-->
	                    </fieldset>
						<fieldset class="step_6">
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 7, $total_step); ?></h2>
	                                </div>
	                            </div>
								<div class="row">
									<div class="col-12">
										<h4 class="text-center"><strong><i class="fa fa-check-circle"></i> <?php echo __('Weekly redemptions import completed.', CIP_TXTDOMAIN); ?></strong></h4>
										<p class="text-center append_response fw-bold"></p>
										<a class="btn button action-button" href="<?php echo get_permalink( 9099 ); ?>"><?php echo __('Okay', CIP_TXTDOMAIN); ?></a>
									</div>
	                            </div>
	                        </div>
	                    </fieldset>
	                    <input type="hidden" name="action" value="cip_weekly_redemptions_import_act" />
	                    <input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxYSMWeeklyRedemptionsImportMSYxCIP_'); ?>" />
	                </form>
					<form class="append_new_csr_holders_data_frm" id="append_new_csr_holders_data_frm">
						<input type="hidden" name="action" value="append_new_csr_holders_data_act">
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XYAppendNew_csr_HoldersDataYX_'); ?>">
					</form>
					<form class="append_cancel_data_frm" id="append_cancel_data_frm">
						<input type="hidden" name="action" value="cancel_append_process">
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XYCancelAppendDataYX_'); ?>">
					</form>
				</div>
			</div>
		</div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
//5078 code
add_shortcode('CIP-WEEKLY-DISTRIBUTION-WIZARD','cip_weekly_distribution_wizard_callback');
function cip_weekly_distribution_wizard_callback(){
	$html = "";
	$_SESSION['csvArray'] = "";
	unset($_SESSION['csvArray']);
	global $wpdb;
	ob_start();
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	$total_step = 4;
	$autoPopulated = "";
	$last_weekly_distribution = get_option('last_weekly_distribution');
	$tableTokenHolder = $wpdb->prefix.'token_holder';
	if( !empty( $last_weekly_distribution ) ){
		$weekPos = stripos( $last_weekly_distribution, "/" );
		$week_number = (int)mb_substr( $last_weekly_distribution, $weekPos+1 ) + 1;

		$yearPos = strripos( $last_weekly_distribution, "/" );
		$year_number = (int)mb_substr( $last_weekly_distribution, 0, $yearPos );
		$totalNumberWeek = 52;
		if( $week_number > $totalNumberWeek ){
			$week_number = $week_number - $totalNumberWeek;
			$year_number = $year_number + 1;
		}else{
			$year_number = $year_number;
		}
		$autoPopulated = $year_number . '/' . sprintf("%02d", $week_number);

		for( $weekloopi=0; $weekloopi < 52; $weekloopi++ ){
			$weekDataCount = $wpdb->get_var("SELECT COUNT(id) FROM $tableTokenHolder WHERE 1 AND `text_10`= '".$autoPopulated."'");
			if( $weekDataCount > 0 ){
				break;
			}else{
				$weekPos = stripos( $autoPopulated, "/" );
				$week_number = (int)mb_substr( $autoPopulated, $weekPos+1 ) + 1;

				$yearPos = strripos( $autoPopulated, "/" );
				$year_number = (int)mb_substr( $autoPopulated, 0, $yearPos );
				$totalNumberWeek = 52;
				if( $week_number > $totalNumberWeek ){
					$week_number = $week_number - $totalNumberWeek;
					$year_number = $year_number + 1;
				}else{
					$year_number = $year_number;
				}
				$autoPopulated = $year_number . '/' . sprintf("%02d", $week_number);
			}
			if( $weekloopi == 51 ){
				$autoPopulated = "";
			}
		}
	}
	?>
	<div class="container-fluid">
	    <div class="row justify-content-center">
	        <div class="col-10 col-sm-9 col-md-7 col-lg-10 col-xl-10 text-center p-0 mt-3 mb-2">
	            <div class="card px-0 pt-4 pb-0 mt-3 mb-3">
	                <form name="cip_weekly_distribution_wizard" class="cip_weekly_distribution_wizard" id="msform">
	                    <!-- progressbar -->
	                    <ul id="progressbar">
	                        <li class="active" id="logging"><strong><?php _e('Pool Reference',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="fieldmapping"><strong><?php _e('Review',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="codemerge"><strong><?php _e('Update Records',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="confirm"><strong><?php _e('Finish',CIP_TXTDOMAIN) ?></strong></li>
	                    </ul>
	                    <div class="progress">
	                        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
	                    </div> <br>
						<!-- fieldsets -->
	                    <fieldset class="step_0">
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 1, $total_step); ?></h2>
	                                </div>
	                            </div>
	                            <label class="fieldlabels"><?php _e('Week Number',CIP_TXTDOMAIN); ?></label> <input type="text" name="week_number" value="<?php echo $autoPopulated; ?>" required />
	                        </div>
	                        <input type="button" name="next" class="next action-button" value="Next" />
	                    </fieldset>

	                    <fieldset class="step_1">
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 2, $total_step); ?></h2>
	                                </div>
	                            </div>

								<div class="row justify-content-center">
									<div class="col-12 text-center distribution_weekly_table">
									<p class="text-left total_weekly_label"></p>
										<table id="tokenholder_distribution_weekly_table" data-toolbar="false" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" class="table table-bordered" data-side-pagination="server" data-page-list="[10, 20, 50, 100]" data-response-handler="responseWeeklyDistributionHandler">
											<thead>
												<tr>
												<th data-field="id" class="id"><?php _e('#',CIP_TXTDOMAIN); ?></th>
												<th data-field="username" data-sortable="true" data-filter-control="input" class="username"><?php echo __('Username',CIP_TXTDOMAIN); ?></th>
												<th data-field="reference" data-sortable="true" data-filter-control="input" class="reference"><?php echo __('Reference number',CIP_TXTDOMAIN); ?></th>
												<th data-field="eth_address" data-sortable="true" data-filter-control="input" class="eth_address"><?php echo __('CSR wallet address',CIP_TXTDOMAIN); ?></th>
												<th data-field="amount_due" data-sortable="true" data-filter-control="input" class="amount_due"><?php echo __('CSR amount due',CIP_TXTDOMAIN); ?></th>
												<th data-field="week_number" data-sortable="true" data-filter-control="input" class="week_number"><?php echo __('Week number',CIP_TXTDOMAIN); ?></th>
												</tr>
											</thead>
											<tbody></tbody>
										</table>
									</div>
								</div>

	                        </div>
							<?php $exportWeeklyDistributionLink = add_query_arg( 'action', 'export_weekly_distribution_act', admin_url('admin-post.php') ); ?>
							<a class="next action-button" href="<?php echo $exportWeeklyDistributionLink; ?>" target="_blank"><?php echo __('Save Weekly Distribution Data',CIP_TXTDOMAIN); ?></a>
							<input type="button" name="previous" class="previous action-button-previous back_disable" value="Previous" />
	                    </fieldset>
	                    <fieldset class="step_2">
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 3, $total_step); ?></h2>
	                                </div>
	                            </div>
	                            <div class="row justify-content-center">
									<div class="col-12 text-center loader_section">
									<h4><?php _e('Update CSR Holders Data', CIP_TXTDOMAIN); ?></h4>
									<div class="summary_data_at_update_step">
										<?php
											global $wpdb;
											$tableName = $wpdb->prefix.'weekly_distribution_export';
											$html = "";
											$getDistributions = $wpdb->get_var("SELECT COUNT(id) FROM $tableName WHERE `append_status` = 1");
											$getDistributionsSummary = $wpdb->get_row("SELECT * FROM $tableName WHERE `append_status` = 1 ORDER BY `id` DESC");
											if( $getDistributions > 0 && $getDistributionsSummary->import_by && $getDistributionsSummary->import_date ){
												$userData = get_user_by( 'id', $getDistributionsSummary->import_by );
												if( $userData ){
													echo '<p>'. sprintf( __('Data imported by : %s', CIP_TXTDOMAIN), $userData->user_login ) .'</p>';
												}
												$import_date = '—';
												try {
													$import_date_obj = DateTime::createFromFormat('Y-m-d H:i:s', $getDistributionsSummary->import_date);
													$import_date = $import_date_obj->format('d/m/Y H:i');
												} catch (\Throwable $th) {
													$import_date = '—';
												}
												echo '<p>'. sprintf( __('Import date : %s', CIP_TXTDOMAIN), $import_date ) .'</p>';
												echo '<p>'. sprintf( __('Total %s records to update', CIP_TXTDOMAIN), number_format($getDistributions) ) .'</p>';
											}
										?>
									</div>
									<button type="button" class="btn btn-outline-primary update_new_csr_holders_data_button"><?php _e('Update CSR Data',CIP_TXTDOMAIN); ?></button>
									<button type="button" class="btn btn-outline-primary update_cancel"><?php _e('Cancel',CIP_TXTDOMAIN); ?></button>
									</div>
									<div class="col-12 text-center">
										<div class="update_process_section"></div>
										<div class="csr_split_spinner" style="display: none;">
											<div class="spinner-grow spinner-grow-sm"></div>
											<div class="spinner-grow spinner-grow-sm"></div>
											<div class="spinner-grow spinner-grow-sm"></div>
										</div>
									</div>
								</div>
	                        </div>
							<input type="button" name="next" class="next action-button finish_step d-none invisible" value="Next" />
							<input type="button" name="previous" class="previous action-button-previous d-none invisible" value="Previous" />
	                    </fieldset>
						<fieldset class="step_3">
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 4, $total_step); ?></h2>
	                                </div>
	                            </div>
								<div class="row">
									<div class="col-12">
										<h4 class="text-center"><strong><i class="fa fa-check-circle"></i> Weekly CSR Distribution Wizard Complete!</strong></h4>
										<p class="text-center update_response fw-bold"></p>
										<a class="btn button action-button" href="<?php echo get_permalink( 9099 ); ?>"><?php echo __('Okay', CIP_TXTDOMAIN); ?></a>
									</div>
	                            </div>
	                        </div>
	                    </fieldset>
	                    <input type="hidden" name="action" value="cip_sm_weekly_distribution_export_act" />
	                    <input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxYSMWeeklyDistributionExportMSYxCIP_'); ?>" />
	                </form>
					<form class="update_new_csr_holders_data_frm" id="update_new_csr_holders_data_frm">
						<input type="hidden" name="action" value="update_new_csr_holders_data_act">
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XYUpdateNew_csr_HoldersDataYX_'); ?>">
					</form>
					<form class="update_cancel_data_frm" id="update_cancel_data_frm">
						<input type="hidden" name="action" value="cancel_update_process">
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XYCancelupdateDataYX_'); ?>">
					</form>
	            </div>
	        </div>
	    </div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
//5216 code
add_shortcode( 'CIP-MEMBER-ASSISTANT-REGISTRATION', 'cip_member_assistant_user_registration_callback' );
function cip_member_assistant_user_registration_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	ob_start();
	?>
	<form name="register_member_assistant_frm" id="register_member_assistant_frm">
		<h3><?php _e( 'Register Member Assistant' ); ?></h3>
		<div class="form-group">
		<label style="color:#000000;" for="website">Email<strong style="color:red;">*</strong></label>
			<input type="email" class="form-control" placeholder="<?php _e('Enter email', CIP_TXTDOMAIN); ?>" name="email" id="email" required />
		</div>
		<div class="form-group">
		<label style="color:#000000;" for="website">First Name<strong style="color:red;">*</strong></label>
			<input type="text" class="form-control" placeholder="<?php _e('Enter first name', CIP_TXTDOMAIN); ?>" name="first_name" id="first_name" required />
		</div>

		<div class="form-group">
			<label style="color:#000000;" for="website">Last Name<strong style="color:red;">*</strong></label>
			<input type="text" class="form-control" placeholder="<?php _e('Enter last name', CIP_TXTDOMAIN); ?>" name="last_name" id="last_name" required />
		</div>
		<input type="hidden" name="action" value="smcreate_memberassitant_action" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPSMCreateMAUserCIP_'); ?>" />
		<button type="submit" class="btn btn-primary"><?php _e('Register', CIP_TXTDOMAIN); ?></button>
	</form>
	<?php
	$html .= ob_get_clean();
	return $html;
}
//4966 code
add_shortcode( 'PENDING-REVIEW-CSR-ADDRESS-LIST', 'cip_pending_review_csr_address_list_callback' );
function cip_pending_review_csr_address_list_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'magnify' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('magnify');
	ob_start();
	global $wpdb;
	$tableTokenHolder = $wpdb->prefix.'token_holder';
	$tableAddressPending = $wpdb->prefix.'csr_address_pending';
	?>
	<table id="csr_address_pending_review" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
	<thead>
		<tr>
			<th data-field="id" class="id" data-switchable="false"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
			<th data-field="username" class="username" data-filter-control="input" data-switchable="false"><?php _e('Username',CIP_TXTDOMAIN); ?></th>
			<th data-field="email" class="email" data-filter-control="input" data-switchable="false"><?php _e('Email',CIP_TXTDOMAIN); ?></th>
			<th data-field="eth_address" data-filter-control="input" class="eth_address" data-switchable="false"><?php _e('CSR address',CIP_TXTDOMAIN); ?></th>
			<th data-field="member_passport" class="member_passport" data-switchable="false"><?php _e('Passport verification image',CIP_TXTDOMAIN); ?></th>
			<th data-field="piece_paper_wallet_address" class="piece_paper_wallet_address" data-switchable="false"><?php _e('Selfie verification image',CIP_TXTDOMAIN); ?></th>
			<!--th data-field="piece_paper_the_date" class="piece_paper_the_date" data-switchable="false"><?php //_e('Piece of paper Date',CIP_TXTDOMAIN); ?></th-->
			<th data-field="reject_msg" class="reject_msg"><?php _e('Rejection message',CIP_TXTDOMAIN); ?></th>
			<th data-field="status" class="status"><?php _e('Status',CIP_TXTDOMAIN); ?></th>
			<th data-field="user_date" class="user_date" data-switchable="false"><?php _e('Date',CIP_TXTDOMAIN); ?></th>
			<th data-field="action" class="action"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
		</tr>
	</thead>
	<tbody>
	</tbody>
	</table>
	<div class="modal fade" id="enlargeImageModal" tabindex="-1" role="dialog" aria-labelledby="enlargeImageModal" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg">
		<div class="modal-content">
		<div class="modal-body">
			<img data-src="" data-magnify="gallery" src="" id="imagepreview" />
		</div>
		<div class="modal-footer">
			<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
		</div>
		</div>
	</div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode( 'MEMBER-DASHBOARD-NOTIFICATION', 'cip_member_dashboard_notification_callback' );
function cip_member_dashboard_notification_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	ob_start();
	global $wpdb;
	$tableCipNotice = $wpdb->prefix.'cip_notice';
	$tempDismissSession = json_decode( $_SESSION['tempDismissSession'], true );
	if( empty( $tempDismissSession ) || !is_array( $tempDismissSession ) ){
		$tempDismissSession = array();
	}
	$viewAnyNotice = false;
	$refAccount = ( isset( $_SESSION['refAccount'] ) && $_SESSION['refAccount'] != "" ) ? $_SESSION['refAccount'] : '-';
	?> <div class="col-md-12 notifaction_list pt-2"> <?php
	if( isset( $_SESSION['refAccount'] ) && !empty( $_SESSION['refAccount'] ) ){
		$getMembersNotice = $wpdb->get_results( "SELECT * FROM $tableCipNotice WHERE `email` = '".$refAccount."' AND `status` = 1 ORDER BY `id` DESC" );
		if( $getMembersNotice ){
			foreach( $getMembersNotice as $getNotice ){
				$encryptId = base64_encode($getNotice->id . md5('CIP_Notice_CIP'));
				if( !in_array( $getNotice->id, $tempDismissSession) ){
					$viewAnyNotice = true;
					$noticeDate = '';
					try {
						$DateObj = DateTime::createFromFormat( 'Y-m-d H:i:s', $getNotice->notice_date );
						$noticeDate = $DateObj->format('d-m-Y H:i') . ' GMT';
					} catch (\Throwable $th) {
						$noticeDate = '';
					}
					?>
					<div class="alert alert-info alert-dismissible- fade show d-flex justify-content-center align-items-center" role="alert">
						<div class="notice_content"><?php echo $getNotice->notice; ?><p class="mb-0"> <i class="fas fa-clock"></i> <?php echo $noticeDate; ?></p></div>
						<div class="close notice_close">
							<label style="padding-top: 0 !important;margin-bottom: 0;"><input type="checkbox" name="dont_show" class="dont_show" /> <?php _e('Don\'t show again', CIP_TXTDOMAIN); ?></label>
							<span aria-hidden="true" class="cip_notice_dismiss" data-id="<?php echo $encryptId; ?>"><?php _e('Dismiss', CIP_TXTDOMAIN); ?>&times;</span>
						</div>
					</div>
					<?php
				}
			}
		}else{
			if( !$viewAnyNotice ){
			?><div class="clear_notifaction"><a href="javascript:void(0);"><?php _e('No Notification Found', CIP_TXTDOMAIN); ?></a></div><?php
			}
		}
	}
	?>
	</div>
	<?php if( $getMembersNotice && $viewAnyNotice ){ ?>
		<div class="col-md-12 close notice_close notice_close_all">
			<label style="padding-top: 0 !important;margin-bottom: 0;"><input type="checkbox" name="dont_show_all" class="dont_show_all" /> <?php _e('Don\'t show again', CIP_TXTDOMAIN); ?></label>
			<span aria-hidden="true" class="cip_notice_dismiss_all"><?php _e('Dismiss All', CIP_TXTDOMAIN); ?>&times;</span>
		</div>
		<!--form class="col-md-12" name="clearAllNotificationFrm" id="clearAllNotificationFrm">
			<div class="clear_notifaction"><a href="javascript:void(0);" class="clearAllNotification">Clear all</a></div>
			<input type="hidden" name="_micro" value="<?php //echo wp_create_nonce('_XyClearAllNoticationNonceyX_') ?>" />
			<input type="hidden" name="action" value="clearAllNotificationAct" />
		</form-->
	<?php } ?>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode( 'PENDING-REVIEW-LIFTSH-CSR-ADDRESS-LIST', 'cip_pending_review_liftsh_csr_address_list_callback' );
function cip_pending_review_liftsh_csr_address_list_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'magnify' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('magnify');
	ob_start();
	global $wpdb;
	$tableTokenHolder = $wpdb->prefix.'token_holder';
	$tableLSHPending = $wpdb->prefix.'csr_lsh_pending';
	?>
	<table id="csr_lsh_pending_review" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
	<thead>
		<tr>
			<th data-field="id" class="id" data-switchable="false"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
			<th data-field="username" data-filter-control="input" class="username" data-switchable="false"><?php _e('Username',CIP_TXTDOMAIN); ?></th>
			<th data-field="email" data-filter-control="input" class="email" data-switchable="false"><?php _e('Email',CIP_TXTDOMAIN); ?></th>
			<th data-field="eth_address" data-filter-control="input" class="eth_address" data-switchable="false"><?php _e('CSR address',CIP_TXTDOMAIN); ?></th>
			<th data-field="member_passport" class="member_passport" data-switchable="false"><?php _e('Passport verification image',CIP_TXTDOMAIN); ?></th>
			<th data-field="piece_paper_wallet_address" class="piece_paper_wallet_address" data-switchable="false"><?php _e('Selfie verification image',CIP_TXTDOMAIN); ?></th>
			<th data-field="reject_msg" class="reject_msg"><?php _e('Rejection message',CIP_TXTDOMAIN); ?></th>
			<th data-field="status" class="status"><?php _e('Status',CIP_TXTDOMAIN); ?></th>
			<th data-field="user_date" class="user_date" data-switchable="false"><?php _e('Date',CIP_TXTDOMAIN); ?></th>
			<th data-field="action" class="action"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
		</tr>
	</thead>
	<tbody>
	</tbody>
	</table>
	<div class="modal fade" id="enlargeImageModal" tabindex="-1" role="dialog" aria-labelledby="enlargeImageModal" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered modal-lg">
		<div class="modal-content">
		<div class="modal-body">
			<img data-src="" data-magnify="gallery" src="" id="imagepreview" />
		</div>
		<div class="modal-footer">
			<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
		</div>
		</div>
	</div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
//5690 KYC
add_shortcode('MEMBER-PROFILE-KYC-WIZARD', 'member_profile_kyc_wizard_callback');
function member_profile_kyc_wizard_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	/* wp_enqueue_style( 'jquery-ui-style' );
	wp_enqueue_script( 'jquery-ui-datepicker' ); */

	wp_enqueue_style( 'bs-datepicker' );
	wp_enqueue_script('bs-datepicker');

	wp_enqueue_style( 'intlTelInput' );
	wp_enqueue_script('intlTelInput');
	wp_enqueue_script( 'jquery.inputmask' );
	wp_enqueue_script( 'notify-js' );
	ob_start();
	global $wpdb;
	$tableKyc = $wpdb->prefix.'kyc_data';
	$total_step = 5;
	$current_user = wp_get_current_user();
	$user_id = get_current_user_id();
	// delete_user_meta( $user_id, 'kyc_complete_notify_date' );
	$getKycData = $wpdb->get_row("SELECT * FROM $tableKyc WHERE `email` = '". $current_user->user_email ."'");
	if( !empty( $getKycData ) && $getKycData->status == 'pending' ){
	?>
	<div class="container-fluid">
		<div class="row justify-content-center">
			<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 text-center p-0 mt-2 mb-2">
				<div class="card shadow p-3 mb-5 bg-white rounded memberKycFrm">
					<h5><?php _e('Your KYC/KYB has been submitted and is being reviewed.', CIP_TXTDOMAIN); ?></h5>
				</div>
			</div>
		</div>
	</div>
	<?php
	}else if( !empty( $getKycData ) && $getKycData->status == 'approved' ){
	?>
	<div class="container-fluid">
		<div class="row justify-content-center">
			<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 text-center p-0 mt-2 mb-2">
				<div class="card shadow p-3 mb-5 bg-white rounded memberKycFrm">
					<h5><?php _e('Your KYC/KYB has been approved.', CIP_TXTDOMAIN); ?></h5>
				</div>
			</div>
		</div>
	</div>
	<?php
	}else{
		if( empty( $getKycData ) || $getKycData->is_first_step == 1 ){
			$account_type = 'individual';
			if( $getKycData->account_type == 'business' ){
				$account_type = 'business';
			}
		?>
		<div class="container-fluid">
			<div class="row justify-content-center">
				<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 text-center p-0 mt-2 mb-2">
					<div class="card shadow p-3 mb-5 bg-white rounded">
						<form name="memberKycAccountTypeFrm" class="memberKycAccountTypeFrm" id="msform">
							<!-- progressbar -->
							<ul id="progressbar">
								<li class="active" id="fieldmapping_user"><strong><?php _e('Account Type',CIP_TXTDOMAIN) ?></strong></li>
							</ul>
							<div class="progress">
								<div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
							</div>
							<br> <!-- fieldsets -->
							<fieldset class="step_0">
								<div class="form-card">
									<div class="row align-items-center text-left">
										<div class="col-12">
											<p><?php _e('In the KYC/KYB process you will be asked to upload a number of documents.', CIP_TXTDOMAIN); ?></p>
											<p><?php _e('To guide you better we need to know the type of account you hold.', CIP_TXTDOMAIN); ?></p>
											<p class="mt-1 mb-1"><?php _e('Please specify your account type', CIP_TXTDOMAIN); ?></p>

									<div class="form-check form-check">
										<input class="form-check-input" type="radio" name="account_type" id="account_type_individual" value="individual" <?php echo checked( $account_type, 'individual', true ); ?>/>
										<label class="form-check-label pt-0" for="account_type_individual">Individual</label>
									</div>
										<div class="form-check form-check">
											<input class="form-check-input" type="radio" name="account_type" id="account_type_business" value="business" <?php echo checked( $account_type, 'business', true ); ?>/>
											<label class="form-check-label pt-0" for="account_type_business">Business</label>
										</div>
										</div>
									</div>

								</div>
								<input type="submit" name="next" class="account_type_next action-button" value="Next" />
							</fieldset>
							<input type="hidden" name="action" value="member_kyc_account_type_save" />
							<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XyCIP_KYCACCOUNTTYPESAVE_CIPyX_'); ?>" />
						</form>
					</div>
				</div>
			</div>
		</div>
		<?php
		}else{
		if( $getKycData->account_type == 'business' ){ //KYB Form
			$total_step = 7;
		?>
		<div class="container-fluid">
			<div class="row justify-content-center">
				<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 text-center p-0 mt-2 mb-2">
					<div class="card shadow bg-white rounded">
					<form name="memberKybFrm" class="memberKybFrm" id="msform">
							<!-- progressbar -->
							<ul id="progressbar">
								<li class="active" id="fieldmapping_user"><strong><?php _e('Account Type',CIP_TXTDOMAIN) ?></strong></li>
								<li id="fieldmapping_document"><strong><?php _e('Business Details',CIP_TXTDOMAIN) ?></strong></li>
								<li id="fieldmapping_document"><strong><?php _e('Contact Details',CIP_TXTDOMAIN) ?></strong></li>
								<li id="fieldmapping_document"><strong><?php _e('Director or Equivalent Person',CIP_TXTDOMAIN) ?></strong></li>
								<li id="fieldmapping_proof"><strong><?php _e('Upload Documents of Business',CIP_TXTDOMAIN) ?></strong></li>
								<li id="fieldmapping_proof"><strong><?php _e('Upload Documents of Business owner/director',CIP_TXTDOMAIN) ?></strong></li>
								<li id="fieldmapping_confirm"><strong><?php _e('Confirmation',CIP_TXTDOMAIN) ?></strong></li>
							</ul>
							<div class="progress">
								<div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
							</div>
							<br> <!-- fieldsets -->
							<fieldset class="step_0">
								<div class="form-card">
									<div class="row">
										<div class="col-12">
											<p class="steps"><?php echo sprintf('Step %s - %s', 1, $total_step); ?></p>
										</div>
									</div>

									<div class="form-group row">
										<div class="col-12">
											<p><?php echo sprintf( __('Account Type: %s', CIP_TXTDOMAIN), ucfirst( $getKycData->account_type ) ); ?></p>
										</div>
									</div>
								</div>
								<input type="button" name="next" class="next action-button" value="Next" style="display:none;" />
							</fieldset>

							<fieldset class="step_1">
								<div class="form-card">
									<div class="row">
										<div class="col-12">
											<p class="steps"><?php echo sprintf('Step %s - %s', 2, $total_step); ?></p>
										</div>
									</div>

									<div class="form-group row">
										<div class="col-xl-4 col-lg-6">
											<label for="business_name">Business Name *</label>
											<input type="text" class="form-control mb-0" id="business_name" name="business_name" value="<?php echo $getKycData->business_name; ?>">
										</div>
										<div class="col-xl-4 col-lg-6">
											<label for="business_registration_country"><?php _e('Registration Country *', CIP_TXTDOMAIN); ?></label>
											<select class="form-control mb-0" id="business_registration_country" name="business_registration_country">
												<?php echo getCountriesDropDown( $getKycData->business_registration_country ); ?>
											</select>
										</div>
										<div class="col-xl-4 col-lg-6">
											<label for="business_registration_number">Registration number *</label>
											<input type="text" class="form-control mb-0" id="business_registration_number" name="business_registration_number" value="<?php echo $getKycData->business_registration_number; ?>">
										</div>
									</div>

									<div class="form-group row">
										<div class="col-xl-4 col-lg-6">
											<label for="business_type_of_business"><?php _e('Type of Business *', CIP_TXTDOMAIN); ?></label>
											<select class="form-control mb-0" id="business_type_of_business" name="business_type_of_business">
												<option value=""><?php _e('Select', CIP_TXTDOMAIN); ?></option>
												<option value="Company limited by share or guarantee" <?php echo selected( $getKycData->business_type_of_business, 'Company limited by share or guarantee' ); ?>><?php _e('Company limited by share or guarantee', CIP_TXTDOMAIN); ?></option>
												<option value="Foundations / Co-ops / Unions / Associates / Clubs / Societies" <?php echo selected( $getKycData->business_type_of_business, 'Foundations / Co-ops / Unions / Associates / Clubs / Societies' ); ?>><?php _e('Foundations / Co-ops / Unions / Associates / Clubs / Societies', CIP_TXTDOMAIN); ?></option>
												<option value="Government body / Agency" <?php echo selected( $getKycData->business_type_of_business, 'Government body / Agency' ); ?>><?php _e('Government body / Agency', CIP_TXTDOMAIN); ?></option>
												<option value="Partnership" <?php echo selected( $getKycData->business_type_of_business, 'Partnership' ); ?>><?php _e('Partnership', CIP_TXTDOMAIN); ?></option>
												<option value="Trust" <?php echo selected( $getKycData->business_type_of_business, 'Trust' ); ?>><?php _e('Trust', CIP_TXTDOMAIN); ?></option>
												<option value="Other" <?php echo selected( $getKycData->business_type_of_business, 'Other' ); ?>><?php _e('Other', CIP_TXTDOMAIN); ?></option>
											</select>
										</div>
										<div class="col-xl-4 col-lg-6">
											<label for="business_nature_of_your_business"><?php _e('What is the nature of your business *', CIP_TXTDOMAIN); ?></label>
											<select class="form-control mb-0" id="business_nature_of_your_business" name="business_nature_of_your_business">
												<option value=""><?php _e('Select', CIP_TXTDOMAIN); ?></option>
												<option value="Plastic Waste Removal" <?php echo selected( $getKycData->business_nature_of_your_business, 'Plastic Waste Removal' ); ?>><?php _e('Plastic Waste Removal', CIP_TXTDOMAIN); ?></option>
												<option value="Sales" <?php echo selected( $getKycData->business_nature_of_your_business, 'Sales' ); ?>><?php _e('Sales', CIP_TXTDOMAIN); ?></option>
												<option value="Retail" <?php echo selected( $getKycData->business_nature_of_your_business, 'Retail' ); ?>><?php _e('Retail', CIP_TXTDOMAIN); ?></option>
												<option value="Manufacturing" <?php echo selected( $getKycData->business_nature_of_your_business, 'Manufacturing' ); ?>><?php _e('Manufacturing', CIP_TXTDOMAIN); ?></option>
												<option value="Healthcare" <?php echo selected( $getKycData->business_nature_of_your_business, 'Healthcare' ); ?>><?php _e('Healthcare', CIP_TXTDOMAIN); ?></option>
												<option value="Financial Services" <?php echo selected( $getKycData->business_nature_of_your_business, 'Financial Services' ); ?>><?php _e('Financial Services', CIP_TXTDOMAIN); ?></option>
												<option value="Agriculture" <?php echo selected( $getKycData->business_nature_of_your_business, 'Agriculture' ); ?>><?php _e('Agriculture', CIP_TXTDOMAIN); ?></option>
												<option value="Information Technology (IT)" <?php echo selected( $getKycData->business_nature_of_your_business, 'Information Technology (IT)' ); ?>><?php _e('Information Technology (IT)', CIP_TXTDOMAIN); ?></option>
												<option value="Real Estate" <?php echo selected( $getKycData->business_nature_of_your_business, 'Real Estate' ); ?>><?php _e('Real Estate', CIP_TXTDOMAIN); ?></option>
												<option value="Hospitality and Tourism" <?php echo selected( $getKycData->business_nature_of_your_business, 'Hospitality and Tourism' ); ?>><?php _e('Hospitality and Tourism', CIP_TXTDOMAIN); ?></option>
												<option value="Construction" <?php echo selected( $getKycData->business_nature_of_your_business, 'Construction' ); ?>><?php _e('Construction', CIP_TXTDOMAIN); ?></option>
												<option value="Professional Services (e.g., legal, accounting)" <?php echo selected( $getKycData->business_nature_of_your_business, 'Professional Services (e.g., legal, accounting)' ); ?>><?php _e('Professional Services (e.g., legal, accounting)', CIP_TXTDOMAIN); ?></option>
												<option value="Education" <?php echo selected( $getKycData->business_nature_of_your_business, 'Education' ); ?>><?php _e('Education', CIP_TXTDOMAIN); ?></option>
												<option value="Transportation and Logistics" <?php echo selected( $getKycData->business_nature_of_your_business, 'Transportation and Logistics' ); ?>><?php _e('Transportation and Logistics', CIP_TXTDOMAIN); ?></option>
												<option value="Food and Beverage" <?php echo selected( $getKycData->business_nature_of_your_business, 'Food and Beverage' ); ?>><?php _e('Food and Beverage', CIP_TXTDOMAIN); ?></option>
												<option value="Energy and Utilities" <?php echo selected( $getKycData->business_nature_of_your_business, 'Energy and Utilities' ); ?>><?php _e('Energy and Utilities', CIP_TXTDOMAIN); ?></option>
												<option value="Automotive" <?php echo selected( $getKycData->business_nature_of_your_business, 'Automotive' ); ?>><?php _e('Automotive', CIP_TXTDOMAIN); ?></option>
												<option value="Entertainment and Media" <?php echo selected( $getKycData->business_nature_of_your_business, 'Entertainment and Media' ); ?>><?php _e('Entertainment and Media', CIP_TXTDOMAIN); ?></option>
												<option value="Nonprofit and Charitable Organizations" <?php echo selected( $getKycData->business_nature_of_your_business, 'Nonprofit and Charitable Organizations' ); ?>><?php _e('Nonprofit and Charitable Organizations', CIP_TXTDOMAIN); ?></option>
												<option value="Government and Public Administration" <?php echo selected( $getKycData->business_nature_of_your_business, 'Government and Public Administration' ); ?>><?php _e('Government and Public Administration', CIP_TXTDOMAIN); ?></option>
												<option value="E-commerce" <?php echo selected( $getKycData->business_nature_of_your_business, 'E-commerce' ); ?>><?php _e('E-commerce', CIP_TXTDOMAIN); ?></option>
												<option value="Telecommunications" <?php echo selected( $getKycData->business_nature_of_your_business, 'Telecommunications' ); ?>><?php _e('Telecommunications', CIP_TXTDOMAIN); ?></option>
												<option value="Wholesale Trade" <?php echo selected( $getKycData->business_nature_of_your_business, 'Wholesale Trade' ); ?>><?php _e('Wholesale Trade', CIP_TXTDOMAIN); ?></option>
												<option value="Pharmaceuticals" <?php echo selected( $getKycData->business_nature_of_your_business, 'Pharmaceuticals' ); ?>><?php _e('Pharmaceuticals', CIP_TXTDOMAIN); ?></option>
												<option value="Environmental Services" <?php echo selected( $getKycData->business_nature_of_your_business, 'Environmental Services' ); ?>><?php _e('Environmental Services', CIP_TXTDOMAIN); ?></option>
												<option value="Aerospace and Defense" <?php echo selected( $getKycData->business_nature_of_your_business, 'Aerospace and Defense' ); ?>><?php _e('Aerospace and Defense', CIP_TXTDOMAIN); ?></option>
												<option value="Fashion and Apparel" <?php echo selected( $getKycData->business_nature_of_your_business, 'Fashion and Apparel' ); ?>><?php _e('Fashion and Apparel', CIP_TXTDOMAIN); ?></option>
												<option value="Mining and Natural Resources" <?php echo selected( $getKycData->business_nature_of_your_business, 'Mining and Natural Resources' ); ?>><?php _e('Mining and Natural Resources', CIP_TXTDOMAIN); ?></option>
												<option value="Sports and Recreation" <?php echo selected( $getKycData->business_nature_of_your_business, 'Sports and Recreation' ); ?>><?php _e('Sports and Recreation', CIP_TXTDOMAIN); ?></option>
												<option value="Art and Culture" <?php echo selected( $getKycData->business_nature_of_your_business, 'Art and Culture' ); ?>><?php _e('Art and Culture', CIP_TXTDOMAIN); ?></option>
												<option value="Biotechnology" <?php echo selected( $getKycData->business_nature_of_your_business, 'Biotechnology' ); ?>><?php _e('Biotechnology', CIP_TXTDOMAIN); ?></option>
												<option value="Consulting" <?php echo selected( $getKycData->business_nature_of_your_business, 'Consulting' ); ?>><?php _e('Consulting', CIP_TXTDOMAIN); ?></option>
												<option value="Fitness and Wellness" <?php echo selected( $getKycData->business_nature_of_your_business, 'Fitness and Wellness' ); ?>><?php _e('Fitness and Wellness', CIP_TXTDOMAIN); ?></option>
												<option value="Home Improvement and Renovation" <?php echo selected( $getKycData->business_nature_of_your_business, 'Home Improvement and Renovation' ); ?>><?php _e('Home Improvement and Renovation', CIP_TXTDOMAIN); ?></option>
												<option value="Insurance" <?php echo selected( $getKycData->business_nature_of_your_business, 'Insurance' ); ?>><?php _e('Insurance', CIP_TXTDOMAIN); ?></option>
												<option value="Marketing and Advertising" <?php echo selected( $getKycData->business_nature_of_your_business, 'Marketing and Advertising' ); ?>><?php _e('Marketing and Advertising', CIP_TXTDOMAIN); ?></option>
												<option value="Technology Startups" <?php echo selected( $getKycData->business_nature_of_your_business, 'Technology Startups' ); ?>><?php _e('Technology Startups', CIP_TXTDOMAIN); ?></option>
												<option value="Travel and Accommodation" <?php echo selected( $getKycData->business_nature_of_your_business, 'Travel and Accommodation' ); ?>><?php _e('Travel and Accommodation', CIP_TXTDOMAIN); ?></option>
												<option value="Renewable Energy" <?php echo selected( $getKycData->business_nature_of_your_business, 'Renewable Energy' ); ?>><?php _e('Renewable Energy', CIP_TXTDOMAIN); ?></option>
												<option value="Shipping and Maritime" <?php echo selected( $getKycData->business_nature_of_your_business, 'Shipping and Maritime' ); ?>><?php _e('Shipping and Maritime', CIP_TXTDOMAIN); ?></option>
												<option value="Social Services" <?php echo selected( $getKycData->business_nature_of_your_business, 'Social Services' ); ?>><?php _e('Social Services', CIP_TXTDOMAIN); ?></option>
												<option value="Veterinary Services" <?php echo selected( $getKycData->business_nature_of_your_business, 'Veterinary Services' ); ?>><?php _e('Veterinary Services', CIP_TXTDOMAIN); ?></option>
												<option value="Other" <?php echo selected( $getKycData->business_nature_of_your_business, 'Other' ); ?>><?php _e('Other', CIP_TXTDOMAIN); ?></option>
											</select>
										</div>
									</div>

								</div>
								<input type="button" name="next" class="next action-button" value="Save & Next" />
								<input type="button" name="previous" class="previous action-button-previous" value="Back" />
							</fieldset>

							<fieldset class="step_2">
								<div class="form-card">
									<div class="row">
										<div class="col-12">
											<p class="steps"><?php echo sprintf('Step %s - %s', 3, $total_step); ?></p>
										</div>
									</div>
									<div class="form-group row">
										<div class="col-sm-12 mb-2"><h4 class="mb-0"><?php _e('Registered Address', CIP_TXTDOMAIN); ?></h4></div>
										<div class="col-sm-12 mb-2">
											<label for="business_registered_address">Address *</label>
											<input type="text" class="form-control mb-0" id="business_registered_address" name="business_registered_address" value="<?php echo $getKycData->business_registered_address; ?>" />
										</div>
										<div class="col-sm-12 mb-2">
											<label for="business_registered_address_line_2">Address line 2</label>
											<input type="text" class="form-control mb-0" id="business_registered_address_line_2" name="business_registered_address_line_2" value="<?php echo $getKycData->business_registered_address_line_2; ?>" />
										</div>
										<div class="col-sm-6 mb-2">
											<label for="business_registered_city"><?php _e('City *', CIP_TXTDOMAIN); ?></label>
											<input type="text" class="form-control mb-0" id="business_registered_city" name="business_registered_city" value="<?php echo $getKycData->business_registered_city; ?>" />
										</div>
										<div class="col-sm-6 mb-2">
											<label for="business_registered_state"><?php _e('State / Province *', CIP_TXTDOMAIN); ?></label>
											<input type="text" class="form-control mb-0" id="business_registered_state" name="business_registered_state" value="<?php echo $getKycData->business_registered_state; ?>" />
										</div>

										<div class="col-sm-6 mb-2">
											<label for="business_registered_postal_code"><?php _e('ZIP / Postal Code *', CIP_TXTDOMAIN); ?></label>
											<input type="text" class="form-control mb-0" id="business_registered_postal_code" name="business_registered_postal_code" value="<?php echo $getKycData->business_registered_postal_code; ?>" />
										</div>
										<div class="col-sm-6 mb-2">
											<label for="business_registered_country"><?php _e('Country *', CIP_TXTDOMAIN); ?></label>
											<select class="form-control mb-0" id="business_registered_country" name="business_registered_country">
												<?php echo getCountriesDropDown( $getKycData->business_registered_country ); ?>
											</select>
										</div>
									</div>
									<div class="form-group row">
										<div class="col-sm-12 mb-2"><h4 class="mb-0"><?php _e('Operating business address', CIP_TXTDOMAIN); ?></h4></div>

										<div class="col-12">
											<div class="form-check form-check-inline-">
												<input class="form-check-input" type="checkbox" name="business_same_as_registered_address" id="business_same_as_registered_address" value="1" <?php checked( $getKycData->business_same_as_registered_address, '1', true ); ?>/>
												<label class="form-check-label pt-0" for="business_same_as_registered_address">Same as registered address</label>
											</div>
										</div>
										<div class="col-12 mb-2 operating_business_address_section" style="<?php echo ( $getKycData->business_same_as_registered_address == 1 ) ? 'display:none;' : ''; ?>">
											<div class="row">
											<div class="col-sm-12 mb-2">
												<label for="business_operating_address">Address *</label>
												<input type="text" class="form-control mb-0" id="business_operating_address" name="business_operating_address" value="<?php echo $getKycData->business_operating_address; ?>" />
											</div>
											<div class="col-sm-12 mb-2">
												<label for="business_operating_address_line_2">Address line 2</label>
												<input type="text" class="form-control mb-0" id="business_operating_address_line_2" name="business_operating_address_line_2" value="<?php echo $getKycData->business_operating_address_line_2; ?>" />
											</div>
											<div class="col-sm-6 mb-2">
												<label for="business_operating_city"><?php _e('City *', CIP_TXTDOMAIN); ?></label>
												<input type="text" class="form-control mb-0" id="business_operating_city" name="business_operating_city" value="<?php echo $getKycData->business_operating_city; ?>" />
											</div>
											<div class="col-sm-6 mb-2">
												<label for="business_operating_state"><?php _e('State / Province *', CIP_TXTDOMAIN); ?></label>
												<input type="text" class="form-control mb-0" id="business_operating_state" name="business_operating_state" value="<?php echo $getKycData->business_operating_state; ?>" />
											</div>

											<div class="col-sm-6 mb-2">
												<label for="business_operating_postal_code"><?php _e('ZIP / Postal Code *', CIP_TXTDOMAIN); ?></label>
												<input type="text" class="form-control mb-0" id="business_operating_postal_code" name="business_operating_postal_code" value="<?php echo $getKycData->business_operating_postal_code; ?>" />
											</div>
											<div class="col-sm-6 mb-2">
												<label for="business_operating_country"><?php _e('Country *', CIP_TXTDOMAIN); ?></label>
												<select class="form-control mb-0" id="business_operating_country" name="business_operating_country">
													<?php echo getCountriesDropDown( $getKycData->business_operating_country ); ?>
												</select>
											</div>
											</div>
										</div>
									</div>
									<div class="form-group row">
										<div class="col-sm-12 mb-2"><h4 class="mb-0"><?php _e('Additional information', CIP_TXTDOMAIN); ?></h4></div>

										<div class="col-sm-6 mb-2">
											<label for="business_contact_number">Contact number</label>
											<input type="text" class="form-control mb-0" id="business_contact_number" name="business_contact_number" value="<?php echo $getKycData->business_contact_number; ?>" data-country="<?php echo ( !empty( $getKycData->business_contact_country ) ) ? $getKycData->business_contact_country : 'us'; ?>" />
										</div>
										<div class="col-sm-6 mb-2">
											<label for="business_company_website">Company website</label>
											<input type="text" class="form-control mb-0" id="business_company_website" name="business_company_website" value="<?php echo $getKycData->business_company_website; ?>" />
											<small><i><?php _e('e.g. http://example.com or https://example.com', CIP_TXTDOMAIN); ?></i></small>
										</div>
									</div>

									<div class="form-group row">
										<div class="col-sm-12 mb-2"><h4 class="mb-0"><?php _e('Declarations', CIP_TXTDOMAIN); ?></h4></div>
										<div class="col-sm-12 mb-1">
											<p class="mb-1">Are you aware of any sanctions or embargoes that apply to your business or customers?</p>
											<div class="form-check form-check-inline">
												<input class="form-check-input" type="radio" name="business_aware_of_any_sanctions" id="business_aware_of_any_sanctions_yes" value="Yes" <?php checked( $getKycData->business_aware_of_any_sanctions, 'Yes', true ); ?>/>
												<label class="form-check-label pt-0" for="business_aware_of_any_sanctions_yes">Yes</label>
											</div>
											<div class="form-check form-check-inline">
												<input class="form-check-input" type="radio" name="business_aware_of_any_sanctions" id="business_aware_of_any_sanctions_no" value="No" <?php checked( $getKycData->business_aware_of_any_sanctions, 'No', true ); ?>/>
												<label class="form-check-label pt-0" for="business_aware_of_any_sanctions_no">No</label>
											</div>
										</div>

										<div class="col-sm-12 mb-1">
											<p class="mb-1">Have you undergone any external audits or assessments related to AML/CTF compliance?</p>
											<div class="form-check form-check-inline">
												<input class="form-check-input" type="radio" name="business_undergone_any_external_audits" id="business_undergone_any_external_audits_yes" value="Yes" <?php checked( $getKycData->business_undergone_any_external_audits, 'Yes', true ); ?>/>
												<label class="form-check-label pt-0" for="business_undergone_any_external_audits_yes">Yes</label>
											</div>
											<div class="form-check form-check-inline">
												<input class="form-check-input" type="radio" name="business_undergone_any_external_audits" id="business_undergone_any_external_audits_no" value="No" <?php checked( $getKycData->business_undergone_any_external_audits, 'No', true ); ?>/>
												<label class="form-check-label pt-0" for="business_undergone_any_external_audits_no">No</label>
											</div>
										</div>
										<div class="col-sm-12 mb-1">
											<p class="mb-1">Is your business involved in any money laundering or financing of terrorism activities?</p>
											<div class="form-check form-check-inline">
												<input class="form-check-input" type="radio" name="business_business_involved_in_any_money_laundering" id="business_business_involved_in_any_money_laundering_yes" value="Yes" <?php checked( $getKycData->business_business_involved_in_any_money_laundering, 'Yes', true ); ?>/>
												<label class="form-check-label pt-0" for="business_business_involved_in_any_money_laundering_yes">Yes</label>
											</div>
											<div class="form-check form-check-inline">
												<input class="form-check-input" type="radio" name="business_business_involved_in_any_money_laundering" id="business_business_involved_in_any_money_laundering_no" value="No" <?php checked( $getKycData->business_business_involved_in_any_money_laundering, 'No', true ); ?>/>
												<label class="form-check-label pt-0" for="business_business_involved_in_any_money_laundering_no">No</label>
											</div>
										</div>
										<div class="col-sm-12 mb-1">
											<p class="mb-1">Have you received any penalties or sanctions related to AML/CTF violations?</p>
											<div class="form-check form-check-inline">
												<input class="form-check-input" type="radio" name="business_received_any_penalties" id="business_received_any_penalties_yes" value="Yes" <?php checked( $getKycData->business_received_any_penalties, 'Yes', true ); ?>/>
												<label class="form-check-label pt-0" for="business_received_any_penalties_yes">Yes</label>
											</div>
											<div class="form-check form-check-inline">
												<input class="form-check-input" type="radio" name="business_received_any_penalties" id="business_received_any_penalties_no" value="No" <?php checked( $getKycData->business_received_any_penalties, 'No', true ); ?>/>
												<label class="form-check-label pt-0" for="business_received_any_penalties_no">No</label>
											</div>
										</div>
									</div>


								</div>
								<input type="button" name="next" class="next action-button" value="Save & Next" />
								<input type="button" name="previous" class="previous action-button-previous" value="Previous" />
							</fieldset>
							<fieldset class="step_3">
								<div class="form-card">
									<div class="row">
										<div class="col-12">
											<p class="steps"><?php echo sprintf('Step %s - %s', 4, $total_step); ?></p>
										</div>
									</div>
									<div class="form-group row">
										<div class="col-sm-12"><h4 class="mb-0"><?php _e('Business Owner', CIP_TXTDOMAIN); ?></h4></div>
										<div class="col-12">
										<div class="row">
											<div class="col-12 form-group">
												<div class="row">
													<div class="col-sm-4">
														<label for="business_owner_first_name">First Name *</label>
														<input type="text" class="form-control mb-0" id="business_owner_first_name" name="business_owner_first_name" value="<?php echo $getKycData->business_owner_first_name; ?>">
													</div>
													<div class="col-sm-4">
														<label for="business_owner_last_name">Last Name *</label>
														<input type="text" class="form-control mb-0" id="business_owner_last_name" name="business_owner_last_name" value="<?php echo $getKycData->business_owner_last_name; ?>">
													</div>
													<div class="col-sm-4">
														<div class="form-group">
															<label>Date Of Birth *</label>
															<div class="input-group-append align-items-center">
																<input type="text" class="form-control mb-0" id="business_owner_dob" name="business_owner_dob" value="<?php echo $getKycData->business_owner_dob; ?>" placeholder="dd/mm/yyyy" autocomplete="none" />
																<label for="business_owner_dob" class="input-group-addon pl-1 pr-1" style="cursor:pointer;"><span><i class="fa fa-calendar-alt" aria-hidden="true"></i></span></label>
															</div>
														</div>
													</div>
												</div>
												<div class="form-group row">
													<div class="col-sm-12 mb-2">
														<label for="business_owner_address">Address *</label>
														<input type="text" class="form-control mb-0" id="business_owner_address" name="business_owner_address" value="<?php echo $getKycData->business_owner_address; ?>" />
													</div>
													<div class="col-sm-12 mb-2">
														<label for="business_owner_address_line_2">Address line 2</label>
														<input type="text" class="form-control mb-0" id="business_owner_address_line_2" name="business_owner_address_line_2" value="<?php echo $getKycData->business_owner_address_line_2; ?>" />
													</div>

													<div class="col-sm-6 mb-2">
														<label for="business_owner_city"><?php _e('City *', CIP_TXTDOMAIN); ?></label>
														<input type="text" class="form-control mb-0" id="business_owner_city" name="business_owner_city" value="<?php echo $getKycData->business_owner_city; ?>" />
													</div>
													<div class="col-sm-6 mb-2">
														<label for="business_owner_state"><?php _e('State / Province *', CIP_TXTDOMAIN); ?></label>
														<input type="text" class="form-control mb-0" id="business_owner_state" name="business_owner_state" value="<?php echo $getKycData->business_owner_state; ?>" />
													</div>

													<div class="col-sm-6 mb-2">
														<label for="business_owner_postal_code"><?php _e('ZIP / Postal Code *', CIP_TXTDOMAIN); ?></label>
														<input type="text" class="form-control mb-0" id="business_owner_postal_code" name="business_owner_postal_code" value="<?php echo $getKycData->business_owner_postal_code; ?>" />
													</div>
													<div class="col-sm-6 mb-2">
														<label for="business_owner_country"><?php _e('Country *', CIP_TXTDOMAIN); ?></label>
														<select class="form-control mb-0" id="business_owner_country" name="business_owner_country">
															<?php echo getCountriesDropDown( $getKycData->business_owner_country ); ?>
														</select>
													</div>
												</div>
												<div class="form-group row">
													<div class="col-sm-12">
														<p class="mb-1">Is this person politically exposed?</p>
														<div class="form-check form-check-inline">
															<input class="form-check-input" type="radio" name="business_owner_person_politically_exposed" id="business_owner_person_politically_exposed_yes" value="Yes" <?php checked( $getKycData->business_owner_person_politically_exposed, 'Yes', true ); ?>/>
															<label class="form-check-label pt-0" for="business_owner_person_politically_exposed_yes">Yes</label>
														</div>
														<div class="form-check form-check-inline">
															<input class="form-check-input" type="radio" name="business_owner_person_politically_exposed" id="business_owner_person_politically_exposed_no" value="No" <?php checked( $getKycData->business_owner_person_politically_exposed, 'No', true ); ?>/>
															<label class="form-check-label pt-0" for="business_owner_person_politically_exposed_no">No</label>
														</div>
													</div>
												</div>
											</div>
										</div>
										</div>
									</div>
									<div class="form-group row">
										<div class="col-sm-12"><p class="mb-0">Enter the details of the main director or controller of the business</p></div>
										<div class="col-sm-12"><h4 class="mb-0"><?php _e('Director', CIP_TXTDOMAIN); ?></h4></div>

										<div class="col-12 mb-2">
											<div class="form-check form-check-inline-">
												<input class="form-check-input" type="checkbox" name="business_director_details_same_as_owner" id="business_director_details_same_as_owner" value="1" <?php checked( $getKycData->business_director_details_same_as_owner, '1', true ); ?>/>
												<label class="form-check-label pt-0" for="business_director_details_same_as_owner">Same as Owner above</label>
											</div>
										</div>
										<div class="col-12 business_director_section" style="<?php echo ( $getKycData->business_director_details_same_as_owner == 1 ) ? 'display:none;' : ''; ?>">
										<div class="row">
										<div class="col-12 form-group">
											<div class="row">
												<div class="col-sm-4 mb-2">
													<label for="business_director_first_name">First Name *</label>
													<input type="text" class="form-control mb-0" id="business_director_first_name" name="business_director_first_name" value="<?php echo $getKycData->business_director_first_name; ?>">
												</div>
												<div class="col-sm-4 mb-2">
													<label for="business_director_last_name">Last Name *</label>
													<input type="text" class="form-control mb-0" id="business_director_last_name" name="business_director_last_name" value="<?php echo $getKycData->business_director_last_name; ?>">
												</div>
												<div class="col-sm-4 mb-2">
													<div class="form-group">
														<label>Date Of Birth *</label>
														<div class="input-group-append align-items-center">
															<input type="text" class="form-control mb-0" id="business_director_dob" name="business_director_dob" value="<?php echo $getKycData->business_director_dob; ?>" placeholder="dd/mm/yyyy" autocomplete="none" />
															<label for="business_director_dob" class="input-group-addon pl-1 pr-1" style="cursor:pointer;"><span><i class="fa fa-calendar-alt" aria-hidden="true"></i></span></label>
														</div>
													</div>
												</div>
											</div>
											<div class="form-group row">
												<div class="col-sm-12 mb-2">
													<label for="business_director_address">Address *</label>
													<input type="text" class="form-control mb-0" id="business_director_address" name="business_director_address" value="<?php echo $getKycData->business_director_address; ?>" />
												</div>
												<div class="col-sm-12 mb-2">
													<label for="business_director_address_line_2">Address line 2</label>
													<input type="text" class="form-control mb-0" id="business_director_address_line_2" name="business_director_address_line_2" value="<?php echo $getKycData->business_director_address_line_2; ?>" />
												</div>

												<div class="col-sm-6 mb-2">
													<label for="business_director_city"><?php _e('City *', CIP_TXTDOMAIN); ?></label>
													<input type="text" class="form-control mb-0" id="business_director_city" name="business_director_city" value="<?php echo $getKycData->business_director_city; ?>" />
												</div>
												<div class="col-sm-6 mb-2">
													<label for="business_director_state"><?php _e('State / Province *', CIP_TXTDOMAIN); ?></label>
													<input type="text" class="form-control mb-0" id="business_director_state" name="business_director_state" value="<?php echo $getKycData->business_director_state; ?>" />
												</div>

												<div class="col-sm-6 mb-2">
													<label for="business_director_postal_code"><?php _e('ZIP / Postal Code *', CIP_TXTDOMAIN); ?></label>
													<input type="text" class="form-control mb-0" id="business_director_postal_code" name="business_director_postal_code" value="<?php echo $getKycData->business_director_postal_code; ?>" />
												</div>
												<div class="col-sm-6 mb-2">
													<label for="business_director_country"><?php _e('Country *', CIP_TXTDOMAIN); ?></label>
													<select class="form-control mb-0" id="business_director_country" name="business_director_country">
														<?php echo getCountriesDropDown( $getKycData->business_director_country ); ?>
													</select>
												</div>
											</div>
											<div class="form-group row">
												<div class="col-sm-12">
													<p class="mb-1">Is this person politically exposed?</p>
													<div class="form-check form-check-inline">
														<input class="form-check-input" type="radio" name="business_director_person_politically_exposed" id="business_director_person_politically_exposed_yes" value="Yes" <?php checked( $getKycData->business_director_person_politically_exposed, 'Yes', true ); ?>/>
														<label class="form-check-label pt-0" for="business_director_person_politically_exposed_yes">Yes</label>
													</div>
													<div class="form-check form-check-inline">
														<input class="form-check-input" type="radio" name="business_director_person_politically_exposed" id="business_director_person_politically_exposed_no" value="No" <?php checked( $getKycData->business_director_person_politically_exposed, 'No', true ); ?>/>
														<label class="form-check-label pt-0" for="business_director_person_politically_exposed_no">No</label>
													</div>
												</div>
											</div>
										</div>
										</div>
										</div>
									</div>
								</div>
								<input type="button" name="next" class="next action-button" value="Save & Next" /> <input type="button" name="previous" class="previous action-button-previous" value="Previous" />
							</fieldset>
							<fieldset class="step_4">
								<div class="form-card">
									<div class="row">
										<div class="col-12">
											<p class="steps"><?php echo sprintf('Step %s - %s', 5, $total_step); ?></p>
										</div>
									</div>

									<div class="form-group row">
										<div class="col-12">
											<i class="textsize18 font-weight-bold">
												<p class="mb-1"><?php _e('File upload instructions:', CIP_TXTDOMAIN); ?></p>
												<p class="mb-1"><?php _e('To upload multiple files / documents (e.g. front and back of ID) select all files at once.', CIP_TXTDOMAIN); ?></p>
												<p><?php _e('Only jpg, jpeg, png, pdf files are valid, max size 10MB will be allowed for each document.', CIP_TXTDOMAIN); ?></p>
											</i>
										</div>
										<div class="col-sm-12"><h4 class="mb-0"><?php _e('Business', CIP_TXTDOMAIN); ?></h4></div>
										<div class="col-md-12">
											<div class="row align-items-end">
												<div class="col-sm-8">
													<label for="business_certificate_of_incorporation"><?php _e('Certificate of Incorporation/Registration of your company *', CIP_TXTDOMAIN) ?></label>
													<input type="file" class="form-control-file mb-0 p-1" id="business_certificate_of_incorporation" name="business_certificate_of_incorporation[]" accept="image/*,.pdf,.doc,docx" multiple />
												</div>
												<div class="col-sm-2">
													<button type="button" class="clear_business_certificate_of_incorporation form-control mt-2 btn btn-primary" style="display: none;"><?php _e('Remove', CIP_TXTDOMAIN) ?></button>
												</div>
											</div>
										</div>
										<div class="col-md-12">
											<div class="row">
												<div class="col-sm-4">
													<div class="d-flex align-items-center business_certificate_of_incorporation doc-grid_section pt-2 pb-2">
													<?php
													$uploadDir = CIP_PLUGIN_BASE . 'uploaded_doc/'.$user_id;
													$ViewDir = CIP_PLUGIN_FOLDER . 'uploaded_doc/'.$user_id;
													if( !empty( $getKycData->business_certificate_of_incorporation_1 ) && file_exists( $uploadDir.'/'.$getKycData->business_certificate_of_incorporation_1 ) ){
														$fileType = strtolower( pathinfo($getKycData->business_certificate_of_incorporation_1, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->business_certificate_of_incorporation_1;
														}
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_certificate_of_incorporation_1.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
													}
													if( !empty( $getKycData->business_certificate_of_incorporation_2 ) && file_exists( $uploadDir.'/'.$getKycData->business_certificate_of_incorporation_2 ) ){
														$fileType = strtolower( pathinfo($getKycData->business_certificate_of_incorporation_2, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->business_certificate_of_incorporation_2;
														}
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_certificate_of_incorporation_2.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
													}
													if( !empty( $getKycData->business_certificate_of_incorporation_3 ) && file_exists( $uploadDir.'/'.$getKycData->business_certificate_of_incorporation_3 ) ){
														$fileType = strtolower( pathinfo($getKycData->business_certificate_of_incorporation_3, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->business_certificate_of_incorporation_3;
														}
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_certificate_of_incorporation_3.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
													}
													?>
													</div>
												</div>
												<div class="col-sm-4"></div>
												<div class="col-sm-4"></div>
											</div>
										</div>
										<!-- ------- -->
										<div class="col-md-12">
											<div class="row align-items-end">
												<div class="col-sm-8">
													<label for="business_shareholder_certificate"><?php _e('Shareholder Certificate or Proof of Ownership *', CIP_TXTDOMAIN) ?></label>
													<input type="file" class="form-control-file mb-0 p-1" id="business_shareholder_certificate" name="business_shareholder_certificate[]" accept="image/*,.pdf,.doc,docx" multiple />
												</div>
												<div class="col-sm-2">
													<button type="button" class="clear_business_shareholder_certificate form-control mt-2 btn btn-primary" style="display: none;"><?php _e('Remove', CIP_TXTDOMAIN) ?></button>
												</div>
											</div>
										</div>
										<div class="col-md-12">
											<div class="row">
												<div class="col-sm-4">
													<div class="d-flex align-items-center business_shareholder_certificate doc-grid_section pt-2 pb-2">
													<?php
													$uploadDir = CIP_PLUGIN_BASE . 'uploaded_doc/'.$user_id;
													$ViewDir = CIP_PLUGIN_FOLDER . 'uploaded_doc/'.$user_id;
													if( !empty( $getKycData->business_shareholder_certificate_1 ) && file_exists( $uploadDir.'/'.$getKycData->business_shareholder_certificate_1 ) ){
														$fileType = strtolower( pathinfo($getKycData->business_shareholder_certificate_1, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->business_shareholder_certificate_1;
														}
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_shareholder_certificate_1.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
													}
													if( !empty( $getKycData->business_shareholder_certificate_2 ) && file_exists( $uploadDir.'/'.$getKycData->business_shareholder_certificate_2 ) ){
														$fileType = strtolower( pathinfo($getKycData->business_shareholder_certificate_2, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->business_shareholder_certificate_2;
														}
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_shareholder_certificate_2.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
													}
													if( !empty( $getKycData->business_shareholder_certificate_4 ) && file_exists( $uploadDir.'/'.$getKycData->business_shareholder_certificate_4 ) ){
														$fileType = strtolower( pathinfo($getKycData->business_shareholder_certificate_4, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->business_shareholder_certificate_4;
														}
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_shareholder_certificate_4.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
													}
													?>
													</div>
												</div>
												<div class="col-sm-4"></div>
												<div class="col-sm-4"></div>
											</div>
										</div>
										<!-- ------- -->
										<div class="col-md-12">
											<div class="row align-items-end">
												<div class="col-sm-8">
													<label for="business_proof_address"><?php _e('Proof of address of the Business *', CIP_TXTDOMAIN) ?></label>
													<input type="file" class="form-control-file mb-0 p-1" id="business_proof_address" name="business_proof_address[]" accept="image/*,.pdf,.doc,docx" multiple />
												</div>
												<div class="col-sm-2">
													<button type="button" class="clear_business_proof_address form-control mt-2 btn btn-primary" style="display: none;"><?php _e('Remove', CIP_TXTDOMAIN) ?></button>
												</div>
											</div>
										</div>
										<div class="col-md-12">
											<div class="row">
												<div class="col-sm-4">
													<div class="d-flex align-items-center business_proof_address doc-grid_section pt-2 pb-2">
													<?php
													$uploadDir = CIP_PLUGIN_BASE . 'uploaded_doc/'.$user_id;
													$ViewDir = CIP_PLUGIN_FOLDER . 'uploaded_doc/'.$user_id;
													if( !empty( $getKycData->business_proof_address_1 ) && file_exists( $uploadDir.'/'.$getKycData->business_proof_address_1 ) ){
														$fileType = strtolower( pathinfo($getKycData->business_proof_address_1, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->business_proof_address_1;
														}
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_proof_address_1.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
													}
													if( !empty( $getKycData->business_proof_address_2 ) && file_exists( $uploadDir.'/'.$getKycData->business_proof_address_2 ) ){
														$fileType = strtolower( pathinfo($getKycData->business_proof_address_2, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->business_proof_address_2;
														}
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_proof_address_2.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
													}
													if( !empty( $getKycData->business_proof_address_3 ) && file_exists( $uploadDir.'/'.$getKycData->business_proof_address_3 ) ){
														$fileType = strtolower( pathinfo($getKycData->business_proof_address_3, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->business_proof_address_3;
														}
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_proof_address_3.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
													}
													?>
													</div>
												</div>
												<div class="col-sm-4"></div>
												<div class="col-sm-4"></div>
											</div>
										</div>
									</div>
								</div>
								<input type="button" name="next" class="next action-button" value="Save & Next" /> <input type="button" name="previous" class="previous action-button-previous" value="Previous" />
							</fieldset>
							<fieldset class="step_5">
								<div class="form-card">
									<div class="row">
										<div class="col-12">
											<p class="steps"><?php echo sprintf('Step %s - %s', 6, $total_step); ?></p>
										</div>
									</div>

									<div class="form-group row">
										<!-- ------- -->
										<div class="col-12">
											<i class="textsize18 font-weight-bold">
												<p class="mb-1"><?php _e('File upload instructions:', CIP_TXTDOMAIN); ?></p>
												<p class="mb-1"><?php _e('To upload multiple files / documents (e.g. front and back of ID) select all files at once.', CIP_TXTDOMAIN); ?></p>
												<p><?php _e('Only jpg, jpeg, png, pdf files are valid, max size 10MB will be allowed for each document.', CIP_TXTDOMAIN); ?></p>
											</i>
										</div>
										<div class="col-12">
											<div class="row">
											<div class="col-sm-12"><h4 class="mb-0"><?php _e('Business Owner', CIP_TXTDOMAIN); ?></h4></div>
											<div class="col-md-12">
												<div class="row align-items-end">
													<div class="col-sm-8">
														<label for="business_owner_passport_national_id"><?php _e('Passport or National ID *', CIP_TXTDOMAIN) ?></label>
														<input type="file" class="form-control-file mb-0 p-1" id="business_owner_passport_national_id" name="business_owner_passport_national_id[]" accept="image/*,.pdf,.doc,docx" multiple />
													</div>
													<div class="col-sm-2">
														<button type="button" class="clear_business_owner_passport_national_id form-control mt-2 btn btn-primary" style="display: none;"><?php _e('Remove', CIP_TXTDOMAIN) ?></button>
													</div>
												</div>
											</div>
											<div class="col-md-12">
												<div class="row">
													<div class="col-sm-4">
														<div class="d-flex align-items-center business_owner_passport_national_id doc-grid_section pt-2 pb-2">
														<?php
														$uploadDir = CIP_PLUGIN_BASE . 'uploaded_doc/'.$user_id;
														$ViewDir = CIP_PLUGIN_FOLDER . 'uploaded_doc/'.$user_id;
														if( !empty( $getKycData->business_owner_passport_national_id_1 ) && file_exists( $uploadDir.'/'.$getKycData->business_owner_passport_national_id_1 ) ){
															$fileType = strtolower( pathinfo($getKycData->business_owner_passport_national_id_1, PATHINFO_EXTENSION) );
															if( $fileType == 'pdf' ){
																$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
															}else{
																$imgSrc = $ViewDir.'/'.$getKycData->business_owner_passport_national_id_1;
															}
															echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_owner_passport_national_id_1.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
														}
														if( !empty( $getKycData->business_owner_passport_national_id_2 ) && file_exists( $uploadDir.'/'.$getKycData->business_owner_passport_national_id_2 ) ){
															$fileType = strtolower( pathinfo($getKycData->business_owner_passport_national_id_2, PATHINFO_EXTENSION) );
															if( $fileType == 'pdf' ){
																$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
															}else{
																$imgSrc = $ViewDir.'/'.$getKycData->business_owner_passport_national_id_2;
															}
															echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_owner_passport_national_id_2.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
														}
														if( !empty( $getKycData->business_owner_passport_national_id_3 ) && file_exists( $uploadDir.'/'.$getKycData->business_owner_passport_national_id_3 ) ){
															$fileType = strtolower( pathinfo($getKycData->business_owner_passport_national_id_3, PATHINFO_EXTENSION) );
															if( $fileType == 'pdf' ){
																$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
															}else{
																$imgSrc = $ViewDir.'/'.$getKycData->business_owner_passport_national_id_3;
															}
															echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_owner_passport_national_id_3.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
														}
														?>
														</div>
													</div>
													<div class="col-sm-4"></div>
													<div class="col-sm-4"></div>
												</div>
											</div>
											<!-- ------- -->
											<div class="col-md-12">
												<div class="row align-items-end">
													<div class="col-sm-8">
														<label for="business_owner_proof_address"><?php _e('Proof of address (Personal Residential Address) *', CIP_TXTDOMAIN) ?></label>
														<input type="file" class="form-control-file mb-0 p-1" id="business_owner_proof_address" name="business_owner_proof_address[]" accept="image/*,.pdf,.doc,docx" multiple />
													</div>
													<div class="col-sm-2">
														<button type="button" class="clear_business_owner_proof_address form-control mt-2 btn btn-primary" style="display: none;"><?php _e('Remove', CIP_TXTDOMAIN) ?></button>
													</div>
												</div>
											</div>
											<div class="col-md-12">
												<div class="row">
													<div class="col-sm-4">
														<div class="d-flex align-items-center business_owner_proof_address doc-grid_section pt-2 pb-2">
														<?php
														$uploadDir = CIP_PLUGIN_BASE . 'uploaded_doc/'.$user_id;
														$ViewDir = CIP_PLUGIN_FOLDER . 'uploaded_doc/'.$user_id;
														if( !empty( $getKycData->business_owner_proof_address_1 ) && file_exists( $uploadDir.'/'.$getKycData->business_owner_proof_address_1 ) ){
															$fileType = strtolower( pathinfo($getKycData->business_owner_proof_address_1, PATHINFO_EXTENSION) );
															if( $fileType == 'pdf' ){
																$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
															}else{
																$imgSrc = $ViewDir.'/'.$getKycData->business_owner_proof_address_1;
															}
															echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_owner_proof_address_1.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
														}
														if( !empty( $getKycData->business_owner_proof_address_2 ) && file_exists( $uploadDir.'/'.$getKycData->business_owner_proof_address_2 ) ){
															$fileType = strtolower( pathinfo($getKycData->business_owner_proof_address_2, PATHINFO_EXTENSION) );
															if( $fileType == 'pdf' ){
																$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
															}else{
																$imgSrc = $ViewDir.'/'.$getKycData->business_owner_proof_address_2;
															}
															echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_owner_proof_address_2.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
														}
														if( !empty( $getKycData->business_owner_proof_address_3 ) && file_exists( $uploadDir.'/'.$getKycData->business_owner_proof_address_3 ) ){
															$fileType = strtolower( pathinfo($getKycData->business_owner_proof_address_3, PATHINFO_EXTENSION) );
															if( $fileType == 'pdf' ){
																$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
															}else{
																$imgSrc = $ViewDir.'/'.$getKycData->business_owner_proof_address_3;
															}
															echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_owner_proof_address_3.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
														}
														?>
														</div>
													</div>
													<div class="col-sm-4"></div>
													<div class="col-sm-4"></div>
												</div>
											</div>
											</div>
										</div>
										<div class="col-12 business_director_upload_document_section" style="<?php echo ( $getKycData->business_director_details_same_as_owner == 1 ) ? 'display:none;' : ''; ?>">
										<div class="row">
										<div class="col-8"><hr class="mt-4 mb-3"></div>
										<div class="col-4"></div>
										<div class="col-sm-12"><h4 class="mb-0"><?php _e('Director or Equivalent Person', CIP_TXTDOMAIN); ?></h4></div>
										<div class="col-md-12">
											<div class="row align-items-end">
												<div class="col-sm-8">
													<label for="business_director_passport_national_id"><?php _e('Passport or National ID *', CIP_TXTDOMAIN) ?></label>
													<input type="file" class="form-control-file mb-0 p-1" id="business_director_passport_national_id" name="business_director_passport_national_id[]" accept="image/*,.pdf,.doc,docx" multiple />
												</div>
												<div class="col-sm-2">
													<button type="button" class="clear_business_director_passport_national_id form-control mt-2 btn btn-primary" style="display: none;"><?php _e('Remove', CIP_TXTDOMAIN) ?></button>
												</div>
											</div>
										</div>
										<div class="col-md-12">
											<div class="row">
												<div class="col-sm-4">
													<div class="d-flex align-items-center business_director_passport_national_id doc-grid_section pt-2 pb-2">
													<?php
													$uploadDir = CIP_PLUGIN_BASE . 'uploaded_doc/'.$user_id;
													$ViewDir = CIP_PLUGIN_FOLDER . 'uploaded_doc/'.$user_id;
													if( !empty( $getKycData->business_director_passport_national_id_1 ) && file_exists( $uploadDir.'/'.$getKycData->business_director_passport_national_id_1 ) ){
														$fileType = strtolower( pathinfo($getKycData->business_director_passport_national_id_1, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->business_director_passport_national_id_1;
														}
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_director_passport_national_id_1.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
													}
													if( !empty( $getKycData->business_director_passport_national_id_2 ) && file_exists( $uploadDir.'/'.$getKycData->business_director_passport_national_id_2 ) ){
														$fileType = strtolower( pathinfo($getKycData->business_director_passport_national_id_2, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->business_director_passport_national_id_2;
														}
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_director_passport_national_id_2.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
													}
													if( !empty( $getKycData->business_director_passport_national_id_3 ) && file_exists( $uploadDir.'/'.$getKycData->business_director_passport_national_id_3 ) ){
														$fileType = strtolower( pathinfo($getKycData->business_director_passport_national_id_3, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->business_director_passport_national_id_3;
														}
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_director_passport_national_id_3.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
													}
													?>
													</div>
												</div>
												<div class="col-sm-4"></div>
												<div class="col-sm-4"></div>
											</div>
										</div>
										<!-- ------- -->
										<div class="col-md-12">
											<div class="row align-items-end">
												<div class="col-sm-8">
													<label for="business_director_proof_address"><?php _e('Proof of address (Personal Residential Address) *', CIP_TXTDOMAIN) ?></label>
													<input type="file" class="form-control-file mb-0 p-1" id="business_director_proof_address" name="business_director_proof_address[]" accept="image/*,.pdf,.doc,docx" multiple />
												</div>
												<div class="col-sm-2">
													<button type="button" class="clear_business_director_proof_address form-control mt-2 btn btn-primary" style="display: none;"><?php _e('Remove', CIP_TXTDOMAIN) ?></button>
												</div>
											</div>
										</div>
										<div class="col-md-12">
											<div class="row">
												<div class="col-sm-4">
													<div class="d-flex align-items-center business_director_proof_address doc-grid_section pt-2 pb-2">
													<?php
													$uploadDir = CIP_PLUGIN_BASE . 'uploaded_doc/'.$user_id;
													$ViewDir = CIP_PLUGIN_FOLDER . 'uploaded_doc/'.$user_id;
													if( !empty( $getKycData->business_director_proof_address_1 ) && file_exists( $uploadDir.'/'.$getKycData->business_director_proof_address_1 ) ){
														$fileType = strtolower( pathinfo($getKycData->business_director_proof_address_1, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->business_director_proof_address_1;
														}
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_director_proof_address_1.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
													}
													if( !empty( $getKycData->business_director_proof_address_2 ) && file_exists( $uploadDir.'/'.$getKycData->business_director_proof_address_2 ) ){
														$fileType = strtolower( pathinfo($getKycData->business_director_proof_address_2, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->business_director_proof_address_2;
														}
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_director_proof_address_2.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
													}
													if( !empty( $getKycData->business_director_proof_address_3 ) && file_exists( $uploadDir.'/'.$getKycData->business_director_proof_address_3 ) ){
														$fileType = strtolower( pathinfo($getKycData->business_director_proof_address_3, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->business_director_proof_address_3;
														}
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->business_director_proof_address_3.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
													}
													?>
													</div>
												</div>
												<div class="col-sm-4"></div>
												<div class="col-sm-4"></div>
											</div>
										</div>
										</div>
										</div>
										<!-- ------- -->
										<br/>

									</div>
								</div>
								<input type="button" name="next" class="next action-button" value="Save & Next" /> <input type="button" name="previous" class="previous action-button-previous" value="Previous" />
							</fieldset>
							<fieldset class="step_6">
								<div class="form-card">
									<div class="row">
										<div class="col-12">
											<p class="steps"><?php echo sprintf('Step %s - %s', 7, $total_step); ?></p>
										</div>
									</div>
									<div class="form-group row">
										<div class="col-sm-12">
											<p class="mb-1">I consent to my data being shared with all companies in the Corsair Group</p>
											<div class="form-check form-check-inline-">
												<input class="form-check-input" type="radio" name="consent_my_data_share" id="consent_my_data_share_yes" value="Yes" <?php checked( $getKycData->consent_my_data_share, 'Yes', true ); ?>/>
												<label class="form-check-label pt-0" for="consent_my_data_share_yes">Yes</label>
											</div>
											<div class="form-check form-check-inline-">
												<input class="form-check-input" type="radio" name="consent_my_data_share" id="consent_my_data_share_no" value="No" <?php checked( $getKycData->consent_my_data_share, 'No', true ); ?>/>
												<label class="form-check-label pt-0" for="consent_my_data_share_no">No</label>
											</div>
										</div>
									</div>
									<div class="form-group row">
										<div class="col-sm-12">
											<p class="mb-1">I confirm the information submitted in this form is complete and correct</p>
											<div class="form-check form-check-inline-">
												<input class="form-check-input" type="radio" name="confirm_correct_info" id="confirm_correct_info_yes" value="Yes" <?php checked( $getKycData->confirm_correct_info, 'Yes', true ); ?>/>
												<label class="form-check-label pt-0" for="confirm_correct_info_yes">Yes</label>
											</div>
											<div class="form-check form-check-inline-">
												<input class="form-check-input" type="radio" name="confirm_correct_info" id="confirm_correct_info_no" value="No" <?php checked( $getKycData->confirm_correct_info, 'No', true ); ?>/>
												<label class="form-check-label pt-0" for="confirm_correct_info_no">No</label>
											</div>
										</div>
									</div>
								</div>
								<input type="button" name="next" class="next action-button" value="Submit" /> <input type="button" name="previous" class="previous action-button-previous" value="Previous" />
							</fieldset>
							<input type="hidden" name="action" value="cipMemberKybSubmitAct" />
							<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPMemberSUbmitKybCIP_'); ?>" />
							<div class="responseSection"></div>
						</form>
					</div>
				</div>
			</div>
		</div>
		<?php
		}else{ //KYC Form
		$total_step = 5;
		?>
		<div class="container-fluid">
			<div class="row justify-content-center">
				<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 text-center p-0 mt-2 mb-2">
					<div class="card shadow p-3 mb-5 bg-white rounded">
						<form name="memberKycFrm" class="memberKycFrm" id="msform">
						<!-- progressbar -->
							<ul id="progressbar">
								<li class="active" id="fieldmapping_user"><strong><?php _e('Account Type',CIP_TXTDOMAIN) ?></strong></li>
								<li id="fieldmapping_user"><strong><?php _e('Personal Information',CIP_TXTDOMAIN) ?></strong></li>
								<li id="fieldmapping_document"><strong><?php _e('Identification Document',CIP_TXTDOMAIN) ?></strong></li>
								<li id="fieldmapping_proof"><strong><?php _e('Proof of Address',CIP_TXTDOMAIN) ?></strong></li>
								<li id="fieldmapping_confirm"><strong><?php _e('Confirmation',CIP_TXTDOMAIN) ?></strong></li>
							</ul>
							<div class="progress">
								<div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
							</div>
							<br> <!-- fieldsets -->
							<fieldset class="step_0">
								<div class="form-card">
									<div class="row">
										<div class="col-12">
											<p class="steps"><?php echo sprintf('Step %s - %s', 1, $total_step); ?></p>
										</div>
									</div>

									<div class="form-group row">
										<div class="col-12">
											<p><?php echo sprintf( __('Account Type: %s', CIP_TXTDOMAIN), ucfirst( $getKycData->account_type ) ); ?></p>
										</div>
									</div>
								</div>
								<input type="button" name="next" class="next action-button" value="Next" style="display:none;" />
							</fieldset>
							<fieldset class="step_1">
								<div class="form-card">
									<div class="row">
										<div class="col-12">
											<p class="steps"><?php echo sprintf('Step %s - %s', 2, $total_step); ?></p>
										</div>
									</div>

									<div class="form-group row mb-0">
										<div class="col-sm-4">
											<label for="firstname">First Name *</label>
											<input type="text" class="form-control mb-0" id="firstname" name="firstname" value="<?php echo $getKycData->firstname; ?>">
										</div>
										<div class="col-sm-4">
											<label for="lastname">Last Name *</label>
											<input type="text" class="form-control mb-0" id="lastname" name="lastname" value="<?php echo $getKycData->lastname; ?>">
										</div>
										<div class="col-sm-4">
											<div class="form-group">
												<label>Date Of Birth *</label>
												<div class="input-group-append align-items-center">
													<input type="text" class="form-control mb-0" id="dob" name="dob" value="<?php echo $getKycData->dob; ?>" placeholder="dd/mm/yyyy" autocomplete="none" />
													<label for="dob" class="input-group-addon pl-1 pr-1" style="cursor:pointer;"><span><i class="fa fa-calendar-alt" aria-hidden="true"></i></span></label>
												</div>
											</div>
										</div>
									</div>
									<div class="form-group row">
										<div class="col-sm-12 mb-2">
											<label for="postal_address">Address *</label>
											<input type="text" class="form-control mb-0" id="address" name="address" value="<?php echo $getKycData->address; ?>" />
										</div>
										<div class="col-sm-12 mb-2">
											<label for="street_address">Address line 2</label>
											<input type="text" class="form-control mb-0" id="street_address" name="street_address" value="<?php echo $getKycData->street_address; ?>" />
										</div>
										<div class="col-sm-6 mb-2">
											<label for="city"><?php _e('City *', CIP_TXTDOMAIN); ?></label>
											<input type="text" class="form-control mb-0" id="city" name="city" value="<?php echo $getKycData->city; ?>" />
										</div>
										<div class="col-sm-6 mb-2">
											<label for="state"><?php _e('State / Province *', CIP_TXTDOMAIN); ?></label>
											<input type="text" class="form-control mb-0" id="state" name="state" value="<?php echo $getKycData->state; ?>" />
										</div>

										<div class="col-sm-6 mb-2">
											<label for="postal_code"><?php _e('ZIP / Postal Code *', CIP_TXTDOMAIN); ?></label>
											<input type="text" class="form-control mb-0" id="postal_code" name="postal_code" value="<?php echo $getKycData->postal_code; ?>" />
										</div>
										<div class="col-sm-6 mb-2">
											<label for="country"><?php _e('Country *', CIP_TXTDOMAIN); ?></label>
											<select class="form-control mb-0" id="country" name="country">
												<?php echo getCountriesDropDown( $getKycData->country ); ?>
											</select>
										</div>
									</div>

								</div>
								<input type="button" name="next" class="next action-button" value="Save & Next" />
								<input type="button" name="previous" class="previous action-button-previous" value="Back" />
							</fieldset>
							<fieldset class="step_2">
								<div class="form-card">
									<div class="row">
										<div class="col-12">
											<p class="steps"><?php echo sprintf('Step %s - %s', 3, $total_step); ?></p>
										</div>
									</div>
									<div class="form-group row">
										<div class="col-sm-4">
											<label for="document_type">Document Type *</label>
											<select name="document_type" id="document_type" class="form-control mb-0">
												<option value="">Select</option>
												<option value="Drivers License" <?php selected( $getKycData->document_type, 'Drivers License', true ); ?>>Drivers License</option>
												<option value="Passport" <?php selected( $getKycData->document_type, 'Passport', true ); ?>>Passport</option>
												<option value="Government issued ID-card" <?php selected( $getKycData->document_type, 'Government issued ID-card', true ); ?>>Government issued ID-card</option>
												<option value="Other" <?php selected( $getKycData->document_type, 'Other', true ); ?>>Other</option>
											</select>
										</div>
										<div class="col-sm-4">
											<label for="document_number">Document Number *</label>
											<input type="text" class="form-control mb-0" id="document_number" name="document_number" value="<?php echo $getKycData->document_number; ?>">
										</div>
										<div class="col-sm-4">
											<label for="issuing_country">Issuing Country *</label>
											<select name="issuing_country" id="issuing_country" class="form-control mb-0">
												<?php echo getCountriesDropDown( $getKycData->issuing_country ); ?>
											</select>
										</div>
									</div>
									<div class="form-group row">
										<div class="col-sm-4">
											<label>Issue Date *</label>
											<div class="input-group-append align-items-center">
												<input type="text" class="form-control mb-0" id="issue_date" name="issue_date" value="<?php echo $getKycData->issue_date; ?>" placeholder="dd/mm/yyyy" autocomplete="none" />
												<label for="issue_date" class="input-group-addon pl-1 pr-1" style="cursor:pointer;"><span><i class="fa fa-calendar-alt" aria-hidden="true"></i></span></label>
											</div>
										</div>

										<div class="col-sm-4">
											<label>Expiration Date *</label>
											<div class="input-group-append align-items-center">
												<input type="text" class="form-control mb-0" id="expiration_date" name="expiration_date" value="<?php echo $getKycData->expiration_date; ?>" placeholder="dd/mm/yyyy" autocomplete="none" />
												<label for="expiration_date" class="input-group-addon pl-1 pr-1" style="cursor:pointer;"><span><i class="fa fa-calendar-alt" aria-hidden="true"></i></span></label>
											</div>
										</div>
										<div class="col-sm-4">
											<label for="nationality">Nationality *</label>
											<select name="nationality" id="nationality" class="form-control mb-0">
											<?php echo getCountriesDropDown( $getKycData->nationality ); ?>
											</select>
										</div>
									</div>
									<div class="form-group row">
										<div class="col-sm-4">
											<div class="form-check">
												<input type="checkbox" class="form-check-input" id="id_no_have_issue_date" name="id_no_have_issue_date" value="1" <?php checked( $getKycData->id_no_have_issue_date, '1', true ); ?>>
												<label class="form-check-label pt-0" for="id_no_have_issue_date">My document does not have issue date.</label>
											</div>
										</div>
										<div class="col-sm-4">
											<div class="form-check">
												<input type="checkbox" class="form-check-input" id="id_no_have_expiry" name="id_no_have_expiry" value="1" <?php checked( $getKycData->id_no_have_expiry, '1', true ); ?>>
												<label class="form-check-label pt-0" for="id_no_have_expiry">My document does not have expiration date.</label>
											</div>
										</div>
										<div class="col-sm-4"></div>
									</div>
									<div class="row">
									<div class="col-12">
										<i class="font-weight-bold">
											<p class="mb-0"><?php _e('File upload instructions:', CIP_TXTDOMAIN); ?></p>
											<p class="mb-0"><?php _e('To upload multiple files / documents (e.g. front and back of ID) select all files at once.', CIP_TXTDOMAIN); ?></p>
											<p class="mb-0"><?php _e('Only jpg, jpeg, png, pdf files are valid, max size 10MB will be allowed for each document.', CIP_TXTDOMAIN); ?></p>
										</i>
									</div>
									</div>
									<div class="form-group row align-items-end">
										<div class="col-sm-8">
											<label for="identification_document">Upload document *</label>
											<input type="file" class="form-control-file mb-0" id="identification_document" name="identification_document[]" accept="image/*,.pdf" multiple />
										</div>
										<div class="col-sm-2">
											<button type="button" class="clear_identification_document form-control mt-2 btn btn-primary" style="display: none;"><?php _e('Remove', CIP_TXTDOMAIN) ?></button>
										</div>
									</div>
									<div class="row">
										<div class="col-sm-4">
											<div class="d-flex align-items-center identification_document doc-grid_section">
											<?php
											$uploadDir = CIP_PLUGIN_BASE . 'uploaded_doc/'.$user_id;
											$ViewDir = CIP_PLUGIN_FOLDER . 'uploaded_doc/'.$user_id;
											if( !empty( $getKycData->identification_document_1 ) && file_exists( $uploadDir.'/'.$getKycData->identification_document_1 ) ){
												$fileType = strtolower( pathinfo($getKycData->identification_document_1, PATHINFO_EXTENSION) );
												if( $fileType == 'pdf' ){
													$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
												}else{
													$imgSrc = $ViewDir.'/'.$getKycData->identification_document_1;
												}
												echo '<div><a href="'.$ViewDir.'/'.$getKycData->identification_document_1.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
											}
											if( !empty( $getKycData->identification_document_2 ) && file_exists( $uploadDir.'/'.$getKycData->identification_document_2 ) ){
												$fileType = strtolower( pathinfo($getKycData->identification_document_2, PATHINFO_EXTENSION) );
												if( $fileType == 'pdf' ){
													$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
												}else{
													$imgSrc = $ViewDir.'/'.$getKycData->identification_document_2;
												}
												echo '<div><a href="'.$ViewDir.'/'.$getKycData->identification_document_2.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
											}
											if( !empty( $getKycData->identification_document_3 ) && file_exists( $uploadDir.'/'.$getKycData->identification_document_3 ) ){
												$fileType = strtolower( pathinfo($getKycData->identification_document_3, PATHINFO_EXTENSION) );
												if( $fileType == 'pdf' ){
													$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
												}else{
													$imgSrc = $ViewDir.'/'.$getKycData->identification_document_3;
												}
												echo '<div><a href="'.$ViewDir.'/'.$getKycData->identification_document_3.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
											}
											?>
											</div>
										</div>
										<div class="col-sm-4"></div>
										<div class="col-sm-4"></div>
									</div>

								</div>
								<input type="button" name="next" class="next action-button" value="Save & Next" /> <input type="button" name="previous" class="previous action-button-previous" value="Previous" />
							</fieldset>
							<fieldset class="step_3">
								<div class="form-card">
									<div class="row">
										<div class="col-12">
											<p class="steps"><?php echo sprintf('Step %s - %s', 4, $total_step); ?></p>
										</div>
									</div>

									<div class="form-group row">
										<div class="col-sm-6">
											<label for="document_proof"><?php _e('Document Type *', CIP_TXTDOMAIN) ?></label>
											<select name="document_proof" id="document_proof" class="form-control mb-0">
											<option value="" selected="">Select</option>
											<option value="Bank Statement" <?php selected( $getKycData->document_proof, 'Bank Statement', true ); ?>>Bank Statement</option>
											<option value="Credit Card Statement" <?php selected( $getKycData->document_proof, 'Credit Card Statement', true ); ?>>Credit Card Statement</option>
											<option value="Utility Bill" <?php selected( $getKycData->document_proof, 'Utility Bill', true ); ?>>Utility Bill</option>
											<option value="Other" <?php selected( $getKycData->document_proof, 'Other', true ); ?>>Other</option>
										</select>
										</div>
										<div class="col-sm-6">
											<label><?php _e('Document Date *', CIP_TXTDOMAIN) ?></label>
											<div class="input-group-append align-items-center">
												<input type="text" class="form-control mb-0" id="document_date" name="document_date" value="<?php echo $getKycData->document_date; ?>" placeholder="dd/mm/yyyy" autocomplete="none" />
												<label for="document_date" class="input-group-addon pl-1 pr-1" style="cursor:pointer;"><span><i class="fa fa-calendar-alt" aria-hidden="true"></i></span></label>
											</div>
											<em><?php _e('(Document date must be within 90 days)', CIP_TXTDOMAIN) ?></em>
										</div>
									</div>
									<div class="row">
									<div class="col-12">
										<i class="font-weight-bold">
											<p class="mb-0"><?php _e('File upload instructions:', CIP_TXTDOMAIN); ?></p>
											<p class="mb-0"><?php _e('To upload multiple files / documents (e.g. front and back of ID) select all files at once.', CIP_TXTDOMAIN); ?></p>
											<p class="mb-0"><?php _e('Only jpg, jpeg, png, pdf files are valid, max size 10MB will be allowed for each document.', CIP_TXTDOMAIN); ?></p>
										</i>
									</div>
									</div>
									<div class="form-group row align-items-end">
										<div class="col-sm-8">
											<label for="proof_document"><?php _e('Upload proof of Address *', CIP_TXTDOMAIN) ?></label>
											<input type="file" class="form-control-file mb-0" id="proof_document" name="proof_document[]" accept="image/*,.pdf,.doc,docx" multiple />
											<!--i><?php _e('Only jpg,jpeg,png,pdf files are valid, max size 10MB will be allowed for each document', CIP_TXTDOMAIN); ?></i-->
										</div>
										<div class="col-sm-2">
											<button type="button" class="clear_proof_document form-control mt-2" style="display: none;"><?php _e('Remove', CIP_TXTDOMAIN) ?></button>
										</div>
									</div>
									<div class="row">
										<div class="col-sm-4">
											<div class="d-flex align-items-center proof_document doc-grid_section">
											<?php
											$uploadDir = CIP_PLUGIN_BASE . 'uploaded_doc/'.$user_id;
											$ViewDir = CIP_PLUGIN_FOLDER . 'uploaded_doc/'.$user_id;
											if( !empty( $getKycData->proof_document_1 ) && file_exists( $uploadDir.'/'.$getKycData->proof_document_1 ) ){
												$fileType = strtolower( pathinfo($getKycData->proof_document_1, PATHINFO_EXTENSION) );
												if( $fileType == 'pdf' ){
													$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
												}else{
													$imgSrc = $ViewDir.'/'.$getKycData->proof_document_1;
												}
												echo '<div><a href="'.$ViewDir.'/'.$getKycData->proof_document_1.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
											}
											if( !empty( $getKycData->proof_document_2 ) && file_exists( $uploadDir.'/'.$getKycData->proof_document_2 ) ){
												$fileType = strtolower( pathinfo($getKycData->proof_document_2, PATHINFO_EXTENSION) );
												if( $fileType == 'pdf' ){
													$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
												}else{
													$imgSrc = $ViewDir.'/'.$getKycData->proof_document_2;
												}
												echo '<div><a href="'.$ViewDir.'/'.$getKycData->proof_document_2.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
											}
											if( !empty( $getKycData->proof_document_3 ) && file_exists( $uploadDir.'/'.$getKycData->proof_document_3 ) ){
												$fileType = strtolower( pathinfo($getKycData->proof_document_3, PATHINFO_EXTENSION) );
												if( $fileType == 'pdf' ){
													$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
												}else{
													$imgSrc = $ViewDir.'/'.$getKycData->proof_document_3;
												}
												echo '<div><a href="'.$ViewDir.'/'.$getKycData->proof_document_3.'" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" /> </a></div>';
											}
											?>
											</div>
										</div>
										<div class="col-sm-4"></div>
										<div class="col-sm-4"></div>
									</div>
								</div>
								<input type="button" name="next" class="next action-button" value="Save & Next" /> <input type="button" name="previous" class="previous action-button-previous" value="Previous" />
							</fieldset>
							<fieldset class="step_4">
								<div class="form-card">
									<div class="row">
										<div class="col-12">
											<p class="steps"><?php echo sprintf('Step %s - %s', 5, $total_step); ?></p>
										</div>
									</div>
									<div class="form-group row">
										<div class="col-sm-12">
											<p class="mb-1">Are you a politically exposed person (PEP). e.g.: Senior Military, government, political officials or relatives or associates of such officials</p>
											<div class="form-check form-check-inline">
												<input class="form-check-input" type="radio" name="politically_exposed_person" id="politically_exposed_person_yes" value="Yes" <?php checked( $getKycData->politically_exposed_person, 'Yes', true ); ?>/>
												<label class="form-check-label pt-0" for="politically_exposed_person_yes">Yes</label>
											</div>
											<div class="form-check form-check-inline">
												<input class="form-check-input" type="radio" name="politically_exposed_person" id="politically_exposed_person_no" value="No" <?php checked( $getKycData->politically_exposed_person, 'No', true ); ?>/>
												<label class="form-check-label pt-0" for="politically_exposed_person_no">No</label>
											</div>
										</div>
									</div>
									<div class="form-group row">
										<div class="col-sm-12">
											<p class="mb-1">I consent to my data being shared with all companies in the Corsair Group</p>
											<div class="form-check form-check-inline">
												<input class="form-check-input" type="radio" name="consent_my_data_share" id="consent_my_data_share_yes" value="Yes" <?php checked( $getKycData->consent_my_data_share, 'Yes', true ); ?>/>
												<label class="form-check-label pt-0" for="consent_my_data_share_yes">Yes</label>
											</div>
											<div class="form-check form-check-inline">
												<input class="form-check-input" type="radio" name="consent_my_data_share" id="consent_my_data_share_no" value="No" <?php checked( $getKycData->consent_my_data_share, 'No', true ); ?>/>
												<label class="form-check-label pt-0" for="consent_my_data_share_no">No</label>
											</div>
										</div>
									</div>
									<div class="form-group row">
										<div class="col-sm-12">
											<p class="mb-1">I confirm the information submitted in this form is complete and correct</p>
											<div class="form-check form-check-inline">
												<input class="form-check-input" type="radio" name="confirm_correct_info" id="confirm_correct_info_yes" value="Yes" <?php checked( $getKycData->confirm_correct_info, 'Yes', true ); ?>/>
												<label class="form-check-label pt-0" for="confirm_correct_info_yes">Yes</label>
											</div>
											<div class="form-check form-check-inline">
												<input class="form-check-input" type="radio" name="confirm_correct_info" id="confirm_correct_info_no" value="No" <?php checked( $getKycData->confirm_correct_info, 'No', true ); ?>/>
												<label class="form-check-label pt-0" for="confirm_correct_info_no">No</label>
											</div>
										</div>
									</div>
								</div>
								<input type="button" name="next" class="next action-button" value="Submit" /> <input type="button" name="previous" class="previous action-button-previous" value="Previous" />
							</fieldset>
							<input type="hidden" name="action" value="cipMemberKycSubmitAct" />
							<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPMemberSUbmitKycCIP_'); ?>" />
							<div class="responseSection"></div>
						</form>
					</div>
				</div>
			</div>
		</div>
		<?php
		}
		?>
		<?php
		}
	?>
	<?php
	}
	$html .= ob_get_clean();
	return $html;
}
//5690 code
add_shortcode( 'PENDING-REVIEW-KYC-LIST', 'cip_pending_review_kyc_list_callback' );
function cip_pending_review_kyc_list_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'magnify' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('magnify');

	wp_enqueue_style( 'daterangepicker-style' );
	wp_enqueue_script('dr-moment');
	wp_enqueue_script('daterangepicker-script');
	
	ob_start();
	global $wpdb;
	$tableKyc = $wpdb->prefix.'kyc_data';
	if( isset( $_GET['view'] ) && !empty( $_GET['view'] ) ){
		$decrypted_id_raw = base64_decode( $_GET['view'] );
		$id = preg_replace(sprintf('/%s/', md5('CIP_kyc_CIP') ), '', $decrypted_id_raw);
		$getKycData = $wpdb->get_row("SELECT * FROM $tableKyc WHERE 1 AND `id` = $id AND ( `status` <> '' AND `status` IS NOT NULL )");
		$reject_steps = array();
		$approve_steps = array();
		if( $getKycData ){
			$userData = get_user_by('email', $getKycData->email);
			$user_id = 0;
			if( $userData ){
				$user_id = $userData->ID;
			}
			$reject_steps = explode( ',', $getKycData->reject_steps );
			$approve_steps = explode( ',', $getKycData->approve_steps );
			$totalProceedStep = 0;
			if( in_array( 1, $reject_steps ) || in_array( 1, $approve_steps ) ){
				$totalProceedStep++;
			}
			if( in_array( 2, $reject_steps ) || in_array( 2, $approve_steps ) ){
				$totalProceedStep++;
			}
			if( in_array( 3, $reject_steps ) || in_array( 3, $approve_steps ) ){
				$totalProceedStep++;
			}
			if( in_array( 4, $reject_steps ) || in_array( 4, $approve_steps ) ){
				$totalProceedStep++;
			}
		?>
		<div class="container-fluid">
			<div class="row justify-content-left">
				<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 p-0 mt-2 mb-2">
					<div class="card shadow p-3 mb-5 bg-white rounded memberKycFrm kycReviewSection">
						<div class="row">
							<div class="col-3 kyc-update-left-panel">
								<div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
									<a class="nav-link active" id="v-pills-personal-information-tab" data-toggle="pill" href="#v-pills-personal-information" role="tab" aria-controls="v-pills-personal-information" aria-selected="true"><?php echo getKycStepsName( 1 ); ?>
										<?php if( in_array( 1, $reject_steps ) ){ ?> <span class="fas fa-times-circle float-right mt-1"></span> <?php } ?>
										<?php if( in_array( 1, $approve_steps ) ){ ?> <span class="fas fa-check-circle float-right mt-1"></span> <?php } ?>
									</a>
									<a class="nav-link" id="v-pills-identification-document-tab" data-toggle="pill" href="#v-pills-identification-document" role="tab" aria-controls="v-pills-identification-document" aria-selected="false"><?php echo getKycStepsName( 2 ); ?>
										<?php if( in_array( 2, $reject_steps ) ){ ?> <span class="fas fa-times-circle float-right mt-1"></span> <?php } ?>
										<?php if( in_array( 2, $approve_steps ) ){ ?> <span class="fas fa-check-circle float-right mt-1"></span> <?php } ?>
									</a>
									<a class="nav-link" id="v-pills-proof-of-address-tab" data-toggle="pill" href="#v-pills-proof-of-address" role="tab" aria-controls="v-pills-proof-of-address" aria-selected="false"><?php echo getKycStepsName( 3 ); ?>
										<?php if( in_array( 3, $reject_steps ) ){ ?> <span class="fas fa-times-circle float-right mt-1"></span> <?php } ?>
										<?php if( in_array( 3, $approve_steps ) ){ ?> <span class="fas fa-check-circle float-right mt-1"></span> <?php } ?>
									</a>
									<a class="nav-link" id="v-pills-confirmation-tab" data-toggle="pill" href="#v-pills-confirmation" role="tab" aria-controls="v-pills-confirmation" aria-selected="false"><?php echo getKycStepsName( 4 ); ?>
										<?php if( in_array( 4, $reject_steps ) ){ ?> <span class="fas fa-times-circle float-right mt-1"></span> <?php } ?>
										<?php if( in_array( 4, $approve_steps ) ){ ?> <span class="fas fa-check-circle float-right mt-1"></span> <?php } ?>		
									</a>
								</div>
								<hr/>
								<br/>
								<?php if( ( in_array( 1, $approve_steps ) && in_array( 2, $approve_steps ) && in_array( 3, $approve_steps ) && in_array( 4, $approve_steps ) ) && $getKycData->status != 'approved' ){ ?>
									<button type="button" id="approvedKycPopup" class="btn w-100 text-left mb-3" data-toggle="modal" data-target="#approvedKycModal"><?php _e('Approve KYC', CIP_TXTDOMAIN); ?></button>
								<?php } ?>
								<?php if( $totalProceedStep == 4 ){ ?>
									<button type="button" id="rejectWholeKycPopup" class="btn w-100 text-left mb-3" data-toggle="modal" data-target="#rejectWholeKycModal"><?php _e('Reject KYC', CIP_TXTDOMAIN); ?></button>
								<?php } ?>
								<?php if( $getKycData->status == 'approved' ){ ?>
									<button type="button" id="dropKycPopup" class="btn w-100 text-left mb-3" data-toggle="modal" data-target="#dropKycModal"><?php _e('Drop KYC', CIP_TXTDOMAIN); ?></button>
								<?php }else{
									$dropTooltip = "";
									if( $getKycData->status == 'reject' ){
										$dropTooltip = sprintf( __('You cannot drop a rejected KYC') );
									}else if( $getKycData->status == 'pending' ){
										$dropTooltip = sprintf( __('You cannot drop a pending KYC') );
									}
									?>
									<button type="button" class="btn w-100 text-left mb-3" data-toggle="tooltip" data-placement="top" title="<?php echo $dropTooltip; ?>" <?php if( $getKycData->status == 'dropped' ){ echo 'disabled'; } ?>><?php _e('Drop KYC', CIP_TXTDOMAIN); ?></button>
								<?php } ?>
								<?php /*<button type="button" id="rejectWholeKycPopup" class="btn w-100 text-left mb-3" data-toggle="modal" data-target="#rejectWholeKycModal"><?php _e('Reject KYC', CIP_TXTDOMAIN); ?></button>*/ ?>
								<?php //if( $getKycData->status == 'pending' ){ ?>
								<?php /*<button type="button" id="approvedKycPopup" class="btn w-100 text-left mb-3" data-toggle="modal" data-target="#approvedKycModal"><?php _e('Approve KYC', CIP_TXTDOMAIN); ?></button>*/ ?>
								<?php //} ?>
								<button type="button" class="btn w-100 text-left mb-3" onclick="window.location.href='<?php echo get_the_permalink( get_page_by_path('kyc-verification') ); ?>'"><?php _e('Back to KYC List', CIP_TXTDOMAIN); ?></button>
							</div>
							<div class="col-9">
								<div class="tab-content" id="v-pills-tabContent">
									<div class="tab-pane fade show active" id="v-pills-personal-information" role="tabpanel" aria-labelledby="v-pills-personal-information-tab">
										<?php if( /* ($getKycData->status == 'pending' || $getKycData->status == 'reject' || $getKycData->status == 'dropped') && */ !in_array( 1, $reject_steps ) ){ ?>
											<button type="button" class="rejectKycPopup btn text-left mb-3" data-step="1"><?php _e('Reject', CIP_TXTDOMAIN); ?></button>
										<?php } ?>
										<?php if( ($getKycData->status == 'pending' || $getKycData->status == 'reject' || $getKycData->status == 'dropped') && !in_array( 1, $approve_steps ) ){ ?>
											<button type="button" class="approveKycStepPopup btn text-left mb-3" data-step="1" data-stepName="<?php echo getKycStepsName( 1 ); ?>" ><?php _e('Approve', CIP_TXTDOMAIN); ?></button>
										<?php } ?>
										<!-- step 1 -->
										<div class="form-group row">
											<div class="col-sm-4">
												<label for="firstname">First Name *</label>
												<p class="form-control mb-0"><?php echo $getKycData->firstname; ?></p>
											</div>
											<div class="col-sm-4">
												<label for="lastname">Last Name *</label>
												<p class="form-control mb-0" ><?php echo $getKycData->lastname; ?></p>
											</div>
											<div class="col-sm-4">
												<label for="dob">Date Of Birth *</label>
												<p class="form-control mb-0"><?php echo $getKycData->dob; ?></p>
											</div>
										</div>
										
										<div class="form-group row">
											<div class="col-sm-12">
												<label for="postal_address">Address *</label>
												<p class="form-control mb-0" ><?php echo $getKycData->address; ?></p>	
											</div>
											<div class="col-sm-12">
												<label for="street_address">Address line 2</label>
												<p class="form-control mb-0" ><?php echo $getKycData->street_address; ?></p>
											</div>
											<div class="col-sm-6">
												<label for="city"><?php _e('City *', CIP_TXTDOMAIN); ?></label>
												<p class="form-control mb-0" ><?php echo $getKycData->city; ?></p>
											</div>
											<div class="col-sm-6">
												<label for="state"><?php _e('State / Province *', CIP_TXTDOMAIN); ?></label>
												<p class="form-control mb-0"><?php echo $getKycData->state; ?></p>
											</div>
											
											<div class="col-sm-6">
												<label for="postal_code"><?php _e('ZIP / Postal Code', CIP_TXTDOMAIN); ?></label>
												<p class="form-control mb-0"><?php echo $getKycData->postal_code; ?></p>
											</div>
											<div class="col-sm-6">
												<label for="country"><?php _e('Country *', CIP_TXTDOMAIN); ?></label>
												<p class="form-control mb-0"><?php echo getCountriesDropDown( $getKycData->country, true ); ?></p>
											</div>
										</div>
									</div>
									<div class="tab-pane fade" id="v-pills-identification-document" role="tabpanel" aria-labelledby="v-pills-identification-document-tab">
										<?php if( /* ($getKycData->status == 'pending' || $getKycData->status == 'reject' || $getKycData->status == 'dropped') && */ !in_array( 2, $reject_steps ) ){ ?>
											<button type="button" class="rejectKycPopup btn text-left mb-3" data-step="2"><?php _e('Reject', CIP_TXTDOMAIN); ?></button>
										<?php } ?>
										<?php if( ($getKycData->status == 'pending' || $getKycData->status == 'reject' || $getKycData->status == 'dropped') && !in_array( 2, $approve_steps ) ){ ?>
											<button type="button" class="approveKycStepPopup btn text-left mb-3" data-step="2" data-stepName="<?php echo getKycStepsName( 2 ); ?>" ><?php _e('Approve', CIP_TXTDOMAIN); ?></button>
										<?php } ?>
										<!-- step 2 -->	
										
										<div class="form-group row">
											<div class="col-sm-6">
												<label for="document_type">Document Type *</label>
												<p class="form-control mb-0"><?php echo $getKycData->document_type; ?></p>
												
												<label for="document_number">Document Number *</label>
												<p class="form-control mb-0"><?php echo $getKycData->document_number; ?></p>
												<label for="issuing_country">Issuing Country *</label>
												<p class="form-control mb-0"><?php echo getCountriesDropDown( $getKycData->issuing_country, true ); ?></p>
												
												<label for="issue_date">Issue Date *</label>
												<p class="form-control mb-0" ><?php echo $getKycData->issue_date; ?></p>
												<div class="form-check">
													<input type="checkbox" class="form-check-input" value="1" <?php checked( $getKycData->id_no_have_issue_date, '1', true ); ?> readonly style=" pointer-events: none; " />
													<label class="form-check-label pt-0">My document does not have issue date.</label>
												</div>
												
												<label for="expiration_date">Expiration Date *</label>
												<p class="form-control mb-0" ><?php echo $getKycData->expiration_date; ?></p>
												
												<div class="form-check">
													<input type="checkbox" class="form-check-input" value="1" <?php checked( $getKycData->id_no_have_expiry, '1', true ); ?> readonly style=" pointer-events: none; " />
													<label class="form-check-label pt-0">My document does not have expiration date.</label>
												</div>
												
												<label for="nationality">Nationality *</label>
												<p class="form-control mb-0"><?php echo getCountriesDropDown( $getKycData->nationality, true ); ?></p>
											</div>
											<div class="col-sm-6">
												<div class="col-sm-12">
													<label for="identification_document">Upload document *</label>
												</div>
												<div class="d-flex align-items-center doc-grid_section">
													<?php
													$uploadDir = CIP_PLUGIN_BASE . 'uploaded_doc/'.$user_id;
													$ViewDir = CIP_PLUGIN_FOLDER . 'uploaded_doc/'.$user_id;
													if( !empty( $getKycData->identification_document_1 ) && file_exists( $uploadDir.'/'.$getKycData->identification_document_1 ) ){
														$fileType = strtolower( pathinfo($getKycData->identification_document_1, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->identification_document_1;
														}
														$magnify = ( $fileType != 'pdf' ) ? 'data-magnify="gallery" data-magnify-initmaximized="true"' : '';
														$magnifySrc = ( $fileType != 'pdf' ) ? 'data-src="'.$imgSrc.'"' : '';
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->identification_document_1.'" data-elementor-open-lightbox="no" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" '.$magnify.' '.$magnifySrc.' /> </a></div>';
													}
													if( !empty( $getKycData->identification_document_2 ) && file_exists( $uploadDir.'/'.$getKycData->identification_document_2 ) ){
														$fileType = strtolower( pathinfo($getKycData->identification_document_2, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->identification_document_2;
														}
														
														$magnify = ( $fileType != 'pdf' ) ? 'data-magnify="gallery" data-magnify-initmaximized="true"' : '';
														$magnifySrc = ( $fileType != 'pdf' ) ? 'data-src="'.$imgSrc.'"' : '';
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->identification_document_2.'" data-elementor-open-lightbox="no" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" '.$magnify.' '.$magnifySrc.' /> </a></div>';
													}
													if( !empty( $getKycData->identification_document_3 ) && file_exists( $uploadDir.'/'.$getKycData->identification_document_3 ) ){
														$fileType = strtolower( pathinfo($getKycData->identification_document_3, PATHINFO_EXTENSION) );
														if( $fileType == 'pdf' ){
															$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
														}else{
															$imgSrc = $ViewDir.'/'.$getKycData->identification_document_3;
														}
														
														$magnify = ( $fileType != 'pdf' ) ? 'data-magnify="gallery" data-magnify-initmaximized="true"' : '';
														$magnifySrc = ( $fileType != 'pdf' ) ? 'data-src="'.$imgSrc.'"' : '';
														echo '<div><a href="'.$ViewDir.'/'.$getKycData->identification_document_3.'" data-elementor-open-lightbox="no" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" '.$magnify.' '.$magnifySrc.' /> </a></div>';
													}
													?>
												</div>
											</div>
										</div>	
																			
									</div>
									<div class="tab-pane fade" id="v-pills-proof-of-address" role="tabpanel" aria-labelledby="v-pills-proof-of-address-tab">
										<?php if( /* ($getKycData->status == 'pending' || $getKycData->status == 'reject' || $getKycData->status == 'dropped') && */ !in_array( 3, $reject_steps ) ){ ?>
											<button type="button" class="rejectKycPopup btn text-left mb-3" data-step="3"><?php _e('Reject', CIP_TXTDOMAIN); ?></button>
										<?php } ?>
										<?php if( ($getKycData->status == 'pending' || $getKycData->status == 'reject' || $getKycData->status == 'dropped') && !in_array( 3, $approve_steps ) ){ ?>
											<button type="button" class="approveKycStepPopup btn text-left mb-3" data-step="3" data-stepName="<?php echo getKycStepsName( 3 ); ?>" ><?php _e('Approve', CIP_TXTDOMAIN); ?></button>
										<?php } ?>
										<!-- step 4 -->	
										<div class="form-group row">
											<div class="col-sm-6">
												<label for="document_proof">Document Type *</label>
												<p class="form-control mb-0"><?php echo $getKycData->document_proof; ?></p>
												<label for="document_date">Document Date *</label>
												<p class="form-control mb-0" ><?php echo $getKycData->document_date; ?></p>
											</div>
											<div class="col-sm-6">
												<div class="col-sm-12">
													<label for="identification_document">Upload proof of Address *</label>
												</div>
												<div class="d-flex align-items-center doc-grid_section">
												<?php
												$uploadDir = CIP_PLUGIN_BASE . 'uploaded_doc/'.$user_id;
												$ViewDir = CIP_PLUGIN_FOLDER . 'uploaded_doc/'.$user_id;
												if( !empty( $getKycData->proof_document_1 ) && file_exists( $uploadDir.'/'.$getKycData->proof_document_1 ) ){
													$fileType = strtolower( pathinfo($getKycData->proof_document_1, PATHINFO_EXTENSION) );
													if( $fileType == 'pdf' ){
														$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
													}else{
														$imgSrc = $ViewDir.'/'.$getKycData->proof_document_1;
													}
													$magnify = ( $fileType != 'pdf' ) ? 'data-magnify="gallery" data-magnify-initmaximized="true"' : '';
													$magnifySrc = ( $fileType != 'pdf' ) ? 'data-src="'.$imgSrc.'"' : '';
													echo '<div><a href="'.$ViewDir.'/'.$getKycData->proof_document_1.'" data-elementor-open-lightbox="no" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" '.$magnify.' '.$magnifySrc.' /> </a></div>';
												}
												if( !empty( $getKycData->proof_document_2 ) && file_exists( $uploadDir.'/'.$getKycData->proof_document_2 ) ){
													$fileType = strtolower( pathinfo($getKycData->proof_document_2, PATHINFO_EXTENSION) );
													if( $fileType == 'pdf' ){
														$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
													}else{
														$imgSrc = $ViewDir.'/'.$getKycData->proof_document_2;
													}
													
													$magnify = ( $fileType != 'pdf' ) ? 'data-magnify="gallery" data-magnify-initmaximized="true"' : '';
													$magnifySrc = ( $fileType != 'pdf' ) ? 'data-src="'.$imgSrc.'"' : '';
													echo '<div><a href="'.$ViewDir.'/'.$getKycData->proof_document_2.'" data-elementor-open-lightbox="no" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" '.$magnify.' '.$magnifySrc.' /> </a></div>';
												}
												if( !empty( $getKycData->proof_document_3 ) && file_exists( $uploadDir.'/'.$getKycData->proof_document_3 ) ){
													$fileType = strtolower( pathinfo($getKycData->proof_document_3, PATHINFO_EXTENSION) );
													if( $fileType == 'pdf' ){
														$imgSrc = CIP_PLUGIN_FOLDER .'/images/pdf.png';
													}else{
														$imgSrc = $ViewDir.'/'.$getKycData->proof_document_3;
													}
													
													$magnify = ( $fileType != 'pdf' ) ? 'data-magnify="gallery" data-magnify-initmaximized="true"' : '';
													$magnifySrc = ( $fileType != 'pdf' ) ? 'data-src="'.$imgSrc.'"' : '';
													echo '<div><a href="'.$ViewDir.'/'.$getKycData->proof_document_3.'" data-elementor-open-lightbox="no" target="_blank"> <img class="doc-img-thumbnail" src="'.$imgSrc.'" '.$magnify.' '.$magnifySrc.' /> </a></div>';
												}
												?>
												</div>
											</div>
										</div>
									</div>
									<div class="tab-pane fade" id="v-pills-confirmation" role="tabpanel" aria-labelledby="v-pills-confirmation-tab">
										<?php if( !in_array( 4, $reject_steps ) ){ ?>
											<button type="button" class="rejectKycPopup btn text-left mb-3" data-step="4"><?php _e('Reject', CIP_TXTDOMAIN); ?></button>
										<?php } ?>
										<?php if( ($getKycData->status == 'pending' || $getKycData->status == 'reject' || $getKycData->status == 'dropped') && !in_array( 4, $approve_steps ) ){ ?>
											<button type="button" class="approveKycStepPopup btn text-left mb-3" data-step="4" data-stepName="<?php echo getKycStepsName( 4 ); ?>" ><?php _e('Approve', CIP_TXTDOMAIN); ?></button>
										<?php } ?>
										<!-- step 5 -->
										<div class="form-group row">
											<div class="col-sm-12">
												<p class="mb-1">Are you a politically exposed person (PEP). e.g.: Senior Military, government, political officials or relatives or associates of such officials</p>
												<div class="form-check form-check-inline">
													<p class="form-check-input"><?php echo $getKycData->politically_exposed_person; ?></p>
												</div>
											</div>
										</div>
										<div class="form-group row">
											<div class="col-sm-12">
												<p class="mb-1">I consent to my data being shared with all companies in the Corsair Group</p>
												<div class="form-check form-check-inline">
													<p class="form-check-input"><?php echo $getKycData->consent_my_data_share; ?></p>
												</div>
											</div>
										</div>
										<div class="form-group row">
											<div class="col-sm-12">
												<p class="mb-1">I confirm the information submitted in this form is complete and correct</p>
												<div class="form-check form-check-inline">
													<p class="form-check-input" ><?php echo $getKycData->confirm_correct_info; ?></p>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="modal fade" id="dropKycModal" tabindex="-1" role="dialog">
			<div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-body">
						<form class="dropKycModalFrm" id="dropKycModalFrm" name="dropKycModalFrm">
							<div class="row">
								<div class="col-sm-12">
									<div class="form-group">
										<label for="drop_message">Message</label>
										<textarea class="form-control" id="drop_message" name="drop_message" required></textarea>
									</div>
									<div class="form-check-inline">
										<label class="form-check-label pt-0"><input type="checkbox" name="dropSteps[]" class="form-check-input" value="1"><?php echo getKycStepsName(1); ?></label>
									</div>
									<div class="form-check-inline">
										<label class="form-check-label pt-0"><input type="checkbox" name="dropSteps[]" class="form-check-input" value="2"><?php echo getKycStepsName(2); ?></label>
									</div>
									<div class="form-check-inline">
										<label class="form-check-label pt-0"><input type="checkbox" name="dropSteps[]" class="form-check-input" value="3"><?php echo getKycStepsName(3); ?></label>
									</div>
									<div class="form-check-inline">
										<label class="form-check-label pt-0"><input type="checkbox" name="dropSteps[]" class="form-check-input" value="4"><?php echo getKycStepsName(4); ?></label>
									</div>
								</div>
							</div>
							<br/>
							<button type="submit" class="btn btn-secondary"><?php _e('Submit', CIP_TXTDOMAIN); ?></button>
							<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
							<input type="hidden" name="action" value="drop_kyc_verification_act" />
							<input type="hidden" name="pageid" value="<?php echo get_the_id(); ?>" />
							<input type="hidden" name="_microid" value="<?php echo $_GET['view']; ?>" />
							<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_YxCIPDropKycCIPXy_'); ?>" />
							<p><span class="form_response"></span></p>
						</form>
					</div>
				</div>
			</div>
		</div>
		
		<?php if( $totalProceedStep == 4 ){ ?>
		<div class="modal fade" id="rejectWholeKycModal" tabindex="-1" role="dialog">
			<div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-body">
						<form class="rejectWholeKycModalFrm" id="rejectWholeKycModalFrm" name="rejectWholeKycModalFrm">
							<div class="row">
								<div class="col-sm-12">
									<h5><?php _e('You are Rejecting the KYC', CIP_TXTDOMAIN); ?></h5>
								</div>
								<div class="col-sm-12">
									<div class="form-group">
										<label for="rejection_message">Message</label>
										<textarea class="form-control" id="rejection_message" name="rejection_message" required></textarea>
									</div>
									<div class="form-check-inline">
										<label class="form-check-label pt-0"><input type="checkbox" name="dropSteps[]" class="form-check-input" value="1"><?php echo getKycStepsName(1); ?></label>
									</div>
									<div class="form-check-inline">
										<label class="form-check-label pt-0"><input type="checkbox" name="dropSteps[]" class="form-check-input" value="2"><?php echo getKycStepsName(2); ?></label>
									</div>
									<div class="form-check-inline">
										<label class="form-check-label pt-0"><input type="checkbox" name="dropSteps[]" class="form-check-input" value="3"><?php echo getKycStepsName(3); ?></label>
									</div>
									<div class="form-check-inline">
										<label class="form-check-label pt-0"><input type="checkbox" name="dropSteps[]" class="form-check-input" value="4"><?php echo getKycStepsName(4); ?></label>
									</div>
								</div>
							</div>
							<br/>
							<button type="submit" class="btn btn-secondary"><?php _e('Reject', CIP_TXTDOMAIN); ?></button>
							<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
							<input type="hidden" name="action" value="reject_whole_kyc_verification_act" />
							<input type="hidden" name="pageid" value="<?php echo get_the_id(); ?>" />
							<input type="hidden" name="_microid" value="<?php echo $_GET['view']; ?>" />
							<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_YxCIPRejectWholeKycCIPXy_'); ?>" />
							<p><span class="form_response"></span></p>
						</form>
					</div>
				</div>
			</div>
		</div>
		<?php } ?>
		<?php if( $getKycData->status == 'pending' || $getKycData->status == 'reject' || $getKycData->status == 'dropped' || $getKycData->status == 'approved' ){ ?>
		<div class="modal fade" id="rejectKycModal" tabindex="-1" role="dialog">
			<div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-body">
						<form class="rejectKycModalFrm" id="rejectKycModalFrm" name="rejectKycModalFrm">
							<div class="row">
								<div class="col-sm-12">
									<div class="form-group">
										<label for="drop_message"><?php _e('Rejection Reason', CIP_TXTDOMAIN ); ?></label>
										<textarea class="form-control" id="rejection_reason" name="rejection_reason" required></textarea>
									</div>
								</div>
							</div>
							<button type="submit" class="btn btn-secondary"><?php _e('Submit', CIP_TXTDOMAIN); ?></button>
							<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
							<input type="hidden" name="action" value="reject_kyc_verification_act" />
							<input type="hidden" name="pageid" value="<?php echo get_the_id(); ?>" />
							<input type="hidden" name="_microid" value="<?php echo $_GET['view']; ?>" />
							<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_YxCIPRejectionKycCIPXy_'); ?>" />
							<p><span class="form_response"></span></p>
						</form>
					</div>
				</div>
			</div>
		</div>
		<?php } ?>
		<?php if( $getKycData->status == 'pending' || $getKycData->status == 'reject' || $getKycData->status == 'dropped' ){ ?>
		<div class="modal fade" id="approveKycStepModal" tabindex="-1" role="dialog">
			<div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-body">
						<form class="approveKycStepModalFrm text-center" id="approveKycStepModalFrm" name="approveKycStepModalFrm">
							<div class="row">
								<div class="col-sm-12">
									<h5>Are you sure want to approve this <span class="stepNameModal">X</span> KYC details.?</h5>
								</div>
							</div>
							<br/>
							<button type="submit" class="btn btn-secondary"><?php _e('Approved', CIP_TXTDOMAIN); ?></button>
							<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
							<input type="hidden" name="action" value="approvedStepKycact" />
							<input type="hidden" name="pageid" value="<?php echo get_the_id(); ?>" />
							<input type="hidden" name="_microid" value="<?php echo $_GET['view']; ?>" />
							<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_YxCIPApproveStepKycCIPXy_'); ?>" />
							<p><span class="form_response"></span></p>
						</form>
					</div>
				</div>
			</div>
		</div>
		<?php } ?>
		<?php if( in_array( 1, $approve_steps ) && in_array( 2, $approve_steps ) && in_array( 3, $approve_steps ) && in_array( 4, $approve_steps ) ){ ?>
		<div class="modal fade" id="approvedKycModal" tabindex="-1" role="dialog">
			<div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-body">
						<form class="approvedKycModalFrm text-center" id="approvedKycModalFrm" name="approvedKycModalFrm">
							<div class="row">
								<div class="col-sm-12">
									<h5><?php _e('You are approving the KYC', CIP_TXTDOMAIN); ?></h5>
								</div>
							</div>
							<br/>
							<button type="submit" class="btn btn-secondary"><?php _e('Approve', CIP_TXTDOMAIN); ?></button>
							<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
							<input type="hidden" name="action" value="approved_kyc_verification_act" />
							<input type="hidden" name="pageid" value="<?php echo get_the_id(); ?>" />
							<input type="hidden" name="_microid" value="<?php echo $_GET['view']; ?>" />
							<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_YxCIPApprovedKycCIPXy_'); ?>" />
							<p><span class="form_response"></span></p>
						</form>
					</div>
				</div>
			</div>
		</div>
		<?php } ?>
		<form name="tabMoveFrm" id="tabMoveFrm" method="post">
			<input type="hidden" name="tabMoveIndex" id="tabMoveIndex" value="" />
		</form>
		<?php if( isset( $_POST['tabMoveIndex'] ) && ( $_POST['tabMoveIndex'] > 0 && $_POST['tabMoveIndex'] < 5 ) ){ ?>
		<script>
			jQuery(document).ready(function($){
				var tabMoveIndex = "<?php echo $_POST['tabMoveIndex']; ?>";
				if( tabMoveIndex == 2 ){
					$('.nav-pills a[href="#v-pills-identification-document"]').tab('show');
				}else if( tabMoveIndex == 3 ){
					$('.nav-pills a[href="#v-pills-proof-of-address"]').tab('show');
				}else if( tabMoveIndex == 4 ){
					$('.nav-pills a[href="#v-pills-confirmation"]').tab('show');
				}
			});
		</script>
		<?php } ?>
		<?php
		}else{
			
		}
	}else{
	?>
	<table id="csr_kyc_pending_review" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
	<thead>
		<tr>
			<th data-field="id" class="id" data-switchable="false"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
			<th data-field="email" data-sortable="true" data-filter-control="input" class="email" data-switchable="false"><?php _e('Email',CIP_TXTDOMAIN); ?></th>
			<th data-field="firstname" data-sortable="true" data-filter-control="input" class="firstname" data-switchable="false"><?php _e('First Name',CIP_TXTDOMAIN); ?></th>
			<th data-field="lastname" data-sortable="true" data-filter-control="input" class="lastname" data-switchable="false"><?php _e('Last Name',CIP_TXTDOMAIN); ?></th>
			<th data-field="dob" class="dob" data-sortable="true" data-filter-control="input"  data-switchable="false"><?php _e('Date of Birth',CIP_TXTDOMAIN); ?></th>
			<th data-field="_date" class="_date" data-sortable="true" data-filter-control="input" data-switchable="false"><?php _e('Submission Date',CIP_TXTDOMAIN); ?></th>
			<th data-field="lastupdate" class="lastupdate" data-sortable="true" data-filter-control="input" data-switchable="false"><?php _e('Last Update Date',CIP_TXTDOMAIN); ?></th>
			<th data-field="status" data-filter-control="select" class="status" data-filter-custom-search="BsTableFilterStatus" data-filter-data="var:filterKycKybStatus" class="status" data-switchable="false"><?php _e('Status',CIP_TXTDOMAIN); ?></th>
			<th data-field="action" class="action"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
		</tr>
	</thead>
	<tbody>
	</tbody>
	</table>
	<?php
	}
	$html .= ob_get_clean();
	return $html;
}
//5753 card
add_shortcode('MY-CSR-SUMMARY-TABLE', 'my_csr_summary_table_callback');
function my_csr_summary_table_callback(){
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	wp_enqueue_script( 'tippy.popperjs' );
	wp_enqueue_script( 'tippy' );
	$html = "";
	ob_start();
	global $wpdb;
	$tableTokenHolder = $wpdb->prefix.'token_holder';
	$tableKycData = $wpdb->prefix.'kyc_data';
	$current_user = wp_get_current_user();
	$user_id = $current_user->ID;
	$withdrawal_suspension = get_user_meta( $user_id, 'withdrawal_suspension_5_minute', true );
	$withdrawal_suspension = ( $withdrawal_suspension == 'disable' ) ? 'disable' : 'enable';

	$refAccount = ( isset( $_SESSION['refAccount'] ) ) ? $_SESSION['refAccount'] : '-';
	// $getCurrentMembers = $wpdb->get_results("SELECT * FROM $tableTokenHolder WHERE `email` = '".$refAccount."' AND `email` IS NOT NULL AND `email` != ''");
	$whereEmail = "`email` = '".$refAccount."' AND `email` IS NOT NULL AND `email` != ''";
	$whereTokenCSR = "AND `token` = 'CSR'";
	$whereTokenCSR25 = "AND `token` = 'CSR25'";
	// $csr_balance = get_user_csr_balance( $user_id );
	$csr_balance = get_user_csr_balance( $refAccount, 'available', 'csr' );
	$csr_balance_total = get_user_csr_balance( $refAccount, 'total', 'csr' );

	$csr25_balance = get_user_csr_balance( $refAccount, 'available', 'csr25' );
	$csr25_balance_total = get_user_csr_balance( $refAccount, 'total', 'csr25' );
	// $csr_balance_total = get_user_csr_balance( $user_id, 'total' );

	$minimum_withdrawal_amount = ( !empty( get_option('minimum_withdrawal_amount') ) ) ? get_option('minimum_withdrawal_amount') : 0;

	$withdraw_tooltip = "";
	$withdrawal_disable = false;

	if( $csr_balance < $minimum_withdrawal_amount && $csr25_balance < $minimum_withdrawal_amount ){
		$withdrawal_disable = true;
		$withdraw_tooltip .= sprintf( __('CSR/CSR25 Balance below minimum withdrawal amount of %s.<br/>', CIP_TXTDOMAIN), $minimum_withdrawal_amount );
	}

	$checkKycStatus = $wpdb->get_row("SELECT COUNT(*) as `kyc_status_count` FROM $tableKycData WHERE $whereEmail AND `status`='approved'");
	if( $checkKycStatus->kyc_status_count <= 0 ){
		$withdrawal_disable = true;
		$withdraw_tooltip .=  __('You must complete the KYC process to request a withdrawal.<br/>', CIP_TXTDOMAIN);
	}

	$corsair_2fa_ga = get_option( 'corsair_2fa_ga' );
	$google_auth_key = get_user_meta( $user_id, 'google_auth_key', true );
	$google_auth_key_withdrawal = get_user_meta( $user_id, 'google_auth_key_withdrawal', true );
	$ga2fa_login_enabled = ( !empty( $google_auth_key ) && $google_auth_key_withdrawal == 1 ) ? 1 : 0;

	if( $corsair_2fa_ga != 'yes' || $ga2fa_login_enabled != 1 ){
		$withdrawal_disable = true;
		$withdraw_tooltip .= __('Please enable Google Authenticator 2FA in your Profile to complete this task.<br/>', CIP_TXTDOMAIN);
	}
	$isWithdrawalSuspend = get_user_meta( $user_id, 'csrnow_withdrawal_suspend', true );
	if( $isWithdrawalSuspend == '1' ){
		$withdrawal_disable = true;
		$withdraw_tooltip .= __('Withdrawals are presently suspended on this account. Please contact support.<br/>', CIP_TXTDOMAIN);
	}
	$tooltipShowTimer = false;
	if( $withdrawal_suspension == 'enable' ){
		if( !empty( $_SESSION['logged_time'] ) && $_SESSION['logged_time'] >= time() ){
			$withdrawal_disable = true;
			$tooltipShowTimer = true;
			// $withdraw_tooltip .= __('For security reasons withdrawals are temporarily suspended.<br/>', CIP_TXTDOMAIN);
		}
	}
	$isSwitch = false;
	if( isset( $_SESSION['isSwitch'] ) && $_SESSION['isSwitch'] == 'Yes' ){
		$isSwitch = true;
	}

	if( current_user_can('member') ){
	//CSR Balance
	$isVisibleCsrSection = false;
	$isVisibleCsr25Section = false;
	?>
	<h5 class="csr_central_title csr_summary_header"><?php _e('CSR Summary', CIP_TXTDOMAIN); ?></h5>
	<div class="table-responsive">
		<table class="table csr_summary csr_summary_table table-borderless">
			<thead>
			<tr>
				<th colspan="7">
						<div class="container-fluid">
							<div class="mob_gridcols" style="display: grid;grid-template-columns: repeat(7, 1fr);column-gap: 99px;justify-content: start;justify-items: start;">

								<div class="table_data">
									<span><?php _e('Token',CIP_TXTDOMAIN); ?></span>
								</div>							

								<div class="table_data">
									<span><?php _e('Total Balance',CIP_TXTDOMAIN); ?></span> <i class="fa fa-info-circle" data-toggle="tooltip" data-placement="top" title="<?php _e('Sum of all CSR holdings', CIP_TXTDOMAIN) ?>"></i>
								</div>

								<div class="table_data">
									<span><?php _e('Pending',CIP_TXTDOMAIN); ?></span>
								</div>

								<div class="table_data">
									<span><?php _e('Issued',CIP_TXTDOMAIN); ?></span>
								</div>

								<div class="table_data">
									<span><?php _e('Delivered',CIP_TXTDOMAIN); ?></span>
								</div>

								<div class="table_data">
									<span><span><?php _e('Withdrawn',CIP_TXTDOMAIN); ?></span> <i class="fa fa-info-circle" data-toggle="tooltip" data-placement="top" title="<?php _e(' CSR withdrawn to blockchain', CIP_TXTDOMAIN) ?>"></i></span>
								</div>		

								<div class="table_data">
									<span><?php _e('Available Balance',CIP_TXTDOMAIN); ?></span>
								</div>	
							</div>
						</div>
					</th>

				</tr>
			</thead>
			<tbody>
				<?php
				$csrBalanceResult = $wpdb->get_row("SELECT
					-- Total main CSR
					( SUM(`amount_due`) + SUM(`csr_amount_issued`) ) AS `total_main_balance`,

					-- Pending CSR total
					SUM(CASE
						WHEN (`corp_approved` = 'Pending' OR `corp_approved` = 'Partially Delivered')
							AND `pool_ref` NOT IN('C', 'F', 'J', 'H')
							AND `pool_ref` NOT LIKE 'SPC%'
						THEN `amount_due`
						ELSE 0
					END) as `csr_pending_total`,

					-- Issued CSR total (SPC-CRSM)
					SUM(CASE
						WHEN `pool_ref` = 'SPC-CRSM'
						THEN `csr_amount_issued`
						ELSE 0
					END) as `csr_issued_total1`,

					-- Issued CSR total (Issued or Partially issued)
					SUM(CASE
						WHEN (`corp_approved` = 'Issued' OR `corp_approved` = 'Partially issued')
						THEN `csr_amount_issued`
						ELSE 0
					END) as `csr_issued_total2`,

					-- Delivered CSR total
					SUM(CASE
						WHEN `corp_approved` = 'Delivered'
						THEN `csr_amount_issued`
						ELSE 0
					END) as `csr_amount_delivered_total`,

					-- Saved CSR total
					SUM(CASE
						WHEN `corp_approved` = 'Saved CSR'
						THEN `csr_amount_issued`
						ELSE 0
					END) as `csr_amount_saved_total`,

					-- Hold/Under Review CSR total (non-awards)
					SUM(CASE
						WHEN `corp_approved` IN('Hold', 'Missing CSR Address', 'Security Hold', 'Under Manual Review', 'Under Review')
							AND `pool_ref` NOT IN('C', 'F', 'J', 'H')
						THEN `amount_due`
						ELSE 0
					END) as `csr_amount_due_total_non_awards`,

					-- Delivered CSR Awards Pending total
					SUM(CASE
						WHEN `corp_approved` = 'Delivered'
							AND `pool_ref` IN ('C', 'F', 'J', 'H')
						THEN `csr_amount_issued`
						ELSE 0
					END) as `csr_amount_awards_delivered_total`,

					-- Hold/Under Review CSR Awards total
					SUM(CASE
						WHEN `corp_approved` IN('Issued', 'Application received', 'Hold', 'Missing CSR Address', 'Security Hold', 'Under Review')
							AND `pool_ref` IN ('C', 'F', 'J', 'H')
						THEN `amount_due`
						ELSE 0
					END) as `csr_amount_due_total_awards`,

					-- Special CSR Pending total
					SUM(CASE
						WHEN `corp_approved` IN('Pending', 'Partially Delivered')
							AND `pool_ref` LIKE 'SPC%'
						THEN `amount_due`
						ELSE 0
					END) as `csr_amount_special_total`,

					-- Special CSR Hold/Under Review total
					SUM(CASE
						WHEN `corp_approved` IN('Under review', 'Hold', 'Security Hold', 'Under Manual Review')
							AND `pool_ref` LIKE 'SPC%'
						THEN `amount_due`
						ELSE 0
					END) as `csr_amount_special_hold_total`

					FROM `$tableTokenHolder`
					WHERE $whereEmail $whereTokenCSR
				");

				$csrPendingTotal = $csrBalanceResult->csr_pending_total;
				$csrIssuedTotal1 = $csrBalanceResult->csr_issued_total1;
				$csrIssuedTotal2 = $csrBalanceResult->csr_issued_total2;
				$csrDeliveredTotal = $csrBalanceResult->csr_amount_delivered_total;
				$csrSavedTotal = $csrBalanceResult->csr_amount_saved_total;
				$csrHoldUReviewNonAwards = $csrBalanceResult->csr_amount_due_total_non_awards;
				$csrDeliveredAwardsTotal = $csrBalanceResult->csr_amount_awards_delivered_total;
				$csrHoldUReviewAwards = $csrBalanceResult->csr_amount_due_total_awards;
				$csrSpecialPendingTotal = $csrBalanceResult->csr_amount_special_total;
				$csrSpecialHoldTotal = $csrBalanceResult->csr_amount_special_hold_total;

				?>

				<?php 
					$tableTransactionHistory = $wpdb->prefix.'csr_delivery_transaction_history';
					$whereStatus = "AND `status`='2'";
					$withdrawalTotalResult = $wpdb->get_row("SELECT SUM(withdrawal_amount) AS total_withdrawal FROM $tableTransactionHistory WHERE $whereEmail $whereTokenCSR $whereStatus");
					$withdrawalTotal = $withdrawalTotalResult->total_withdrawal;

					//CSR Issued
					$issuedAmount = 0;
					if( 0 ){
						$issuedAmount = $csrIssuedTotal1;
					}else{
						$issuedAmount = $csrIssuedTotal2;
					}
					// $totalAmount = ((int)$csrPendingTotal + (int)$issuedAmount + (int)$csrDeliveredTotal);
					$totalAmount = $csrBalanceResult->total_main_balance;  

					$isAmountValid = (int)$totalAmount + (int)$withdrawalTotal + (int)$csr_balance + (int)$csrSavedTotal + (int)$csrHoldUReviewNonAwards + (int)$csrDeliveredAwardsTotal + (int)$csrHoldUReviewAwards + (int)$csrSpecialPendingTotal + (int)$csrSpecialHoldTotal;

					if($isAmountValid > 0)
					{
						$isVisibleCsrSection = true;

				?>

				<tr>
					<td colspan="7">
						<div class="container-fluid">
							<div class="mob_gridcols" style="display: grid;grid-template-columns: repeat(7, 1fr);column-gap: 99px;justify-content: start;justify-items: start;">

								<div class="table_data">
									<p class="curr_title"><?php _e('CSR',CIP_TXTDOMAIN); ?> </p>
								</div>



								<!-- Total Amount -->
								<div class="table_data">
									<span>
									<?php echo sprintf( __('%s', CIP_TXTDOMAIN), number_format( $totalAmount ) ); ?>
									</span>
								</div>

								<?php
								//CSR Pending
								if( $csrPendingTotal ){ ?>
									<div class="table_data"><?php echo number_format( $csrPendingTotal ); ?></div>
								<?php }else{ ?>
									<div class="table_data">0</div>
								<?php } ?>

								<?php
								//CSR Issued
								if( $issuedAmount ){?>
									<div class="table_data"><?php  echo number_format( $issuedAmount ); ?></div>
								<?php }else{ ?>
									<div class="table_data">0</div>
								<?php } ?>

								<?php
								// CSR Delivered
								if( $csrDeliveredTotal ){ ?>
									<div class="table_data"><?php echo number_format( $csrDeliveredTotal ); ?>
									<!-- <span class="fa-fw fa-lg float-right">
										<i class="fa fa-plus-square" onclick="toggleSlide('csr_tabledata')" aria-hidden="true"></i>
									</span> -->
									</div>
								<?php }else{ ?>
									<div class="table_data">0
									<!-- <span class="fa-fw fa-lg float-right">
										<i class="fa fa-plus-square" onclick="toggleSlide('csr_tabledata')" aria-hidden="true"></i>
									</span> -->
									</div>
								<?php } ?>

								

								<!-- Withdrawn -->
								<div class="table_data">
									<div class="d-flex mobile-d-flex justify-content-between">
										<span><?=$withdrawalTotal ? number_format($withdrawalTotal) : '0'?></span>
									</div>
								</div>

								<!-- Available Balance  -->
								<div class="table_data">
									<div class="d-flex mobile-d-flex justify-content-between">
										<span>
										<?php echo sprintf( __('%s', CIP_TXTDOMAIN), number_format( $csr_balance ) ); ?>
										</span>
										<?php if( $csrSavedTotal || $csrHoldUReviewNonAwards || $csrDeliveredAwardsTotal || $csrHoldUReviewAwards || $csrSpecialPendingTotal || $csrSpecialHoldTotal ){ ?>
										<span class="fa-fw fa-lg float-right">
											<i class="fa fa-plus-square js-burger" data-section="csr" aria-hidden="true"></i>
										</span>
										<?php } ?>
									</div>
								</div>

								<div class="custom_menu csr">
							<button class="close_ico btn btn-primary js-burger" data-section="csr">
								<i class="fas fa-times"></i>
							</button>
							<div class="text-center mb-3">
								<h5 class="csr_central_title">CSR Summary</h5>
							</div>
								<div class="csr_tabledata">
									<?php
									//CSR Saved
									if( $csrSavedTotal ){ ?>
										<div class="tab_data col-12"><p class="csrtab_heading"><?php _e('Saved CSR',CIP_TXTDOMAIN); ?></p> <span><?php echo number_format( $csrSavedTotal ); ?></span></div>
									<?php } ?>

									<?php
									//CSR on Hold or Under Review
									if( $csrHoldUReviewNonAwards ){ ?>
										<div class="tab_data col-12"><p class="csrtab_heading"><?php _e('Hold or Under Review',CIP_TXTDOMAIN); ?> </p><span><?php echo number_format( $csrHoldUReviewNonAwards ); ?> </span></div>
									<?php } ?>

									<?php
									// CSR Awards Delivered
									if( $csrDeliveredAwardsTotal ){ ?>
										<div class="tab_data col-12"><p class="csrtab_heading"><?php _e('Awards Delivered',CIP_TXTDOMAIN); ?> </p><span><?php echo number_format( $csrDeliveredAwardsTotal ); ?> </span></div>
									<?php } ?>

									<?php
									//CSR Awards on Hold or Under Review
									if( $csrHoldUReviewAwards ){ ?>
										<div class="tab_data col-12"><p class="csrtab_heading"><?php _e('Awards on Hold or Under Review',CIP_TXTDOMAIN); ?> </p><span><?php echo number_format( $csrHoldUReviewAwards ); ?> </span></div>
									<?php } ?>

									<?php
									// CSR Special Pending
									if( $csrSpecialPendingTotal ){ ?>
										<div class="tab_data col-12"><p class="csrtab_heading"><?php _e('Special Pending',CIP_TXTDOMAIN); ?> </p><span><?php echo number_format( $csrSpecialPendingTotal ); ?></span></div>
									<?php } ?>

									<?php
									// CSR Special (Hold/Under Review)
									if( $csrSpecialHoldTotal ){ ?>
										<div class="tab_data col-12"><p class="csrtab_heading"><?php _e('Special (Hold/Under Review)',CIP_TXTDOMAIN); ?> </p><span><?php echo number_format( $csrSpecialHoldTotal ); ?></span></div>
									<?php } ?>
								</div>
    					</div> 

						</div>
					</div>
				</td>
			</tr>
				<?php 
				}
				?>
				<!-- CSR25 -->


					<?php

					$csr25BalanceResult = $wpdb->get_row("SELECT
						-- Total main CSR
						( SUM(`amount_due`) + SUM(`csr_amount_issued`) ) AS `total_main_balance`,

						-- Pending CSR total
						SUM(CASE
							WHEN (`corp_approved` = 'Pending' OR `corp_approved` = 'Partially Delivered')
								AND `pool_ref` NOT IN('C', 'F', 'J', 'H')
								AND `pool_ref` NOT LIKE 'SPC%'
							THEN `amount_due`
							ELSE 0
						END) as `csr_pending_total`,

						-- Issued CSR total (SPC-CRSM)
						SUM(CASE
							WHEN `pool_ref` = 'SPC-CRSM'
							THEN `csr_amount_issued`
							ELSE 0
						END) as `csr_issued_total1`,

						-- Issued CSR total (Issued or Partially issued)
						SUM(CASE
							WHEN (`corp_approved` = 'Issued' OR `corp_approved` = 'Partially issued')
							THEN `csr_amount_issued`
							ELSE 0
						END) as `csr_issued_total2`,

						-- Delivered CSR total
						SUM(CASE
							WHEN `corp_approved` = 'Delivered'
							THEN `csr_amount_issued`
							ELSE 0
						END) as `csr_amount_delivered_total`,

						-- Saved CSR total
						SUM(CASE
							WHEN `corp_approved` = 'Saved CSR'
							THEN `csr_amount_issued`
							ELSE 0
						END) as `csr_amount_saved_total`,

						-- Hold/Under Review CSR total (non-awards)
						SUM(CASE
							WHEN `corp_approved` IN('Hold', 'Missing CSR Address', 'Security Hold', 'Under Manual Review', 'Under Review')
								AND `pool_ref` NOT IN('C', 'F', 'J', 'H')
							THEN `amount_due`
							ELSE 0
						END) as `csr_amount_due_total_non_awards`,

						-- Delivered CSR Awards Pending total
						SUM(CASE
							WHEN `corp_approved` = 'Delivered'
								AND `pool_ref` IN ('C', 'F', 'J', 'H')
							THEN `csr_amount_issued`
							ELSE 0
						END) as `csr_amount_awards_delivered_total`,

						-- Hold/Under Review CSR Awards total
						SUM(CASE
							WHEN `corp_approved` IN('Issued', 'Application received', 'Hold', 'Missing CSR Address', 'Security Hold', 'Under Review')
								AND `pool_ref` IN ('C', 'F', 'J', 'H')
							THEN `amount_due`
							ELSE 0
						END) as `csr_amount_due_total_awards`,

						-- Special CSR Pending total
						SUM(CASE
							WHEN `corp_approved` IN('Pending', 'Partially Delivered')
								AND `pool_ref` LIKE 'SPC%'
							THEN `amount_due`
							ELSE 0
						END) as `csr_amount_special_total`,

						-- Special CSR Hold/Under Review total
						SUM(CASE
							WHEN `corp_approved` IN('Under review', 'Hold', 'Security Hold', 'Under Manual Review')
								AND `pool_ref` LIKE 'SPC%'
							THEN `amount_due`
							ELSE 0
						END) as `csr_amount_special_hold_total`

						FROM `$tableTokenHolder`
						WHERE $whereEmail $whereTokenCSR25
					");

					$csr25PendingTotal = $csr25BalanceResult->csr_pending_total;
					$csr25IssuedTotal1 = $csr25BalanceResult->csr_issued_total1;
					$csr25IssuedTotal2 = $csr25BalanceResult->csr_issued_total2;
					$csr25DeliveredTotal = $csr25BalanceResult->csr_amount_delivered_total;
					$csr25SavedTotal = $csr25BalanceResult->csr_amount_saved_total;
					$csr25HoldUReviewNonAwards = $csr25BalanceResult->csr_amount_due_total_non_awards;
					$csr25DeliveredAwardsTotal = $csr25BalanceResult->csr_amount_awards_delivered_total;
					$csr25HoldUReviewAwards = $csr25BalanceResult->csr_amount_due_total_awards;
					$csr25SpecialPendingTotal = $csr25BalanceResult->csr_amount_special_total;
					$csr25SpecialHoldTotal = $csr25BalanceResult->csr_amount_special_hold_total;

					?>
					
					<?php 
						$tableTransactionHistory = $wpdb->prefix.'csr_delivery_transaction_history';
						$whereStatus = "AND `status`='2'";
						$csr25withdrawalTotalResult = $wpdb->get_row("SELECT SUM(withdrawal_amount) AS total_withdrawal FROM $tableTransactionHistory WHERE $whereEmail $whereTokenCSR25 $whereStatus ");
						$csr25withdrawalTotal = $csr25withdrawalTotalResult->total_withdrawal;

						//CSR Issued
						$issuedAmount = 0;
						if( 0 ){
							$issuedAmount = $csr25IssuedTotal1;
						}else{
							$issuedAmount = $csr25IssuedTotal2;
						}
						// $totalAmount = ((int)$csr25PendingTotal + (int)$issuedAmount + (int)$csr25DeliveredTotal);
						$totalAmount = $csr25BalanceResult->total_main_balance;

						$isAmountValid = (int)$totalAmount + (int)$csr25withdrawalTotal + (int)$csr25_balance + (int)$csr25SavedTotal + (int)$csr25HoldUReviewNonAwards + (int)$csr25DeliveredAwardsTotal + (int)$csr25HoldUReviewAwards + (int)$csrSpecialPendingTotal + (int)$csr25SpecialHoldTotal;

						if($isAmountValid > 0)
						{
							$isVisibleCsr25Section = true;

					?>

				<tr>
					<td colspan="7">
						<div class="container-fluid">
							<div class="mob_gridcols" style="display: grid;grid-template-columns: repeat(7, 1fr);column-gap: 99px;justify-content: start;justify-items: start;">

								<div class="table_data">
									<p class="curr_title"><?php _e('CSR25',CIP_TXTDOMAIN); ?> </p>
								</div>

								<div class="table_data">
									<span>
									<?php 
									?>
									<?php echo sprintf( __('%s', CIP_TXTDOMAIN), number_format( $totalAmount ) ); ?>
									</span>
								</div>

								<?php
								//CSR Pending
								if( $csr25PendingTotal ){ ?>
									<div class="table_data"><?php echo number_format( $csr25PendingTotal ); ?></div>
								<?php }else{ ?>
									<div class="table_data">0</div>
								<?php } ?>

								<?php

								if( $issuedAmount ){?>
									<div class="table_data"><?php  echo number_format( $issuedAmount ); ?></div>
								<?php }else{ ?>
									<div class="table_data">0</div>
								<?php } ?>

								<?php
								// CSR Delivered
								if( $csr25DeliveredTotal ){ ?>
									<div class="table_data"><?php echo number_format( $csr25DeliveredTotal ); ?>
									<!-- <span class="fa-fw fa-lg float-right">
										<i class="fa fa-plus-square" onclick="toggleSlide('csr25_tabledata')" aria-hidden="true"></i>
									</span> -->
									</div>
								<?php }else{ ?>
									<div class="table_data">0
									<!-- <span class="fa-fw fa-lg float-right">
										<i class="fa fa-plus-square" onclick="toggleSlide('csr25_tabledata')" aria-hidden="true"></i>
									</span> -->
									</div>
								<?php } ?>

								
								<!-- Withdrawn -->
								<div class="table_data">
									<div class="d-flex mobile-d-flex justify-content-between">
										<span>
										<?= $csr25withdrawalTotal ? number_format($csr25withdrawalTotal) : '0' ?>
										</span>
									</div>
								</div>

								<!-- Available Balance -->
								<div class="table_data">
									<div class="d-flex mobile-d-flex justify-content-between">
										<span>
										<?php echo sprintf( __('%s', CIP_TXTDOMAIN), number_format( $csr25_balance ) ); ?>
										</span>
										<?php if( $csr25SavedTotal || $csr25HoldUReviewNonAwards || $csr25DeliveredAwardsTotal || $csr25HoldUReviewAwards || $csr25SpecialPendingTotal || $csr25SpecialHoldTotal ){ ?>
										<span class="fa-fw fa-lg float-right ">
											<i class="fa fa-plus-square js-burger" data-section="csr25" aria-hidden="true"></i>
										</span>
										<?php } ?>
									</div>
								</div>

								<div class="custom_menu csr25">
							<button class="close_ico btn btn-primary js-burger" data-section="csr25">
								<i class="fas fa-times"></i>
							</button>
							<div class="text-center mb-3">
								<h5 class="csr_central_title">CSR25 Summary</h5>
							</div>
							<div class="csr25_tabledata">
									<?php
									//CSR Saved
									if( $csr25SavedTotal ){ ?>
										<div class="tab_data col-12"><p class="csrtab_heading"><?php _e('Saved CSR',CIP_TXTDOMAIN); ?> </p> <span><?php echo number_format( $csr25SavedTotal ); ?></span></div>
									<?php } ?>

									<?php
									//CSR on Hold or Under Review
									if( $csr25HoldUReviewNonAwards ){ ?>
										<div class="tab_data col-12"><p class="csrtab_heading"><?php _e('Hold or Under Review',CIP_TXTDOMAIN); ?> </p><span><?php echo number_format( $csr25HoldUReviewNonAwards ); ?> </span></div>
									<?php } ?>

									<?php
									// CSR Awards Delivered
									if( $csr25DeliveredAwardsTotal ){ ?>
										<div class="tab_data col-12"><p class="csrtab_heading"><?php _e('Awards Delivered',CIP_TXTDOMAIN); ?> </p><span><?php echo number_format( $csr25DeliveredAwardsTotal ); ?> </span></div>
									<?php } ?>

									<?php
									//CSR Awards on Hold or Under Review
									if( $csr25HoldUReviewAwards ){ ?>
										<div class="tab_data col-12"><p class="csrtab_heading"><?php _e('Awards on Hold or Under Review',CIP_TXTDOMAIN); ?> </p><span><?php echo number_format( $csr25HoldUReviewAwards ); ?> </span></div>
									<?php } ?>

									<?php
									// CSR Special Pending
									if( $csr25SpecialPendingTotal ){ ?>
										<div class="tab_data col-12"><p class="csrtab_heading"><?php _e('Special Pending',CIP_TXTDOMAIN); ?> </p><span><?php echo number_format( $csrSpecialPendingTotal ); ?></span></div>
									<?php } ?>

									<?php
									// CSR Special (Hold/Under Review)
									if( $csr25SpecialHoldTotal ){ ?>
										<div class="tab_data col-12"><p class="csrtab_heading"><?php _e('Special (Hold/Under Review)',CIP_TXTDOMAIN); ?> </p><span><?php echo number_format( $csr25SpecialHoldTotal ); ?></span></div>
									<?php } ?>
							</div>
						</div>

							</div>
						</div>
					</td>
				</tr>
				<?php 
					}
				?>
			</tbody>
		</table>		
					
		</div>

		<?php if( $isVisibleCsrSection == false && $isVisibleCsr25Section == false ){ ?>
		<style>.csr_summary_header, table.csr_summary_table{display: none;}</style>
		<?php } ?>

	<div class="row">
		<div class="col-md-12 text-center mt-3">
			<span>
				<?php if( !$isSwitch ){ ?>
				<button class="btn btn-primary <?php echo ( $tooltipShowTimer == true && empty( $withdraw_tooltip ) ) ? 'tippyTimerCounter' : ''; ?> <?php echo ( $withdrawal_disable == true ) ? 'disabled' : ''; ?>" <?php if( $withdrawal_disable === false ){ echo 'data-toggle="modal" data-target="#withdrawalModal" data-backdrop="static" data-keyboard="false"'; } ?> style="padding:10px 25px !important;">
					<?php _e("Withdraw", CIP_TXTDOMAIN); ?>
					<?php if( $withdrawal_disable == true && !empty( $withdraw_tooltip ) ){ ?>
					<i class="fa fa-info-circle" data-toggle="tooltip" data-placement="top" data-html="true" title="<?php echo $withdraw_tooltip; ?>"></i>
					<?php }else if( $tooltipShowTimer == true ){ ?>
						<i class="fa fa-info-circle"></i>
					<?php } ?>
				</button>
				<?php } ?>
			</span>
		</div>
	</div>

	<?php
	if( $withdrawal_suspension == 'enable' ){
		if( !empty( $_SESSION['logged_time'] ) && $_SESSION['logged_time'] >= time() ){
			if( $tooltipShowTimer == true && empty( $withdraw_tooltip ) ){
			?>
			<div class="withdrawal_disable_after_login_timer_section coundown-container clock rounded shadow">
				<div class="countdown-el countdown-el-text">For security reasons withdrawals are temporarily suspended. You can turn this feature off in your My Profile section.</div>
				<div class="d-flex justify-content-center">
					<div class="countdown-el minutes-container"><p class="big-text" id="minutes"></p><span>Minutes</span></div>
					<div class="countdown-el seconds-container"><p class="big-text" id="seconds"></p><span>Seconds</span></div>
				</div>
			</div>
			<div class="tippyContent"></div>
			<style>
				.withdrawal_disable_after_login_timer_section{
					display:none;
				}
				.tippyContent .withdrawal_disable_after_login_timer_section{
					display:block;
				}
			</style>
			<?php
			}
		}
	}
	if( $withdrawal_disable === false ){
		$total_step = 4;
		$csr_amount = get_user_csr_balance( $refAccount, 'available', 'csr' );
		$csr25_amount = get_user_csr_balance( $refAccount, 'available', 'csr25' );
		$percentageNumber25 = ( $csr_amount * 25 ) / 100;
		$percentageNumber50 = ( $csr_amount * 50 ) / 100;
		$percentageNumber75 = ( $csr_amount * 75 ) / 100;
		$percentageNumber100 = ( $csr_amount * 100 ) / 100;
	?>
	<div class="modal fade" id="withdrawalModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
			<div class="modal-content">
				<div class="modal-body">
				<div class="container-fluid">
					<span class="withdrawal_close_btn close" data-dismiss="modal">&times;</span>
					<div class="row justify-content-center">
						<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 text-center p-0 mt-0 mb-2">
							<div class="card-">
								<form name="csrWithdrawalFrm" class="csrWithdrawalFrm" id="msform">
									<!-- progressbar -->
									<ul id="progressbar" class="mb-3">
										<li class="active" id="fieldmapping"><strong><?php _e('Select your withdrawal details','corsair-login') ?></strong></li>
										<li id="fieldmapping"><strong><?php _e('Withdrawal confirmation','corsair-login') ?></strong></li>
										<li id="fieldmapping"><strong><?php _e('Enter passwords','corsair-login') ?></strong></li>
										<li id="fieldmapping"><strong><?php _e('Complete','corsair-login') ?></strong></li>
									</ul>
									<div class="progress">
										<div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
									</div>
									<br> <!-- fieldsets -->
									<fieldset class="step_0">
										<div class="form-card">
											<div class="row">
												<div class="col-12">
													<p class="steps"><?php echo sprintf('Step %s - %s', 1, $total_step); ?></p>
												</div>
											</div>

											<div class="row">
												<div class="col-12 pt-24">
													<div class="form-group">
														<label for="token"><?php _e('Token', 'corsair-login'); ?></label>
														<select name="token" id="token">
															<option value="">Select Token</option>
															<?php if((int)$csr_amount > 0)
															{
															?>
																<option value="CSR" >CSR</option>
															<?php
															}
															?>
															<?php if((int)$csr25_amount > 0)
															{
															?>
																<option value="CSR25">CSR25</option>
															<?php
															}
															?>

														</select>
													</div>
													<div class="token_selected">
														<div class="form-group">
															<label for="csr_wallet_address"><?php _e('CSR Wallet address', 'corsair-login'); ?></label>
															<input class="form-control" type="text" name="csr_wallet_address" id="csr_wallet_address" />
														</div>
														<div class="form-group">
															<label for="csr_withdrawal_amount"><?php _e('Withdrawal amount', 'corsair-login'); ?></label>
															<input class="form-control m-0" type="text" name="csr_withdrawal_amount" id="csr_withdrawal_amount" />
															<small class="available_balance_notice"></small>
														</div>
														<div class="form-group">
															<button type="button" class="percentage_25" data-percentage-val="<?php echo number_format( $percentageNumber25, 2, '.', '') ?>">25%</button>
															<button type="button" class="percentage_50" data-percentage-val="<?php echo number_format( $percentageNumber50, 2, '.', '') ?>">50%</button>
															<button type="button" class="percentage_75" data-percentage-val="<?php echo number_format( $percentageNumber75, 2, '.', '') ?>">75%</button>
															<button type="button" class="percentage_100" data-percentage-val="<?php echo number_format( $percentageNumber100, 2, '.', '') ?>">100%</button>
														</div>
													</div>
												</div>
                                    		</div>
										</div>
										<div class="token_selected">
											<input type="button" name="next" id="next_sp1" class="next_cw action-button" value="Next" />
										</div>
									</fieldset>

									<fieldset class="step_1">
										<div class="form-card">
											<p class="csr_wallet_address_text"><?php _e('CSR Wallet address'); ?> : <span></span></p>
											<p class="withdraw_amount_text"><?php _e('Withdrawal amount'); ?> : <span></span></p>
											<p class="received_amount_text"><?php _e('Received amount'); ?> : <span></span></p>
											<p class="withdrawal_fee_text"><?php _e('Withdrawal fee'); ?> : <span></span></p>
	                            			<p><label class="csr_wallet_address_text" for="i_confirm_that_withdrawal"><input type="checkbox" name="i_confirm_that_withdrawal" id="i_confirm_that_withdrawal" value="1" /> <?php _e('I confirm that once the withdrawal is initiated control of the CSR is transferred to the owner of the address', CIP_TXTDOMAIN); ?> <span></span></label></p>

											<p><label for="withdraw_csr_directly_to_the_deposit_address"><input type="checkbox" name="withdraw_csr_directly_to_the_deposit_address" id="withdraw_csr_directly_to_the_deposit_address" value="1" /> <?php _e('I understand that if I withdraw CSR directly to the deposit address on an exchange the receiving exchange may not automatically recognise the deposit bringing about delays or even loss of my CSR.', CIP_TXTDOMAIN); ?></label></p>
										</div>
										<input type="button" name="next" class="next_cw action-button" value="Next" /> <input type="button" name="previous" class="previous_cw action-button-previous" value="Previous" />
									</fieldset>
									<fieldset class="step_2">
										<div class="form-card">
											<div class="row">
												<div class="col-12">
													<p class="steps"><?php echo sprintf('Step %s - %s', 3, $total_step); ?></p>
												</div>
											</div>

											<div class="row">
												<div class="col-12">
													<div class="otp_response_section"></div>
													<div class="ga_response_section"></div>
												</div>
											</div>
										</div>
										<input type="button" name="next" class="next_cw action-button" value="Submit" /> <input type="button" name="previous" class="previous_cw action-button-previous" value="Previous" />
									</fieldset>
									<fieldset class="step_3">
										<div class="form-card">
											<div class="row">
												<div class="col-12">
													<p class="steps"><?php echo sprintf('Step %s - %s', 4, $total_step); ?></p>
												</div>
											</div>
										</div>
										<div class="row">
											<div class="col-12">
												<div class="final_response_section text-left"></div>
											</div>
										</div>
										<!-- <input type="button" name="previous" class="previous_cw action-button-previous" value="Previous" /> -->
									</fieldset>
									<input type="hidden" name="action" value="csrwithdrawalaction" />
									<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XyCIPWithdrawalCSRPICyX_'); ?>" />
									<div class="responseSection"></div>
								</form>
							</div>
						</div>
					</div>
				</div>
				</div>
			</div>
		</div>
	</div>
	<?php
	}
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('COUNTRIES-MANAGEMENT-TABLE', 'countries_management_table_callback');
function countries_management_table_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'daterangepicker-style' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	ob_start();
	if( current_user_can('supportmanager') || current_user_can('supportagent') ){
		$cipDisabledCountries = get_option( 'cipDisabledCountries' );
		$cipDisabledCountries = maybe_unserialize( $cipDisabledCountries );
		?>
		<!-- <form class="form-inline" name="addCountryMgmt" id="addCountryMgmt">
			<input class="form-control mb-2 mr-sm-2" name="country" placeholder="<?php _e('Add country for disable', CIP_TXTDOMAIN); ?>" />
			<button class="btn btn-primary mb-2" type="submit"><?php _e('Add', CIP_TXTDOMAIN); ?></button>
			<input type="hidden" name="action" value="addCountrytoDisableAct" />
			<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XyaddCountrytoDisableyX_'); ?>" />
		</form> -->
		<table class="table table-bordered" id="countries_management" data-search="true" data-filter-control="true" data-show-search-clear-button="false" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
		<thead>
			<tr>
				<th data-field="country_names"><span><?php _e('Countries', CIP_TXTDOMAIN); ?></span></th>
				<th data-field="action"><span><?php _e('Enable/Disable', CIP_TXTDOMAIN); ?></span></th>
			</tr>
		</thead>
		<tbody>
		<?php
		$GF_Field_Address = new GF_Field_Address();
		$countries = $GF_Field_Address->get_countries();
		if( !empty( $countries ) ){
			/* $loopCount = 0;
			foreach( $countries as $country ){
				$isDisableCountry = ( in_array( $country, $cipDisabledCountries ) ) ? 0 : 1;
				$label = ( $isDisableCountry ) ? 'Enabled' : 'Disabled';
			?>
			<tr>
				<td><?php echo $country; ?></td>
				<td>
					<div class="custom-control custom-switch mb-0">
						<input type="checkbox" class="custom-control-input countries_management_chkbox" name="countryName" value="<?php echo $country ?>" id="country_<?php echo $loopCount; ?>" data-_micro="<?php echo wp_create_nonce('_Micro_CountriesManagement_Micro_'); ?>" <?php checked( 1, $isDisableCountry, true ); ?> />
						<label class="custom-control-label" for="country_<?php echo $loopCount; ?>"><?php echo $label; ?></label>
					</div>
				</td>
			</tr>
			<?php
			$loopCount++;
			} */
		}else{
			?>
			<tr>
				<td colspan="2"><?php __('No countries found', CIP_TXTDOMAIN); ?></td>
			</tr>
			<?php
		}
		?>
		</tbody>
		</table>
		<?php
	}
	$html .= ob_get_clean();
	return $html;
}
//CSR-WITHDRAWAL-SETTING
add_shortcode('CSR-WITHDRAWAL-REQUESTS', 'csr_withdrawal_requests_callback');
function csr_withdrawal_requests_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'daterangepicker-style' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('dr-moment');
	wp_enqueue_script('daterangepicker-script');
	wp_enqueue_style( 'select2' );
	wp_enqueue_script('select2');
	ob_start();
	global $wpdb;
	$tableWithdraw = $wpdb->prefix.'withdraw_data_pending';
	$tableWithdrawInProcess = $wpdb->prefix.'withdraw_data_inprocess';
	$tableWithdrawComplete = $wpdb->prefix.'withdraw_data_completed';
	$tableWithdrawalRequestsCsv = $wpdb->prefix.'withdrawal_requests_csv';
	$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableWithdraw WHERE 1");
	$total_items_process = $wpdb->get_var("SELECT COUNT(id) FROM $tableWithdrawInProcess WHERE 1");
	$total_step = 3;
	$currentUserData = wp_get_current_user();
	// delete_option('withdrawal_request_wizard_process_user');
	$withdrawal_request_wizard_process_user = get_option('withdrawal_request_wizard_process_user');
	$buttonShow = true;
	if( !empty( $withdrawal_request_wizard_process_user ) && $withdrawal_request_wizard_process_user != $currentUserData->ID ){
		$buttonShow = false;
	}
	$tableWithdrawInProcess = $wpdb->prefix.'withdraw_data_inprocess';
	$getProcessCount = $wpdb->get_var("SELECT COUNT(id) FROM $tableWithdrawInProcess WHERE 1");
	$unique_addresses = $wpdb->get_var("SELECT COUNT(DISTINCT(`eth_address`)) FROM $tableWithdraw WHERE 1 AND ( `eth_address` IS NOT NULL AND `eth_address` <> '' )");
	$totalWithdrawalsAmount = 0;
	$totalWithdrawals = 0;
	$receivedAmountData = $wpdb->get_row("SELECT COALESCE(SUM(`received_amount`),0) as `received_amount` FROM $tableWithdraw WHERE 1");
	$withdrawalData = $wpdb->get_row("SELECT COUNT(*) as `totalCount` FROM $tableWithdraw WHERE 1");
	if( $receivedAmountData ){
		$totalWithdrawalsAmount = $receivedAmountData->received_amount;
	}
	if( $withdrawalData ){
		$totalWithdrawals = $withdrawalData->totalCount;
	}
	$currentUserData = wp_get_current_user();
	$user_id = $currentUserData->ID;
	$corsair_2fa_ga = get_option( 'corsair_2fa_ga' );
	$google_auth_key = get_user_meta( $user_id, 'google_auth_key', true );
	$google_auth_key_walletdelivery = get_user_meta( $user_id, 'google_auth_key_walletdelivery', true );
	// $ga2fa_login_enabled = ( !empty( $google_auth_key ) && $google_auth_key_login == 1 ) ? 1 : 0;
	$ga2fa_delivery_enabled = ( !empty( $google_auth_key ) && $google_auth_key_walletdelivery == 1 ) ? 1 : 0;
	$warningToolTip = "";
	if( $corsair_2fa_ga != 'yes' || $ga2fa_delivery_enabled != 1 ){
		$warningToolTip = '<i class="fa fa-info-circle" data-toggle="tooltip" data-placement="top" data-html="true" title="'.__('Please enable Google Authenticator 2FA in your Profile to complete this task.', CIP_TXTDOMAIN).'"></i>';
	}
	if( current_user_can('supportagent') ){
		$_SESSION['sessionWdRequestSelectionData'] = array();
		if( $total_items || $total_items_process ){
		?>
		<div class="d-flex justify-content-end" id="customToolbar">

			<button type="button" style="padding: 6px 12px !important;" <?php if( empty( $warningToolTip ) ){ ?> name="withdrawal_request_approve_selected" id="withdrawal_request_approve_selected" class="withdrawal_request_approve_selected mr-2" <?php } ?>><?php _e('Approve', CIP_TXTDOMAIN); ?> <?php echo $warningToolTip; ?>  </button>

			<?php if( $buttonShow ){ ?>
			<button type="button" style="padding: 6px 12px !important;" <?php if( empty( $warningToolTip ) ){ ?> name="withdrawal_request_wizard_opener" id="withdrawal_request_wizard_opener" class="withdrawal_request_wizard_opener" <?php } ?>><?php _e('Process Withdrawal Requests', CIP_TXTDOMAIN); ?> <?php echo $warningToolTip; ?>  </button>
			<?php } ?>
			<button type="button" class="btn btn-primary csr_withdrawal_requests_download" style="margin-left: 5px;padding: 6px 12px !important;"><i class="fa fa-download"></i></button>
		</div>
		<?php if( $buttonShow && empty( $warningToolTip ) ){ ?>
		<div class="modal fade" id="withdrawalRequestModal" tabindex="-1" role="dialog">
			<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
				<div class="modal-content">
					<div class="modal-body">
					<div class="container-fluid">
						<span class="withdrawal_close_btn close" data-dismiss="modal">&times;</span>
						<div class="row justify-content-center">
							<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 text-center p-0 mt-0 mb-2">
								<div class="card-">
									<form name="sa_withdrawal_request_wizard" class="sa_withdrawal_request_wizard" id="msform">
									<!-- progressbar -->
										<ul id="progressbar" class="mb-3">
											<li class="active" id="fieldmapping"><strong><?php _e('Verify Withdrawals','corsair-login') ?></strong></li>
											<li id="fieldmapping"><strong><?php _e('Download Withdrawals','corsair-login') ?></strong></li>
											<li id="fieldmapping"><strong><?php _e('Token award Confirmation','corsair-login') ?></strong></li>
										</ul>
										<div class="progress">
											<div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
										</div>
										<br> <!-- fieldsets -->
										<fieldset class="step_0">
											<div class="form-card">
												<div class="row">
													<div class="col-12">
														<p class="steps"><?php echo sprintf('Step %s - %s', 1, $total_step); ?></p>
													</div>
												</div>

												<div class="row process_withdrawal_requests_summary_section text-left justify-content-left">
													<?php /*<div class="col-12">
														<h5><?php _e('Check the the withdrawal summary and click Next', CIP_TXTDOMAIN); ?></h5>
														<p><?php echo sprintf( __('Total withdrawals : %s', CIP_TXTDOMAIN ), $totalWithdrawals ); ?></p>
														<p><?php echo sprintf( __('Total CSR withdrawal amount : %s CSR', CIP_TXTDOMAIN ), number_format( $totalWithdrawalsAmount, 2 ) ); ?></p>
														<p><?php echo sprintf( __('Unique CSR addresses : %s', CIP_TXTDOMAIN ), $unique_addresses ); ?></p>
													</div>*/ ?>
												</div>

											</div>
											<input type="button" name="next" class="next_wrw action-button" value="Next" />
										</fieldset>

										<fieldset class="step_1">
											<div class="form-card">
												<div class="row">
													<div class="col-12">
														<p class="steps mb-0"><?php echo sprintf('Step %s - %s', 2, $total_step); ?></p>
													</div>
												</div>
												<div class="row text-left justify-content-center">
													<p class="pt-3 text-center"><?php _e('Enter your 2FA and click download to download the Withdrawal file for Token Award. The distribution process will take place on Token Award. If you wish to cancel this process enter your 2FA and click cancel. Note you should not process the the Distribution on Token Award if you  cancel.', CIP_TXTDOMAIN); ?></p>
												</div>
												<div class="download_link" style="display: none;"></div>

												<div class="row text-center justify-content-center">
													<hr class="mt-4 mb-3">
													<div class="otp_section pb-3">
														<label for="user_ga_otp"><?php echo __('Please enter the authentication code', CIP_TXTDOMAIN); ?></label>
														<input type="text" name="user_ga_otp" id="user_ga_otp" class="input mb-1" maxlength="6" pattern="{0-9}+" />
														<small class="form-text text-muted"><?php _e('Enter the 6-digit code generated by the Authenticator App.') ?></small>
														<?php
														$exportFileid = get_option('withdrawal_request_wizard_export_fileid');
														$getFileData = $wpdb->get_row("SELECT * FROM $tableWithdrawalRequestsCsv WHERE `fileid`='". $exportFileid ."'");
														if( !empty( $exportFileid ) ){ ?>
															<input type="button" name="download" class="download_wrw action-button" value="<?php _e('Download', CIP_TXTDOMAIN); ?>" />
														<?php } ?>
														<?php if( $getProcessCount > 0 ){ ?><input type="button" name="cancel" class="cancel_wrw action-button" value="<?php _e('Cancel', CIP_TXTDOMAIN); ?>" /><?php } ?>
													</div>
												</div>
											</div>
											<?php if( !empty( $exportFileid ) && $getFileData->downloadStatus == 1 ){ ?>
												<input type="button" name="next" class="next_wrw action-button" value="Next" />
											<?php }else{ ?>
												<input type="button" name="next" class="next_wrw action-button disabled" value="Next" disabled />
											<?php } ?>
										</fieldset>
										<fieldset class="step_2">
											<div class="form-card">
												<div class="row">
													<div class="col-12">
														<p class="steps"><?php echo sprintf('Step %s - %s', 3, $total_step); ?></p>
													</div>
												</div>
												<div class="row text-left justify-content-center complete_2fa_form">
													<h5 class="pt-3 text-center"><?php _e('Process the Distribution on Token Award', CIP_TXTDOMAIN); ?></h5>
												</div>
												<div class="row text-left justify-content-center complete_2fa_form">
													<p class="pt-3 text-center"><?php _e('When complete, enter the transaction hash, 2FA, and click Complete. If you wish to cancel this process, enter your 2FA and click cancel. Note you should not process the Distribution on Token Award if you cancel.', CIP_TXTDOMAIN); ?></p>
												</div>
												<div class="row text-center complete_2fa_form justify-content-center">
													<hr class="mt-4 mb-3">
													<div class="otp_section pb-3">
														<div class="form-group mb-0">
															<label for="sa_txnhash"><?php echo __('Please enter transaction hash', CIP_TXTDOMAIN); ?></label>
															<input type="text" name="sa_txnhash" class="sa_txnhash" id="sa_txnhash" class="input mb-1" />
														</div>

														<div class="form-group mb-0">
															<label for="user_complete_ga_otp"><?php echo __('Please enter the authentication code', CIP_TXTDOMAIN); ?></label>
															<input type="text" name="user_complete_ga_otp" id="user_complete_ga_otp" class="input mb-1" maxlength="6" pattern="{0-9}+" />
															<small class="form-text text-muted"><?php _e('Enter the 6-digit code generated by the Authenticator App.') ?></small>
														</div>
														<?php if( $getProcessCount > 0 ){ ?><input type="button" name="cancel" class="cancel_last_wrw action-button" value="<?php _e('Cancel', CIP_TXTDOMAIN); ?>" /><?php } ?>
														<?php
														$getFileData = $wpdb->get_row("SELECT * FROM $tableWithdrawalRequestsCsv WHERE `fileid`='". $exportFileid ."'");
														if( !empty( $exportFileid ) && $getFileData->downloadStatus == 1 ){ ?>
															<input type="button" name="next" class="next_wrw action-button" style="width: auto;" value="<?php _e('Complete', CIP_TXTDOMAIN); ?>" />
														<?php }else{ ?>
															<input type="button" name="next" class="next_wrw action-button disabled" style="width: auto;" value="<?php _e('Complete', CIP_TXTDOMAIN); ?>" disabled />
														<?php } ?>
													</div>
												</div>
												<div class="row justify-content-center">
													<h5 class="update_withdraw_request_response"></h5>
												</div>
											</div>
										</fieldset>
										<input type="hidden" name="action" value="sa_withdrawal_request_wizard_action" />
										<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPWithdrawalRequestWizardCIP_'); ?>" />
									</form>
								</div>
							</div>
						</div>
					</div>
					</div>
				</div>
			</div>
		</div>
		<?php } ?>
		<?php
		}
	?>
	<div class="" style="position: absolute;top:0%;">
		<p style="margin:0px !important;" class="text-left total_withdraw_request_label"></p>
		<p style="margin:0px !important;" class="text-left total_withdraw_request_label25"></p>
	</div>
	<table id="csr_withdraw_requests" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[500, 1000, 1500, 2000]" data-page-size="500" data-response-handler="responseHandlerWithdrawRequests" data-toolbar="#customToolbar">
	<thead>
		<tr>
			<th data-field="rowiddata" data-switchable="false"><input type="checkbox" name="toggleWDAll" id="toggleWDAll" checked /></th>
			<th data-field="id" class="id" data-switchable="false"><?php _e('ID',CIP_TXTDOMAIN); ?></th>
			<th data-field="token" data-sortable="true" data-filter-control="select" data-filter-data="var:withdrawalProcessToken" class="token" data-switchable="true"><?php _e('Token Type',CIP_TXTDOMAIN); ?></th>
			<th data-field="withdrawal_process_status" data-sortable="true" data-filter-control="select" data-filter-data="var:withdrawalProcessStatus" class="withdrawal_process_status" data-switchable="true"><?php _e('Status',CIP_TXTDOMAIN); ?></th>
			<th data-field="username" data-sortable="true" data-filter-control="input" class="username" data-switchable="true"><?php _e('Username',CIP_TXTDOMAIN); ?></th>
			<th data-field="withdrawal_id" data-sortable="true" data-filter-control="input" class="withdrawal_id" data-switchable="true"><?php _e('Withdrawal ID',CIP_TXTDOMAIN); ?></th>
			<th data-field="requested_date" data-sortable="true" class="requested_date" data-filter-control="input" data-switchable="true"><?php _e('Date Requested',CIP_TXTDOMAIN); ?></th>
			<th data-field="first_name" data-sortable="true" data-filter-control="input" class="first_name" data-switchable="true"><?php _e('First Name',CIP_TXTDOMAIN); ?></th>
			<th data-field="last_name" data-sortable="true" data-filter-control="input" class="last_name" data-switchable="true"><?php _e('Last Name',CIP_TXTDOMAIN); ?></th>
			<th data-field="email" data-sortable="true" data-filter-control="input" class="email" data-switchable="true"><?php _e('Email',CIP_TXTDOMAIN); ?></th>
			<th data-field="user_star" data-sortable="true" data-filter-control="select" data-filter-data="var:userStarRank" class="user_star" data-switchable="true"><?php _e('Star Rank',CIP_TXTDOMAIN); ?></th>
			<th data-field="eth_address" data-sortable="true" data-filter-control="input" class="eth_address" data-switchable="true"><?php _e('CSR address',CIP_TXTDOMAIN); ?></th>
			<th data-field="withdraw_amount" data-sortable="true" data-filter-control="input" class="withdraw_amount" data-switchable="true"><?php _e('Withdrawal amount',CIP_TXTDOMAIN); ?></th>
			<th data-field="withdrawal_fee" data-sortable="true" data-filter-control="input" class="withdrawal_fee" data-switchable="true"><?php _e('Withdrawal fee',CIP_TXTDOMAIN); ?></th>
			<th data-field="received_amount" data-sortable="true" data-filter-control="input" class="received_amount" data-switchable="true"><?php _e('Received amount',CIP_TXTDOMAIN); ?></th>
			<th data-field="action" class="action" data-switchable="false"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
		</tr>
	</thead>
	<tbody>
	</tbody>
	</table>
	<div class="modal fade" id="UsernameFilterModal" tabindex="-1" role="dialog" aria-labelledby="UsernameFilterModal" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered" role="document">
		<div class="modal-content">

			<form class="filter_by_username" name="filter_by_username" id="filter_by_username">
				<div class="modal-body">
					<div class="form-group">
						<label for="filter_by_condition_username">Filter by condition</label>
						<select class="form-control" name="filter_condition_type_username" id="filter_condition_type_username">
							<option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
							<option value="is_exactly_simple"><?php _e('Is exactly (multiple)', CIP_TXTDOMAIN); ?></option>
							<option value="is_exactly"><?php _e('Is exactly adv. (multiple)', CIP_TXTDOMAIN); ?></option>
						</select>
						<textarea name="filter_condition_value_username_bulk" id="filter_condition_value_username_bulk" class="form-control mt-2" style="display: none;" rows="3" placeholder="<?php _e('Bulk Usernames', CIP_TXTDOMAIN ); ?>"></textarea>
						<select class="form-control mt-2" style="width:100%" name="filter_condition_value_username[]" id="filter_condition_value_username" multiple></select>
					</div>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
					<button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
				</div>
			</form>
		</div>
		</div>
	</div>
	<div class="modal fade" id="cancelWithdrawModal" tabindex="-1" role="dialog" aria-hidden="true">
	  <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
		<div class="modal-content">
			<div class="modal-body">
			</div>
		</div>
	  </div>
	</div>
	<div class="modal fade" id="reviewWithdrawRequestModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-body">
					<form class="review_withdraw_request_frm" id="review_withdraw_request_frm" name="review_withdraw_request_frm">
						<div class="form-group">
							<h5><?php _e('Review Withdrawal Request', CIP_TXTDOMAIN); ?></h5>
						</div>
						<p class="review_label"></p>
						<div class="form-group">
							<div class="otp_section pb-1">
								<label for="user_ga_otp"><?php echo __('Please enter the authentication code', CIP_TXTDOMAIN); ?></label>
								<input type="text" name="user_ga_otp" id="user_ga_otp" class="input mb-1" maxlength="6" pattern="{0-9}+" />
								<small class="form-text text-muted"><?php _e('Enter the 6-digit code generated by the Authenticator App.') ?></small>
							</div>
						</div>
						<button type="submit" class="btn btn-secondary"><?php _e('Confirm', CIP_TXTDOMAIN); ?></button>
						<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
						<input type="hidden" name="action" value="review_withdraw_request_action" />
					</form>
				</div>
			</div>
		</div>
	</div>

	<div class="modal fade" id="approveWithdrawRequestSelectedModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-body">
					<form class="approve_selected_withdraw_request_frm" id="approve_selected_withdraw_request_frm" name="approve_selected_withdraw_request_frm">
						<div class="form-group">
							<h5><?php _e('Approve Withdrawal Request', CIP_TXTDOMAIN); ?></h5>
						</div>
						<p class="approve_label"></p>
						<div class="form-group">
							<div class="otp_section pb-1">
								<label for="user_ga_otp"><?php echo __('Please enter the authentication code', CIP_TXTDOMAIN); ?></label>
								<input type="text" name="user_ga_otp" id="user_ga_otp" class="input mb-1" maxlength="6" pattern="{0-9}+" />
								<small class="form-text text-muted"><?php _e('Enter the 6-digit code generated by the Authenticator App.') ?></small>
							</div>
						</div>
						<button type="submit" class="btn btn-secondary"><?php _e('Confirm', CIP_TXTDOMAIN); ?></button>
						<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
						<input type="hidden" name="_micro" value="<?= wp_create_nonce('CIP_WithdrawalRequestApproveSelected_CIP') ?>" />
						<input type="hidden" name="action" value="approve_selected_withdraw_request_action" />
						
					</form>
				</div>
			</div>
		</div>
	</div>

	<div class="modal fade" id="approveWithdrawRequestModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-body">
					<form class="approve_withdraw_request_frm" id="approve_withdraw_request_frm" name="approve_withdraw_request_frm">
						<div class="form-group">
							<h5><?php _e('Approve Withdrawal Request', CIP_TXTDOMAIN); ?></h5>
						</div>
						<p class="approve_label"></p>
						<div class="form-group">
							<div class="otp_section pb-1">
								<label for="user_ga_otp"><?php echo __('Please enter the authentication code', CIP_TXTDOMAIN); ?></label>
								<input type="text" name="user_ga_otp" id="user_ga_otp" class="input mb-1" maxlength="6" pattern="{0-9}+" />
								<small class="form-text text-muted"><?php _e('Enter the 6-digit code generated by the Authenticator App.') ?></small>
							</div>
						</div>
						<button type="submit" class="btn btn-secondary"><?php _e('Confirm', CIP_TXTDOMAIN); ?></button>
						<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
						<input type="hidden" name="action" value="approve_withdraw_request_action" />
					</form>
				</div>
			</div>
		</div>
	</div>
	<?php
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CSR-WALLET-DELIVERY', 'csr_wallet_delivery_callback');
function csr_wallet_delivery_callback(){
	$html = "";
	if( is_user_logged_in() && ( current_user_can('supportmanager') || current_user_can('supportagent') ) ){
		global $wpdb;
		$_SESSION['sessionSelectionData'] = array();
		wp_enqueue_style( 'cip-css' );
		wp_enqueue_style( 'bs-table' );
		wp_enqueue_style( 'bs-sticky-header' );
		wp_enqueue_style( 'daterangepicker-style' );
		wp_enqueue_script('bs-table');
		wp_enqueue_script('bs-sticky-header');
		wp_enqueue_script('bs-table-filter-control');
		wp_enqueue_script('dr-moment');
		wp_enqueue_script('daterangepicker-script');
		wp_enqueue_style( 'select2' );
		wp_enqueue_script('select2');
		ob_start();
		?>
		<div class="container-fluid wallet_delivery_frm">
		<div class="table-responsive">
		<?php
			$user_id = get_current_user_id();
			if( !metadata_exists( 'user', $user_id, 'cip_sagent_toggle_columns' ) ){
				$columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
				update_user_meta( $user_id, 'cip_sagent_toggle_columns', $columnsSAColumnOption );
			}
			$saUserData = get_user_by( 'id', $user_id );
			global $defaultColumnsArr;
			if( $saUserData && ( in_array( "supportagent", $saUserData->roles ) || in_array( "supportmanager", $saUserData->roles ) ) ){
				$columnOrders = (array)get_option('cip_sm_column_order');
				$columnsLabelArr = (array)get_option('cip_sm_column_labels');
				$columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
				$columnsSAToggleArr = (array)get_user_meta( $user_id, 'cip_sagent_toggle_columns', true );
				$columnsArr = array();
				if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
					foreach( $columnOrders as $columnOrder ){
						if( isset( $columnsSAToggleArr[$columnOrder] ) ){
							$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
						}
					}
					if( empty( $columnsArr ) ){
						foreach( $columnOrders as $columnOrder ){
							if( isset( $columnsSAColumnOption[$columnOrder] ) ){
								$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
							}
						}
					}
				}else{
					unset( $defaultColumnsArr['imported_by'] );
					unset( $defaultColumnsArr['import_at'] );
					unset( $defaultColumnsArr['last_update_at'] );
					$columnsArr = $defaultColumnsArr;
				}
			}else{
				unset( $defaultColumnsArr['imported_by'] );
				unset( $defaultColumnsArr['import_at'] );
				unset( $defaultColumnsArr['last_update_at'] );
				$columnsArr = $defaultColumnsArr;
			}
		?>
		<div class="csr_delivery_summary_wl">
			<div class="d-flex" style="column-gap:10px;">
				<div>
					<h6 class="m-0"><?php _e('Token Delivery Summary', CIP_TXTDOMAIN ); ?></h6>
					<p class="text-left mb-0"> <?php _e('Filtered Total Amount: ', CIP_TXTDOMAIN ); ?><span class="total_amount_due_label"></span> </p>
					<p class="text-left mb-0"> <?php _e('Filtered Selected Total Amount: ', CIP_TXTDOMAIN ); ?><span class="total_selected_amount_due_label"></span> </p>
				</div>
				<div>
					<button type="button" class="btn btn-primary csr_delivery" style="padding: 10px 10px !important;"><?php _e('Deliver', CIP_TXTDOMAIN); ?></button>
				</div>
				<div>
					<button type="button" class="btn btn-primary csr_delivery_partial_pre" style="padding: 10px 10px !important;" data-toggle="tooltip" data-placement="top" title="<?php _e('For partial delivery you will confirm amounts to be delivered on the next page.',CIP_TXTDOMAIN); ?>"><?php _e('Partial Delivery', CIP_TXTDOMAIN); ?></button>
					<form name="partialDeliveryFrm" id="partialDeliveryFrm" action="<?php echo get_permalink( 6395 ); ?>" method="post" target="_blank" style="display:none;">
						<button type="submit" class="btn btn-primary csr_partial_delivery disabled" data-toggle="tooltip" data-placement="top" title="<?php _e('Partial Delivery only available for small delivery selections of under 15 rows.',CIP_TXTDOMAIN); ?>" style="padding: 10px 10px !important;" disabled><?php _e('Partial Delivery', CIP_TXTDOMAIN); ?></button>
						<input type="hidden" name="action" value="partialdelivery" />
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxYPartialDeliveryYxCIP_'); ?>" />
						<input type="hidden" name="partialDeliveryIds" value="" />
						<input type="hidden" name="isSelectAll" value="1" />
					</form>
				</div>
				<div>
					<button type="button" class="btn btn-primary csr_delivery_to_saving" style="padding: 10px 10px !important;"><?php _e('Deliver to Savings', CIP_TXTDOMAIN); ?></button>
				</div>
				<div>
					<button type="button" class="btn btn-primary csr_delivery_clear_filter" style="padding: 10px 10px !important;" onclick="window.location.reload();" ><?php _e('Clear', CIP_TXTDOMAIN); ?></button>
				</div>
			</div>
		</div>
		<button type="button" class="btn btn-primary csr_delivery_download"><i class="fa fa-download"></i></button>
	    <table id="tokenholder_wallet_delivery" data-toolbar="false" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" class="table table-bordered" data-side-pagination="server" data-page-size="20" data-page-list="[20, 30, 50, 100]" data-response-handler="responseHandlerW" data-query-params="queryParams">
			<thead>
			<tr>
				<th data-field="rowiddata" data-switchable="false"><input type="checkbox" name="toggleWDAll" id="toggleWDAll" /></th>
				<th data-field="id" class="id"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
				<?php
				if( $columnsArr ){
					foreach( $columnsArr as $columnKey => $columnsVal ){
						$filter_attr = 'data-filter-control="input"';
						$filterData_attr = '';
						if( $columnKey == '_user_status' || $columnKey == 'kyc_status' || $columnKey == 'corp_approved' || $columnKey == 'token'  ){
							if( $columnKey == '_user_status' ){
								$filterData_attr = ' data-filter-data="var:filterUserStatus"';
							}
							if( $columnKey == 'kyc_status' ){
								$filterData_attr = ' data-filter-data="var:filterKycStatus"';
							}
							if( $columnKey == 'corp_approved' ){
								$filterData_attr = ' data-filter-data="var:filterCorpApproved"';
							}
							if( $columnKey == 'token' ){
								$filterData_attr = ' data-filter-data="var:withdrawalProcessToken"';
							}
							$filter_attr = 'data-filter-control="select" class="status" data-filter-custom-search="BsTableFilterStatus"'.$filterData_attr;
						}
					?>
					<th data-field="<?php echo $columnKey ?>" data-sortable="true" <?php echo $filter_attr; ?> class="<?php echo $columnKey ?>"><?php echo $columnsVal; ?></th>
					<?php
					}
				}
				?>
			</tr>
			</thead>
			<tbody>
			</tbody>
		</table>
		<div class="modal fade" id="notesFilterModal" tabindex="-1" role="dialog" aria-labelledby="notesFilterModal" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">

			<form class="filter_by_notes" name="filter_by_notes" id="filter_by_notes">
				<div class="modal-body">
					<div class="form-group">
						<label for="filter_by_condition">Filter by condition</label>
						<select class="form-control" name="filter_condition_type" id="filter_condition_value">
							<option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
							<option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
							<option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
							<option value="contains_text"><?php _e('Contains Text', CIP_TXTDOMAIN); ?></option>
							<option value="does_not_contains_text"><?php _e('Does not Contains Text', CIP_TXTDOMAIN); ?></option>
							<option value="starts_with"><?php _e('Starts with', CIP_TXTDOMAIN); ?></option>
							<option value="ends_with"><?php _e('Ends with', CIP_TXTDOMAIN); ?></option>
							<option value="is_exactly"><?php _e('Is exactly', CIP_TXTDOMAIN); ?></option>
						</select>
						<input type="text" class="form-control mt-2" name="filter_condition_value" id="filter_condition_value" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
					</div>
				</div>
				<div class="modal-footer">
		        	<button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
		        	<button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
				</div>
			</form>
		    </div>
		  </div>
		</div>

		<div class="modal fade" id="poolRefFilterModal" tabindex="-1" role="dialog" aria-labelledby="poolRefFilterModal" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">

			<form class="filter_by_pool_ref" name="filter_by_pool_ref" id="filter_by_pool_ref">
				<div class="modal-body">
					<div class="form-group">
						<label for="filter_by_condition_pool_ref">Filter by condition</label>
						<select class="form-control" name="filter_condition_type_pool_ref" id="filter_condition_type_pool_ref">
							<option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
							<option value="is_exactly_simple"><?php _e('Is exactly (multiple)', CIP_TXTDOMAIN); ?></option>
							<option value="is_exactly"><?php _e('Is exactly adv. (multiple)', CIP_TXTDOMAIN); ?></option>
						</select>
						<textarea name="filter_condition_value_pool_ref_bulk" id="filter_condition_value_pool_ref_bulk" class="form-control mt-2" style="display: none;" rows="3" placeholder="<?php _e('Bulk Pool Reference', CIP_TXTDOMAIN ); ?>"></textarea>
						<select class="form-control mt-2" style="width:100%" name="filter_condition_value_pool_ref[]" id="filter_condition_value_pool_ref" multiple></select>
					</div>
				</div>
				<div class="modal-footer">
		        	<button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
		        	<button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
				</div>
			</form>
		    </div>
		  </div>
		</div>

		<div class="modal fade" id="DistributionWeekFilterModal" tabindex="-1" role="dialog" aria-labelledby="DistributionWeekFilterModal" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">

				<form class="filter_by_distribution_week" name="filter_by_distribution_week" id="filter_by_distribution_week">
					<div class="modal-body">
						<div class="form-group">
							<label for="filter_by_condition_distribution_week">Filter by condition</label>
							<select class="form-control" name="filter_condition_type_distribution_week" id="filter_condition_type_distribution_week">
								<option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
								<option value="weeks_before"><?php _e('Weeks Before', CIP_TXTDOMAIN); ?></option>
								<option value="is_exactly_simple"><?php _e('Is exactly (multiple)', CIP_TXTDOMAIN); ?></option>
								<option value="is_exactly"><?php _e('Is exactly adv. (multiple)', CIP_TXTDOMAIN); ?></option>
							</select>
							<input type="text" class="form-control mt-2" name="filter_condition_value_distribution_week_before" id="filter_condition_value_distribution_week_before" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
							<textarea name="filter_condition_value_distribution_bulk" id="filter_condition_value_distribution_bulk" class="form-control mt-2" style="display: none;" rows="3" placeholder="<?php _e('Bulk Distribution Week', CIP_TXTDOMAIN ); ?>"></textarea>
							<select class="form-control mt-2" style="width:100%" name="filter_condition_value_distribution_week[]" id="filter_condition_value_distribution_week" multiple></select>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
						<button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
					</div>
				</form>
		    </div>
		  </div>
		</div>

		<div class="modal fade" id="UsernameFilterModal" tabindex="-1" role="dialog" aria-labelledby="UsernameFilterModal" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">

				<form class="filter_by_username" name="filter_by_username" id="filter_by_username">
					<div class="modal-body">
						<div class="form-group">
							<label for="filter_by_condition_username">Filter by condition</label>
							<select class="form-control" name="filter_condition_type_username" id="filter_condition_type_username">
								<option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
								<option value="is_exactly_simple"><?php _e('Is exactly (multiple)', CIP_TXTDOMAIN); ?></option>
								<option value="is_exactly"><?php _e('Is exactly adv. (multiple)', CIP_TXTDOMAIN); ?></option>
							</select>
							<textarea name="filter_condition_value_username_bulk" id="filter_condition_value_username_bulk" class="form-control mt-2" style="display: none;" rows="3" placeholder="<?php _e('Bulk Usernames', CIP_TXTDOMAIN ); ?>"></textarea>
							<select class="form-control mt-2" style="width:100%" name="filter_condition_value_username[]" id="filter_condition_value_username" multiple></select>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
						<button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
					</div>
				</form>
		    </div>
		  </div>
		</div>
		<div class="modal fade" id="csrDeliveryModal" tabindex="-1" role="dialog" aria-hidden="true">
			<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-body">
						<div class="container-fluid">
							<span class="withdrawal_close_btn close" data-dismiss="modal">&times;</span>
							<div class="csrDeliveryBody"></div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="modal fade" id="csrDeliveryToSavingModal" tabindex="-1" role="dialog" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-body">
						<div class="container-fluid">
							<span class="withdrawal_close_btn close" data-dismiss="modal">&times;</span>
							<div class="csrDeliveryToSavingBody"></div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="modal fade" id="viewMoreModal" tabindex="-1" role="dialog" aria-labelledby="viewMoreModalTitle" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">
		      <div class="modal-body">
		      </div>
		      <div class="modal-footer">
		        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
		      </div>
		    </div>
		  </div>
		</div>
		</div>
	</div>
	<?php
	}else{
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CSR-WALLET-DELIVERY-REPORT', 'csr_wallet_delivery_report_callback');
function csr_wallet_delivery_report_callback(){
	$html = "";
	if( is_user_logged_in() && ( current_user_can('supportmanager') || current_user_can('supportagent') ) ){
		global $wpdb;
		$_SESSION['sessionSelectionData'] = array();
		wp_enqueue_style( 'cip-css' );
		wp_enqueue_style( 'bs-table' );
		wp_enqueue_style( 'bs-sticky-header' );
		wp_enqueue_style( 'daterangepicker-style' );
		wp_enqueue_script('bs-table');
		wp_enqueue_script('bs-sticky-header');
		wp_enqueue_script('bs-table-filter-control');
		wp_enqueue_script('dr-moment');
		wp_enqueue_script('daterangepicker-script');
		wp_enqueue_style( 'select2' );
		wp_enqueue_script('select2');
		ob_start();
		?>
		<div class="container-fluid wallet_delivery_frm">
		<div class="table-responsive">
		<?php
			$user_id = get_current_user_id();
			if( !metadata_exists( 'user', $user_id, 'cip_sagent_toggle_columns' ) ){
				$columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
				update_user_meta( $user_id, 'cip_sagent_toggle_columns', $columnsSAColumnOption );
			}
			$saUserData = get_user_by( 'id', $user_id );
			global $defaultColumnsArr;
			if( $saUserData && ( in_array( "supportagent", $saUserData->roles ) || in_array( "supportmanager", $saUserData->roles ) ) ){
				$columnOrders = (array)get_option('cip_sm_column_order');
				$columnsLabelArr = (array)get_option('cip_sm_column_labels');
				$columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
				$columnsSAToggleArr = (array)get_user_meta( $user_id, 'cip_sagent_toggle_columns', true );
				$columnsArr = array();
				if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
					foreach( $columnOrders as $columnOrder ){
						if( isset( $columnsSAToggleArr[$columnOrder] ) ){
							$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
						}
					}
					if( empty( $columnsArr ) ){
						foreach( $columnOrders as $columnOrder ){
							if( isset( $columnsSAColumnOption[$columnOrder] ) ){
								$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
							}
						}
					}
				}else{
					unset( $defaultColumnsArr['imported_by'] );
					unset( $defaultColumnsArr['import_at'] );
					unset( $defaultColumnsArr['last_update_at'] );
					$columnsArr = $defaultColumnsArr;
				}
			}else{
				unset( $defaultColumnsArr['imported_by'] );
				unset( $defaultColumnsArr['import_at'] );
				unset( $defaultColumnsArr['last_update_at'] );
				$columnsArr = $defaultColumnsArr;
			}
			$columnsArrNew['note_8'] = __('Delivery Batch Id', CIP_TXTDOMAIN);
			// $columnsArrNew['note_9'] = __('Delivery Reference Id', CIP_TXTDOMAIN);
			$columnsArr = $columnsArrNew + $columnsArr;
		?>
		<button type="button" class="btn btn-primary csr_delivery_report_download"><i class="fa fa-download"></i></button>
		<table id="tokenholder_wallet_delivery_report" data-toolbar="false" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" class="table table-bordered" data-side-pagination="server" data-page-size="20" data-page-list="[20, 30, 50, 100]" data-query-params="queryParams">
			<thead>
			<tr>
				<th data-field="id" class="id"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
				<?php
				if( $columnsArr ){
					foreach( $columnsArr as $columnKey => $columnsVal ){
						$filter_attr = 'data-filter-control="input"';
						$filterData_attr = '';
						if( $columnKey == '_user_status' || $columnKey == 'kyc_status' || $columnKey == 'corp_approved' || $columnKey == 'token' ){
							if( $columnKey == '_user_status' ){
								$filterData_attr = ' data-filter-data="var:filterUserStatus"';
							}
							if( $columnKey == 'kyc_status' ){
								$filterData_attr = ' data-filter-data="var:filterKycStatus"';
							}
							if( $columnKey == 'corp_approved' ){
								$filterData_attr = ' data-filter-data="var:filterCorpApproved"';
							}
							if( $columnKey == 'token' ){
								$filter_attr = 'data-filter-control="select" data-filter-data="var:withdrawalProcessToken"';
							}
							$filter_attr = 'data-filter-control="select" class="status" data-filter-custom-search="BsTableFilterStatus"'.$filterData_attr;
						}
					?>
					<th data-field="<?php echo $columnKey ?>" data-sortable="true" <?php echo $filter_attr; ?> class="<?php echo $columnKey ?>"><?php echo $columnsVal; ?></th>
					<?php
					}
				}
				?>
			</tr>
			</thead>
			<tbody>
			</tbody>
		</table>
		<div class="modal fade" id="notesFilterModal" tabindex="-1" role="dialog" aria-labelledby="notesFilterModal" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">

			<form class="filter_by_notes" name="filter_by_notes" id="filter_by_notes">
				<div class="modal-body">
					<div class="form-group">
						<label for="filter_by_condition">Filter by condition</label>
						<select class="form-control" name="filter_condition_type" id="filter_condition_value">
							<option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
							<option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
							<option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
							<option value="contains_text"><?php _e('Contains Text', CIP_TXTDOMAIN); ?></option>
							<option value="does_not_contains_text"><?php _e('Does not Contains Text', CIP_TXTDOMAIN); ?></option>
							<option value="starts_with"><?php _e('Starts with', CIP_TXTDOMAIN); ?></option>
							<option value="ends_with"><?php _e('Ends with', CIP_TXTDOMAIN); ?></option>
							<option value="is_exactly"><?php _e('Is exactly', CIP_TXTDOMAIN); ?></option>
						</select>
						<input type="text" class="form-control mt-2" name="filter_condition_value" id="filter_condition_value" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
					</div>
				</div>
				<div class="modal-footer">
		        	<button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
		        	<button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
				</div>
			</form>
		    </div>
		  </div>
		</div>

		<div class="modal fade" id="poolRefFilterModal" tabindex="-1" role="dialog" aria-labelledby="poolRefFilterModal" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">

			<form class="filter_by_pool_ref" name="filter_by_pool_ref" id="filter_by_pool_ref">
				<div class="modal-body">
					<div class="form-group">
						<label for="filter_by_condition_pool_ref">Filter by condition</label>
						<select class="form-control" name="filter_condition_type_pool_ref" id="filter_condition_type_pool_ref">
							<option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
							<option value="is_exactly_simple"><?php _e('Is exactly (multiple)', CIP_TXTDOMAIN); ?></option>
							<option value="is_exactly"><?php _e('Is exactly adv. (multiple)', CIP_TXTDOMAIN); ?></option>
						</select>
						<textarea name="filter_condition_value_pool_ref_bulk" id="filter_condition_value_pool_ref_bulk" class="form-control mt-2" style="display: none;" rows="3" placeholder="<?php _e('Bulk Pool Reference', CIP_TXTDOMAIN ); ?>"></textarea>
						<select class="form-control mt-2" style="width:100%" name="filter_condition_value_pool_ref[]" id="filter_condition_value_pool_ref" multiple></select>
					</div>
				</div>
				<div class="modal-footer">
		        	<button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
		        	<button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
				</div>
			</form>
		    </div>
		  </div>
		</div>

		<div class="modal fade" id="DistributionWeekFilterModal" tabindex="-1" role="dialog" aria-labelledby="DistributionWeekFilterModal" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">

				<form class="filter_by_distribution_week" name="filter_by_distribution_week" id="filter_by_distribution_week">
					<div class="modal-body">
						<div class="form-group">
							<label for="filter_by_condition_distribution_week">Filter by condition</label>
							<select class="form-control" name="filter_condition_type_distribution_week" id="filter_condition_type_distribution_week">
								<option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
								<option value="weeks_before"><?php _e('Weeks Before', CIP_TXTDOMAIN); ?></option>
								<option value="is_exactly_simple"><?php _e('Is exactly (multiple)', CIP_TXTDOMAIN); ?></option>
								<option value="is_exactly"><?php _e('Is exactly adv. (multiple)', CIP_TXTDOMAIN); ?></option>
							</select>
							<input type="text" class="form-control mt-2" name="filter_condition_value_distribution_week_before" id="filter_condition_value_distribution_week_before" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
							<textarea name="filter_condition_value_distribution_bulk" id="filter_condition_value_distribution_bulk" class="form-control mt-2" style="display: none;" rows="3" placeholder="<?php _e('Bulk Distribution Week', CIP_TXTDOMAIN ); ?>"></textarea>
							<select class="form-control mt-2" style="width:100%" name="filter_condition_value_distribution_week[]" id="filter_condition_value_distribution_week" multiple></select>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
						<button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
					</div>
				</form>
		    </div>
		  </div>
		</div>

		<div class="modal fade" id="UsernameFilterModal" tabindex="-1" role="dialog" aria-labelledby="UsernameFilterModal" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">

				<form class="filter_by_username" name="filter_by_username" id="filter_by_username">
					<div class="modal-body">
						<div class="form-group">
							<label for="filter_by_condition_username">Filter by condition</label>
							<select class="form-control" name="filter_condition_type_username" id="filter_condition_type_username">
								<option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
								<option value="is_exactly_simple"><?php _e('Is exactly (multiple)', CIP_TXTDOMAIN); ?></option>
								<option value="is_exactly"><?php _e('Is exactly adv. (multiple)', CIP_TXTDOMAIN); ?></option>
							</select>
							<textarea name="filter_condition_value_username_bulk" id="filter_condition_value_username_bulk" class="form-control mt-2" style="display: none;" rows="3" placeholder="<?php _e('Bulk Usernames', CIP_TXTDOMAIN ); ?>"></textarea>
							<select class="form-control mt-2" style="width:100%" name="filter_condition_value_username[]" id="filter_condition_value_username" multiple></select>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
						<button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
					</div>
				</form>
		    </div>
		  </div>
		</div>
		<div class="modal fade" id="viewMoreModal" tabindex="-1" role="dialog" aria-labelledby="viewMoreModalTitle" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">
		      <div class="modal-body">
		      </div>
		      <div class="modal-footer">
		        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
		      </div>
		    </div>
		  </div>
		</div>
		</div>
	</div>
	<?php
	}else{
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CSR-PARTIAL-WALLET-DELIVERY', 'csr_partial_wallet_delivery_callback');
function csr_partial_wallet_delivery_callback(){
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	if( $_POST['action'] == 'partialdelivery' && wp_verify_nonce( $_POST['_micro'], '_CIPxYPartialDeliveryYxCIP_' ) && ( current_user_can( 'supportmanager' ) || current_user_can( 'supportagent' ) ) ){

		global $wpdb;
		$sessionSelectionDataEncrypt = ( isset( $_SESSION['sessionSelectionData'] ) && !empty( $_SESSION['sessionSelectionData'] ) ) ? $_SESSION['sessionSelectionData'] : array();
		$sessionSelectionData = array();
		if( !empty( $sessionSelectionDataEncrypt ) ){
			foreach( $sessionSelectionDataEncrypt as $encryptId ){
				$decryptedIdRaw = base64_decode( $encryptId );
				$decryptedUserId = preg_replace(sprintf('/%s/', md5('CIP_WDSELECTION_PIC') ), '', $decryptedIdRaw);
				$sessionSelectionData[] = $decryptedUserId;
			}
		}

		$partialDeliveryIdsEncrypt = explode( ',', $_POST['partialDeliveryIds'] );
		$partialDeliveryIds = array();
		if( !empty( $partialDeliveryIdsEncrypt ) ){
			foreach( $partialDeliveryIdsEncrypt as $encryptId ){
				$decryptedIdRaw = base64_decode( $encryptId );
				$decryptedUserId = preg_replace(sprintf('/%s/', md5('CIP_WDSELECTION_PIC') ), '', $decryptedIdRaw);
				$partialDeliveryIds[] = $decryptedUserId;
			}
		}


		$partialDeliveryFinalIds = array();
		$isSelectAll = $_POST['isSelectAll'];

		if( !empty( $sessionSelectionData ) ){
			if( $isSelectAll == 1 ){
				foreach( $partialDeliveryIds as $partialDeliveryId ){
					if( !in_array( $partialDeliveryId, $sessionSelectionData ) ){
						$partialDeliveryFinalIds[] = $partialDeliveryId;
					}
				}
			}else{
				foreach( $partialDeliveryIds as $partialDeliveryId ){
					if( in_array( $partialDeliveryId, $sessionSelectionData ) ){
						$partialDeliveryFinalIds[] = $partialDeliveryId;
					}
				}
			}
		}else{
			$partialDeliveryFinalIds = $partialDeliveryIds;
		}

		$tableTokenHolder = $wpdb->prefix.'token_holder';
		$csrPartialResults = $wpdb->get_results("SELECT * FROM $tableTokenHolder WHERE 1 AND `id` IN (". implode(',', $partialDeliveryFinalIds) .") ORDER BY `id` DESC");

		$user_id = get_current_user_id();
		$saUserData = get_user_by( 'id', $user_id );
		global $defaultColumnsArr;
		if( $saUserData && ( in_array( "supportagent", $saUserData->roles ) || in_array( "supportmanager", $saUserData->roles ) ) ){
			$columnOrders = (array)get_option('cip_sm_column_order');
			$columnsLabelArr = (array)get_option('cip_sm_column_labels');
			$columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
			$columnsSAToggleArr = (array)get_user_meta( $user_id, 'cip_sagent_toggle_columns', true );
			$columnsArr = array();
			if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
				foreach( $columnOrders as $columnOrder ){
					if( isset( $columnsSAToggleArr[$columnOrder] ) ){
						$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
					}
				}
				if( empty( $columnsArr ) ){
					foreach( $columnOrders as $columnOrder ){
						if( isset( $columnsSAColumnOption[$columnOrder] ) ){
							$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
						}
					}
				}
			}else{
				unset( $defaultColumnsArr['imported_by'] );
				unset( $defaultColumnsArr['import_at'] );
				unset( $defaultColumnsArr['last_update_at'] );
				$columnsArr = $defaultColumnsArr;
			}

		}else{
			unset( $defaultColumnsArr['imported_by'] );
			unset( $defaultColumnsArr['import_at'] );
			unset( $defaultColumnsArr['last_update_at'] );
			$columnsArr = $defaultColumnsArr;
		}

		?>
		<form name="partialWalletDeliveryFrm" id="partialWalletDeliveryFrm" >
		<button type="button" class="btn btn-primary deliver_now disabled" disabled data-toggle="tooltip" data-placement="top" title="<?php _e('You must complete an allocation of CSR for each row',CIP_TXTDOMAIN); ?>" ><?php _e('Deliver Now', CIP_TXTDOMAIN) ?></button>
		<table id="tokenholder_partial_wallet_delivery" data-filter-control="true" data-show-search-clear-button="false" data-pagination="false" data-sortable="true" data-toggle="table" data-show-columns="true" data-show-columns-toggle-all="true" data-show-toggle="false" data-show-export="false" class="table table-bordered">
			<thead>
			<tr>
				<th data-field="id" class="id"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
				<th data-field="delivery_amount" class="delivery_amount"><?php _e('Delivery Amount',CIP_TXTDOMAIN); ?></th>
				<th data-field="delivery_amount_percentage" class="delivery_amount_percentage"><?php _e('Delivery Amount %',CIP_TXTDOMAIN); ?></th>
				<?php
				if( $columnsArr ){
					foreach( $columnsArr as $columnKey => $columnsVal ){
						$filter_attr = "";
						?>
						<th data-field="<?php echo $columnKey ?>" data-sortable="true" <?php echo $filter_attr; ?> class="<?php echo $columnKey ?>"><?php echo $columnsVal; ?></th>
						<?php
					}
				}
				?>
			</tr>
			</thead>
			<tbody>
			<?php
			$sno=1;
			if( $csrPartialResults ){
				foreach($csrPartialResults as $csrPartialResult){
				$id = $csrPartialResult->id;
				$rowEncryptId = base64_encode( $id . md5('CIP_WDSELECTION_PIC'));
				?>
				<tr data-maxAmount="<?php echo $csrPartialResult->amount_due; ?>">
				<?php
				if( $columnsArr ){
					?>
					<td><?php echo $sno;?></td>
					<td>
						<input type="text" name="delivery_amount[<?php echo $sno; ?>][amount]" class="delivery_amount"/>
						<input type="hidden" name="delivery_amount[<?php echo $sno; ?>][id]" value="<?php echo $rowEncryptId; ?>" />
					</td>
					<td><input type="text" name="delivery_amount[<?php echo $sno; ?>][percentage]" class="delivery_amount_percentage" /></td>
					<?php
					foreach( $columnsArr as $columnKey => $columnsVal ){
						$columnsDataVal = $csrPartialResult->$columnKey;
						$verified = ( $csrPartialResult->sign_verify == 1 ) ? true : false;
						if( $columnKey == 'eth_address' ){
							if( !empty( $columnsDataVal ) ){
								$columnsDataValMask = substr($columnsDataVal, 0, 6) . '...' . substr($columnsDataVal, -6);
								$columnsDataVal = '<a href="https://etherscan.io/address/'. $columnsDataVal . '#tokentxns" target="_blank" data-toggle-tt="tooltip" data-placement="top" title="'.$columnsDataVal.'" >'. $columnsDataValMask . '</a>';
								if( $verified ){ $columnsDataVal .= '<img src="'.CIP_PLUGIN_FOLDER.'/images/verified.png" class="verified_address_sticker" />'; }
							}else{
								$columnsDataVal = '—';
							}
						}
						if( $columnKey == 'notes_internal' || $columnKey == 'notes_external' ){
							$columnsDataVal = cip_trim_notes( $columnsDataVal );
							$columnsDataVal150 = wp_html_excerpt( strip_shortcodes( $columnsDataVal ), 150, '......');
							$columnsDataVal = wp_html_excerpt( strip_shortcodes( $columnsDataVal ), 20, '<a href="javascript:void(0);" class="modelpop_notes" data-toggle="modal" data-target="#viewMoreModal" data-id="'.$csrPartialResult->id.'" data-viewmore="'.wpautop( $columnsDataVal ).'" data-toggle-tt1="tooltip" data-placement1="top" title="'.$columnsDataVal150.'" ><img src="'.CIP_PLUGIN_FOLDER.'/images/view-more.png" class="view-more-notes" /></a>' );
							if( !empty( $columnsDataVal ) ){
								$columnsDataVal = '<div class="width_length_20_hr">' . $columnsDataVal . '</div>';
							}
						}
						if( $columnKey == 'position' ){
							$positionVal = '—';
							$positionText = __('Distribution Position not set... Try back later',CIP_TXTDOMAIN);
							if( $columnsDataVal ){
								$positionVal = $columnsDataVal;
								$positionText = sprintf( __('Distribution Position is set... congratulations you are at position %s in the distribution list',CIP_TXTDOMAIN), $columnsDataVal );
							}
							$columnsDataVal = '<a href="javascript:void(0);" data-id="'.$csrPartialResult->id.'" data-toggle-tt="tooltip" data-placement="top" title="'.$positionText.'" >'.$positionVal.'</a>';
						}
						?>
						<td><?php echo $columnsDataVal; ?></td>
						<?php
					}
					$sno=$sno+1;
				}
				?>
				</tr>
			<?php }
			}
			?>
			</tbody>
		</table>
		<div class="modal fade" id="partialDeliveryG2FAModal" tabindex="-1" role="dialog" aria-labelledby="partialDeliveryG2FAModalTitle" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
					<div class="modal-body">
						<div class="partially_delivery_summary_section">
							<h6 class="mb-1">CSR Partially Delivery Summary</h6>
							<p class="text-left mb-1 amount"> Total Amount: <span></span> </p>
							<p class="text-left mb-1 rows"> Rows to update: <span></span> </p>
						</div>
						<div class="otp_section pb-3">
							<label for="sasm_ga_otp"><?php echo __('Please enter the authentication code', CIP_TXTDOMAIN); ?></label>
							<input type="text" name="partial_deliver_ga_otp" id="partial_deliver_ga_otp" class="input mb-1" maxlength="6" pattern="{0-9}+" />
							<small class="form-text text-muted"><?php _e('Enter the 6-digit code generated by the Authenticator App.') ?></small>
						</div>
						<input type="submit" class="btn btn-primary" name="submit" value="<?php _e('Deliver', CIP_TXTDOMAIN); ?>" />
						<input type="button" name="cancel" class="btn btn-primary" data-dismiss="modal" value="<?php _e('Cancel', CIP_TXTDOMAIN); ?>" />
					</div>
				</div>
			</div>
		</div>
		<input type="hidden" name="action" value="partialDeliverNowAct" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPXyZ_PartialDeliverNow_ZyXCIP_'); ?>" />
		</form>
		<div class="modal fade" id="viewMoreModal" tabindex="-1" role="dialog" aria-labelledby="viewMoreModalTitle" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-body">
				</div>
				<div class="modal-footer">
				<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
				</div>
			</div>
			</div>
		</div>
		<?php
		/* echo "<pre>";
		print_r( $sessionSelectionData );
		print_r( $partialDeliveryIds );
		print_r( $partialDeliveryFinalIds );
		print_r( $_POST );
		echo "</pre>"; */
	}
}
add_shortcode('CIP-SMSA-AUTH-TYPE', 'cip_smsa_auth_type_callback');
function cip_smsa_auth_type_callback(){
	wp_enqueue_style( 'cip-css' );
	$html = "";
	$current_user = wp_get_current_user();
	$user_id = $current_user->ID;
	ob_start();
	if( is_user_logged_in() && ( current_user_can('supportmanager') || current_user_can('supportagent') || current_user_can('administrator') ) ){
		$current_user = wp_get_current_user();
		$google_auth_key = get_user_meta( $user_id, 'google_auth_key', true );
		$google_auth_key_login = get_user_meta( $user_id, 'google_auth_key_login', true );
		$google_auth_key_walletdelivery = get_user_meta( $user_id, 'google_auth_key_walletdelivery', true );
		$total_step = 4;

		$ga2fa_login_enabled = ( !empty( $google_auth_key ) && $google_auth_key_login == 1 ) ? 1 : 0;
		$ga2fa_delivery_enabled = ( !empty( $google_auth_key ) && $google_auth_key_walletdelivery == 1 ) ? 1 : 0;
	?>
	<div class="row">
		<div class="col-md-12">
			<div class="shadow p-3 bg-white rounded">

				<form id="users_login_authentication_option" name="users_login_authentication_option">
					<h5><?php _e('2 Factor Authentication', 'corsair-login'); ?><p><small class="text-muted"><?php _e('Improve your account security by enabling additional security measures.', 'corsair-login'); ?></small></p></h5><br/>
					<div class="2fa_ga_section">
					<h5><?php _e('Google Authenticator 2FA', 'corsair-login'); ?></h5>
					<div class="m-10">
						<div class="card-">
		
							<?php if( empty( $google_auth_key ) ){ ?>
								<p class="card-text"><?php _e('Google authenticator app is required and available for download in the next step.') ?></p>
							<?php } ?>
							<div class="" style="padding-top: 0 !important;">
		
								<div class="custom-control custom-checkbox mb-3">
									<input type="checkbox" class="custom-control-input" data-_micro="<?php echo wp_create_nonce('_SMSALOGIN2FAMicro_'); ?>" <?php checked( 1, $ga2fa_login_enabled, true ); ?> disabled />
									<label class="custom-control-label pt-1" for="ga2fa_smsa_login"><?php _e('Login', 'corsair-login'); ?></label>
								</div>
		
								<div class="custom-control custom-checkbox mb-3">
									<input type="checkbox" class="custom-control-input" data-_micro="<?php echo wp_create_nonce('_WalletDelivery2FAMicro_'); ?>" <?php checked( 1, $ga2fa_delivery_enabled, true ); ?> disabled />
									<label class="custom-control-label pt-1" for="ga2fa_walletdelivery"><?php _e('CSR Wallet Delivery', 'corsair-login'); ?></label>
								</div>
								<input type="hidden" name="_micro" id="toggle2famicro" value="<?php echo wp_create_nonce('_CL_Toogle2FAMicroWallertDelivery_LC_'); ?>" />
		
								<?php if( empty( $google_auth_key ) || $google_auth_key_login != 1 || $google_auth_key_walletdelivery != 1 ){ ?>
									<button type="button" class="btn btn-primary" id="enable_smsa_ga2fa_modal" data-toggle="modal" data-target="#enableSmSaGa2faModal"><?php _e('Enable', 'corsair-login'); ?></button>
								<?php } ?>
								<?php /*if( !empty( $google_auth_key ) ){ ?>
									<button type="button" class="btn btn-primary" id="disable_smsa_ga2fa_modal" data-toggle="modal" data-target="#disableSmSaGa2faModal"><?php _e('Disable', 'corsair-login'); ?></button>
								<?php }*/ ?>
		
								<?php if( empty( $google_auth_key ) || $google_auth_key_login != 1 || $google_auth_key_walletdelivery != 1 ){ ?>
								<h6 class="text-danger"><?php _e('Please activate Google Authenticator 2FA', CIP_TXTDOMAIN); ?></h6>
								<?php } ?>
		
							</div>
						</div>
					</div>
					</div>
					<input type="hidden" name="action" value="smsa_delivery_auth_options_act" />
					<input type="hidden" name="_micro" value="<?php echo wp_create_nonce( '_SMSA_Delivery_AuthenticatioN_OPTION_' ); ?>" />
				</form>
			</div>
		</div>
	</div>
	<?php if( empty( $google_auth_key ) ){ ?>
	<div class="modal fade" id="enableSmSaGa2faModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
			<div class="modal-content">
				<div class="modal-body">
				<div class="container-fluid">
					<span class="withdrawal_close_btn close" data-dismiss="modal">&times;</span>
					<div class="row justify-content-center">
						<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 text-center p-0 mt-0 mb-2">
							<div class="card-">
								<form name="smsaGa2faEnableFrm" class="smsaGa2faEnableFrm" id="msform">
								<!-- progressbar -->
									<ul id="progressbar" class="mb-3">
										<li class="active" id="fieldmapping"><strong><?php _e('Download App','corsair-login') ?></strong></li>
										<li id="fieldmapping"><strong><?php _e('Scan QR Code','corsair-login') ?></strong></li>
										<li id="fieldmapping"><strong><?php _e('Enable Google Authenticator','corsair-login') ?></strong></li>
										<li id="fieldmapping"><strong><?php _e('Complete','corsair-login') ?></strong></li>
									</ul>
									<div class="progress">
										<div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
									</div>
									<br> <!-- fieldsets -->
									<fieldset class="step_0">
										<div class="form-card">
											<div class="row">
												<div class="col-12">
													<p class="steps"><?php echo sprintf('Step %s - %s', 1, $total_step); ?></p>
												</div>
											</div>

											<div class="row text-center justify-content-center">
												<div class="col-lg-8 col-10 pt-24">
													<h3 class="text-center"><?php _e('Download and install the Authenticator app', CIP_TXTDOMAIN ); ?></h3>
													<br>
													<div class=" row">
														<div class="col-sm-6 text-center">
															<img src="<?php echo CIP_PLUGIN_FOLDER;?>/assets/app-store-ga-qr-code.png">
															<p class="main_heading text-center"><?php _e('App Store', CIP_TXTDOMAIN ); ?></p>
														</div>
														<div class="col-sm-6 text-center">
															<img src="<?php echo CIP_PLUGIN_FOLDER;?>/assets/google-play-store-ga-qr.png">
															<p class="main_heading text-center"><?php _e('Android APK', CIP_TXTDOMAIN ); ?></p>
														</div>
													</div>
													<div class="row">
														<div class="col-sm-12">
															<p class="text-center mt-3"><b><?php _e('Scan to Download', CIP_TXTDOMAIN ); ?></b> <?php _e('iOS and Android', CIP_TXTDOMAIN ); ?></p>
														</div>
													</div>
													<br>
												</div>
                                    		</div>
										</div>
										<input type="button" name="next" class="next_wdga action-button" value="Next" />
									</fieldset>

									<fieldset class="step_1">
										<div class="form-card">
											<div class="row">
												<div class="col-12">
													<p class="steps mb-0"><?php echo sprintf('Step %s - %s', 2, $total_step); ?></p>
												</div>
											</div>
											<div class="row text-center justify-content-center">
											<?php
												$siteUrl = get_bloginfo('url');
												$siteUrlName = trim( str_replace( array( 'http://', 'https://' ), '', $siteUrl ), '/' );
												$google2fa = new \PragmaRX\Google2FA\Google2FA();
												$secret_key = $google2fa->generateSecretKey();
												$qr = $google2fa->getQRCodeUrl( $siteUrlName, $current_user->user_email, $secret_key );
												// $image_url = 'https://chart.googleapis.com/chart?cht=qr&chs=250x250&chl='.$qr;
												$_SESSION['google_auth_key'] = $secret_key;
												$image_url = add_query_arg( array(
													'qr'	=>	$qr,
													'action' => 'google2fa_qrcode',
												), admin_url('admin-ajax.php') );
											?>
											<input type="hidden" name="google_auth_key" id="google_auth_key" value="<?php echo $secret_key; ?>" />
											<div class="col-12">
												<h3 class="fs-title text-center main_heading mb-0"><?php _e('Scan this QR Code in the Authenticator app', 'corsair-login'); ?></h3>
												<img style="padding: 30px;" src="<?php echo $image_url; ?>" />
											</div>
											</div>
											<div class="row text-center justify-content-center">
												<div class="col-sm-8 pt-24">
													<h3 class="fs-title text-center main_heading"><?php _e('Save this Backup Key in secure location', 'corsair-login'); ?></h3>
												<p class="csr_color text-center"> <strong><?php echo $secret_key; ?></strong></p>
												<p class="text-center"><?php _e('If you are unable to scan the Qr Code, Please enter this code manually into the app', 'corsair-login'); ?></p>
												<div class="text-center">
													<p class="text-center mb-0"><?php _e('This key will allow you to recover your Authenticator, if you lose your phone. Otherwise, resetting Google Authenticator will take at least 7 days.', 'corsair-login'); ?></p>
												</div>
											</div>
											</div>
										</div>
										<input type="button" name="next" class="next_wdga action-button" value="Next" /> <input type="button" name="previous" class="previous_wdga action-button-previous" value="Previous" />
									</fieldset>
									<fieldset class="step_2">
										<div class="form-card">
											<div class="row">
												<div class="col-12">
													<p class="steps"><?php echo sprintf('Step %s - %s', 3, $total_step); ?></p>
												</div>
											</div>

											<div class="row justify-content-center">
											<div class="col-12">
												<h3 class="fs-title text-center main_heading"><?php _e('Enable Authenticator by verifying your account', 'corsair-login'); ?></h3>
												<div class="form-group">
													<label for="backupkey"><?php _e('Enter Backup Key', 'corsair-login'); ?></label>
													<div class="input-group-append align-items-center" id="show_hide_password">
														<input class="form-control" type="password" name="key" id="backupkey" />
														<div class="input-group-addon pl-1 pr-1"><a href="javascript:void(0);"><i class="fa fa-eye-slash" aria-hidden="true"></i></a></div>
													</div>
												</div>
												<div class="form-group">
													<label for="backupkey"><?php _e('Enter the 6-digit code generated by the Authenticator App.', 'corsair-login'); ?></label>
													<input type="number" class="form-control" name="code" placeholder="" id="init-code" maxlength="6">

												</div>
											</div>
											</div>
										</div>
										<input type="button" name="next" class="next_wdga action-button" value="Next" /> <input type="button" name="previous" class="previous_wdga action-button-previous" value="Previous" />
									</fieldset>
									<fieldset class="step_3">
										<div class="form-card">
											<div class="row">
												<div class="col-12">
													<p class="steps"><?php echo sprintf('Step %s - %s', 4, $total_step); ?></p>
												</div>
											</div>
										</div>
										<input type="button" name="next" class="next_wdga action-button" value="Submit" /> <input type="button" name="previous" class="previous_wdga action-button-previous" value="Previous" />
									</fieldset>
									<input type="hidden" name="action" value="googleAuth2FAWalletDeliveryactivationAct" />
									<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPGoogleAuthenticatorWalletDeliveryEnablingCIP_'); ?>" />
								</form>
							</div>
						</div>
					</div>
				</div>
				</div>
			</div>
		</div>
	</div>
	<?php }else if( !empty( $google_auth_key ) ){ ?>
	<div class="modal fade" id="disableSmSaGa2faModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-body">
				<div class="container-fluid">
					<div class="row">
						<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 p-0 mt-2 mb-2">
							<div class="card-">
								<form name="SmSaga2faDisableFrm" class="SmSaga2faDisableFrm">
									<div class="row">
										<div class="col-12">
											<p class="text-center main_heading"><b><?php _e('Disable Google 2FA', 'corsair-login'); ?></b></p>
											<div class="form-group">
												<label for="verify-code"><?php _e('Enter the 6-digit code generated by the Authenticator App.', 'corsair-login'); ?></label>
												<input type="number" class="form-control" name="code" placeholder="" id="verify-code" maxlength="6">

											</div>
											<input type="submit" name="submit" class="action-button" value="<?php _e('Confirm', 'corsair-login'); ?>" />
											<input type="button" name="cancel" class="action-button" data-dismiss="modal" value="<?php _e('Cancel', 'corsair-login'); ?>" />
										</div>
									</div>
									<input type="hidden" name="action" value="SmSagoogleAuth2FADeactivateAct" />
									<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPSmSaGoogleAuthenticatorDisablingCIP_'); ?>" />
								</form>
							</div>
						</div>
					</div>
				</div>
				</div>
			</div>
		</div>
	</div>
	<div class="modal fade" id="toggleSaSmGa2faModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-body">
				<div class="container-fluid">
					<div class="row">
						<div class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12 p-0 mt-2 mb-2">
							<div class="card-">
								<form name="SmSaga2faToggleFrm" class="SmSaga2faToggleFrm">
									<div class="row">
										<div class="col-12">
											<p class="text-center main_heading"><b><?php _e('', 'corsair-login'); ?></b></p>
											<div class="form-group">
												<label for="verify-code"><?php _e('Enter the 6-digit code generated by the Authenticator App.', 'corsair-login'); ?></label>
												<input type="number" class="form-control" name="code" placeholder="" id="verify-code" maxlength="6">
											</div>
											<input type="submit" name="submit" class="action-button" value="<?php _e('Confirm', 'corsair-login'); ?>" />
											<input type="button" name="cancel" class="action-button" data-dismiss="modal" value="<?php _e('Cancel', 'corsair-login'); ?>" />
										</div>
									</div>
									<input type="hidden" name="action" value="toggle_for_smsa_ga_twofa" />
									<input type="hidden" name="_micro" id="toggle2famicro" value="<?php echo wp_create_nonce('_CL_Toogle2FAMicroSaSm_LC_'); ?>" />
								</form>
							</div>
						</div>
					</div>
				</div>
				</div>
			</div>
		</div>
	</div>
	<?php
	}
	}
	$html .= ob_get_clean();
	return $html;
}
//5759
add_shortcode('WITHDRAWAL-SUSPENSION-SETTING', 'withdrawal_suspension_setting_callback');
function withdrawal_suspension_setting_callback(){
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-datepicker' );
	wp_enqueue_script('bs-datepicker');
	wp_enqueue_script( 'jquery.inputmask' );
	$html = "";
	$current_user = wp_get_current_user();
	$user_id = $current_user->ID;
	global $wpdb;

	$tableKycData = $wpdb->prefix.'kyc_data';
	$refAccount = ( isset( $_SESSION['refAccount'] ) ) ? $_SESSION['refAccount'] : '-';
	$whereEmail = "`email` = '".$refAccount."' AND `email` IS NOT NULL AND `email` != ''";
	$withdrawal_suspension = get_user_meta( $user_id, 'withdrawal_suspension_5_minute', true );
	$withdrawal_suspension_enable = ( $withdrawal_suspension == 'disable' ) ? 0 : 1;
	$checkKycStatus = $wpdb->get_row("SELECT COUNT(*) as `kyc_status_count` FROM $tableKycData WHERE $whereEmail AND `status`='approved'");
	$isKycApproved = false;
	if( $checkKycStatus->kyc_status_count > 0 ){
		$isKycApproved = true;
	}
	ob_start();
	if( is_user_logged_in() && current_user_can('member') && $isKycApproved ){
		$withdrawal_suspension_min = get_withdrawal_suspension_option( 'min' );
	?>
	<div class="row withdrawal_suspension_container">
		<div class="col-md-12 shadow p-3 bg-white rounded">
			<form id="withdrawal_suspension_frm" name="withdrawal_suspension_frm">
			<div class="withdrawal_suspension_section">
				<div class="m-10">
					<div class="card-">
						<div class="" style="padding-top: 0 !important;">
							<h6 class="card-text"><strong><?php _e('Withdrawal suspension', CIP_TXTDOMAIN) ?></strong></h6>
						</div>
						<hr class="mt-3"/>
						<div class="d-flex mt-1 align-content-center">
							<div  style="padding-top: 6px !important;">
								<div class="custom-control custom-checkbox">
									<input type="checkbox" class="custom-control-input" name="withdrawal_suspension" id="withdrawal_suspension" value="1" <?php checked( 1, $withdrawal_suspension_enable, true ); ?>>
									<label class="custom-control-label" for="withdrawal_suspension"></label>
								</div>
							</div>
							<div>
							<h6 class="mb-0"><?php _e('Suspend withdrawals for '. $withdrawal_suspension_min  .' minutes after login.', 'corsair-login'); ?><p class="mb-0"><small class="text-muted"><?php _e('Upon every login, you will not be able to make a withdrawal for ' . $withdrawal_suspension_min  . ' minutes.', 'corsair-login'); ?></small></p></h6>
							</div>

						</div>
					</div>
				</div>
			</div>
			<input type="hidden" name="action" value="toggleWithdrawalSuspensionAction" />
			<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_YxWithdrawalSuspensionTogglexY_') ?>" />
			</form>
		</div>
	</div>
	<div class="modal fade" id="disableWithdrawalSuspensionModal" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered" role="document">
			<div class="modal-content">
		  		<div class="modal-body">
					<form name="disable_withdrawal_suspension_frm" class="disable_withdrawal_suspension_frm" id="disable_withdrawal_suspension_frm">
						<div class="container-fluid">
							<span class="withdrawal_close_btn close" data-dismiss="modal">&times;</span>
					  		<div class="row"><div class="col-12"><h5><?php _e('Disable Withdrawal Suspension', CIP_TXTDOMAIN); ?></h5></div></div>
							<div class="disable_withdrawal_suspension_section">
								<div class="row">
									<div class="col-12">
										<div class="otp_response_section"></div>
										<div class="ga_response_section"></div>
									</div>
								</div>
								<div class="row">
									<div class="col-12">
										<button type="submit" name="submit"><?php _e('Submit', CIP_TXTDOMAIN); ?></button>
									</div>
								</div>
							</div>
						</div>
						<input type="hidden" name="action" value="disable_withdrawal_suspension_act" />
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIP321_DISABLE_WITHDRAWAL_SUSPENSION_123PIC_'); ?>" />
					</form>
		  		</div>
			</div>
	  	</div>
	</div>
	<?php
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('MY-CSR-WALLET-TRANSACTION-TABLE', 'my_csr_wallet_transaction_table_callback');
function my_csr_wallet_transaction_table_callback(){
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'daterangepicker-style' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('dr-moment');
	wp_enqueue_script('daterangepicker-script');
	$html = "";
	ob_start();
	global $wpdb;
	if( current_user_can('member') ){
	?>
	<div class="csr_transaction_history_section">
	<h5 class="csr_central_title"><?php _e('CSR Wallet Transactions', CIP_TXTDOMAIN); ?> <span class="fa fa-info-circle" data-toggle="tooltip" data-placement="top" title="<?php _e('CSR Wallet Transactions do not include any transactions prior to the launch of CSR Central', CIP_TXTDOMAIN); ?>"></span></h5>

	<div class="text-left mb-2">
		<button type="button" class="toggle_transaction_history_deposit active"><?php _e('Deposit', CIP_TXTDOMAIN); ?></button>
		<button type="button" class="toggle_transaction_history_withdrawals"><?php _e('Withdrawals', CIP_TXTDOMAIN); ?></button>
	</div>
	<div class="deposit_section active">
		<h5 class="text-left"><?php _e('Deposit', CIP_TXTDOMAIN); ?></h5>
		<table id="csr_transaction_history_deposit" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
		<thead>
			<tr>
				<th data-field="token" data-filter-control="select" class="token" data-filter-data="var:withdrawalProcessToken" data-switchable="false"><?php _e('Token',CIP_TXTDOMAIN); ?></th>
				<th data-field="_date" class="_date" data-filter-control="input" data-switchable="false"><?php _e('Time',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Date and time of deposit transaction', CIP_TXTDOMAIN) ); ?></th>
				<th data-field="received_amount" data-filter-control="input" class="received_amount" data-switchable="false"><?php _e('Amount',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Amount of CSR deposited into your CSR Wallet', CIP_TXTDOMAIN) ); ?></th>
				<th data-field="txn_id" data-filter-control="input" class="txn_id" data-switchable="false"><?php _e('Reference',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Reference number of redemption', CIP_TXTDOMAIN) ); ?></th>
				<th data-field="short_description" data-filter-control="input" class="short_description" data-switchable="false"><?php _e('Description',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Description of deposits', CIP_TXTDOMAIN) ); ?></th>
				<th data-field="status" class="status" data-filter-control="input" data-switchable="false"><?php _e('Status',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Status of deposit transaction', CIP_TXTDOMAIN) ); ?></th>
			</tr>
		</thead>
		<tbody>
		</tbody>
		</table>
	</div>
	<div class="withdrawals_section">
		<h5 class="text-left"><?php _e('Withdrawals', CIP_TXTDOMAIN); ?></h5>
		<table id="csr_transaction_history_withdrawals" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
		<thead>
			<tr>
				<th data-field="token" class="token" data-filter-control="select" data-filter-data="var:withdrawalProcessToken" data-switchable="false"><?php _e('Token',CIP_TXTDOMAIN); ?></th>
				<th data-field="_date" class="_date" data-filter-control="input" data-switchable="false"><?php _e('Time',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Date and time of withdrawal application', CIP_TXTDOMAIN) ); ?></th>
				<th data-field="withdrawal_amount" data-filter-control="input" class="withdrawal_amount" data-switchable="false"><?php _e('Amount',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Amount of CSR withdrawn from your CSR Wallet', CIP_TXTDOMAIN) ); ?></th>
				<th data-field="withdrawal_fee" data-filter-control="input" class="withdrawal_fee" data-switchable="false"><?php _e('Fee',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Transaction fee, deducted from initial withdrawal amount', CIP_TXTDOMAIN) ); ?></th>
				<th data-field="received_amount" data-filter-control="input" class="received_amount" data-switchable="false"><?php _e('Delivered Amount',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Amount of CSR distributed to your external CSR Wallet', CIP_TXTDOMAIN) ); ?></th>
				<th data-field="eth_address" data-filter-control="input" class="eth_address" data-switchable="false"><?php _e('Destination',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('External CSR wallet address where the withdrawal was requested to be sent', CIP_TXTDOMAIN) ); ?></th>
				<th data-field="txn_id" data-filter-control="input" class="txn_id" data-switchable="false"><?php _e('Transaction Reference',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Unique transaction reference number', CIP_TXTDOMAIN) ); ?></th>
				<th data-field="transhash" data-filter-control="input" class="transhash" data-switchable="false"><?php _e('Transaction Hash',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Unique transaction hash number traceable on Blockchain', CIP_TXTDOMAIN) ); ?></th>
				<th data-field="short_description" data-filter-control="input" class="short_description" data-switchable="false"><?php _e('Description',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Description of withdrawals', CIP_TXTDOMAIN) ); ?></th>
				<th data-field="status" class="status" data-filter-control="input" data-switchable="false"><?php _e('Status',CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Status of withdrawal request / application', CIP_TXTDOMAIN) ); ?></th>
				<th data-field="action" class="action" data-switchable="false"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
			</tr>
		</thead>
		<tbody>
		</tbody>
		</table>
		<div class="modal fade" id="cancelPendingWithdrawRequestUserModal" tabindex="-1" role="dialog" aria-hidden="true">
		<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
			<div class="modal-content">
				<div class="modal-body">
				</div>
			</div>
		</div>
		</div>
	</div>

	</div>
	<?php
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('SUPPORTAGENT-LISTING-AUTHENTICATION-MANAGE', 'corsair_supportagent_google_listing_authentication_manage_callback');
function corsair_supportagent_google_listing_authentication_manage_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	ob_start();
	?>
	<table id="cip_supportagent_users_list" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
	<thead>
		<tr>
			<th data-field="id" class="id" data-switchable="false"><?php _e('Id','corsair-login'); ?></th>
			<th data-field="email" data-sortable="true" data-filter-control="input" class="email" data-switchable="false"><?php _e('Email','corsair-login'); ?></th>
			<th data-field="action_g2fa" class="action_g2fa"><?php _e('Google 2FA','corsair-login'); ?></th>
			<!-- <th data-field="toggle_login" class="toggle_login"><?php //_e('Login','corsair-login'); ?></th> -->
		</tr>
	</thead>
	<tbody>
	</tbody>
	</table>
	<?php
	$html .= ob_get_clean();

	return $html;
}
add_shortcode('COMPLETED-WITHDRAWALS', 'completed_withdrawals_callback');
function completed_withdrawals_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'daterangepicker-style' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('dr-moment');
	wp_enqueue_script('daterangepicker-script');
	ob_start();
	if( isset( $_GET['action'] ) && $_GET['action'] == 'withdrawal_request_view_act' && wp_verify_nonce( $_GET['_micro'],'_CIP_COMPLETED_WITHDRAWAL_REQUEST_VIEW_CIP_' ) && current_user_can( 'supportagent' ) && !empty( $_GET['file'] ) ){
		global $wpdb;
		$tableWithdrawalRequestsCsv = $wpdb->prefix.'withdrawal_requests_csv';
		$tableWithdrawComplete = $wpdb->prefix.'withdraw_data_completed';
		$csr_wallet_api_mode = ( !empty( get_option('csr_wallet_api_mode') ) ) ? get_option('csr_wallet_api_mode') : 'test';
		$endpoint = ( $csr_wallet_api_mode == 'live' ) ? 'https://etherscan.io/tx/' : 'https://sepolia.etherscan.io/tx/';
		$decrypted_id_raw = base64_decode( $_REQUEST['file'] );
		$fileid = preg_replace(sprintf('/%s/', md5('CIPWithdrawalRequestCSV') ), '', $decrypted_id_raw);
		$result = $wpdb->get_row("SELECT `fileid` FROM $tableWithdrawalRequestsCsv WHERE `fileid`='".$fileid."'");
		if( $result ){
			$getCompletedRecords = $wpdb->get_results("SELECT * FROM $tableWithdrawComplete WHERE `fileid`='".$result->fileid."' ");
			if( $getCompletedRecords ){
				?>
				<div class="d-flex justify-content-end pb-3">
					<button type="button" class="btn btn-primary view_all_completed_withdrawals" style="margin-left: 5px;"><a href="<?php echo get_the_permalink( get_page_by_path('content/operations/support_agent/csr-wallet-processes/completed-withdrawals-all') ); ?>"><?php _e('View All'); ?><i class="fa fa-eye"></i></a></button>
				</div>
				<table id="completedWithdrawalsList" data-filter-control="true" data-show-search-clear-button="false" data-pagination="false" data-sortable="true" data-toggle="table" data-show-columns="true" data-show-columns-toggle-all="true" data-show-toggle="false" data-show-export="false" class="table table-bordered">
				<thead>
					<tr>
						<th data-field="id" data-filter-control="input" data-sortable="true" class="id" data-switchable="false"><?php _e('Withdrawal ID','corsair-login'); ?></th>
						<th data-field="username" data-filter-control="input" data-sortable="true" class="username" data-switchable="false"><?php _e('Username','corsair-login'); ?></th>
						<th data-field="email" data-filter-control="input" data-sortable="true" class="email" data-switchable="false"><?php _e('Email','corsair-login'); ?></th>
						<th data-field="eth_address" data-filter-control="input" data-sortable="true" class="eth_address" data-switchable="false"><?php _e('Wallet Address','corsair-login'); ?></th>
						<th data-field="withdraw_amount" data-filter-control="input" data-sortable="true" class="withdraw_amount" data-switchable="false"><?php _e('Withdrawal Amount','corsair-login'); ?></th>
						<th data-field="withdrawal_fee" data-filter-control="input" data-sortable="true" class="withdrawal_fee" data-switchable="false"><?php _e('Withdrawal Fee','corsair-login'); ?></th>
						<th data-field="received_amount" data-filter-control="input" data-sortable="true" class="received_amount" data-switchable="false"><?php _e('Received Amount','corsair-login'); ?></th>
						<th data-field="processed_date" data-filter-control="input" data-sortable="true" class="processed_date" data-switchable="false"><?php _e('Date time (GMT)','corsair-login'); ?></th>
					</tr>
				</thead>
				<tbody>
				<?php
				foreach( $getCompletedRecords as $getCompletedRecord ){
					$eth_address = "";
					if( !empty( $getCompletedRecord->eth_address ) ){
						$columnsDataValMask = substr($getCompletedRecord->eth_address, 0, 6) . '...' . substr($getCompletedRecord->eth_address, -6);
						$eth_address = '<a href="' . $endpoint . $getCompletedRecord->eth_address . '#tokentxns" target="_blank" data-toggle-tt="tooltip" data-placement="top" title="'.$getCompletedRecord->eth_address.'" >'. $columnsDataValMask . '</a>';
					}
					$processed_date = "—";
					try {
						$user_date_obj = DateTime::createFromFormat( 'Y-m-d H:i:s', $getCompletedRecord->processed_date );
						$processed_date = $user_date_obj->format('d-m-Y H:i');
					} catch (\Throwable $th) {
						$processed_date = '—';
					}
				?>
				<tr>
					<td><?php echo $getCompletedRecord->withdrawal_id; ?></td>
					<td><?php echo $getCompletedRecord->username; ?></td>
					<td><?php echo $getCompletedRecord->email; ?></td>
					<td><?php echo $eth_address; ?></td>
					<td><?php echo number_format( $getCompletedRecord->withdraw_amount, 2, '.', ',' ); ?></td>
					<td><?php echo number_format( $getCompletedRecord->withdrawal_fee, 2, '.', ',' ); ?></td>
					<td><?php echo number_format( $getCompletedRecord->received_amount, 2, '.', ',' ); ?></td>
					<td><?php echo $processed_date; ?></td>
				</tr>
				<?php
				}
				?>
				</tbody>
				</table>
				<?php
			}
		}
	}else{ ?>
	<button id="export-completed-withdrawals-btn" class="btn btn-primary mb-2">Export Data</button>
	<table id="cip_completed_withdrawals_list" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
	<thead>
		<tr>
			<th data-field="withdrawal_batch_id" class="withdrawal_batch_id" data-switchable="false"><?php _e('Withdrawal Batch ID','corsair-login'); ?></th>
			<th data-field="total_withdrawals" data-filter-control="input" data-sortable="true" class="total_withdrawals" data-switchable="false"><?php _e('Number of Withdrawals','corsair-login'); ?></th>
			<!--th data-field="total_withdrawals_amount" data-filter-control="input" data-sortable="true" class="total_withdrawals_amount" data-switchable="false"><?php //_e('Amount of CSR','corsair-login'); ?></th-->
			<th data-field="total_withdrawals_amount_fees" data-filter-control="input" data-sortable="true" class="total_withdrawals_amount_fees" data-switchable="false"><?php _e('Amount of CSR','corsair-login'); ?></th>
			<th data-field="transhash" data-filter-control="input" data-sortable="true" class="transhash" data-switchable="false"><?php _e('Transaction hash','corsair-login'); ?></th>
			<th data-field="last_update" data-filter-control="input" data-sortable="true" class="last_update" data-switchable="false"><?php _e('Date time (GMT)','corsair-login'); ?></th>
			<th data-field="status" class="status" data-switchable="false"><?php _e('Status','corsair-login'); ?></th>
			<th data-field="download" class="download" data-switchable="false"><?php _e('Action','corsair-login'); ?></th>
		</tr>
	</thead>
	<tbody>
	</tbody>
	</table>
	<?php }
	$html .= ob_get_clean();

	return $html;
}
add_shortcode('COMPLETED-WITHDRAWALS-ALL', 'completed_withdrawals_all_callback');
function completed_withdrawals_all_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'daterangepicker-style' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('dr-moment');
	wp_enqueue_script('daterangepicker-script');
	ob_start();
	?>
	<button id="export-completed-withdrawals-all-btn" class="btn btn-primary mb-2">Export Data</button>
	<table id="cip_completed_withdrawals_all_list" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
	<thead>
		<tr>

			<th data-field="token" data-filter-control="select" class="token" data-switchable="false"><?php _e('Token','corsair-login'); ?></th>
			<th data-field="withdrawal_batch_id" data-filter-control="input" class="withdrawal_batch_id" data-switchable="false"><?php _e('Withdrawal Batch ID','corsair-login'); ?></th>
			<th data-field="withdrawal_id" data-filter-control="input" class="withdrawal_id" data-switchable="false"><?php _e('Withdrawal ID','corsair-login'); ?></th>
			<th data-field="username" data-filter-control="input" data-sortable="true" class="username" data-switchable="false"><?php _e('Username','corsair-login'); ?></th>
			<th data-field="email" data-filter-control="input" data-sortable="true" class="email" data-switchable="false"><?php _e('Email','corsair-login'); ?></th>
			<th data-field="eth_address" data-filter-control="input" data-sortable="true" class="eth_address" data-switchable="false"><?php _e('Wallet Address','corsair-login'); ?></th>
			<th data-field="transhash" data-filter-control="input" data-sortable="true" class="transhash" data-switchable="false"><?php _e('Transaction hash','corsair-login'); ?></th>
			<th data-field="withdraw_amount" data-filter-control="input" data-sortable="true" class="withdraw_amount" data-switchable="false"><?php _e('Withdrawal Amount','corsair-login'); ?></th>
			<th data-field="withdrawal_fee" data-filter-control="input" data-sortable="true" class="withdrawal_fee" data-switchable="false"><?php _e('Withdrawal Fee','corsair-login'); ?></th>
			<th data-field="received_amount" data-filter-control="input" data-sortable="true" class="received_amount" data-switchable="false"><?php _e('Received Amount','corsair-login'); ?></th>
			<th data-field="processed_date" data-filter-control="input" data-sortable="true" class="processed_date" data-switchable="false"><?php _e('Date time (GMT)','corsair-login'); ?></th>
		</tr>
	</thead>
	<tbody>
	</tbody>
	</table>
	<?php
	$html .= ob_get_clean();

	return $html;
}
add_shortcode('SIMPLE-NOTES-MANAGEMENT', 'simple_notes_management_callback');
function simple_notes_management_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	ob_start();
	?>
	<div class="text-right">
		<button type="button" id="create_member_popup" class="text-right mb-2" data-toggle="modal" data-target="#createSimpleNotesModal"><i class="fa fa-plus" aria-hidden="true"></i> <?php _e('Add Note', CIP_TXTDOMAIN); ?></button>
	</div>
	<table id="cip_simple_notes_management_list" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
	<thead>
		<tr>
			<th data-field="id" class="id" data-switchable="false"><?php _e('ID','corsair-login'); ?></th>
			<th data-field="notes" data-filter-control="input" data-sortable="true" class="notes" data-switchable="false"><?php _e('Notes','corsair-login'); ?></th>
			<th data-field="action" class="action" data-switchable="false"><?php _e('Action','corsair-login'); ?></th>
		</tr>
	</thead>
	<tbody>
	</tbody>
	</table>
	<div class="modal fade" id="createSimpleNotesModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-body">
					<form class="create_simple_notes_frm" id="create_simple_notes_frm" name="create_simple_notes_frm">
						<div class="form-group">
							<h5><?php _e('Add Notes', CIP_TXTDOMAIN); ?></h5>
						</div>
						<div class="form-group">
							<input type="text" class="form-control" id="simple_notes" name="simple_notes" placeholder="<?php _e('Note *', CIP_TXTDOMAIN); ?>" />
						</div>
						<button type="submit" class="btn btn-secondary"><?php _e('Submit', CIP_TXTDOMAIN); ?></button>
						<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
						<input type="hidden" name="action" value="create_simple_note_act" />
						<input type="hidden" name="pageid" value="<?php echo get_the_id(); ?>" />
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_YCIPcreateSimpleNoteCIPY_'); ?>" />
					</form>
				</div>
			</div>
		</div>
	</div>
	<div class="modal fade" id="EditSimpleNotesModal" tabindex="-1" role="dialog">
		  <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		    <div class="modal-content">
		      	<div class="modal-body">

				</div>
		    </div>
		  </div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('SMS-ALERT-MANAGEMENT', 'sms_alert_management_callback');
function sms_alert_management_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	ob_start();
	?>
	<div class="text-right">
		<button type="button" id="create_sms_number_popup" class="text-right mb-2" data-toggle="modal" data-target="#createSmsNumberModal"><i class="fa fa-plus" aria-hidden="true"></i> <?php _e('Add Number', CIP_TXTDOMAIN); ?></button>
	</div>
	<table id="cip_sms_alert_management_list" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
	<thead>
		<tr>
			<th data-field="id" class="id" data-switchable="false"><?php _e('ID','corsair-login'); ?></th>
			<th data-field="number" data-filter-control="input" data-sortable="true" class="number" data-switchable="false"><?php _e('Number','corsair-login'); ?></th>
			<th data-field="action" class="action" data-switchable="false"><?php _e('Action','corsair-login'); ?></th>
		</tr>
	</thead>
	<tbody>
	</tbody>
	</table>
	<div class="modal fade" id="createSmsNumberModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-body">
					<form class="create_sms_alert_frm" id="create_sms_alert_frm" name="create_sms_alert_frm">
						<div class="form-group">
							<h5><?php _e('Add Number', CIP_TXTDOMAIN); ?></h5>
						</div>
						<div class="form-group">
							<label for="sms_alert"><?php echo __('Number', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" id="sms_alert" name="sms_alert" />
						</div>
						<div class="form-group">
						<div class="otp_section pb-3">
							<label for="user_ga_otp"><?php echo __('Please enter the authentication code', CIP_TXTDOMAIN); ?></label>
							<input type="text" name="user_ga_otp" id="user_ga_otp" class="input mb-1" maxlength="6" pattern="{0-9}+" />
							<small class="form-text text-muted"><?php _e('Enter the 6-digit code generated by the Authenticator App.') ?></small>
						</div>
						</div>
						<button type="submit" class="btn btn-secondary"><?php _e('Submit', CIP_TXTDOMAIN); ?></button>
						<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
						<input type="hidden" name="action" value="create_sms_alert_act" />
						<input type="hidden" name="pageid" value="<?php echo get_the_id(); ?>" />
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_YCIPCreateSmsAlertCIPY_'); ?>" />
					</form>
				</div>
			</div>
		</div>
	</div>
	<div class="modal fade" id="deleteSmsNumberModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-body">
					<form class="delete_sms_alert_frm" id="delete_sms_alert_frm" name="delete_sms_alert_frm">
						<div class="form-group">
							<h5><?php _e('Delete Number', CIP_TXTDOMAIN); ?></h5>
						</div>
						<p class="delete_number_label"></p>
						<div class="form-group">
						<div class="otp_section pb-3">
							<label for="user_ga_otp"><?php echo __('Please enter the authentication code', CIP_TXTDOMAIN); ?></label>
							<input type="text" name="user_ga_otp" id="user_ga_otp" class="input mb-1" maxlength="6" pattern="{0-9}+" />
							<small class="form-text text-muted"><?php _e('Enter the 6-digit code generated by the Authenticator App.') ?></small>
						</div>
						</div>
						<button type="submit" class="btn btn-secondary"><?php _e('Confirm', CIP_TXTDOMAIN); ?></button>
						<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
						<input type="hidden" name="action" value="delete_sms_alert_act" />
						<input type="hidden" name="pageid" value="<?php echo get_the_id(); ?>" />
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_YCIPDeleteSmsAlertCIPY_'); ?>" />
					</form>
				</div>
			</div>
		</div>
	</div>
	<div class="modal fade" id="EditSmsAlertModal" tabindex="-1" role="dialog">
		  <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		    <div class="modal-content">
		      	<div class="modal-body">

				</div>
		    </div>
		  </div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('SM-EMAIL-SEND-SWITCH-SETTINGS','cip_sm_email_send_switch_settings_cb');
function cip_sm_email_send_switch_settings_cb(){
	$html = "";
	$email_notification_toggle_login = ( !empty( get_option('email_notification_toggle_login') ) ) ? get_option('email_notification_toggle_login') : 0 ;
	$email_notification_toggle_deposit = ( !empty( get_option('email_notification_toggle_deposit') ) ) ? get_option('email_notification_toggle_deposit') : 0 ;
	$email_notification_toggle_withdrawal_request = ( !empty( get_option('email_notification_toggle_withdrawal_request') ) ) ? get_option('email_notification_toggle_withdrawal_request') : 0 ;
	$email_notification_toggle_withdrawal_complete = ( !empty( get_option('email_notification_toggle_withdrawal_complete') ) ) ? get_option('email_notification_toggle_withdrawal_complete') : 0 ;
	$email_notification_toggle_kyc_status_change = ( !empty( get_option('email_notification_toggle_kyc_status_change') ) ) ? get_option('email_notification_toggle_kyc_status_change') : 0 ;
	$email_notification_toggle_2fa_enabled_disabled = ( !empty( get_option('email_notification_toggle_2fa_enabled_disabled') ) ) ? get_option('email_notification_toggle_2fa_enabled_disabled') : 0 ;
	$email_notification_toggle_otp_enabled_disabled = ( !empty( get_option('email_notification_toggle_otp_enabled_disabled') ) ) ? get_option('email_notification_toggle_otp_enabled_disabled') : 0 ;
	$email_notification_toggle_complete_your_kyc = ( !empty( get_option('email_notification_toggle_complete_your_kyc') ) ) ? get_option('email_notification_toggle_complete_your_kyc') : 0 ;
	ob_start();
	?>
		<form name="sm_email_sending_switch_frm" id="sm_email_sending_switch_frm">
			<h5><?php _e('Email sending switch', CIP_TXTDOMAIN); ?></h5>
			<div class="row">
				<div class="col-md-6">
					<div class="form-group">
						<div class="custom-control custom-switch">
							<input type="checkbox" class="custom-control-input" name="email_notification_switch_toggle_login" id="email_notification_switch_toggle_login" value="1" <?php checked( 1, $email_notification_toggle_login, true ); ?>>
							<label class="custom-control-label" for="email_notification_switch_toggle_login"><?php _e('Login', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Users email notification about login', CIP_TXTDOMAIN) ); ?> </label>
						</div>
					</div>
					<div class="form-group">
						<div class="custom-control custom-switch">
							<input type="checkbox" class="custom-control-input" name="email_notification_switch_toggle_otp_enabled_disabled" id="email_notification_switch_toggle_otp_enabled_disabled" value="1" <?php checked( 1, $email_notification_toggle_otp_enabled_disabled, true ); ?>>
							<label class="custom-control-label" for="email_notification_switch_toggle_otp_enabled_disabled"><?php _e('OTP enabled / disabled', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Users email notification about OTP status change', CIP_TXTDOMAIN) ); ?></label>
						</div>
					</div>
					<div class="form-group">
						<div class="custom-control custom-switch">
							<input type="checkbox" class="custom-control-input" name="email_notification_switch_toggle_2fa_enabled_disabled" id="email_notification_switch_toggle_2fa_enabled_disabled" value="1" <?php checked( 1, $email_notification_toggle_2fa_enabled_disabled, true ); ?>>
							<label class="custom-control-label" for="email_notification_switch_toggle_2fa_enabled_disabled"><?php _e('2FA enabled / disabled', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Users email notification about 2FA status change', CIP_TXTDOMAIN) ); ?></label>
						</div>
					</div>
					<div class="form-group">
						<div class="custom-control custom-switch">
							<input type="checkbox" class="custom-control-input" name="email_notification_switch_toggle_complete_your_kyc" id="email_notification_switch_toggle_complete_your_kyc" value="1" <?php checked( 1, $email_notification_toggle_complete_your_kyc, true ); ?>>
							<label class="custom-control-label" for="email_notification_switch_toggle_complete_your_kyc"><?php _e('Complete your KYC', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Users email notification about KYC completion request', CIP_TXTDOMAIN) ); ?></label>
						</div>
					</div>

				</div>
				<div class="col-md-6">
					<div class="form-group">
						<div class="custom-control custom-switch">
							<input type="checkbox" class="custom-control-input" name="email_notification_switch_toggle_kyc_status_change" id="email_notification_switch_toggle_kyc_status_change" value="1" <?php checked( 1, $email_notification_toggle_kyc_status_change, true ); ?>>
							<label class="custom-control-label" for="email_notification_switch_toggle_kyc_status_change"><?php _e('KYC status change', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Users email notification about KYC status change', CIP_TXTDOMAIN) ); ?></label>
						</div>
					</div>
					<div class="form-group">
						<div class="custom-control custom-switch">
							<input type="checkbox" class="custom-control-input" name="email_notification_switch_toggle_deposit" id="email_notification_switch_toggle_deposit" value="1" <?php checked( 1, $email_notification_toggle_deposit, true ); ?>>
							<label class="custom-control-label" for="email_notification_switch_toggle_deposit"><?php _e('Deposit', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Users email notification about CSR delivery completion', CIP_TXTDOMAIN) ); ?></label>
						</div>
					</div>
					<div class="form-group">
						<div class="custom-control custom-switch">
							<input type="checkbox" class="custom-control-input" name="email_notification_switch_toggle_withdrawal_request" id="email_notification_switch_toggle_withdrawal_request" value="1" <?php checked( 1, $email_notification_toggle_withdrawal_request, true ); ?>>
							<label class="custom-control-label" for="email_notification_switch_toggle_withdrawal_request"><?php _e('Withdrawal request', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Users email notification about withdrawal submission request', CIP_TXTDOMAIN) ); ?></label>
						</div>
					</div>
					<div class="form-group">
						<div class="custom-control custom-switch">
							<input type="checkbox" class="custom-control-input" name="email_notification_switch_toggle_withdrawal_complete" id="email_notification_switch_toggle_withdrawal_complete" value="1" <?php checked( 1, $email_notification_toggle_withdrawal_complete, true ); ?>>
							<label class="custom-control-label" for="email_notification_switch_toggle_withdrawal_complete"><?php _e('Withdrawal complete', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Users email notification about withdrawal transaction completion', CIP_TXTDOMAIN) ); ?></label>
						</div>
					</div>

				</div>
			</div>
				<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
				<input type="hidden" name="action" value="cip_sm_email_sending_switch_settings_act" />
				<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsm_csr_email_sending_switch_settingxCIP_'); ?>" />
			</form>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('SM-SMS-SEND-SWITCH-SETTINGS','cip_sm_sms_send_switch_settings_cb');
function cip_sm_sms_send_switch_settings_cb(){
	$html = "";
	$sms_notification_toggle_admin_login = ( !empty( get_option('sms_notification_toggle_admin_login') ) ) ? get_option('sms_notification_toggle_admin_login') : 0 ;
	$sms_notification_toggle_batch_delivery = ( !empty( get_option('sms_notification_toggle_batch_delivery') ) ) ? get_option('sms_notification_toggle_batch_delivery') : 0 ;
	$sms_notification_toggle_batch_distribution = ( !empty( get_option('sms_notification_toggle_batch_distribution') ) ) ? get_option('sms_notification_toggle_batch_distribution') : 0 ;
	$sms_notification_toggle_csr_holder_update = ( !empty( get_option('sms_notification_toggle_csr_holder_update') ) ) ? get_option('sms_notification_toggle_csr_holder_update') : 0 ;
	$sms_notification_toggle_alert_disabled = ( !empty( get_option('sms_notification_toggle_alert_disabled') ) ) ? get_option('sms_notification_toggle_alert_disabled') : 0 ;
	$sms_notification_toggle_sms_balance_below = ( !empty( get_option('sms_notification_toggle_sms_balance_below') ) ) ? get_option('sms_notification_toggle_sms_balance_below') : 0 ;
	ob_start();
	?>
	<form name="sm_sms_sending_switch_frm" id="sm_sms_sending_switch_frm">
		<h5><?php _e('SMS sending switch', CIP_TXTDOMAIN); ?></h5>
		<div class="row">
			<div class="col-md-6">
				<div class="form-group">
					<div class="custom-control custom-switch">
						<input type="checkbox" class="custom-control-input" name="sms_notification_switch_toggle_admin_login" id="sms_notification_switch_toggle_admin_login" value="1" <?php checked( 1, $sms_notification_toggle_admin_login, true ); ?>>
						<label class="custom-control-label" for="sms_notification_switch_toggle_admin_login"><?php _e('Admin Login', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Admin sms notification about login', CIP_TXTDOMAIN) ); ?> </label>
					</div>
				</div>
				<div class="form-group">
					<div class="custom-control custom-switch">
						<input type="checkbox" class="custom-control-input" name="sms_notification_switch_toggle_batch_delivery" id="sms_notification_switch_toggle_batch_delivery" value="1" <?php checked( 1, $sms_notification_toggle_batch_delivery, true ); ?>>
						<label class="custom-control-label" for="sms_notification_switch_toggle_batch_delivery"><?php _e('Batch delivery', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Batch delivery', CIP_TXTDOMAIN) ); ?> </label>
					</div>
				</div>
				<div class="form-group">
					<div class="custom-control custom-switch">
						<input type="checkbox" class="custom-control-input" name="sms_notification_switch_toggle_batch_distribution" id="sms_notification_switch_toggle_batch_distribution" value="1" <?php checked( 1, $sms_notification_toggle_batch_distribution, true ); ?>>
						<label class="custom-control-label" for="sms_notification_switch_toggle_batch_distribution"><?php _e('Batch distribution', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Batch distribution', CIP_TXTDOMAIN) ); ?> </label>
					</div>
				</div>
				<div class="form-group">
					<div class="custom-control custom-switch">
						<input type="checkbox" class="custom-control-input" name="sms_notification_switch_toggle_csr_holder_update" id="sms_notification_switch_toggle_csr_holder_update" value="1" <?php checked( 1, $sms_notification_toggle_csr_holder_update, true ); ?>>
						<label class="custom-control-label" for="sms_notification_switch_toggle_csr_holder_update"><?php _e('CSR holder update', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('CSR holder update', CIP_TXTDOMAIN) ); ?> </label>
					</div>
				</div>
			</div>
			<div class="col-md-6">
				<div class="form-group">
					<div class="custom-control custom-switch">
						<input type="checkbox" class="custom-control-input" name="sms_notification_switch_toggle_alert_disabled" id="sms_notification_switch_toggle_alert_disabled" value="1" <?php checked( 1, $sms_notification_toggle_alert_disabled, true ); ?>>
						<label class="custom-control-label" for="sms_notification_switch_toggle_alert_disabled"><?php _e('Alert disabled', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('Alert disabled', CIP_TXTDOMAIN) ); ?> </label>
					</div>
				</div>
				<div class="form-group">
					<div class="custom-control custom-switch">
						<input type="checkbox" class="custom-control-input" name="sms_notification_switch_toggle_sms_balance_below" id="sms_notification_switch_toggle_sms_balance_below" value="1" <?php checked( 1, $sms_notification_toggle_sms_balance_below, true ); ?>>
						<label class="custom-control-label" for="sms_notification_switch_toggle_sms_balance_below"><?php _e('SMS balance below', CIP_TXTDOMAIN); ?> <?php echo cipColumnHeaderTooltip( __('SMS balance below', CIP_TXTDOMAIN) ); ?> </label>
					</div>
				</div>
			</div>
		</div>
		<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="cip_sm_sms_sending_switch_settings_act" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsm_csr_sms_sending_switch_settingxCIP_'); ?>" />
		</form>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('maintenance-form-settings','cip_maintenance_form_settings_cb');
function cip_maintenance_form_settings_cb(){
	$maintenance_live_option = get_option( 'maintenance_live_option' ,true);
	$maintenance_whole_option = get_option( 'maintenance_whole_option' ,true);
	$maintenance_retirement_option = get_option( 'maintenance_retirement_option' ,true);
	// print_r($maintenance_live_option);
	?>
	<form id="maintenance_form">
		<div class="row">
			<div class="form-group col-lg-6 col-md-6 col-12">
				<label for="live_title">Live Site Maintenance Title</label>
				<textarea id="live_title" name="live_title"><?php echo $maintenance_live_option['title']; ?></textarea>
			</div>
			<div class="form-group col-lg-6 col-md-6 col-12">
				<label for="live_message">Live Site Maintenance Message</label>
				<textarea id="live_message" name="live_message"><?php echo $maintenance_live_option['message']; ?></textarea>
			</div>
			<div class="form-group col-lg-6 col-md-6 col-12">
				<label for="whole_title">Whole Site Maintenance Title</label>
				<textarea id="whole_title" name="whole_title"><?php echo $maintenance_whole_option['title']; ?></textarea>
			</div>
			<div class="form-group col-lg-6 col-md-6 col-12">
				<label for="whole_message">Whole Site Maintenance Message</label>
				<textarea id="whole_message" name="whole_message"><?php echo $maintenance_whole_option['message']; ?></textarea>
			</div>
			<div class="form-group col-lg-6 col-md-6 col-12">
				<label for="retirement_title">Retirement Maintenance Title</label>
				<textarea id="retirement_title" name="retirement_title"><?php echo $maintenance_retirement_option['title']; ?></textarea>
			</div>
			<div class="form-group col-lg-6 col-md-6 col-12">
				<label for="retirement_message">Retirement Maintenance Message</label>
				<textarea id="retirement_message" name="retirement_message"><?php echo $maintenance_retirement_option['message']; ?></textarea>
			</div>
		</div>
        <button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxmaintenance_form_settingsxCIP_'); ?>" />
    </form>
	<?php
}
add_shortcode('Routin-Maintenance-Message','cip_routin_maintenance_logs_view_cb');
function cip_routin_maintenance_logs_view_cb(){
	$html = "";
	ob_start();
	$cip_routine_maintenance_mode = get_option( 'cip_routine_maintenance_mode' ,true);
	if($cip_routine_maintenance_mode == 1){
		$maintenance_live_option = get_option( 'maintenance_live_option' ,true);
		?>
		<div class="routine_maintenance_mode_section">
			<h2><?php echo $maintenance_live_option['title']; ?></h2>
			<p><?php echo nl2br( $maintenance_live_option['message'] ); ?></p>
		</div>
		<?php
	}
	$cip_site_maintenance_mode = get_option( 'cip_site_maintenance_mode' ,true);
	if($cip_site_maintenance_mode == 1){
		$maintenance_whole_option = get_option( 'maintenance_whole_option' ,true);
		?>
		<div class="routine_maintenance_mode_section">
			<h2><?php echo $maintenance_whole_option['title']; ?></h2>
			<p><?php echo nl2br( $maintenance_whole_option['message'] ); ?></p>
		</div>
		<?php
	}
	$cip_retirement_maintenance_mode = get_option( 'cip_retirement_maintenance_mode' ,true);
	if($cip_retirement_maintenance_mode == 1){
		$maintenance_retirement_option = get_option( 'maintenance_retirement_option' ,true);
		?>
		<div class="routine_maintenance_mode_section">
			<h2><?php echo $maintenance_retirement_option['title']; ?></h2>
			<p><?php echo nl2br( $maintenance_retirement_option['message'] ); ?></p>
		</div>
		<?php
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CSR-WITHDRAWALS-REPORT-DETAILS', 'csr_withdrawals_report_details_callback');
function csr_withdrawals_report_details_callback(){
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	if( current_user_can( 'supportmanager' ) || current_user_can( 'supportagent' ) ){

		global $wpdb;
		$user_id = get_current_user_id();
		$columnsArr = array(
			// 'id'				=>	__('id', CIP_TXTDOMAIN),
			// 'withdrawal_id'		=>	__('withdrawal_id', CIP_TXTDOMAIN),
			// 'requested_date'	=>	__('requested_date', CIP_TXTDOMAIN),
			'email'				=>	__('email', CIP_TXTDOMAIN),
			'username'			=>	__('username', CIP_TXTDOMAIN),
			'full_name'			=>	__('full_name', CIP_TXTDOMAIN),
			// 'user_star'			=>	__('user_star', CIP_TXTDOMAIN),
			// 'eth_address'		=>	__('eth_address', CIP_TXTDOMAIN),
			'withdraw_amount'	=>	__('withdraw_amount', CIP_TXTDOMAIN),
			// 'withdrawal_fee'	=>	__('withdrawal_fee', CIP_TXTDOMAIN),
			// 'received_amount'	=>	__('received_amount', CIP_TXTDOMAIN),
		);
		$csr_withdrawals_report_amount = ( !empty( get_option('csr_withdrawals_report_amount') ) ) ? get_option('csr_withdrawals_report_amount') : 50000;
		$tableWithdraw = $wpdb->prefix.'withdraw_data_pending';
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableWithdraw WHERE 1");
		$getWithdrawListAll = $wpdb->get_row("SELECT COUNT(*) as `totalRequests`, COALESCE(SUM(`withdraw_amount`),0) as `totalWithdrawAmount` FROM $tableWithdraw WHERE 1");
		$getWithdrawListOver50 = $wpdb->get_row("SELECT COUNT(*) as `totalRequests`, COALESCE(SUM(`withdraw_amount`),0) as `totalWithdrawAmount` FROM $tableWithdraw WHERE 1 AND `withdraw_amount` >= $csr_withdrawals_report_amount");
		$getWithdrawList = $wpdb->get_results("SELECT * FROM $tableWithdraw WHERE 1 AND `withdraw_amount` >= $csr_withdrawals_report_amount ORDER BY `id` DESC");

		if( $getWithdrawList ){
			$withdrawalsReportDetailsLink = add_query_arg( 'action', 'withdrawals_report_details_download_act', admin_url('admin-post.php') );
		?><a class="btn btn-primary float-right" href="<?php echo $withdrawalsReportDetailsLink; ?>" target="_blank"><?php _e('Download', CIP_TXTDOMAIN) ?></a><?php } ?>
		<?php
		echo sprintf( __('<p>There are %s withdrawals requests totalling %s CSR<br>Of these %s there are %s over %s totalling %s CSR</p>', CIP_TXTDOMAIN), number_format( $getWithdrawListAll->totalRequests ), number_format( $getWithdrawListAll->totalWithdrawAmount, 2, '.', ',' ), number_format( $getWithdrawListAll->totalRequests ), number_format( $getWithdrawListOver50->totalRequests ), number_format( $csr_withdrawals_report_amount ), number_format( $getWithdrawListOver50->totalWithdrawAmount, 2, '.', ',' ) );
		?>
		<table id="csr_withdrawal_report_details" data-filter-control="false" data-show-search-clear-button="false" data-pagination="false" data-sortable="true" data-toggle="table" data-show-columns="true" data-show-columns-toggle-all="true" data-show-toggle="false" data-show-export="false" class="table table-bordered">
			<thead>
			<tr>
				<!-- <th data-field="id" class="id" data-switchable="true"><?php _e('ID',CIP_TXTDOMAIN); ?></th> -->
				<!-- <th data-field="withdrawal_id" data-filter-control="input" class="withdrawal_id" data-switchable="true"><?php _e('Withdrawal ID',CIP_TXTDOMAIN); ?></th> -->
				<!-- <th data-field="requested_date" class="requested_date" data-filter-control="input" data-switchable="true"><?php _e('Date Requested',CIP_TXTDOMAIN); ?></th> -->
				<th data-field="email" data-filter-control="input" class="email" data-switchable="true"><?php _e('Email',CIP_TXTDOMAIN); ?></th>
				<th data-field="username" data-filter-control="input" class="username" data-switchable="true"><?php _e('Username',CIP_TXTDOMAIN); ?></th>
				<th data-field="first_name" data-filter-control="input" class="first_name" data-switchable="true"><?php _e('Full Name',CIP_TXTDOMAIN); ?></th>
				<!-- <th data-field="last_name" data-filter-control="input" class="last_name" data-switchable="true"><?php _e('Last Name',CIP_TXTDOMAIN); ?></th> -->
				<!-- <th data-field="user_star" data-filter-control="input" class="user_star" data-switchable="true"><?php _e('Star Rank',CIP_TXTDOMAIN); ?></th> -->
				<!-- <th data-field="eth_address" data-filter-control="input" class="eth_address" data-switchable="true"><?php _e('CSR address',CIP_TXTDOMAIN); ?></th> -->
				<th data-field="withdraw_amount" data-filter-control="input" class="withdraw_amount" data-switchable="true"><?php _e('CSR amount',CIP_TXTDOMAIN); ?></th>
				<!-- <th data-field="withdrawal_fee" data-filter-control="input" class="withdrawal_fee" data-switchable="true"><?php _e('Withdrawal fee',CIP_TXTDOMAIN); ?></th> -->
				<!-- <th data-field="received_amount" data-filter-control="input" class="received_amount" data-switchable="true"><?php _e('Received amount',CIP_TXTDOMAIN); ?></th> -->
			</tr>
		</thead>
		<tbody>
		<?php
		if( $getWithdrawList ){
			$sno=1;
			foreach( $getWithdrawList as $getWithdraw ){
				?><tr>
				<?php
				if( $columnsArr ){
					foreach( $columnsArr as $columnKey => $columnsVal ){
						if( $columnKey == 'withdrawal_id' ){
							$columnsDataVal = $getWithdraw->withdrawal_id;
						}else if( $columnKey == 'withdraw_amount' || $columnKey == 'withdrawal_fee' || $columnKey == 'received_amount' ){
							$columnsDataVal = number_format( $getWithdraw->$columnKey, 2 );
						}else if( $columnKey == 'eth_address' ){
							$columnsDataVal = '<a href="javascript:void(0);">'.$getWithdraw->$columnKey.'</a>';
						}else if( $columnKey == 'full_name' ){
							$columnsDataVal = trim( $getWithdraw->first_name.' ' . $getWithdraw->last_name );
						}else{
							$columnsDataVal = $getWithdraw->$columnKey;
						}
						if( $columnKey == 'requested_date' ){
							try {
								$user_date_obj = DateTime::createFromFormat( 'Y-m-d H:i:s', $columnsDataVal );
								$columnsDataVal = $user_date_obj->format('d-m-Y');
							} catch (\Throwable $th) {
								$columnsDataVal = '—';
							}
						}else{
							if( empty( $columnsDataVal ) ){
								$columnsDataVal = '—';
							}
						}
						?>
						<td><?php echo $columnsDataVal; ?></td>
						<?php
					}
				}
				?><tr><?php
				$sno=$sno+1;
			}
		}
		?>
		</tbody>
		</table>
		<?php
	}
}
add_shortcode( 'WEEKLY-BONUS-POOLS-SPLIT-WIZARD', 'cip_weekly_bonus_pools_split_wizard_callback' );
function cip_weekly_bonus_pools_split_wizard_callback(){
	$html = "";
	global $wpdb;
	ob_start();
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_style( 'select2' );
	wp_enqueue_script('select2');
	$total_step = 6;
	?>
	<div class="container-fluid">
	    <div class="row justify-content-center">
			<div class="col-10 col-sm-9 col-md-7 col-lg-10 col-xl-10 text-center p-0 mt-3 mb-2">
				<div class="card px-0 pt-4 pb-0 mt-3 mb-3">
					<form name="weekly_bonus_pools_split_wizard_frm" class="weekly_bonus_pools_split_wizard_frm" id="msform">
					<!-- progressbar -->
					<ul id="progressbar">
	                        <li class="active" id="fieldmapping"><strong><?php _e('Choose Pool',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="fieldmapping"><strong><?php _e('Logs',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="fieldmapping"><strong><?php _e('Review',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="fieldmapping"><strong><?php _e('Split 10% Distribution',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="fieldmapping"><strong><?php _e('Review 10% Distribution',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="codemerge"><strong><?php _e('Append New CSR Holders',CIP_TXTDOMAIN) ?></strong></li>
	                        <li id="confirm"><strong><?php _e('Finish',CIP_TXTDOMAIN) ?></strong></li>
	                    </ul>
	                    <div class="progress">
	                        <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuemin="0" aria-valuemax="100"></div>
	                    </div> <br> <!-- fieldsets -->
	                    <fieldset class="step_0">
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 1, $total_step); ?></h2>
	                                </div>
	                            </div>

								<label for="bonus_pool_ref"><?php _e('Pool', CIP_TXTDOMAIN); ?></label>
								<select class="bonus_pool_ref_select" id="bonus_pool_ref" name="bonus_pool_ref[]" multiple="multiple" /></select>
								<div class="pool_ref_toogle" style="display: none;">
									<label class="fieldlabels"><?php _e('CSR Segmentation',CIP_TXTDOMAIN); ?></label> <input type="number" name="csr_segmentation" min="10" value="100" placeholder="<?php _e('Default will be 100', CIP_TXTDOMAIN); ?>" required />
								</div>
	                        </div>
	                        <input type="button" name="next" class="next action-button" value="Next" />
	                    </fieldset>

						<fieldset class="step_1">
							<div class="form-card">
								<div class="row">
									<div class="col-12">
										<h2 class="steps"><?php echo sprintf('Step %s - %s', 2, $total_step); ?></h2>
									</div>
								</div>

								<div class="row">
									<div class="col-12">
										<ul class="list-group list-group-flush process_log" id="process_log"></ul>
										<div class="csr_spinner" style="display: none;">
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
										</div>
									</div>
								</div>
							</div>
							<input type="button" name="next" class="next action-button" value="Review New CSR Holders Data" style="display: none;" disabled /> <input type="button" name="previous" class="previous action-button-previous" value="Previous" style="display: none;" />
						</fieldset>
	                    <fieldset class="step_2">
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 3, $total_step); ?></h2>
	                                </div>
	                            </div>

								<div class="row justify-content-center">
									<div class="col-12 text-center import_update_response"></div>
									<div class="col-12 text-center distribution_section_table" style="display:none;">
										<p class="text-left total_import_label"></p>
										<table id="tokenholder_distribution_table" data-toolbar="false" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" class="table table-bordered" data-side-pagination="server" data-page-list="[10, 20, 50, 100]" data-response-handler="responseImportHandlerBonus">
											<thead>
												<tr>
												<th data-field="id" class="id"><?php _e('#',CIP_TXTDOMAIN); ?></th>
												<th data-field="username" data-sortable="true" data-filter-control="input" class="username"><?php echo __('Username',CIP_TXTDOMAIN); ?></th>
												<th data-field="reference" data-sortable="true" data-filter-control="input" class="reference"><?php echo __('Reference Number',CIP_TXTDOMAIN); ?></th>
												<th data-field="eth_address" data-sortable="true" data-filter-control="input" class="eth_address"><?php echo __('CSR wallet address',CIP_TXTDOMAIN); ?></th>
												<th data-field="csr_amount_initial" data-sortable="true" data-filter-control="input" class="csr_amount_initial"><?php echo __('CSR Amount Initial',CIP_TXTDOMAIN); ?></th>
												<!--th data-field="csr_amount_issued" data-sortable="true" data-filter-control="input" class="csr_amount_issued"><?php //echo __('CSR Amount Issued',CIP_TXTDOMAIN); ?></th-->
												<!--th data-field="amount_due" data-sortable="true" data-filter-control="input" class="amount_due"><?php //echo __('Amount Due',CIP_TXTDOMAIN); ?></th-->
												<th data-field="first_name" data-sortable="true" data-filter-control="input" class="first_name"><?php echo __('First name',CIP_TXTDOMAIN); ?></th>
												<th data-field="last_name" data-sortable="true" data-filter-control="input" class="last_name"><?php echo __('Last name',CIP_TXTDOMAIN); ?></th>
												<th data-field="created" data-sortable="true" data-filter-control="input" class="created"><?php echo __('Created',CIP_TXTDOMAIN); ?></th>
												<th data-field="email" data-sortable="true" data-filter-control="input" class="email"><?php echo __('Email',CIP_TXTDOMAIN); ?></th>
												<th data-field="distribution_status" data-sortable="true" data-filter-control="input" class="distribution_status"><?php echo __('Distribution Status',CIP_TXTDOMAIN); ?></th>
												<th data-field="member_status" data-sortable="true" data-filter-control="input" class="member_status"><?php echo __('Member Status',CIP_TXTDOMAIN); ?></th>
												<!--th data-field="corp_approved" data-sortable="true" data-filter-control="input" class="corp_approved"><?php //echo __('corp_approved',CIP_TXTDOMAIN); ?></th-->
												<!--th data-field="notes_external" data-sortable="true" data-filter-control="input" class="notes_external"><?php //echo __('Notes External',CIP_TXTDOMAIN); ?></th-->
												<th data-field="pool_ref" data-sortable="true" data-filter-control="input" class="pool_ref"><?php echo __('Pool Reference ',CIP_TXTDOMAIN); ?></th>
												</tr>
											</thead>
											<tbody></tbody>
										</table>
									</div>
								</div>

	                        </div>
							<input type="button" name="next" class="next action-button" value="Split 10% Distribution Data" /> <input type="button" name="previous" class="previous action-button-previous back_disable" value="Previous" />
	                    </fieldset>
						<fieldset class="step_3">
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 4, $total_step); ?></h2>
	                                </div>
	                            </div>
	                            <div class="row">
									<div class="col-12">
										<ul class="list-group list-group-flush process_split_log" id="process_split_log"></ul>
										<div class="csr_split_spinner" style="display: none;">
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
										</div>
									</div>
								</div>
	                        </div>
							<input type="button" name="next" class="next action-button" value="Review 10% Distribution Data" />
							<input type="button" name="previous" class="previous action-button-previous" value="Previous" />
	                    </fieldset>
						<fieldset class="step_4">
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 5, $total_step); ?></h2>
	                                </div>
	                            </div>
	                            <div class="row justify-content-center">
									<div class="col-12 text-center import_update_response"></div>
									<div class="col-12 text-center distribution_10_section_table" style="display:none;">
										<p class="text-left total_distribution_label"></p>
										<table id="tokenholder_distribution_10_table" data-toolbar="false" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" class="table table-bordered" data-side-pagination="server" data-page-list="[10, 20, 50, 100]" data-response-handler="responseHandlerBonus">
											<thead>
												<tr>
												<th data-field="id" class="id"><?php _e('#',CIP_TXTDOMAIN); ?></th>
												<th data-field="username" data-sortable="true" data-filter-control="input" class="username"><?php echo __('Username',CIP_TXTDOMAIN); ?></th>
												<th data-field="reference" data-sortable="true" data-filter-control="input" class="reference"><?php echo __('Reference Number',CIP_TXTDOMAIN); ?></th>
												<th data-field="eth_address" data-sortable="true" data-filter-control="input" class="eth_address"><?php echo __('CSR wallet address',CIP_TXTDOMAIN); ?></th>
												<th data-field="csr_amount_initial" data-sortable="true" data-filter-control="input" class="csr_amount_initial"><?php echo __('CSR Amount Initial',CIP_TXTDOMAIN); ?></th>
												<th data-field="csr_amount_issued" data-sortable="true" data-filter-control="input" class="csr_amount_issued"><?php echo __('CSR Amount Issued',CIP_TXTDOMAIN); ?></th>
												<th data-field="amount_due" data-sortable="true" data-filter-control="input" class="amount_due"><?php echo __('Amount Due',CIP_TXTDOMAIN); ?></th>
												<th data-field="first_name" data-sortable="true" data-filter-control="input" class="first_name"><?php echo __('First name',CIP_TXTDOMAIN); ?></th>
												<th data-field="last_name" data-sortable="true" data-filter-control="input" class="last_name"><?php echo __('Last name',CIP_TXTDOMAIN); ?></th>
												<th data-field="created" data-sortable="true" data-filter-control="input" class="created"><?php echo __('Created',CIP_TXTDOMAIN); ?></th>
												<th data-field="email" data-sortable="true" data-filter-control="input" class="email"><?php echo __('Email',CIP_TXTDOMAIN); ?></th>
												<th data-field="distribution_status" data-sortable="true" data-filter-control="input" class="distribution_status"><?php echo __('Distribution Status',CIP_TXTDOMAIN); ?></th>
												<th data-field="corp_approved" data-sortable="true" data-filter-control="input" class="corp_approved"><?php echo __('Corp Approved',CIP_TXTDOMAIN); ?></th>
												<th data-field="week_number" data-sortable="true" data-filter-control="input" class="week_number"><?php echo __('Week Number',CIP_TXTDOMAIN); ?></th>
												<th data-field="member_status" data-sortable="true" data-filter-control="input" class="member_status"><?php echo __('Member Status',CIP_TXTDOMAIN); ?></th>
												<th data-field="pool_ref" data-sortable="true" data-filter-control="input" class="pool_ref"><?php echo __('Pool Reference ',CIP_TXTDOMAIN); ?></th>
												<th data-field="source" data-sortable="true" data-filter-control="input" class="source"><?php echo __('Source ',CIP_TXTDOMAIN); ?></th>
												</tr>
											</thead>
											<tbody></tbody>
										</table>
									</div>
								</div>
	                        </div>
							<?php $exportDistributionLink = add_query_arg( 'action', 'export_distribution_act', admin_url('admin-post.php') ); ?>
							<?php /*<a class="next action-button" href="<?php echo $exportDistributionLink; ?>"><?php echo __('Save 10% Distribution Data',CIP_TXTDOMAIN); ?></a>*/ ?>
							<input type="button" name="next" class="next action-button" value="Append Data" />
							<input type="button" name="previous" class="previous action-button-previous back_disable" value="Previous" />
	                    </fieldset>
	                    <fieldset class="step_5">
							<?php
								$tableDistribution = $wpdb->prefix.'token_holder_distribution';
								$getDistributions = $wpdb->get_var("SELECT COUNT(id) FROM $tableDistribution WHERE `append_status` = 1");
								$getDistributionsSummary = $wpdb->get_row("SELECT * FROM $tableDistribution WHERE `append_status` = 1 ORDER BY `id` DESC");
								$getDistributionsData = $wpdb->get_results("SELECT * FROM $tableDistribution WHERE `append_status` = 1 AND `csr_amount_issued` > 0");
								$totalRedemptions = 0;
								$totalCsr = 0;
								if( $getDistributionsData ){
									foreach( $getDistributionsData as $distribution ){
										$totalCsr += $distribution->csr_amount_initial;
										$totalRedemptions++;
									}
								}
							?>
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 6, $total_step); ?></h2>
	                                </div>
	                            </div>
	                            <div class="row justify-content-center">
									<div class="col-12 text-center">
									<h4><?php _e('Append New CSR Holders Data', CIP_TXTDOMAIN); ?></h4>
									<div class="summary_data_at_append_step">
										<?php /*if( $getDistributions > 0 && $getDistributionsSummary->import_by && $getDistributionsSummary->import_date ){
											$userData = get_user_by( 'id', $getDistributionsSummary->import_by );
											if( $userData ){
												echo '<p>'. sprintf( __('Data imported by : %s', CIP_TXTDOMAIN), $userData->user_login ) .'</p>';
											}
											$import_date = '—';
											try {
												$import_date_obj = DateTime::createFromFormat('Y-m-d H:i:s', $getDistributionsSummary->import_date);
												$import_date = $import_date_obj->format('d/m/Y H:i');
											} catch (\Throwable $th) {
												$import_date = '—';
											}
											echo '<p>'. sprintf( __('Import date : %s', CIP_TXTDOMAIN), $import_date ) .'</p>';
											// echo '<p>'. sprintf( __('Total redemptions : %s', CIP_TXTDOMAIN), number_format($totalRedemptions) ) .'</p>';
											// echo '<p>'. sprintf( __('Total CSR : %s', CIP_TXTDOMAIN), number_format($totalCsr) ) .'</p>';
										}*/ ?>
									</div>
									<button type="button" class="btn btn-outline-primary append_new_bonus_csr_holders_data_button"><?php _e('Confirm Append Data',CIP_TXTDOMAIN); ?></button>
									<button type="button" class="btn btn-outline-primary append_bonus_cancel"><?php _e('Cancel',CIP_TXTDOMAIN); ?></button>
									</div>
									<div class="col-12">
										<ul class="list-group list-group-flush process_split_append_log" id="process_split_append_log"></ul>
										<div class="csr_split_append_spinner" style="display: none;">
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
											<div class="spinner-grow spinner-grow-sm text-primary"></div>
										</div>
									</div>
								</div>
	                        </div>
							<input type="button" name="next" class="next action-button finish_step d-none invisible" value="Next" />
							<input type="button" name="previous" class="previous action-button-previous" value="Previous" />
							<!--a class="previous action-button-previous" href="" /><?php //_e('Cancel', CIP_TXTDOMAIN); ?></a-->
	                    </fieldset>
						<fieldset class="step_6">
	                        <div class="form-card">
	                            <div class="row">
	                                <div class="col-12">
	                                    <h2 class="steps"><?php echo sprintf('Step %s - %s', 7, $total_step); ?></h2>
	                                </div>
	                            </div>
								<div class="row">
									<div class="col-12">
										<h4 class="text-center"><strong><i class="fa fa-check-circle"></i> Weekly bonus pool split wizard completed!</strong></h4>
										<p class="text-center append_response fw-bold"></p>
										<a class="btn button action-button" href="<?php echo get_permalink( 9099 ); ?>"><?php echo __('Okay', CIP_TXTDOMAIN); ?></a>
									</div>
	                            </div>
	                        </div>
	                    </fieldset>
	                    <input type="hidden" name="action" value="cip_weekly_bonus_pool_split_act" />
	                    <input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxYSMWeeklyBonusPoolSplitMSYxCIP_'); ?>" />
	                </form>
					<form class="append_new_bonus_csr_holders_data_frm" id="append_new_bonus_csr_holders_data_frm">
						<input type="hidden" name="action" value="append_new_bonus_csr_holders_data_act">
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XYAppendNewBonus_csr_HoldersDataYX_'); ?>">
					</form>
					<form class="append_cancel_bonus_data_frm" id="append_cancel_bonus_data_frm">
						<input type="hidden" name="action" value="cancel_append_bonus_process">
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XYCancelAppendBonusDataYX_'); ?>">
					</form>
				</div>
			</div>
		</div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('WITHDRAWAL-SUSPENSION-AFTER-LOGIN-SETTING', 'withdrawal_suspension_after_login_setting_callback');
function withdrawal_suspension_after_login_setting_callback(){
	$html = "";
	global $wpdb;
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	$withdrawal_suspension_minutes = ( !empty( get_option('withdrawal_suspension_minutes') ) ) ? get_option('withdrawal_suspension_minutes') : 5;
	ob_start();
	?>
	<div class="row">
		<div class="col-md-12">
			<div class="shadow p-3 bg-white rounded h-100">
				<form id="withdrawal_suspension_after_login_setting_frm" name="withdrawal_suspension_after_login_setting_frm">
					<h6><?php _e('Withdrawal suspension after login (minutes):', CIP_TXTDOMAIN); ?></h6>
					<input type="number" name="withdrawal_suspension_minutes" id="withdrawal_suspension_minutes" value="<?php echo $withdrawal_suspension_minutes; ?>" max="60" class="form-control">
					<input type="hidden" name="action" value="withdrawal_suspension_minutes_setting_act">
					<input type="hidden" name="_micro" id="_micro" value="<?php echo wp_create_nonce('_ZyxwithdrawalSuspensionConfigxyZ_'); ?>">
					<br/>
					<button type="submit" class="form-control btn btn-primary"><?php _e('Submit', CIP_TXTDOMAIN); ?></button>
				</form>
			</div>
		</div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
/**
 * Corporate Users
 */
add_shortcode('CORPORATE-USERS', 'cip_corporate_users_callback');
function cip_corporate_users_callback(){
	$html = "";
	global $wpdb;
	$current_user = wp_get_current_user();
	$user_id = $current_user->ID;
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'daterangepicker-style' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('dr-moment');
	wp_enqueue_script('daterangepicker-script');
	wp_enqueue_style( 'select2' );
	wp_enqueue_script('select2');
	ob_start();
	$data_micro = wp_create_nonce( $user_id . md5('CIP_CreateModalCorporateUser_CIP') );
	?>
	<div class="d-flex justify-content-end" id="customToolbar">
		<button type="button" id="create_corporate_user_popup" data-_micro="<?php echo $data_micro; ?>"><i class="fa fa-plus" aria-hidden="true"></i> <?php _e('Add Corporate User', CIP_TXTDOMAIN); ?></button> <!-- data-toggle="modal" data-target="#createCorporateUserModal" data-backdrop="static" data-keyboard="false" -->
	</div>
	<table id="corporate_users_list" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]" data-page-size="10" data-toolbar="#customToolbar"> <!-- data-response-handler="responseHandlerWithdrawRequests" -->
	<thead>
		<tr>
			<th data-field="id" class="id" data-switchable="false"><?php _e('#',CIP_TXTDOMAIN); ?></th>
			<th data-field="first_name" data-filter-control="input" class="first_name" data-switchable="true"><?php _e('First Name',CIP_TXTDOMAIN); ?></th>
			<th data-field="last_name" data-filter-control="input" class="last_name" data-switchable="true"><?php _e('Last Name',CIP_TXTDOMAIN); ?></th>
			<th data-field="email" data-filter-control="input" class="email" data-switchable="true"><?php _e('Email',CIP_TXTDOMAIN); ?></th>
			<th data-field="eth_address" data-filter-control="input" class="eth_address" data-switchable="true"><?php _e('CSR Wallet Address',CIP_TXTDOMAIN); ?></th>
			<th data-field="action" class="action" data-switchable="false"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
		</tr>
	</thead>
	<tbody>
	</tbody>
	</table>
	<div class="modal fade" id="createCorporateUserModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-body">
			</div>
		</div>
		</div>
	</div>
	<div class="modal fade" id="EditCorporateUserModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-body">
			</div>
		</div>
		</div>
	</div>
	<div class="modal fade" id="DeleteCorporateUserModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-body">
			</div>
		</div>
		</div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CORPORATE-USERS-WITHDRAWALS-LIST', 'corporate_users_withdrawals_list_callback');
function corporate_users_withdrawals_list_callback(){
	$html = "";
	if( is_user_logged_in() && current_user_can('supportagent') ){
		global $wpdb;
		wp_enqueue_style( 'cip-css' );
		wp_enqueue_style( 'bs-table' );
		wp_enqueue_style( 'bs-sticky-header' );
		wp_enqueue_style( 'daterangepicker-style' );
		wp_enqueue_script('bs-table');
		wp_enqueue_script('bs-sticky-header');
		wp_enqueue_script('bs-table-filter-control');
		wp_enqueue_script('dr-moment');
		wp_enqueue_script('daterangepicker-script');
		wp_enqueue_style( 'select2' );
		wp_enqueue_script('select2');
		ob_start();
		?>
		<div class="container-fluid wallet_delivery_frm">
		<div class="table-responsive">
		<?php
			$user_id = get_current_user_id();
			if( !metadata_exists( 'user', $user_id, 'cip_sagent_toggle_columns' ) ){
				$columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
				update_user_meta( $user_id, 'cip_sagent_toggle_columns', $columnsSAColumnOption );
			}
			$saUserData = get_user_by( 'id', $user_id );
			$columnsArr = array(
				'first_name' 			=> __( 'First Name', CIP_TXTDOMAIN),
				'last_name' 			=> __( 'Last Name', CIP_TXTDOMAIN),
				'email' 				=> __( 'Email', CIP_TXTDOMAIN),
				'eth_address' 			=> __( 'CSR Wallet Address', CIP_TXTDOMAIN),
				'balance_csr_central'	=> __( 'Balance (CSR Central)', CIP_TXTDOMAIN),
				'pending_balance'		=> __( 'Pending', CIP_TXTDOMAIN),
				'balance_blockchain'	=> __( 'Balance (Blockchain)', CIP_TXTDOMAIN)
			);
		?>
		<div class="csr_corporate_user_summary_wr" id="csr_corporate_user_summary_wr">
			<div class="d-flex align-items-center" style="column-gap:10px;">
				<div class="filter-control">
					<select name="token_type" id="token_type">
						<option value="csr"><?php _e('CSR', CIP_TXTDOMAIN); ?></option>
						<option value="csr25"><?php _e('CSR25', CIP_TXTDOMAIN); ?></option>
					</select>
				</div>
				<div>
					<button type="button" class="btn btn-primary corporate_user_request_withdrawal" style="padding: 11px 11px !important;"><?php _e('Request Withdrawal', CIP_TXTDOMAIN); ?></button>
				</div>
				<div>
					<button type="button" class="btn btn-primary corporate_user_request_withdrawal_download hide" style="padding: 11px 11px !important;"><i class="fa fa-download"></i></button>
				</div>
			</div>
		</div>
	    <table id="corporate_user_request_withdrawal_list" data-toolbar="#csr_corporate_user_summary_wr" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" class="table table-bordered" data-side-pagination="server" data-page-list="[500, 1000, 1500, 2000]" data-page-size="500" data-response-handler="responseHandlerCURW"  data-query-params="queryParams">
			<thead>
			<tr>
				<th data-field="rowiddata" data-switchable="false"><input type="checkbox" name="toggleCURWDAll" id="toggleCURWDAll" checked /></th>
				<th data-field="id" class="id"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
				<?php
				if( $columnsArr ){
					foreach( $columnsArr as $columnKey => $columnsVal ){
						$filter_attr = 'data-sortable="true" data-filter-control="input"';
						if( $columnKey == 'email' ){
							$filter_attr .= 'data-switchable="false"';
						}
						if( $columnKey == 'balance_csr_central' || $columnKey == 'balance_blockchain' || $columnKey == 'pending_balance' ){
							$filter_attr = '';
						}
					?>
					<th data-field="<?php echo $columnKey ?>" <?php echo $filter_attr; ?> class="<?php echo $columnKey; ?>"><?php echo $columnsVal; ?></th>
					<?php
					}
				}
				?>
			</tr>
			</thead>
			<tbody>
			</tbody>
		</table>

		<div class="modal fade" id="csrCorporateUserRequestWithdrawalModal" tabindex="-1" role="dialog" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
				<div class="modal-content">
					<div class="modal-body">
						<div class="container-fluid">
							<span class="withdrawal_close_btn close" data-dismiss="modal">&times;</span>
							<div class="csrCorporateUserRequestWithdrawalBody"></div>
						</div>
					</div>
				</div>
			</div>
		</div>
		</div>
	</div>
	<?php
	}else{
	}
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('WITHDRAWAL-ADDRESS-BLOCK-SETTING', 'withdrawal_address_block_setting_callback');
function withdrawal_address_block_setting_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	ob_start();
	?>
	<div class="d-flex justify-content-end mr-3" id="customToolbar">
		<div class="text-right">
			<button type="button" id="create_withdrawal_block_address_popup" class="text-right" data-toggle="modal" data-target="#createWithdrawalBlockAddressModal"><i class="fa fa-plus" aria-hidden="true"></i> <?php _e('Add Withdrawal Block Address', CIP_TXTDOMAIN); ?></button>
		</div>
	</div>
	<table id="cip_withdrawal_block_address_list" data-search="true" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-page-list="[10, 20, 50, 100]" data-toolbar="#customToolbar">
	<thead>
		<tr>
			<th data-field="id" class="id" data-switchable="false"><?php _e('ID',CIP_TXTDOMAIN); ?></th>
			<th data-field="address_name" data-sortable="true" class="address_name" data-switchable="false"><?php _e('Address Name',CIP_TXTDOMAIN); ?></th>
			<th data-field="withdrawal_block_address" data-sortable="true" class="eth_address withdrawal_block_address" data-switchable="false"><?php _e('Withdrawal Block Address',CIP_TXTDOMAIN); ?></th>
			<th data-field="internal_note" data-sortable="true" class="internal_note" data-switchable="false"><?php _e('Internal Note',CIP_TXTDOMAIN); ?></th>
			<th data-field="action" class="action" data-switchable="false"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
		</tr>
	</thead>
	<tbody>
	</tbody>
	</table>
	<div class="modal fade" id="createWithdrawalBlockAddressModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
			<div class="modal-content">
				<div class="modal-body">
					<form class="create_withdrawal_block_address_frm" id="create_withdrawal_block_address_frm" name="create_withdrawal_block_address_frm">
						<div class="form-group">
							<h5><?php _e('Add Withdrawal Block Address', CIP_TXTDOMAIN); ?></h5>
						</div>
						<div class="form-group">
							<label for="address_name"><?php echo __('Address Name', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" id="address_name" name="address_name" />
						</div>
						<div class="form-group">
							<label for="withdrawal_block_address"><?php echo __('Withdrawal Block Address', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" id="withdrawal_block_address" name="withdrawal_block_address" />
						</div>
						<div class="form-group">
							<label for="internal_note"><?php echo __('Internal note', CIP_TXTDOMAIN); ?></label>
							<input type="text" class="form-control" id="internal_note" name="internal_note" />
						</div>
						<button type="submit" class="btn btn-secondary"><?php _e('Submit', CIP_TXTDOMAIN); ?></button>
						<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
						<input type="hidden" name="action" value="create_withdrawal_block_address_act" />
						<input type="hidden" name="pageid" value="<?php echo get_the_id(); ?>" />
						<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_YCIPWithdrawalBlockAddressCIPY_'); ?>" />
					</form>
				</div>
			</div>
		</div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode( 'HALL-OF-FAME-LIST', 'hall_of_fame_list_cb_new' );
function hall_of_fame_list_cb_new(){
    $html = "";
	global $wpdb;
	$tableRetirement = $wpdb->prefix.'retirement_data';
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'bs-datepicker' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('bs-datepicker');
	$getRetirements = $wpdb->get_results("SELECT * FROM $tableRetirement");
	ob_start();
    ?>
    <div class="row align-items-end" id="hall_of_body">
        <div class="col-xl-9">
			<form name="filter_form_model_form" class="d-flex gap-2" id="filter_form_model_form" style="gap: 10px;">
			<div class="hall-field-group">
				<label>Filter type</label>
				<select name="filter_type" id="search-input" class=" w-30 hall_of_fame_select_filter">
					<option>Please select filter type</option>
					<option value="fullname">Name</option>
					<option value="eth_address">Address</option>
					<option value="retire_transhash">Transaction hash</option>
					<option value="retire_amount">Amount</option>
					<option value="retire_confirm_date">Age</option>
					<option value="retire_token_type">Token</option>
				</select>
			</div>
			<div class="d-flex gap-2 fields-selected" style="width:70%; gap: 10px;" >
				<div class="hall-field-group search-input-field fullname">
					<label>Filter by name</label>
					<input type="text" id="search-input" class="search-input-field fullname" name="fullname" placeholder="Search name">
				</div>
				<div class="hall-field-group search-input-field eth_address">
					<label>Filter by address</label>
					<input type="text" id="search-input" class="search-input-field eth_address" name="eth_address" placeholder="Search address">
				</div>
				<div class="hall-field-group search-input-field retire_transhash">
					<label>Filter by transaction hash</label>
					<input type="text" id="search-input" class="search-input-field retire_transhash" name="retire_transhash" placeholder="Search transaction hash">
				</div>
				<div class="hall-field-group search-input-field retire_amount">
					<label>Filter by amount</label>
					<div class="d-flex amount-filter-class">
						<select id="search-input" class="search-input-field retire_amount" name="retire_amount_type">
							<!-- <option value=""></option> -->
							<option value=">">></option>
							<option value="<"><</option>
							<option value="=">=</option>
							<option value=">=">>=</option>
							<option value="<="><=</option>
						</select>
						<input type="number" id="search-input" class="search-input-field retire_amount" name="retire_amount_start" placeholder="Search greater than amount">
					</div>
				<!-- <input type="text" id="search-input" class="search-input-field retire_amount" name="retire_amount_start" placeholder="Search creater than amount">
				<input type="text" id="search-input" class="search-input-field retire_amount" name="retire_amount_end" placeholder="Search less than amount"> -->
				</div>
				<div class="hall-field-group search-input-field retire_confirm_date">
					<label>Before date</label>
					<input type="date" id="search-input" class="search-input-field retire_confirm_date" name="retire_confirm_date_start" placeholder="Search before date">
				</div>
				<div class="hall-field-group search-input-field retire_confirm_date">
					<label>After date </label>
					<input type="date" id="search-input" class="search-input-field retire_confirm_date" name="retire_confirm_date_end" placeholder="Search after date">
				</div>
				<div class="hall-field-group search-input-field retire_token_type">
					<label>Filter by amount</label>
					<div class="d-flex amount-filter-class">
						<select id="search-input" class="search-input-field retire_token_type" name="token_type">
							<option value="">Select Token</option>
							<option value="CSR">CSR</option>
							<option value="CSR25">CSR25</option>
						</select>
					</div>
				</div>
			</div>
			</form>
        </div>
        <div class="col-xl-3 nrl_row d-flex justify-content-end">

            <ul id="hall_of_fame_grid_list">
                <li class="Clear-button" data-toggle="tooltip" data-placement="top" title="Clear Filter">
				<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="40" height="40" viewBox="0 0 122.88 110.668" enable-background="new 0 0 122.88 110.668" xml:space="preserve"><g><path fill-rule="evenodd" fill="#ffffff" clip-rule="evenodd" d="M91.124,15.645c12.928,0,23.406,10.479,23.406,23.406 c0,12.927-10.479,23.406-23.406,23.406c-12.927,0-23.406-10.479-23.406-23.406C67.718,26.125,78.197,15.645,91.124,15.645 L91.124,15.645z M2.756,0h117.322c1.548,0,2.802,1.254,2.802,2.802c0,0.848-0.368,1.622-0.996,2.139l-10.667,13.556 c-1.405-1.375-2.95-2.607-4.614-3.672l6.628-9.22H9.43l37.975,46.171c0.59,0.516,0.958,1.254,0.958,2.102v49.148l21.056-9.623 V57.896c1.651,1.9,3.548,3.582,5.642,4.996v32.133c0,1.105-0.627,2.064-1.586,2.506l-26.476,12.758 c-1.327,0.773-3.023,0.332-3.798-1.033c-0.258-0.441-0.368-0.92-0.368-1.4V55.02L0.803,4.756c-1.07-1.106-1.07-2.839,0-3.945 C1.355,0.258,2.056,0,2.756,0L2.756,0z M96.93,28.282c1.328-1.349,3.489-1.355,4.825-0.013c1.335,1.342,1.341,3.524,0.013,4.872 l-5.829,5.914l5.836,5.919c1.317,1.338,1.299,3.506-0.04,4.843c-1.34,1.336-3.493,1.333-4.81-0.006l-5.797-5.878l-5.807,5.889 c-1.329,1.349-3.489,1.355-4.826,0.013c-1.335-1.342-1.341-3.523-0.013-4.872l5.83-5.913l-5.836-5.919 c-1.317-1.338-1.3-3.507,0.04-4.843c1.339-1.336,3.492-1.333,4.81,0.006l5.796,5.878L96.93,28.282L96.93,28.282z"/></g></svg>
                </li>
                <li class="grid active">
					<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none">
						<path d="M16.6667 5H5V16.6667H16.6667V5Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
						<path d="M35.0002 5H23.3335V16.6667H35.0002V5Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
						<path d="M35.0002 23.3333H23.3335V34.9999H35.0002V23.3333Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
						<path d="M16.6667 23.3333H5V34.9999H16.6667V23.3333Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
					</svg>
                </li>
                <li class="list">
					<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none">
						<path d="M5 20H35" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
						<path d="M5 10H35" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
						<path d="M5 30H35" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
					</svg>
                </li>
            </ul>
        </div>
    </div>
    <div id="az-pagination">
        <!-- Links will be added dynamically here -->
    </div>
	<div class="hall-of-wall-list-body">
		<div class="csr_split_spinner" style="display: none;">
			<img src="/wp-content/uploads/csr.png" class="hall_of_body_img_loader">
			<!-- <div class="spinner-grow spinner-grow-sm text-primary"></div> -->
			<!-- <div class="spinner-grow spinner-grow-sm text-primary"></div> -->
			<!-- <div class="spinner-grow spinner-grow-sm text-primary"></div> -->
		</div>
		<div id="post-list" class="nlr_grid_view">
			<div class="hall_of_fame_list_row">
			<?php
				global $wpdb;
				$tableRetirement = $wpdb->prefix.'retirement_data';
				$tableTokenHolder = $wpdb->prefix.'token_holder';
				$tableRetirementSetting = $wpdb->prefix.'retirement_setting';
				$user_id = get_current_user_id();
				$user_id = -1;

				$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableRetirement");
				$getRetirements = $wpdb->get_results("SELECT * FROM $tableRetirement");

				$limit = isset( $_POST['postsPerPage'] ) ? $_POST['postsPerPage'] : 12;
				$offset = isset( $_POST['page']) ? ($_POST['page']-1)*$limit : 0;
				$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
				$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'desc';

				$filter_qry = "";
				$visibility_qry = 'retire_visibility = 3';
				$refAccount = ( isset( $_SESSION['refAccount'] ) ) ? $_SESSION['refAccount'] : '-';
				if( is_user_logged_in() ){
					$visibility_qry = '((retire_visibility = 3 OR retire_visibility = 2) OR (email = "'.$refAccount.'" AND retire_visibility = 1))';
				}
				$filters = json_decode( stripslashes( $_REQUEST['columnfilter'] ), true );
				if( !empty( $filters ) ){
					$count = 1;
					foreach( $filters as $filterKey => $filterData ){
						if( $filterKey == 'fullname' ){
							$companyEmails = array();
							$getCompanies = $wpdb->get_results("SELECT `email` FROM $tableRetirementSetting WHERE 1 AND `company_name` like '%".$filterData."%' AND `company_name_toggle` = 1");
							if( $getCompanies ){
								foreach( $getCompanies as $getCompany ){
									$companyEmails[] = $getCompany->email;
								}
							}
							if( !empty( $companyEmails ) ){
								$companyEmail = implode( "','",$companyEmails );
								$filter_qry .= " AND ( `first_name` LIKE '%" . $filterData . "%' OR `last_name` LIKE '%" . $filterData . "%' OR `email` IN ('".$companyEmail."') )";
							}else{
								$filter_qry .= " AND ( `first_name` LIKE '%" . $filterData . "%' OR `last_name` LIKE '%" . $filterData . "%' )";
							}
						}else if($filterKey == 'letter'){
							$companyEmails = array();
							$getCompanies = $wpdb->get_results("SELECT `email` FROM $tableRetirementSetting WHERE 1 AND `company_name` like '".$filterData."%' AND `company_name_toggle` = 1");
							if( $getCompanies ){
								foreach( $getCompanies as $getCompany ){
									$companyEmails[] = $getCompany->email;
								}
							}
							if( !empty( $companyEmails ) ){
								$companyEmail = implode( "','",$companyEmails );
								$filter_qry .= " AND ( `first_name` LIKE '" . $filterData . "%' OR `last_name` LIKE '" . $filterData . "%' OR `email` IN ('".$companyEmail."') )";
							}else{
								$filter_qry .= " AND ( `first_name` LIKE '" . $filterData . "%' OR `last_name` LIKE '" . $filterData . "%' )";
							}
						}else{
							$filter_qry .= ( $filterKey == 'retire_amount' ) ? " AND `$filterKey` = $filterData" : " AND `$filterKey` LIKE '" . $filterData . "%'";
						}
						// $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
						$count++;
					}
					$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableRetirement WHERE retire_status = 1 AND $visibility_qry $filter_qry ORDER BY `id` DESC");
				}else{
					$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableRetirement WHERE retire_status = 1 AND $visibility_qry $filter_qry");
				}


				$getRetirements = $wpdb->get_results("SELECT * FROM $tableRetirement WHERE retire_status = 1 AND $visibility_qry $filter_qry ORDER BY `$orderby` $order LIMIT $limit OFFSET $offset");
				// $getRetirements = $wpdb->get_results("SELECT * FROM $tableRetirement WHERE retire_status = 1 AND $visibility_qry $filter_qry ORDER BY `$orderby` $order LIMIT $limit OFFSET $offset");
				$user_id = get_current_user_id();
				// echo "ORDER BY `$orderby` $order LIMIT $limit OFFSET $offset";

				$csr_wallet_api_mode = ( !empty( get_option('csr_wallet_api_mode') ) ) ? get_option('csr_wallet_api_mode') : 'test';
				$endpoint = ( $csr_wallet_api_mode == 'live' ) ? 'https://etherscan.io/tx/' : 'https://sepolia.etherscan.io/tx/';
				$rows = array();
				if( $getRetirements ){
					foreach( $getRetirements as $getRetirement ){
						$row = array();
						$columnsDataVal = '—';
						if( !empty( $getRetirement->eth_address ) ){
							$columnsDataValMask = substr($getRetirement->eth_address, 0, 6) . '...' . substr($getRetirement->eth_address, -6);
							$columnsDataVal = '<a href="https://etherscan.io/address/'. $getRetirement->eth_address . '#tokentxns" target="_blank" data-toggle-tt="tooltip" data-placement="top" title="'.$getRetirement->eth_address.'" >'.$columnsDataValMask.'</a>';
						}else{
							$columnsDataVal = '—';
						}

						$retire_transhash = '—';
						if( !empty( $getRetirement->retire_transhash ) ){
							$transhashDataValMask = substr($getRetirement->retire_transhash, 0, 10) . '...' . substr($getRetirement->retire_transhash, -10);
							$retire_transhash = '<a href="'.$endpoint.$getRetirement->retire_transhash.'" target="_blank" class="transhash_view" data-toggle-tt="tooltip" data-placement="top" title="'.$getRetirement->retire_transhash.'" >'.$transhashDataValMask.'</a>';
						}else{
							$retire_transhash = '—';
						}

						$retire_confirm_date = '—';
						try {
							$DateObj = DateTime::createFromFormat( 'Y-m-d H:i:s', $getRetirement->retire_confirm_date );
							// $retire_confirm_date = $DateObj->format('d/m/Y');
							$retire_confirm_date = time_elapsed_string( $getRetirement->retire_confirm_date );
						} catch (\Throwable $th) {
							$retire_confirm_date = '—';
						}

						$hiLine = $getRetirement->first_name.' '.$getRetirement->last_name;

					$getTokenData = $wpdb->get_row("SELECT `first_name`,`last_name` FROM $tableTokenHolder WHERE email IN ('".$getRetirement->email."') ORDER BY id DESC");
			if( $getTokenData ){
				if( !empty( $getTokenData->first_name ) || !empty( $getTokenData->last_name ) ){
					$hiLine = $getTokenData->first_name . ' ' . $getTokenData->last_name;
				}
			}

			$getRetirementSetting = $wpdb->get_row("SELECT `company_name_toggle`,`company_name`,`status`,`member_logo`,`member_url` FROM $tableRetirementSetting WHERE email = '".$getRetirement->email."' ");
						$member_logo_img = "";
						if( $getRetirementSetting ){
							if( $getRetirementSetting->company_name_toggle == 1 && !empty( $getRetirementSetting->company_name ) ){
								$hiLine = $getRetirementSetting->company_name;
							}
							if( $getRetirementSetting->status == 1 && !empty( $getRetirementSetting->member_logo ) ){
								$member_logo_img = '<img class="member_logo_img" src="data:image/jpg;charset=utf8;base64,'.base64_encode($getRetirementSetting->member_logo).'" class="img-responsive" />';
								if( !empty( $getRetirementSetting->member_url ) ){
									$member_logo_img = '<a href="'. $getRetirementSetting->member_url .'" target="_blank">'.$member_logo_img.'</a>';
								}
							}
							if( $getRetirementSetting->status == 1 && !empty( $getRetirementSetting->member_url ) ){
								$hiLine = '<a href="'. $getRetirementSetting->member_url .'" target="_blank">'.$hiLine.' <span><svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" viewBox="0 0 12 12" fill="none">
								<path d="M9.09473 0.00324014C8.33321 0.0393708 7.60225 0.371958 7.03621 0.937078L4.81742 3.15587C5.16575 2.80568 6.45997 3.04655 6.7731 3.36061L8.11642 2.01729C8.4138 1.71991 8.78623 1.5374 9.16792 1.52165C9.42639 1.50868 9.79325 1.56334 10.1166 1.88666C10.4177 2.18775 10.4816 2.53794 10.4816 2.77696C10.4816 3.17625 10.2991 3.57369 9.98502 3.88589L7.6495 6.23624C7.06215 6.82452 6.16722 6.87177 5.64935 6.35297C5.35382 6.05744 4.86652 6.05558 4.56913 6.35297C4.27175 6.65035 4.27175 7.1358 4.56913 7.43318C5.10183 7.9668 5.80221 8.23639 6.52482 8.23639C7.3058 8.23639 8.10345 7.91677 8.71489 7.30255L11.0652 4.96611C11.6619 4.37134 12 3.57554 12 2.77696C12 2.03397 11.7184 1.32803 11.1968 0.805525C10.6382 0.247817 9.88867 -0.0338169 9.09473 0.00324014ZM5.47425 3.76916C4.69328 3.76916 3.88265 4.09063 3.26936 4.70393L0.933838 7.03945C0.337219 7.63421 0 8.43001 0 9.22952C0 9.97159 0.280707 10.6785 0.802285 11.2C1.36092 11.7587 2.11133 12.0394 2.90527 12.0032C3.66587 11.9662 4.39775 11.6345 4.96287 11.0685L7.18258 8.84969C6.83147 9.19987 5.54003 8.959 5.22597 8.64495L3.88265 9.98826C3.58527 10.2856 3.21285 10.4663 2.83209 10.4848C2.57269 10.4978 2.20582 10.4422 1.88342 10.1198C1.58234 9.81873 1.51841 9.46669 1.51841 9.22952C1.51841 8.8293 1.70092 8.43187 2.01405 8.11966L4.3505 5.76932C4.93785 5.18196 5.83185 5.13657 6.34973 5.65259C6.64711 5.94997 7.13441 5.94997 7.42994 5.65259C7.72732 5.35521 7.72732 4.86976 7.42994 4.57238C6.89724 4.03968 6.19501 3.76916 5.47425 3.76916Z" fill="#363636"/>
							</svg></span></a>';
							}
						}

						$row['member_logo'] = $member_logo_img;
						$row['fullname'] = $hiLine;
						$row['eth_address'] = $columnsDataVal;
						$row['retire_transhash'] = $retire_transhash;
						// $row['retire_transhash'] = $select_abc;
						$retire_amount = floatval( bcadd( $getRetirement->retire_amount, 0, 2) );
						if (fmod($retire_amount, 1) !== 0.0) {
							$row['retire_amount'] = cip_number_format($getRetirement->retire_amount,true)." ".$getRetirement->token;
						}else{
							$row['retire_amount'] = cip_number_format($getRetirement->retire_amount,false)." ".$getRetirement->token;
						}
						$row['retire_confirm_date'] = $retire_confirm_date;
						$rows[] = $row;
						?>
						<div class="item">
							<div class="item_row">

								<?php
								if($member_logo_img){
									?>
									<div class="item_img">
										<?php echo $member_logo_img; ?>
									</div>
									<?php
								}

								?>

								<div class="item_contain">
									<div class="item_inner_grup">
										<h4><?php echo $hiLine;?></h4>
									</div>
									<div class="item_inner_grup">
										<p class="cc_title">Address</p>
										<p class="cc_total"><?php echo $columnsDataVal; ?></p>
									</div>
									<div class="item_inner_grup">
										<p class="cc_title">Transaction hash</p>
										<p class="cc_total"><?php echo $retire_transhash; ?></p>
									</div>
									<div class="item_inner_grup row align-items-end justify-content-between">
										<!-- <div class="row align-items-end"> -->
											<div>
												<p class="cc_title">Amount</p>
												<?php if (fmod($retire_amount, 1) !== 0.0) { ?>
													<p class="cc_total  mini-total"><?php echo cip_number_format($getRetirement->retire_amount,true); ?> <?=$getRetirement->token?></p>
												<?php }else{ ?>
													<p class="cc_total  mini-total"><?php echo cip_number_format($getRetirement->retire_amount,false); ?> <?=$getRetirement->token?></p>
												<?php } ?>
											</div>
											<div class="">
												<p class="cc_title w-100 text-left new">Age</p>
												<p class="cc_total text-right"><?php echo $retire_confirm_date; ?></p>
											</div>
										<!-- </div> -->

									</div>
								</div>
							</div>
						</div>
						<?php
					}
				}else{
					echo 'No Hall of Fame Found';
				}
			?>
			</div>
		</div>
		<div class="hall-of-wall-bot-table">
			<table id="retirement_table">
			</table>
			<!-- <table id="retirement_table" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="false" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[12]">
				<thead>
					<tr>
						<th data-field="member_logo" class="member_logo"></th>
						<th data-field="fullname" data-sortable="false" data-filter-control="input" data-switchable="false" class="fullname"><?php _e('Name',CIP_TXTDOMAIN); ?></th>
						<th data-field="eth_address" data-sortable="false" data-filter-control="input" data-switchable="false" class="eth_address"><?php _e('CSR address',CIP_TXTDOMAIN); ?></th>
						<th data-field="retire_transhash" data-filter-control="input" class="retire_transhash" data-switchable="false"><?php _e('Transaction hash',CIP_TXTDOMAIN); ?></th>
						<th data-field="retire_amount" class="retire_amount" data-filter-control="input" data-sortable="false" data-switchable="false"><?php _e('Amount',CIP_TXTDOMAIN); ?><div class="log_data"></div></th>
						<th data-field="retire_confirm_date" class="retire_confirm_date" data-filter-control="input" data-sortable="false" data-switchable="false"><?php _e('Age',CIP_TXTDOMAIN); ?></th>
					</tr>
				</thead>
				<tbody>
				</tbody>
			</table> -->
		</div>
		<div id="pagination-dropdown-wrapper">
			<!-- <div id="pagination-dropdown">
				<form id="pagination-dropdown-form" action="" method="get">
					<label for="posts_per_page">Hall of Fame Per Page:</label>
					<select name="posts_per_page" class="btn btn-secondary dropdown-toggle" id="posts_per_page" >
						<option value="10" selected>10</option>
						<option value="20" >20</option>
						<option value="50">50</option>
					</select>
				</form>
			</div> -->
			<div id="pagination" current_page="1"></div>
		</div>
	</div>
    <script>
		var totalPosts = parseInt(<?php echo $total_items; ?>);
		var totalPages = Math.ceil(totalPosts / 12);
		var pagination = jQuery('#pagination');
		pagination.empty();
        var currentPage = 1;

        if (totalPages > 1) {
            if (currentPage > 1) {
                pagination.append('<a class="prev-page" href="#"><i class="fa fa-angle-double-left"></i> Previous</a>');
            }else{
                pagination.append('<a class="prev-page disabled" href="#"><i class="fa fa-angle-double-left"></i> Previous</a>');
            }

            // Show first 5 pages
            if (currentPage <= 5) {
                for (var i = 1; i <= Math.min(5, totalPages); i++) {
                    pagination.append(createPageLink(i, currentPage));
                }
                if (totalPages > 5) {
                    pagination.append('<span class="dots">...</span>');
                    pagination.append(createPageLink(totalPages, currentPage));
                }

            // Show last 5 pages
            } else if (currentPage > totalPages - 5) {
                pagination.append(createPageLink(1, currentPage));
                pagination.append('<span class="dots">...</span>');

                for (var i = totalPages - 4; i <= totalPages; i++) {
                    pagination.append(createPageLink(i, currentPage));
                }

            // Show the first page, "...", 3 pages around the current page, "...", and the last page
            } else {
                pagination.append(createPageLink(1, currentPage)); // First page
                pagination.append('<span class="dots">...</span>'); // "..."

                // Show 3 pages centered around the current page
                for (var i = currentPage - 1; i <= currentPage + 1; i++) {
                    pagination.append(createPageLink(i, currentPage));
                }

                pagination.append('<span class="dots">...</span>'); // "..."
                pagination.append(createPageLink(totalPages, currentPage)); // Last page
            }

            if (currentPage < totalPages) {
                pagination.append('<a class="next-page" href="#">Next <i class="fa fa-angle-double-right"></i></a>');
            }else{
                pagination.append('<a class="next-page disabled" href="#">Next <i class="fa fa-angle-double-right"></i></a>');
            }
        }

	    function createPageLink(pageNumber, currentPage) {
	        if (pageNumber == currentPage) {
	            return '<span class="current-page">' + pageNumber + '</span>';
	        } else {
	            return '<a class="mini-page" href="#" mini-page="' + pageNumber + '">' + pageNumber + '</a>';
	        }
	    }
		jQuery(window).on('load',function(){
			jQuery('#retirement_table').bootstrapTable('destroy');
			// jQuery('#retirement_table').bootstrapTable({ data: response_data.rows });
			jQuery('#retirement_table').bootstrapTable({
				data: <?php echo json_encode($rows);?>,
				columns: [
					{
					field: 'member_logo',
					title: 'Member Logo',
					class: 'member_logo'
					},
					{
					field: 'fullname',
					title: 'Full Name',
					class: 'fullname'
					},
					{
					field: 'eth_address',
					title: 'ETH Address',
					class: 'eth_address'
					},
					{
					field: 'retire_transhash',
					title: 'Transaction Hash',
					class: 'retire_transhash'
					},
					{
					field: 'retire_amount',
					title: 'Retire Amount',
					class: 'retire_amount'
					},
					{
					field: 'retire_confirm_date',
					title: 'Confirmation Date',
					class: 'retire_confirm_date'
					}
				]
			});
		});
		jQuery(document).on('click','.az-link', function (e) {
			e.preventDefault();
			jQuery('.az-link').removeClass('active');
			var letter = jQuery(this).attr('data-letter');
			jQuery(this).addClass('active');
			jQuery('#az-pagination').attr('data-letter', letter);
			// load_hall_of_fame();
			// updatePagination();
			jQuery('#pagination').attr('current_page',1);
			retirement_table_update();
		});
		jQuery(document).on('click','#pagination .prev-page,#pagination .mini-page,#pagination .next-page', function (e) {
			
			// load_hall_of_fame();
			// updatePagination();
			retirement_table_update();
		});
		jQuery(document).on('change','.hall_of_fame_select_filter', function (e) {
			e.preventDefault();
			
			
			jQuery(".search-input-field").hide();
			var value = jQuery(this).val();
			jQuery("."+value).show();
			// retirement_table_update();
		});
		jQuery('.hall-of-wall-bot-table').hide();
		
		function retirement_table_update() {
			var $pool_ref = jQuery('#retirement_table .retire_amount .filter-control input');
			let eve = jQuery.Event("keyup");
			// console.log("test2");
			eve.which = 13
			eve.keyCode = 13
			$pool_ref.trigger(eve);
		};
		jQuery(document).on('change','.search-input-field', function (e) {
			// jQuery(".search-input-field").val("");
			// jQuery(".search-input-field").hide();
			
			if($(this).attr('name')){
				if($(this).attr('name') == 'retire_amount_type' ){
					if(jQuery("[name='retire_amount_start']").val() != ""){
						retirement_table_update();
					}
				}else{
					retirement_table_update();
				}
			}
		});
		
	</script>
    <?php
    $html .= ob_get_clean();
    return $html;
}
add_shortcode('SM-VAT-PRICE-API-SETTING-OPTION','cip_sm_price_api_setting_option_cb');
function cip_sm_price_api_setting_option_cb(){
	$html = "";
	ob_start();
	if( current_user_can('supportmanager') || current_user_can('supportagent') ){

		$amplivo_api_mode = ( !empty( get_option('amplivo_api_mode') ) ) ? get_option('amplivo_api_mode') : '' ;
		$selling_price_csr = ( !empty( get_option('selling_price_csr') ) ) ? get_option('selling_price_csr') : '' ;
		$amplivo_api_live_source_url = ( !empty( get_option('amplivo_api_live_source_url') ) ) ? get_option('amplivo_api_live_source_url') : '' ;
		$amplivo_api_test_source_url = ( !empty( get_option('amplivo_api_test_source_url') ) ) ? get_option('amplivo_api_test_source_url') : '' ;
		$amplivo_api_auth_username = ( !empty( get_option('amplivo_api_auth_username') ) ) ? get_option('amplivo_api_auth_username') : '' ;
		$amplivo_api_auth_pwd = ( !empty( get_option('amplivo_api_auth_pwd') ) ) ? get_option('amplivo_api_auth_pwd') : '' ;
		$selling_price_csr = ( !empty( get_option('selling_price_csr') ) ) ? get_option('selling_price_csr') : 0.025 ;
		$selling_kgs = ( !empty( get_option('selling_kgs') ) ) ? get_option('selling_kgs') : 1;
		$selling_price_csr_inc = ( !empty( get_option('selling_price_csr_inc') ) ) ? get_option('selling_price_csr_inc') : 0;
		//echo $selling_price_csr_inc;
	?>
	<hr class="pt-1 pb-2">
	<h4 class="mb-0"><?php _e('Amplivo API', CIP_TXTDOMAIN); ?></h4>
	<form name="sm_price_api_settings" id="sm_price_api_settings">
		<div class="form-group">
			<label for="amplivo_api_mode"><?php _e('API Mode', CIP_TXTDOMAIN); ?></label>
			<!-- <input type="number" class="form-control" step="0.00001" name="amplivo_api_mode" id="amplivo_api_mode" value="<?php echo $selling_price_csr; ?>"> -->
			<select class="regular-text"  class="form-control" id="amplivo_api_mode" name="amplivo_api_mode">
				<option>Select Mode</option>
				<option value="live" <?php echo ($amplivo_api_mode == 'live') ? 'selected' : '' ;?>>live</option>
				<option value="stage"  <?php echo ($amplivo_api_mode == 'stage') ? 'selected' : '' ;?>>Stage</option>
			</select>
		</div>
		<div class="form-group">
			<label for="amplivo_api_live_source_url"><?php _e('API URL', CIP_TXTDOMAIN); ?></label>
			<input type="text" class="form-control" name="amplivo_api_live_source_url" id="amplivo_api_live_source_url" value="<?php echo $amplivo_api_live_source_url; ?>">
		</div>
		<div class="form-group">
			<label for="amplivo_api_test_source_url"><?php _e('API Test URL', CIP_TXTDOMAIN); ?></label>
			<input type="text" class="form-control" name="amplivo_api_test_source_url" id="amplivo_api_test_source_url" value="<?php echo $amplivo_api_test_source_url; ?>">
		</div>
		<div class="form-group">
			<label for="amplivo_api_auth_username"><?php _e('API User Name', CIP_TXTDOMAIN); ?></label>
			<input type="text" class="form-control" name="amplivo_api_auth_username" id="amplivo_api_auth_username" value="<?php echo $amplivo_api_auth_username; ?>">
		</div>
		<div class="form-group">
			<label for="amplivo_api_auth_pwd"><?php _e('API User Password', CIP_TXTDOMAIN); ?></label>
			<input type="text" class="form-control" name="amplivo_api_auth_pwd" id="amplivo_api_auth_pwd" value="<?php echo $amplivo_api_auth_pwd; ?>">
		</div>
		<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="cip_sm_price_api_settings_act" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxspricemapisettingxCIP_'); ?>" />
		<p class="form_response"></p>
	</form>
	<?php
	}
	$html .= ob_get_clean();
	return $html;
}
/**
 * CSR Pool Report
 */
add_shortcode('CSR-POOL-REPORT-LIST', 'csr_pool_report_list_callback');
function csr_pool_report_list_callback(){
	$html = "";
	global $wpdb;
	$current_user = wp_get_current_user();
	$user_id = $current_user->ID;
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'daterangepicker-style' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('dr-moment');
	wp_enqueue_script('daterangepicker-script');
	wp_enqueue_style( 'select2' );
	wp_enqueue_script('select2');
	ob_start();
	$data_micro = wp_create_nonce( $user_id . md5('CIP_RefreshPoolReportData_CIP') );
	$tableTokenHolder = $wpdb->prefix.'token_holder';
	$getDistributionStatus = $wpdb->get_results( "SELECT `corp_approved` FROM $tableTokenHolder GROUP BY `corp_approved`" );
	$lastRefreshDate = get_option('csr_pool_report_refresh');
	$lastRefreshDateFormat = "";
	if( !empty( $lastRefreshDate ) ){
		try {
			$_date = DateTime::createFromFormat('Y-m-d H:i:s', $lastRefreshDate);
			$lastRefreshDateFormat = $_date->format('d/m/Y H:i A');
		} catch (\Throwable $th) {
			$lastRefreshDateFormat = '';
		}
	}
	?>
	<div class="d-flex justify-content-end" id="customToolbar">
		<button type="button" id="create_csr_pool_report_popup" data-toggle="modal" data-target="#createCsrPoolReportModal" data-backdrop="static" data-keyboard="false"><i class="fa fa-plus" aria-hidden="true"></i> <?php _e('Add Report Row', CIP_TXTDOMAIN); ?></button>
		<div class="d-flex align-items-center">
			<button type="button" class="ml-2" id="refresh_csr_pool_report" data-_micro="<?php echo $data_micro; ?>" data-toggle="tooltip" data-placement="top" title="<?php _e('Refresh CSR Pool Report', CIP_TXTDOMAIN); ?>" ><i class="fa fa-sync" aria-hidden="true"></i></button>
			<p class="pool_report_last_update m-0"><?php echo sprintf( __('Last update: %s', CIP_TXTDOMAIN), $lastRefreshDateFormat ); ?></p>
		</div>
	</div>
	<table id="csr_pool_report_list" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" data-click-to-select="false" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]" data-page-size="10" data-toolbar="#customToolbar">
	<thead>
		<tr>
			<th data-field="id" class="id" data-switchable="false"><?php _e('ID',CIP_TXTDOMAIN); ?></th>
			<th data-field="distribution_status" class="distribution_status" data-switchable="true" data-filter-control="select" data-sortable="true" data-filter-data="var:distributionStatus"><?php _e('Distribution Status',CIP_TXTDOMAIN); ?></th>
			<th data-field="pool_reference" class="pool_reference" data-switchable="true" data-filter-control="input" data-sortable="true"><?php _e('Pool Reference',CIP_TXTDOMAIN); ?></th>
			<th data-field="distribution_week" class="distribution_week" data-switchable="true" data-filter-control="input" data-sortable="true"><?php _e('Distribution Week',CIP_TXTDOMAIN); ?></th>
			<th data-field="amount_due_condition_value" class="amount_due_condition_value" data-switchable="true" data-filter-control="input"><?php _e('Amount Due Condition',CIP_TXTDOMAIN); ?></th>
			<th data-field="csr_initial_amount" class="csr_initial_amount" data-switchable="true" data-filter-control="input" data-sortable="true"><?php _e('CSR Initial Amount',CIP_TXTDOMAIN); ?></th>
			<th data-field="csr_distributed" class="csr_distributed" data-switchable="true" data-filter-control="input" data-sortable="true"><?php _e('CSR Distributed',CIP_TXTDOMAIN); ?></th>
			<th data-field="amount_due" class="amount_due" data-switchable="true" data-filter-control="input" data-sortable="true"><?php _e('Amount Due',CIP_TXTDOMAIN); ?></th>
			<th data-field="action" class="action" data-switchable="false"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
		</tr>
	</thead>
	<tbody>
	</tbody>
	</table>
	<div class="modal fade" id="poolRefFilterModal" tabindex="-1" role="dialog" aria-labelledby="poolRefFilterModal" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">

			<form class="filter_by_pool_reference" name="filter_by_pool_reference" id="filter_by_pool_reference">
				<div class="modal-body">
					<div class="form-group">
						<label for="filter_by_condition_pool_reference">Filter by condition</label>
						<select class="form-control" name="filter_condition_type_pool_reference" id="filter_condition_type_pool_reference">
							<option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
							<option value="is_exactly_simple"><?php _e('Is exactly (multiple)', CIP_TXTDOMAIN); ?></option>
							<option value="is_exactly"><?php _e('Is exactly adv. (multiple)', CIP_TXTDOMAIN); ?></option>
						</select>
						<textarea name="filter_condition_value_pool_reference_bulk" id="filter_condition_value_pool_reference_bulk" class="form-control mt-2" style="display: none;" rows="3" placeholder="<?php _e('Bulk Pool Reference', CIP_TXTDOMAIN ); ?>"></textarea>
						<select class="form-control mt-2" style="width:100%" name="filter_condition_value_pool_reference[]" id="filter_condition_value_pool_reference" multiple></select>
					</div>
				</div>
				<div class="modal-footer">
		        	<button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
		        	<button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
				</div>
			</form>
		    </div>
		  </div>
		</div>

		<div class="modal fade" id="DistributionWeekFilterModal" tabindex="-1" role="dialog" aria-labelledby="DistributionWeekFilterModal" aria-hidden="true">
		  <div class="modal-dialog modal-dialog-centered" role="document">
		    <div class="modal-content">

				<form class="filter_by_distribution_week" name="filter_by_distribution_week" id="filter_by_distribution_week">
					<div class="modal-body">
						<div class="form-group">
							<label for="filter_by_condition_distribution_week">Filter by condition</label>
							<select class="form-control" name="filter_condition_type_distribution_week" id="filter_condition_type_distribution_week">
								<option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
								<option value="weeks_before"><?php _e('Weeks Before', CIP_TXTDOMAIN); ?></option>
								<option value="is_exactly_simple"><?php _e('Is exactly (multiple)', CIP_TXTDOMAIN); ?></option>
								<option value="is_exactly"><?php _e('Is exactly adv. (multiple)', CIP_TXTDOMAIN); ?></option>
							</select>
							<input type="text" class="form-control mt-2" name="filter_condition_value_distribution_week_before" id="filter_condition_value_distribution_week_before" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
							<textarea name="filter_condition_value_distribution_bulk" id="filter_condition_value_distribution_bulk" class="form-control mt-2" style="display: none;" rows="3" placeholder="<?php _e('Bulk Distribution Week', CIP_TXTDOMAIN ); ?>"></textarea>
							<select class="form-control mt-2" style="width:100%" name="filter_condition_value_distribution_week[]" id="filter_condition_value_distribution_week" multiple></select>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
						<button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
					</div>
				</form>
		    </div>
		  </div>
		</div>
	<div class="modal fade" id="createCsrPoolReportModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
		<div class="modal-content">
			<div class="modal-body">
			<span class="modalpopup_close_btn close" data-dismiss="modal">×</span>
				<form class="create_csrpoolreport_frm" id="create_csrpoolreport_frm" name="create_csrpoolreport_frm">
					<div class="form-group">
						<h5><?php _e('Add Report Row', CIP_TXTDOMAIN); ?></h5>
					</div>
					<div class="row">
						<div class="col-12">
							<div class="form-group">
								<label><?php _e('Distribution Status', CIP_TXTDOMAIN); ?></label>
								<select class="form-control" name="distribution_status">
									<option value="" selected disabled><?php _e('Select Distribution Status', CIP_TXTDOMAIN); ?></option>
									<?php
									if( $getDistributionStatus ){
										foreach( $getDistributionStatus as $distributionStatus){
											?><option value="<?php echo $distributionStatus->corp_approved ?>"><?php echo $distributionStatus->corp_approved ?></option><?php
										}
									}
									?>
								</select>
							</div>
						</div>
						<div class="col-12">
							<div class="form-group">
								<label><?php _e('Pool Reference', CIP_TXTDOMAIN); ?></label>
								<select class="form-control" name="pool_reference"></select>
							</div>
						</div>
						<div class="col-12">
							<div class="form-group">
								<label><?php _e('Distribution Week', CIP_TXTDOMAIN); ?></label>
								<select class="form-control" name="distribution_week"></select>
							</div>
						</div>
						<div class="col-12">
							<label><?php _e('Amount Due', CIP_TXTDOMAIN); ?></label>
							<div class="input-group mb-3">
								<div class="input-group-prepend">
									<select class="form-control" name="amount_due_condition">
										<option value=""></option>
										<option value="<"><?php echo '<'; ?></option>
										<option value="="><?php echo '='; ?></option>
										<option value=">"><?php echo '>'; ?></option>
										<option value=">="><?php echo '>='; ?></option>
										<option value="<="><?php echo '<='; ?></option>
									</select>
								</div>
								<input type="text" class="form-control" name="amount_due_condition_value" />
							</div>
						</div>
					</div>
					<button type="submit" class="btn btn-secondary"><?php _e('Add', CIP_TXTDOMAIN); ?></button>
					<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Cancel', CIP_TXTDOMAIN) ?></button>
					<input type="hidden" name="action" value="create_csr_pool_report_act" />
					<input type="hidden" name="pageid" value="<?php echo get_the_id(); ?>" />
					<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_YCIPCSRPoolReportCIPY_'); ?>" />
				</form>
			</div>
		</div>
		</div>
	</div>
	<div class="modal fade" id="EditCsrPoolReportModal" tabindex="-1" role="dialog">
		<div class="modal-dialog modal-lg modal-dialog-centered" role="document">
		<div class="modal-content">
			<div class="modal-body">
			</div>
		</div>
		</div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
include( CIP_PLUGIN_BASE.'includes/member-wp-creation/member-wp-creation.php' );
add_shortcode('member-wp-creation','sa_member_wp_creation_callback');
function sa_member_wp_creation_callback(){
    //include member-wp-creation file
    return get_member_wp_creation();
}
include( CIP_PLUGIN_BASE.'includes/amplivo-api-settings-page/amplivo-api-settings-page.php' );
add_shortcode('amplivo-api-settings-page','amplivo_api_settings_page_callback');
function amplivo_api_settings_page_callback(){
    //include amplivo-api-settings-page file
    return get_amplivo_api_settings_page();
}
include( CIP_PLUGIN_BASE.'includes/csr-savings/csr-savings.php' );
add_shortcode('SM-CSR-SAVINGS','sm_csr_saving_callback');
function sm_csr_saving_callback(){
    //include csr-savings file
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_style( 'daterangepicker-style' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_script('dr-moment');
	wp_enqueue_script('daterangepicker-script');
	wp_enqueue_style( 'select2' );
	wp_enqueue_script('select2');
    return get_sm_csr_saving();
}
/**
 * Member to Member Transfer
 */
include( CIP_PLUGIN_BASE.'includes/member-transfer/member-transfer.php' );
include( CIP_PLUGIN_BASE.'includes/member-transfer/member-transfer-listing.php' );
add_shortcode('SA-MEMBER-TO-MEMBER-TRANSFER','sa_member_to_member_transfer_callback');
function sa_member_to_member_transfer_callback(){
    //include member-transfer file
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'select2' );
	wp_enqueue_script('select2');
    return get_sa_member_to_member_transfer();
}
add_shortcode('RETIREMENT-OF-CSR-WALLAT', 'cip_wallat_retirement_of_csr_setting_cb');
function cip_wallat_retirement_of_csr_setting_cb(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	global $wpdb;
	$tableRetirementSetting = $wpdb->prefix.'retirement_setting';
	$tableTokenHolder = $wpdb->prefix.'token_holder';
	$tableLSHPending = $wpdb->prefix.'csr_lsh_pending';
	$refAccount = ( isset( $_SESSION['refAccount'] ) && $_SESSION['refAccount'] != "" ) ? $_SESSION['refAccount'] : '-';
	$getRetirementSetting = $wpdb->get_row("SELECT * FROM $tableRetirementSetting WHERE email = '".$refAccount."' ");
	$company_name = $getRetirementSetting->company_name;
	$company_name_toggle = $getRetirementSetting->company_name_toggle;
	$member_url = $getRetirementSetting->member_url;
	$status = $getRetirementSetting->status;
	$member_logo = $getRetirementSetting->member_logo;
	$url_logo_status = $getRetirementSetting->status;
	$rejection_msg = $getRetirementSetting->rejection_msg;
	if( empty( $rejection_msg ) ){
		$rejection_msg = __('<strong>Logo & url are pending for review</strong><br/>It will take up to 7 days to approve the url & logo. You should check back regularly.', CIP_TXTDOMAIN);
	}
	ob_start();
/*
	?>
	<div class="row">
	<div class="col-md-12 shadow p-3 bg-white rounded d-none" >
	<form name="retirement_setting_frm" id="retirement_setting_frm">

		<div class="row">
			<div class="col-md-6">

				<div class="form-group retirement_confirmation_block_section">
					<label for="company_name"><?php _e('Company name', CIP_TXTDOMAIN); ?> <!--i class="fa fa-info-circle" data-toggle="tooltip" data-placement="top" title="<?php //_e('Company name displayed on retirement certificates instead of an individuals name',CIP_TXTDOMAIN); ?>" ></i--> </label>
					<input type="text" class="form-control" name="company_name" id="company_name" value="<?php echo $company_name; ?>">
					<div class="form-check">
						<label class="form-check-label" style="line-height: unset;">
							<input type="checkbox" class="form-check-input" name="company_name_toggle" id="company_name_toggle" value="1" <?php echo checked( $company_name_toggle, 1); ?>><?php _e('Display company name on retirement certificates instead of an individuals name', CIP_TXTDOMAIN); ?>
						</label>
					</div>
				</div>
				<div class="form-group">
					<label for="member_url"><?php _e('Company url', CIP_TXTDOMAIN); ?></label>
					<?php if( $status == 2 ){ ?>
						<p class="form-control"><?php echo $member_url ?></p>
					<?php }else{ ?>
						<input type="text" class="form-control" id="member_url" name="member_url" value="<?php echo $member_url ?>" />
						<i><?php _e('e.g. http://example.com or https://example.com', CIP_TXTDOMAIN); ?></i>
					<?php } ?>
				</div>
			</div>
			<div class="col-md-6">
				<?php if( $status != 2 ){ ?>
					<div class="form-group">
						<label for="member_logo"><?php _e('Company logo', CIP_TXTDOMAIN); ?></label>
						<input type="file" class="form-control-file border" id="member_logo" name="member_logo" />
						<i><?php _e('Only jpg,jpeg,png files are valid, max dimension 250*250px, and max size 100KB will be allowed', CIP_TXTDOMAIN); ?></i>
					</div>
				<?php } ?>
				<?php if( $status == 2 ){ ?>
					<div class="form-group">
						<label for="member_logo"><?php _e('Company logo', CIP_TXTDOMAIN); ?></label>
						<input type="file" class="form-control-file border" id="logo_disabled" name="logo_disabled" disabled readonly />
						<i><?php _e('Only jpg,jpeg,png files are valid, max dimension 250*250px, and max size 100KB will be allowed', CIP_TXTDOMAIN); ?></i>
					</div>
				<?php } ?>
				<?php if( !empty( $member_logo ) ){ ?>
					<div class="form-group">
						<img src="data:image/jpg;charset=utf8;base64,<?php echo base64_encode($member_logo); ?>" class="img-responsive company_logo_preview" />
					</div>
				<?php } ?>
			</div>
		</div>

		<?php if( $url_logo_status != 1 && ( !empty( $member_url ) || !empty( $member_logo ) ) ){ ?>
		<div class="alert alert-info">
		<?php echo $rejection_msg; ?>
		</div>
		<?php } ?>
		<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="cip_retirement_setting_act" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxRetirement_SettingxCIP_'); ?>" />
		<p class="form_response"></p>
	</form>
	</div>
	</div>
	*/?>

	<br/>

	<div class="row">
	<div class="col-md-12 p-3 rounded">
		<form name="cip_security_hold_record" id="cip_security_hold_record">
			<div class="form-group">
				<?php
				$getWalletAddress = $wpdb->get_results("SELECT `id`, `eth_address`,`sign_verify` FROM $tableTokenHolder WHERE email = '".$refAccount."' AND ( `eth_address` IS NOT NULL AND `eth_address` <> '' ) GROUP BY `eth_address`");
				?>
				<table class="table table-bordered table-hover">
					<thead>
						<tr>
							<th>
								<div class="d-flex justify-content-between align-items-center"> <span><?php _e('CSR wallet address', CIP_TXTDOMAIN); ?></span> <button type="button" class="addNewCsrAddress" data-toggle="modal" data-target="#addNewWalletAddressModel" data-backdrop="static" data-keyboard="false"><?php _e('Add CSR wallet address', CIP_TXTDOMAIN); ?></button> </div>
							</th>
						</tr>
					</thead>
					<tbody>
					<?php
					if( $getWalletAddress ){
						foreach( $getWalletAddress as $getWallet ){
							$encryptAddress = base64_encode( $getWallet->eth_address . md5('CIPSecurityHold'));
							$encryptId = base64_encode( $getWallet->id . md5('CIPSecurityHold'));
							$allNoneIssuedCount = $wpdb->get_var("SELECT COUNT(id) FROM $tableTokenHolder WHERE `email` = '".$refAccount."' AND `eth_address` = '".$getWallet->eth_address."' AND (`corp_approved` != 'Issued' AND `corp_approved` != 'Delivered' AND `corp_approved` != 'Saved CSR')");
							$allSHCount = $wpdb->get_var("SELECT COUNT(id) FROM $tableTokenHolder WHERE `email` = '".$refAccount."' AND `eth_address` = '".$getWallet->eth_address."' AND `corp_approved` = 'Security Hold'");
							$isPendingReview = false;
							$pendingLSHLists = $wpdb->get_var(" SELECT COUNT(id) FROM $tableLSHPending WHERE email = '".$refAccount."' AND `eth_address` = '".$getWallet->eth_address."' AND status = 2 AND type = 'request' ORDER BY `id` DESC ");
							if( $pendingLSHLists ){
								$isPendingReview = true;
							}

							?><tr data-eth="<?php echo $getWallet->id; ?>"><td class="eth_address d-flex flex-row justify-content-between align-items-center">
								<a href="javascript:void(0);"><?php echo $getWallet->eth_address; ?><?php if( $getWallet->sign_verify == 1 ){ ?><img src="<?php echo CIP_PLUGIN_FOLDER; ?>/images/verified.png" class="verified_address_sticker" /><?php  } ?></a>
								<div>
								<?php

								if( $allSHCount > 0 ){
									if( $isPendingReview ){
									?>
									<button type="button" class="set_lsh_address_pending" data-toggle="tooltip" data-placement="top" title="<?php _e('Your request to Lift Security Hold has been received. Please check back in 2 working days.',CIP_TXTDOMAIN); ?>"> <?php _e('Lift Security Hold In Review', CIP_TXTDOMAIN); ?> <i class="fa fa-info-circle"></i></button>
									<?php
									}else{
									?>
									<button type="button" class="set_lsh_address" data-id="<?php echo $encryptAddress; ?>" data-aid="<?php echo $encryptId; ?>" > <?php _e('Lift Security Hold', CIP_TXTDOMAIN); ?> <i class="fa fa-info-circle" data-toggle="tooltip" data-placement="top" title="<?php _e('Lifting Security Hold will un-suspend CSR distribution to this wallet address. Additional confirmation information will be requested.',CIP_TXTDOMAIN); ?>" ></i></button>
									<?php
									}
								}else if( $allNoneIssuedCount > 0 ){
								?>
									<button type="button" class="set_sh_address" data-id="<?php echo $encryptAddress; ?>" data-aid="<?php echo $encryptId; ?>" > <?php _e('Set Security Hold', CIP_TXTDOMAIN); ?> <i class="fa fa-info-circle" data-toggle="tooltip" data-placement="top" title="<?php _e('Setting Security Hold status will suspend all distribution of CSR to this address.',CIP_TXTDOMAIN); ?>" ></i></button>
								<?php
								}
								if( $getWallet->sign_verify != 1 ){
									echo '<a href="javascript:void(0);" class="signVerifyBtn mr-2 ml-2" data-toggle-tt="tooltip" data-placement="top" title="'.__('Verify your CSR Wallet address using MetaMask (Free).',CIP_TXTDOMAIN).'"><i class="fas fa-user-check"></i></a>';

							  	}
								?>
							</div></td></tr><?php
						}
					}else{
						?><tr><td><?php _e('No CSR wallet address available', CIP_TXTDOMAIN); ?></td></tr><?php
					}
					?>
					</tbody>
				</table>

			</div>
			<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('__CIPSecurityHoldRecordCIP__'); ?>" />
			<input type="hidden" name="action" value="update_security_hold_record" />
		</form>

		<div class="modal fade" id="liftSecurityHoldPopup" tabindex="-1" role="dialog" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered modal-xl" role="document">
				<div class="modal-content">
					<div class="modal-header"><button type="button" class="close" data-dismiss="modal">×</button></div>
					<div class="modal-body">
					</div>
				</div>
			</div>
		</div>
		<div class="modal fade" id="addNewWalletAddressModel" tabindex="-1" role="dialog" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered modal-lg" role="document">
				<div class="modal-content">
					<div class="modal-body">
						<div class="container-fluid">
							<span class="modalpopup_close_btn close" data-dismiss="modal">&times;</span>
						</div>
						<form name="addNewCsrWalletAddress" class="addNewCsrWalletAddress" id="addNewCsrWalletAddress">
							<div class="form-group">
								<label for="csrwalletaddress" class="col-form-label"><?php _e('Enter your CSR wallet address', CIP_TXTDOMAIN); ?></label>
								<input type="text" class="form-control" id="csrwalletaddress" name="csrwalletaddress" required />
								<small class="form-text text-muted"><?php _e('MetaMask will ask you to verify your wallet address. This action does not charge you any fees, nor does it make any changes to your CSR holdings.', CIP_TXTDOMAIN); ?></small>
								<p class="form_response"></p>
								<input type="hidden" name="action" value="addNewCsrWalletAddressMemberAct" />
								<input type="hidden" name="_micro" value="<?php echo wp_create_nonce( $refAccount ); ?>" />
							</div>
							<button type="submit" class="btn btn-primary"><?php _e('Add', CIP_TXTDOMAIN); ?></button>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	</div>
	<?php
	$html .= ob_get_clean();
	return $html;
}
add_shortcode('CSR-ADDRESS-REPORT', 'csr_address_report_callback');
function csr_address_report_callback(){
	$html = "";
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_style( 'bs-sticky-header' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	ob_start();

	$csr_address_report_url = add_query_arg( [
		'action'	=>	'csr_address_report_loader',
		'pageid'	=>	get_the_ID(),
	], admin_url( 'admin-ajax.php' ) );
	$csr_address_report_table_data_url = add_query_arg( [
		'action'	=>	'csr_address_report_table_data',
		'pageid'	=>	get_the_ID(),
	], admin_url( 'admin-ajax.php' ) );

	?>
	<style type="text/css">
		table#csr_address_report_table {
		    border: unset;
		}
	</style>
	<div class="csr_address_report_wrapper">
		<form name="csr_address_report" id="csr_address_report" method="POST">
			<div class="container">
				<div class="row">
					<div class="col-2"></div>
					<div class="col-8 flex-row" style="align-items: end; display: flex; justify-content: center; gap: 20px; ">
						<div class="form-group">
							<label for="address_name"><?php echo __('Blockchain Address', CIP_TXTDOMAIN); ?></label>
							<!-- <input type="text" name="block_chain" id="block_chain" class="form-control" style="width: 600px;"> -->
							<textarea name="block_chain" rows="3" id="block_chain" class="form-control" style="width: 600px !important;text-align:left;height: auto;"></textarea>
						</div>
						<div class="form-group m-0">
							<select class="token_selection form-control" id="token_selection">
								<option value="CSR" selected>CSR</option>
								<option value="CSR25">CSR25</option>
							</select>
							<button style="margin-top: 15px;margin-bottom: 16px;" type="button" class="btn btn-secondary" id="csr_address_report_button"><?php _e('Submit', CIP_TXTDOMAIN); ?></button>
							
						</div>
					</div>
				<div class="col-2"></div>
				</div>
			</div>

			<input type="hidden" name="action" value="csr_address_report_loader" />
			<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('__CSR_address_REPORT_'); ?>" />

		</form>

		<div style="margin:auto; justify-content: center;">
			<table id="csr_address_report_table"  data-toggle="table" data-pagination="true" data-search="false" data-show-search-clear-button="false" data-filter-control="true" data-sortable="true" style="display:none;">
				<thead>
					<tr>
						<th data-field="id" class="id" data-switchable="false"><?php _e('ID',CIP_TXTDOMAIN); ?></th>
						<th data-field="username" data-filter-control="input" data-sortable="true" data-searchable="true" class="username" data-switchable="false"><?php _e('Username',CIP_TXTDOMAIN); ?></th>
						<th data-field="fullname" data-filter-control="input" data-sortable="false" class="fullname" data-switchable="false"><?php _e('Full Name',CIP_TXTDOMAIN); ?></th>
						<th data-field="email" data-filter-control="input" data-sortable="true" class="email" data-switchable="false"><?php _e('Email',CIP_TXTDOMAIN); ?></th>
						<th data-field="user_registrations_date" data-filter-control="input" data-sortable="false" class="user_registrations_date" data-switchable="false"><?php _e('Registration Date',CIP_TXTDOMAIN); ?></th>
						<th data-field="rank" data-filter-control="input" class="rank" data-switchable="false"><?php _e('Rank',CIP_TXTDOMAIN); ?></th>
						<th data-field="csr_delivered" data-filter-control="input" class="csr_delivered" data-switchable="false"><?php _e('CSR Delivered',CIP_TXTDOMAIN); ?></th>
						<th data-field="csr_in_wallet" data-filter-control="input" class="csr_in_wallet" data-switchable="false"><?php _e('CSR In Wallet',CIP_TXTDOMAIN); ?></th>
						<th data-field="csr_on_blockchain" data-filter-control="input" class="csr_on_blockchain" data-switchable="false"><?php _e('CSR On Blockchain',CIP_TXTDOMAIN); ?></th>
						<th data-field="csr_due" data-filter-control="input" class="csr_due" data-switchable="false"><?php _e('CSR Due',CIP_TXTDOMAIN); ?></th>
						<th data-field="csr_issued" data-filter-control="input" class="csr_issued" data-switchable="false"><?php _e('CSR Issued',CIP_TXTDOMAIN); ?></th>

						<th data-field="csr25_delivered" data-filter-control="input" class="csr25_delivered" data-switchable="false"><?php _e('CSR25 Delivered',CIP_TXTDOMAIN); ?></th>
						<th data-field="csr25_in_wallet" data-filter-control="input" class="csr25_in_wallet" data-switchable="false"><?php _e('CSR25 In Wallet',CIP_TXTDOMAIN); ?></th>
						<th data-field="csr25_on_blockchain" data-filter-control="input" class="csr25_on_blockchain" data-switchable="false"><?php _e('CSR25 On Blockchain',CIP_TXTDOMAIN); ?></th>
						<th data-field="csr25_due" data-filter-control="input" class="csr25_due" data-switchable="false"><?php _e('CSR25 Due',CIP_TXTDOMAIN); ?></th>
						<th data-field="csr25_issued" data-filter-control="input" class="csr25_issued" data-switchable="false"><?php _e('CSR25 Issued',CIP_TXTDOMAIN); ?></th>

						<th data-field="upline_to_the_advisor" data-filter-control="input" data-sortable="true" class="upline_to_the_advisor" data-switchable="false"><?php _e('Upline To The Advisor',CIP_TXTDOMAIN); ?></th>
						<th data-field="action" class="action" data-switchable="false"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
					</tr>
				</thead>
				
			</table>
		</div>
	</div>
	<script type="text/javascript">
		jQuery(document).ready(function($){
			var block_config = { css: { backgroundColor: 'transparent', border: 'none' }, message: '<div class="blockUIspinner"></div>', baseZ: 1500, overlayCSS: { backgroundColor: '#FFFFFF', opacity: 0.8, cursor: 'wait' } };
			$(document).on('click','#csr_address_report_button',function(e){
				e.preventDefault;
				var sa_packages_listing_list_url = "<?php echo $csr_address_report_url ?>";
				var csr_address_report_table_data_url = "<?php echo $csr_address_report_table_data_url ?>";
				if($('#block_chain').val())
				{
					let block_chain_input = $('#block_chain').val().trim();

					let block_chain_values = block_chain_input.split(/[\n,]+/).map(function(address) {
					    return address.trim();
					}).filter(function(address) {
					    return address.length > 0;
					});

					var token = $('form#csr_address_report select#token_selection').val()

		  			$.blockUI(block_config);

					$.ajax({
			            url: csr_address_report_table_data_url, 
			            method: 'POST',
						data: {
						    block_chain: block_chain_values,
						    token: token
						},
			            dataType: 'json',
			            success: function(response) {

			                var newData = response.rows;

			                // Append new data to the existing table
			                $('#csr_address_report_table').bootstrapTable('removeAll');
			                $('#csr_address_report_table').bootstrapTable('append', newData);

			                if(token == 'CSR25')
			                {
			                	$('#csr_address_report_table').bootstrapTable('hideColumn', 'csr_delivered');
			                	$('#csr_address_report_table').bootstrapTable('hideColumn', 'csr_in_wallet');
			                	$('#csr_address_report_table').bootstrapTable('hideColumn', 'csr_on_blockchain');
			                	$('#csr_address_report_table').bootstrapTable('hideColumn', 'csr_due');
			                	$('#csr_address_report_table').bootstrapTable('hideColumn', 'csr_issued');

			                	$('#csr_address_report_table').bootstrapTable('showColumn', 'csr25_delivered');
			                	$('#csr_address_report_table').bootstrapTable('showColumn', 'csr25_in_wallet');
			                	$('#csr_address_report_table').bootstrapTable('showColumn', 'csr25_on_blockchain');
			                	$('#csr_address_report_table').bootstrapTable('showColumn', 'csr25_due');
			                	$('#csr_address_report_table').bootstrapTable('showColumn', 'csr25_issued');

			                }else{
								
								$('#csr_address_report_table').bootstrapTable('showColumn', 'csr_delivered');
			                	$('#csr_address_report_table').bootstrapTable('showColumn', 'csr_in_wallet');
			                	$('#csr_address_report_table').bootstrapTable('showColumn', 'csr_on_blockchain');
			                	$('#csr_address_report_table').bootstrapTable('showColumn', 'csr_due');
			                	$('#csr_address_report_table').bootstrapTable('showColumn', 'csr_issued');

			                	$('#csr_address_report_table').bootstrapTable('hideColumn', 'csr25_delivered');
			                	$('#csr_address_report_table').bootstrapTable('hideColumn', 'csr25_in_wallet');
			                	$('#csr_address_report_table').bootstrapTable('hideColumn', 'csr25_on_blockchain');
			                	$('#csr_address_report_table').bootstrapTable('hideColumn', 'csr25_due');
			                	$('#csr_address_report_table').bootstrapTable('hideColumn', 'csr25_issued');
			                }


							$('#csr_address_report_table').css('display','block');
			  				$("#csr_address_report_table").bootstrapTable("hideLoading");
			  				$.unblockUI();

			            },
			            error: function(error) {
			                console.error("Error fetching data:", error);
			            }
			        });					
				}

			});
			$('body').on('click', '.copyReportData', function(){
				var thisIndex = $(this).attr('data-index');
				var copiedData = $('body').find('.csraddressReportContent_'+thisIndex).html();
				navigator.clipboard.writeText(copiedData);
				swalToast({ type: 'success', title: 'Copied Successfully.' });
			});
			$('body').on('click', '.copyEssentialReportData', function(){
				var thisIndex = $(this).attr('data-index');
				var copiedData = $('body').find('.copyEssentialReportContent_'+thisIndex).html();
				navigator.clipboard.writeText(copiedData);
				swalToast({ type: 'success', title: 'Copied Successfully.' });
			});
		});

		jQuery('#csr_address_report_table').on('sort.bs.table', function (name,order) {
		  	$("#csr_address_report_table").bootstrapTable("showLoading");
		})

	</script>
	<?php
	$html .= ob_get_clean();
	return $html;
}
/**
 * New delivery plan wizard
 */
include( CIP_PLUGIN_BASE.'includes/new-delivery-plan-wizard/new-delivery-plan-wizard.php' );
add_shortcode('NEW-DELIVERY-PLAN-WIZARD','cip_new_delivery_plan_wizard_callback');
function cip_new_delivery_plan_wizard_callback(){
    //include new-delivery-plan-wizard file
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
    return get_new_delivery_plan_wizard();
}
/**
 * Notice Ticker
 */
add_action( 'wp_enqueue_scripts', 'cip_enqueue_notice_ticker_scripts_cb' );
function cip_enqueue_notice_ticker_scripts_cb(){
	wp_register_style( 'ent-admin', '//cdn.jsdelivr.net/gh/freeps2/Ticker@main/ent-admin.css', array(), '1.18.3', 'all' );
	wp_register_style( 'ent-style', '//cdn.jsdelivr.net/gh/freeps2/Ticker@main/ent-style.css', array(), '1.18.3', 'all' );
	wp_register_style( 'ticker-style', '//cdn.jsdelivr.net/gh/freeps2/Ticker@main/style.css', array(), '1.18.3', 'all' );
    // wp_register_script( 'bs-sticky-header', '//cdn.jsdelivr.net/gh/freeps2/Ticker@main/jquery-3.6.0.min.js', array( 'jquery' ), '1.18.3', true );
    wp_register_script( 'ticker-easing', '//cdn.jsdelivr.net/gh/freeps2/Ticker@main/jquery.easing.js', array( 'jquery' ), '1.18.3', true );
    wp_register_script( 'ticker-webfont', '//ajax.googleapis.com/ajax/libs/webfont/1.6.26/webfont.js', array( 'jquery' ), '1.18.3', true );
    wp_register_script( 'ent-script', '//cdn.jsdelivr.net/gh/freeps2/Ticker@main/ent-script.min.js', array( 'jquery' ), '1.18.3', true );
    wp_register_script( 'ent-admin', '//cdn.jsdelivr.net/gh/freeps2/Ticker@main/ent-admin.js', array( 'jquery' ), '1.18.3', true );
}
include( CIP_PLUGIN_BASE.'includes/notice-ticker/notice-ticker.php' );
add_shortcode('notice-ticker','cip_notice_ticker_callback');
function cip_notice_ticker_callback(){
    //include notice-ticker file
	// wp_enqueue_style( 'cip-css' );
	// wp_enqueue_style( 'ent-admin' );
	wp_enqueue_style( 'ent-style' );
	// wp_enqueue_style( 'ticker-style' );
	wp_enqueue_script( 'ticker-easing' );
	wp_enqueue_script( 'ticker-webfont' );
	wp_enqueue_script( 'ent-script' );
	wp_enqueue_script( 'ent-admin' );
    return get_notice_ticker_callback();
}
include( CIP_PLUGIN_BASE.'includes/Token-Holder2/token-holder2.php' );
/**
 * Amendment process bonus discount
*/
include( CIP_PLUGIN_BASE.'includes/amendment-process-bonus-discount/amendment-process-bonus-discount.php' );
add_shortcode('AMENDMENT-PROCESS-BONUS-DISCOUNT','cip_amendment_process_bonus_discount_callback');
function cip_amendment_process_bonus_discount_callback(){
	//include amendment-process-bonus-discount file
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-sticky-header');
	wp_enqueue_script('bs-table-filter-control');
	wp_enqueue_style( 'bs-datepicker' );
	wp_enqueue_script('bs-datepicker');
	wp_enqueue_script( 'jquery.inputmask' );
	return get_amendment_process_bonus_discount();
}
include( CIP_PLUGIN_BASE.'includes/Csr-Scheduler/csr25-scheduler.php' );
// mint csr
include( CIP_PLUGIN_BASE.'includes/mint-csr/mint-csr.php' );
add_shortcode('MINT-CSR25-PAGE','cip_mint_csr_callback');
function cip_mint_csr_callback(){
    return get_mint_csr_callback();
}
/**
 * CSR25 Token Minting
 */
include( CIP_PLUGIN_BASE.'includes/mint-csr/minting-csr-web3.php' );
add_shortcode('CSR25-TOKEN-MINTING','cip_minting_csr_web3_callback');
function cip_minting_csr_web3_callback(){
    return get_mint_csr_web3_callback();
}
/**
 * CSR remaining
 */
include( CIP_PLUGIN_BASE.'includes/csr-remaining/csr-remaining.php' );
add_shortcode('CSR-REMAINING-DASHBOARD','cip_csr_remaining_dashboard_callback');
function cip_csr_remaining_dashboard_callback(){
	wp_enqueue_style( 'cip-css' );
	wp_enqueue_script( 'notify-js' );
	wp_enqueue_style( 'bs-table' );
	wp_enqueue_script('bs-table');
	wp_enqueue_script('bs-table-filter-control');
    return get_csr_remaining_dashboard();
}
//REGISTER Show Member Invoices  BY SA SHORTCODE
add_shortcode( 'sa_view_po_invoice_report', 'sa_view_po_invoice_report' );
function sa_view_po_invoice_report() {
    require("SA_po_invoice_reports/sa_show_po_invoice_report.php");
    sa_member_po_invoice();
}