<?php
add_action('wp_footer', 'detect_site_mode');
function detect_site_mode() {
    $excluded_domains = [
        'canada.amplivo.com',
        'academy.amplivo.com',
        'csrnow.com'
    ];

    // Get current domain and normalize (strip www)
    $host = parse_url(get_site_url(), PHP_URL_HOST);
    $normalized_host = preg_replace('/^www\./', '', strtolower($host));

    if (!in_array($normalized_host, $excluded_domains)) {
      ?>
        <style>
            header {
                border: 3px solid black;
                background-color: #7236B8 !important;
                position: relative !important;
            }
        </style>
        <div style="
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            background: rgb(163, 9, 9);
            color: rgb(255, 255, 255);
            text-align: center;
            font-weight: bold;
            font-size: 14px;
            padding: 15px;
            z-index: 9999;
        ">
            Test Site
        </div>
      <?php
    }
}