<?php
function get_amplivo_api_settings_page(){
    global $wpdb;
    $html = "";
    ob_start();
	if( current_user_can('supportmanager') || current_user_can('supportagent') ){
    ?>
    <div class="main-container-wrapper">
        <nav class="nav nav-tabs nav-justified">
            <a class="nav-item nav-link active" data-toggle="tab" href="#euvatapi_setting"><i class='fas fa-cog'></i> <?php _e('Euvatapi & CSR Price',CIP_TXTDOMAIN); ?></a>
            <a class="nav-item nav-link" data-toggle="tab" href="#amplivo_api_setting"><i class='fas fa-cog'></i> <?php _e('Amplivo API Setting',CIP_TXTDOMAIN); ?></a>
            <a class="nav-item nav-link" data-toggle="tab" href="#logout_time_setting"><i class='fas fa-cog'></i> <?php _e('Auto Logout Setting',CIP_TXTDOMAIN); ?></a>
            <a class="nav-item nav-link" data-toggle="tab" href="#withdrawal_suspension_setting"><i class='fas fa-cog'></i> <?php _e('Withdrawal Suspension Setting',CIP_TXTDOMAIN); ?></a>
			<a class="nav-item nav-link" data-toggle="tab" href="#mfp_setting"><i class='fas fa-cog'></i> <?php _e('MFP Settings',CIP_TXTDOMAIN); ?></a>
        </nav>
        <div></div>
        <div class="tab-content">
            <div id="euvatapi_setting" class="tab-pane fade in active show">
				<?php echo do_shortcode('[SM-VAT-API-SETTING-OPTION]'); ?>
            </div>
            <div id="amplivo_api_setting" class="tab-pane fade in">
			<?php $amplivo_api_mode = ( !empty( get_option('amplivo_api_mode') ) ) ? get_option('amplivo_api_mode') : 'test'; ?>
			<form name="sm_amplivo_api_settings" id="sm_amplivo_api_settings">
				<h4><?php _e('Amplivo API', CIP_TXTDOMAIN); ?></h4>
				<div class="row">
					<div class="col-6">
						<div class="form-group">
							<label for="amplivo_api_mode"><?php echo __("API Mode" , "aachelper"); ?></label>
							<select id="amplivo_api_mode" name="amplivo_api_mode" class="regular-text form-control">
								<option value="test" <?php echo selected( $amplivo_api_mode, 'test' ); ?>><?php _e('Test', CIP_TXTDOMAIN); ?></option>
								<option value="live" <?php echo selected( $amplivo_api_mode, 'live' ); ?>><?php _e('Live', CIP_TXTDOMAIN); ?></option>
							</select>
						</div>
					</div>
				</div>
				
				<div class="row">
					<div class="col-6">
						<div class="form-group">
							<label for="amplivo_api_test_source_url"><?php echo __("Amplivo Test API Source" , "aachelper"); ?></label>
							<input type="text" id="amplivo_api_test_source_url" name="amplivo_api_test_source_url"  value="<?php echo get_option( 'amplivo_api_test_source_url' ); ?>" class="regular-text form-control" pattern=".*\S+.*"/>
						</div>
					</div>
					<div class="col-6">
						<div class="form-group">
							<label for="amplivo_api_live_source_url"><?php echo __("Amplivo Live API Source" , "aachelper"); ?></label>
							<input type="text" id="amplivo_api_live_source_url" name="amplivo_api_live_source_url"  value="<?php echo get_option( 'amplivo_api_live_source_url' ); ?>" class="regular-text form-control" pattern=".*\S+.*"/>
						</div>
					</div>
				</div>
				
				<div class="row">
					<div class="col-6">
						<div class="form-group">
							<label for="amplivo_api_auth_username"><?php echo __("Amplivo API Auth Username" , "aachelper"); ?></label>
							<input type="text" id="amplivo_api_auth_username" name="amplivo_api_auth_username"  value="<?php echo get_option( 'amplivo_api_auth_username' ); ?>" class="regular-text form-control" pattern=".*\S+.*"/>
						</div>
					</div>
					<div class="col-6">
						<div class="form-group">
							<label for="amplivo_api_auth_pwd"><?php echo __("Amplivo API Auth Password" , "aachelper"); ?></label>
							<input type="text" id="amplivo_api_auth_pwd" name="amplivo_api_auth_pwd"  value="<?php echo get_option( 'amplivo_api_auth_pwd' ); ?>" class="regular-text form-control" pattern=".*\S+.*"/>
						</div>
					</div>
				</div>

				<button type="submit" class="btn btn-primary"><?php _e('Save', CIP_TXTDOMAIN); ?></button>
				<input type="hidden" name="action" value="cip_sm_amplivo_api_settings_act" />
				<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CIPxsmAmplivoApisettingxCIP_'); ?>" />
				<p class="form_response"></p>
			</form>
            </div>

			<div id="logout_time_setting" class="tab-pane fade in">
				<?php echo do_shortcode('[ADD-LOGOUT-TIMEOUT]'); ?>
            </div>
			<div id="withdrawal_suspension_setting" class="tab-pane fade in">
				<?php echo do_shortcode('[WITHDRAWAL-SUSPENSION-AFTER-LOGIN-SETTING]'); ?>
            </div>
			<div id="mfp_setting" class="tab-pane fade in">
				<?php echo do_shortcode('[SM-MFP-SETTINGS]'); ?>
            </div>
        </div>  
    </div>
	<?php
	}
	$html .= ob_get_clean();
	return $html;
}
/**
 * SM setting option save
 */
add_action('wp_ajax_cip_sm_amplivo_api_settings_act','cip_sm_amplivo_api_settings_act_cb');
function cip_sm_amplivo_api_settings_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_CIPxsmAmplivoApisettingxCIP_' ) && (current_user_can( 'supportmanager' ) || current_user_can( 'supportagent' )) ){
		
		$amplivo_api_mode = get_option('amplivo_api_mode');
		$amplivo_api_test_source_url = get_option('amplivo_api_test_source_url');
		$amplivo_api_live_source_url = get_option('amplivo_api_live_source_url');

		$amplivo_api_auth_username = get_option('amplivo_api_auth_username');
		$amplivo_api_auth_pwd = get_option('amplivo_api_auth_pwd');
		
		update_option('amplivo_api_mode', isset($_POST['amplivo_api_mode']) ? $_POST['amplivo_api_mode'] : '');
		update_option('amplivo_api_test_source_url', isset($_POST['amplivo_api_test_source_url']) ? $_POST['amplivo_api_test_source_url'] : '');
		update_option('amplivo_api_live_source_url', isset($_POST['amplivo_api_live_source_url']) ? $_POST['amplivo_api_live_source_url'] : '');
		
		update_option('amplivo_api_auth_username', isset($_POST['amplivo_api_auth_username']) ? $_POST['amplivo_api_auth_username'] : '');
		update_option('amplivo_api_auth_pwd', isset($_POST['amplivo_api_auth_pwd']) ? $_POST['amplivo_api_auth_pwd'] : '');

		
		$log_type = 'amplivo_api_update';
		$data_array = array(
			"Amplivo api mode" => $_POST['amplivo_api_mode'],
			"Amplivo api test source url" => $_POST['amplivo_api_test_source_url'],
			"Amplivo api live source url" => $_POST['amplivo_api_live_source_url'],
			"Amplivo api auth username" => $_POST['amplivo_api_auth_username'],
			"Amplivo api auth pwd" => $_POST['amplivo_api_auth_pwd'],
		);
		$pre_data_array = array(
			"Amplivo api mode" => $amplivo_api_mode,
			"Amplivo api test source url" => $amplivo_api_test_source_url,
			"Amplivo api live source url" => $amplivo_api_live_source_url,
			"Amplivo api auth username" => $amplivo_api_auth_username,
			"Amplivo api auth pwd" => $amplivo_api_auth_pwd,
		);
		$logs = 'Changed Amplivo api values '.stripslashes( json_encode($data_array) ).' Previous values '.stripslashes( json_encode($pre_data_array) );
		$user = wp_get_current_user();
		create_cip_logs_entery( $user->ID, $log_type, '','sm', $logs, true );
		
		$out = array( "error" => 0,'msg' => __('Setting Saved',CIP_TXTDOMAIN) );
	}
	echo wp_json_encode( $out );
	exit;
}