<?php
add_action( 'init', 'set_rewrite_rule_for_refer_var', 10 );
function set_rewrite_rule_for_refer_var(){
    add_rewrite_rule( 'sponsor/([a-z0-9-]+)[/]?$', 'index.php?sponsor=$matches[1]', 'top' );
	if( !session_id() ){ @session_start(); }
}
add_filter( 'query_vars', 'assign_refer_to_query_variable', 10 );
function assign_refer_to_query_variable( $query_vars ){
    $query_vars[] = 'sponsor';
    return $query_vars;
}
add_action( 'template_redirect', 'set_refer_to_session', 10 );
function set_refer_to_session(){
	$refer_var = get_query_var( 'sponsor' );
	if( !empty( $refer_var ) ){
		$sponsorData = get_sponsor_fullname_byuser( $refer_var );
		setcookie('cse_refer', $sponsorData['sponsor_full_name'], time() + ( 86400 * 7 ), "/");
		setcookie('cse_refer_nm', $refer_var, time() + ( 86400 * 7 ), "/");
		wp_redirect( site_url() );
		exit;
	}
}
/*add_filter( 'gform_field_value_intro', 'set_refer_intro_to_gform_field_value' );
function set_refer_intro_to_gform_field_value( $value ) {
	global $wpdb;
	$tableName = $wpdb->prefix.'cip_member_invoice';
	$refAccount = ( isset( $_SESSION['refAccount'] ) && !empty( $_SESSION['refAccount'] ) ) ? $_SESSION['refAccount'] : '-' ;
	$get_sponsor = $wpdb->get_row("SELECT * FROM $tableName WHERE email = '".$refAccount."' AND ( IntroducedBy IS NOT NULL OR IntroducedBy <> '')");
	if( $get_sponsor ){
		if( !empty( $get_sponsor->IntroducedBy ) ){
			$value = $get_sponsor->IntroducedBy;
		}
	}else{
		$value = $_COOKIE['cse_refer'];
	}
	return $value;
}*/
add_filter( 'gform_pre_render_4', 'set_gform_field_value_default', 10, 3 );
function set_gform_field_value_default( $form, $ajax , $field_values ) {
	global $wpdb;
	$tableName = $wpdb->prefix.'cip_member_invoice';
	$cse_refer_val = "";
	$refAccount = ( isset( $_SESSION['refAccount'] ) && !empty( $_SESSION['refAccount'] ) ) ? $_SESSION['refAccount'] : '-' ;
	$get_sponsor = $wpdb->get_row("SELECT * FROM $tableName WHERE email = '".$refAccount."' AND ( IntroducedBy IS NOT NULL OR IntroducedBy <> '')");
	if( $get_sponsor ){
		if( !empty( $get_sponsor->IntroducedBy ) ){
			$cse_refer_val = $get_sponsor->IntroducedBy;
		}
	}else{
		$cse_refer_val = $_COOKIE['cse_refer'];
	}
	
	$fields = $form['fields'];
	foreach( $fields as &$field ){
		if ( $field->id == 16 ) {
			$field->defaultValue = $_POST['total_price'];
		}
		if ( $field->id == 15 ) {
			$field->defaultValue = $_POST['plastic_waste'];
		}
		if ( $field->id == 18 ) {
			$field->defaultValue = $_POST['plastic_amt'];
		}
		if ( $field->id == 35 ) {
			$value = $field->defaultValue;
			if( !empty( $cse_refer_val ) ){				
				$field->defaultValue = $cse_refer_val;
			}
			$field->cssClass = 'readField gf_visible_hidden';
		}
		if ( $field->id == 30 ) {
			$value = $field->defaultValue;
			if( !empty( $_COOKIE['cse_refer_nm'] ) ){				
				$field->defaultValue = $_COOKIE['cse_refer_nm'];
				// $field->cssClass = 'readField';
			}
		}
    }
	return $form;
}
add_filter( 'gform_field_css_class_4', 'loggedin_email_sponsor_noneditable', 10, 3 );
function loggedin_email_sponsor_noneditable( $classes, $field, $form ){
	$readOnlyClass="";
	global $wpdb;
	$tableName = $wpdb->prefix.'cip_member_invoice';
	$refAccount = ( isset( $_SESSION['refAccount'] ) && !empty( $_SESSION['refAccount'] ) ) ? $_SESSION['refAccount'] : '' ;
	if( !empty( $refAccount ) && is_user_logged_in() ){
		if( $field->id == 3 ){
			$readOnlyClass = ' readField';
		}
		if( $field->id == 30 ){
			$introducedby = get_sponsor_username_byemail( $refAccount );
			if( !empty( $introducedby ) ){
				$readOnlyClass = ' readField';
			}
		}
	}
	$classes .= $readOnlyClass;
    return $classes;
}
// add_filter( 'gform_field_css_class_4', 'refer_empty_able_to_input_class', 10, 3 );
function refer_empty_able_to_input_class( $classes, $field, $form ){
	$readOnlyClass="";
	global $wpdb;
	$tableName = $wpdb->prefix.'cip_member_invoice';
	$refAccount = ( isset( $_SESSION['refAccount'] ) && !empty( $_SESSION['refAccount'] ) ) ? $_SESSION['refAccount'] : '-' ;
	$get_sponsor = $wpdb->get_row("SELECT * FROM $tableName WHERE email = '".$refAccount."' AND ( IntroducedBy IS NOT NULL OR IntroducedBy <> '')");
	if( $get_sponsor && $field->id == 30 ){
		if( !empty( $get_sponsor->IntroducedBy ) ){
			$readOnlyClass = ' readField';
		}
	}else if( $field->id == 30 && !empty( $_COOKIE['cse_refer'] ) ){
		$readOnlyClass = ' readField';
	}
	/* if( $field->id == 30 && !empty( $_COOKIE['cse_refer'] ) ){
        $classes .= ' readField';
	} */
	$classes .= $readOnlyClass;
    return $classes;
}