<?php
//MFP changes
add_shortcode('SM-MFP-SETTINGS','acc_sm_mfp_settings_cb');
function acc_sm_mfp_settings_cb(){
	$html = "";
	$vpn_switch_toggle= ( !empty( get_option('vpn_switch_toggle') ) ) ? get_option('vpn_switch_toggle') : 0 ;
	$proxy_switch_toggle = ( !empty( get_option('proxy_switch_toggle') ) ) ? get_option('proxy_switch_toggle') : 0 ;
	$tron_switch_toggle = ( !empty( get_option('tron_switch_toggle') ) ) ? get_option('tron_switch_toggle') : 0 ;
	ob_start();
	?>

	<form name="sm_mfp_setting_frm" id="sm_mfp_setting_frm">
		<h5><?php _e('MFP Settings', 'aachelper'); ?></h5>
		<div class="row">
			<div class="col-md-6">
				<div class="form-group">
                    <!-- VPN -->
					<div class="custom-control custom-switch">

						<input type="checkbox" class="custom-control-input" name="vpn_switch_toggle" id="vpn_switch_toggle" value="1" <?php checked(1, $vpn_switch_toggle, true); ?>>
						<label class="custom-control-label sms_admin_login" for="vpn_switch_toggle">
							<?php _e('VPN', AACTXTDOMAIN); ?>
						</label>
					</div>

                    <!-- Proxy -->
					<div class="custom-control custom-switch">
						<input type="checkbox" class="custom-control-input" name="proxy_switch_toggle" id="proxy_switch_toggle" value="1" <?php checked(1, $proxy_switch_toggle, true); ?>>
						<label class="custom-control-label sms_admin_login" for="proxy_switch_toggle">
							<?php _e('Proxy', AACTXTDOMAIN); ?>
						</label>
					</div>

                    <!-- TRON -->
					<div class="custom-control custom-switch">
						<input type="checkbox" class="custom-control-input" name="tron_switch_toggle" id="tron_switch_toggle" value="1" <?php checked(1, $tron_switch_toggle, true); ?>>
						<label class="custom-control-label sms_admin_login" for="tron_switch_toggle">
							<?php _e('TOR', AACTXTDOMAIN); ?>
						</label>
					</div>

				</div>
			</div>
		</div>
		<button type="submit" class="btn btn-primary"><?php _e('Save', AACTXTDOMAIN); ?></button>
		<input type="hidden" name="action" value="acc_sm_mfp_settings_act" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_ACCsm_acc_mfp_settingACC_'); ?>" />
	</form>

	<form name="vpn_api_key_settings" id="vpn_api_key_settings">
		<h5 style="margin-top: 20px;"><?php _e('VPN API Key Setting', 'aachelper'); ?></h5>

		<div class="row">
			<div class="col-12">
				<div class="form-group">
					<label for="vpn_api_key"><?php echo __("VPN API key" , "aachelper"); ?></label>
					<input type="text" id="vpn_api_key" name="vpn_api_key"  value="<?php echo get_option( 'vpn_api_key' ); ?>" class="regular-text form-control" pattern=".*\S+.*" required/>
				</div>
			</div>
		</div>
		<button type="submit" class="btn btn-primary"><?php _e('Save', 'aachelper'); ?></button>
		<input type="hidden" name="action" value="acc_vpn_api_settings_act" />
		<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_ACCxvpnapisettingxACC_'); ?>" />
		<p class="form_response"></p>
	</form>
	<?php
	$html .= ob_get_clean();
	return $html;
}

add_action('wp_ajax_acc_sm_mfp_settings_act','acc_sm_mfp_settings_act_cb');
function acc_sm_mfp_settings_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',AACTXTDOMAIN) );

	if( wp_verify_nonce( $_POST['_micro'],'_ACCsm_acc_mfp_settingACC_' ) && current_user_can( 'supportagent' ) ){

		$current_user = wp_get_current_user();

		$user_id = $current_user->ID;

		//vpn
		if( isset( $_POST['vpn_switch_toggle'] ) && $_POST['vpn_switch_toggle'] == 1 ){
			update_option( 'vpn_switch_toggle', 1 );
		}else{
			update_option( 'vpn_switch_toggle', 0 );
		}
		//proxy
		if( isset( $_POST['proxy_switch_toggle'] ) && $_POST['proxy_switch_toggle'] == 1 ){
			update_option( 'proxy_switch_toggle', 1 );
		}else{
			update_option( 'proxy_switch_toggle', 0 );
		}
		//tron
		if( isset( $_POST['tron_switch_toggle'] ) && $_POST['tron_switch_toggle'] == 1 ){
			update_option( 'tron_switch_toggle', 1 );
		}else{
			update_option( 'tron_switch_toggle', 0 );
		}

		$vpn_status = ( get_option('vpn_switch_toggle') == 1 ) ? 'Activate' : 'Deactivate' ;
		$proxy_status = ( get_option('proxy_switch_toggle') == 1 ) ? 'Activate' : 'Deactivate' ;
		$tron_status = ( get_option('tron_switch_toggle') == 1 ) ? 'Activate' : 'Deactivate' ;

		$log_message = sprintf(
			__('MFP Settings Updated: VPN is %s, Proxy is %s, Tron is %s. Updated by %s at %s', AACTXTDOMAIN),
			$vpn_status,
			$proxy_status,
			$tron_status,
			$current_user->user_email,
			date_i18n('d/m/Y H:i A')
		);
		create_cip_logs_entery( $user_id, 'mfp settings', '','sm', $log_message, true );
		$out = array( "error" => 0,'msg' => __('Updated',AACTXTDOMAIN) );
	}
	echo wp_json_encode( $out );
	exit;
}

add_action('wp_ajax_acc_vpn_api_settings_act','acc_vpn_api_settings_act_cb');
function acc_vpn_api_settings_act_cb(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',AACTXTDOMAIN) );

	if( wp_verify_nonce( $_POST['_micro'],'_ACCxvpnapisettingxACC_' ) && current_user_can( 'supportagent' ) ){
		$vpn_api_key_updated = update_option('vpn_api_key', $_POST['vpn_api_key']);
		$user = wp_get_current_user();
		$message = sprintf( __('VPN API key updated by %s at %s. %s', 'aachelper'), $user->user_email, date_i18n('d/m/Y H:i A'), '' );
		create_cip_logs_entery( $user->ID, 'vpn api key setting', '', 'sm', $message );
		$out = array( "error" => 0,'msg' => __('VPN API key Saved','aachelper') );
	}
	echo wp_json_encode( $out );
	exit;
}
add_action('wp_footer','cip_mfp_setting_script');
function cip_mfp_setting_script(){
?>
<script>

	jQuery(document).ready(function($){
		$('body').on('submit', '#sm_mfp_setting_frm', function(){
			$form = $(this);
			var data = $(this).serialize();
			$form.block( block_config );
			$.post(cipscript.ajax_url, data, function(response) {
				var obj = JSON.parse( response );
				$form.unblock();
				if( obj.error == 0 ){
					swalToast({ type: 'success', title: obj.msg });
				}else{
					swalToast({ type: 'error', title: obj.msg });
				}
			});
			return false;
		});

		//vpn api key
		$('body').on('submit', '#vpn_api_key_settings', function(){
			$form = $(this);
			var data = $(this).serialize();
			$form.block( block_config );
			$.post(cipscript.ajax_url, data, function(response) {
				var obj = JSON.parse( response );
				$form.unblock();
				if( obj.error == 0 ){
					swalToast({ type: 'success', title: obj.msg });
				}else{
					swalToast({ type: 'error', title: obj.msg });
				}
			});
			return false;
		});
	});
</script>
<?php
}
