<?php
add_shortcode('CIP-MA-TOKEN-HOLDERS-LIST','cip_ma_token_holders_list_cb');
function cip_ma_token_holders_list_cb(){
	$html = "";
	ob_start();
	if( is_user_logged_in() && current_user_can('member_assistant') ){
		global $wpdb;
		$tableName = $wpdb->prefix.'token_holder';
		
		wp_enqueue_style( 'cip-css' );
		wp_enqueue_style( 'bs-table' );
		wp_enqueue_style( 'bs-sticky-header' );
		wp_enqueue_script('bs-table');
		wp_enqueue_script('bs-sticky-header');
		wp_enqueue_script('bs-table-filter-control');
		if( ( isset($_GET['action']) && $_GET['action'] === 'edit' ) && ( isset($_GET['id']) && is_numeric( $_GET['id'] ) ) ){
			global $wpdb;
			$getMember = $wpdb->get_row("SELECT * FROM $tableName WHERE id = ".$_GET['id']." AND ma_enabled = 1");
			if( $getMember ){
				global $defaultColumnsArr;
				unset( $defaultColumnsArr['imported_by'] );
				unset( $defaultColumnsArr['import_at'] );
				unset( $defaultColumnsArr['last_update_at'] );
				$columnOrders = get_option('cip_sm_column_order');
				$columnsArr = array();
				if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
					foreach( $columnOrders as $columnOrder ){
						$columnsArr[$columnOrder] = $defaultColumnsArr[$columnOrder];
					}
				}
				if( empty( $columnsArr ) ){
					$columnsArr = $defaultColumnsArr;
				}
				$saEditColOption = (array)get_option('cip_column_sa_toggle_columns');
			?>
			<div class="container">
			<form name="ma_member_update" id="ma_member_update">
				<div class="row">
				<?php
				if( $columnsArr ){
					$column_count = 0;
					foreach( $columnsArr as $columnKey => $columnLbl ){
						if( isset( $defaultColumnsArr[ $columnKey ] ) ){
							if( isset( $saEditColOption[ $columnKey ] ) ){
								$attr = 'id="'.$columnKey.'" name="'.$columnKey.'"';
							}else{
								continue;
							}
                            $extra_attr = "readonly disabled";
                            if( $columnKey == 'first_name' || $columnKey == 'last_name' || $columnKey == 'email' || $columnKey == 'eth_address' ){
                                $extra_attr = "";
                                if( $columnKey == 'eth_address' && !empty( $getMember->$columnKey ) ){
                                    $extra_attr = "readonly disabled";
                                    $attr = "";
                                }
                            }else{
                                $attr = "";
                            }
						?>
						<div class="col-md-4">
							<div class="form-group">
						    	<label for="<?php echo $columnKey ?>"><?php echo $columnKey; ?></label>
						    	<?php if( $columnKey == 'notes_internal' || $columnKey == 'notes_external' ){ ?>
						    		<textarea <?php echo $attr; ?> <?php echo $extra_attr; ?>><?php echo $getMember->$columnKey; ?></textarea>
						    	<?php }else{ ?>
						    		<input type="text" class="form-control" <?php echo $attr; ?> value="<?php echo $getMember->$columnKey; ?>" <?php echo $extra_attr; ?> />
						    	<?php } ?>
						  	</div>
						</div>
						<?php
						}
					}
				}
				?>
				</div>
				<div class="row">
				<div class="col-md-4">
					<div class="form-check">
						<input class="form-check-input" type="checkbox" value="1" name="update_all_match" id="update_all_match">
						<label class="form-check-label" for="update_all_match" style="margin-bottom: 0.5rem;padding-top: 0px !important;"><?php _e('Update all',CIP_TXTDOMAIN); ?></label>
					</div>
					<div class="form-group update_all_option_section" style="display: none;">
						<label for="update_all_option"><?php _e('Update all options', CIP_TXTDOMAIN); ?></label>
						<select class="form-control" name="update_all_option" id="update_all_option">
							<option value="single_row_update"><?php _e('Single row update', CIP_TXTDOMAIN); ?></option>
							<option value="all_username_update"><?php _e('All rows with this username', CIP_TXTDOMAIN); ?></option>
							<option value="all_email_update"><?php _e('All rows with this email', CIP_TXTDOMAIN); ?></option>
							<option value="all_reference_update"><?php _e('All rows with this reference number', CIP_TXTDOMAIN); ?></option>
							<option value="all_wallet_address_update"><?php _e('All rows with this wallet address', CIP_TXTDOMAIN); ?></option>
						</select>
					</div>
					<div class="form-group reference_update_section" style="display: none;">
						<label for="reference_update_field"><?php _e('Reference*', CIP_TXTDOMAIN); ?></label>
						<input type="text" class="form-control" name="reference_update_field" id="reference_update_field" />
					</div>
				</div>
				</div>
				<input type="hidden" name="action" value="ma_update_th_tp1_act" />
				<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_XMAupdatethtp1MAX_'); ?>" />
				<input type="hidden" name="sathid" value="<?php echo $_GET['id']; ?>">
		  		<button type="submit" class="btn btn-primary"><?php _e('Update',CIP_TXTDOMAIN); ?></button>
		  		<p><span class="form_response"></span></p>
			</form>
			</div>
			<div class="modal fade" id="update_warning" tabindex="-1" role="dialog" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title"><span class="fa fa-exclamation-circle"></span> <?php _e('Warning', CIP_TXTDOMAIN); ?></h5>
				</div>
				<div class="modal-body">
					<h5><?php _e('Exercise caution and double check any updates',CIP_TXTDOMAIN); ?></h5>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Close',CIP_TXTDOMAIN); ?></button>
				</div>
				</div>
			</div>
			</div>
			<?php
			}
		}else{
		?>
		<div class="container">
		
		<div class="table-responsive">
		<?php
			$user_id = get_current_user_id();
			if( !metadata_exists( 'user', $user_id, 'cip_sagent_toggle_columns' ) ){
				$columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
				update_user_meta( $user_id, 'cip_sagent_toggle_columns', $columnsSAColumnOption );
			}
			$saUserData = get_user_by( 'id', $user_id );
			global $defaultColumnsArr;
			if( $saUserData && in_array( "member_assistant", $saUserData->roles ) ){
				$columnOrders = (array)get_option('cip_sm_column_order');
				$columnsLabelArr = (array)get_option('cip_sm_column_labels');
				$columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
				$columnsArr = array();
				if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
					if( empty( $columnsArr ) ){
						foreach( $columnOrders as $columnOrder ){
							if( isset( $columnsSAColumnOption[$columnOrder] ) ){
								$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
							}
						}
					}
				}else{
					unset( $defaultColumnsArr['imported_by'] );
					unset( $defaultColumnsArr['import_at'] );
					unset( $defaultColumnsArr['last_update_at'] );
					$columnsArr = $defaultColumnsArr;
				}
			}else{
				unset( $defaultColumnsArr['imported_by'] );
				unset( $defaultColumnsArr['import_at'] );
				unset( $defaultColumnsArr['last_update_at'] );
				$columnsArr = $defaultColumnsArr;
			}
		?>
	    <table id="tokenholder_table_ma" class="ma_own_holder" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="true" data-show-columns-toggle-all="true" class="table table-bordered" data-side-pagination="server" data-pagination="true" data-page-list="[10, 20, 50, 100]">
			<thead>
			<tr>
				<th data-field="id" class="id"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
				<?php
				if( $columnsArr ){
					foreach( $columnsArr as $columnKey => $columnsVal ){
						$filter_attr = 'data-filter-control="input"';
						$filterData_attr = '';
						if( $columnKey == '_user_status' || $columnKey == 'kyc_status' || $columnKey == 'corp_approved'  ){
							if( $columnKey == '_user_status' ){
								$filterData_attr = ' data-filter-data="var:filterUserStatus"';
							}
							if( $columnKey == 'kyc_status' ){
								$filterData_attr = ' data-filter-data="var:filterKycStatus"';
							}
							if( $columnKey == 'corp_approved' ){
								$filterData_attr = ' data-filter-data="var:filterCorpApproved"';
							}
							$filter_attr = 'data-filter-control="select" class="status" data-filter-custom-search="BsTableFilterStatus"'.$filterData_attr;
						}
					?>
					<th data-field="<?php echo $columnKey ?>" data-sortable="true" <?php echo $filter_attr; ?> class="<?php echo $columnKey ?>"><?php echo $columnsVal; ?></th>
					<?php
					}
				}
				?>
				<th data-field="action" class="action"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
			</tr>
			</thead>
			<tbody>
			</tbody>
		</table>
		</div>
	</div>
	<?php } ?>
	<?php
	}else{
		?><h2><?php echo __('No record(s) found', CIP_TXTDOMAIN); ?></h2><?php
	}
	$html .= ob_get_clean();
	return $html;
}
add_filter( 'login_redirect', 'cip_ma_login_redirect', 10, 3 );
function cip_ma_login_redirect( $redirect_to, $request, $user ) {
    global $user;
    if( isset( $user->roles ) && is_array( $user->roles ) ){
        if( in_array( 'member_assistant', $user->roles ) ){
			$redirect_to = home_url();
		}
    }
	return $redirect_to;
}

// CSR Center Dashbord Info
add_shortcode( 'CSR-CENTER-DASHBORD-INFO-AREA', 'csr_center_dashbord_info_area' );
function csr_center_dashbord_info_area(){
    $html = "";
    ob_start();
    ?>
		<div>
			<script>
				function addCommas(nStr) {
					nStr += '';
					x = nStr.split('.');
					x1 = x[0];
					x2 = x.length > 1 ? '.' + x[1] : '';
					var rgx = /(\d+)(\d{3})/;
					while (rgx.test(x1)) {
						x1 = x1.replace(rgx, '$1' + ',' + '$2');
					}
					return x1 + x2;
				}
				jQuery(document).ready(function($){ 
					var settings = {
					"url": "https://api.latoken.com/v2/ticker/CSR/USDT",
					"method": "GET",
					"timeout": 0,
					};
	
					$.ajax(settings).done(function (response) {

						$(".pair_label").html(response.symbol);
						$(".lastPrice_label").html(addCommas(parseFloat(response.lastPrice).toFixed(4)));
						$(".volume24h_label").html(addCommas(parseFloat(response.volume24h).toFixed(4)));
						$(".volume7d_label").html(addCommas(parseFloat(response.volume7d).toFixed(4)));

						if(response.change24h > 0){
							$(".change24h_label").css('color','#4b8800');							
							$(".change24h_label").html('+' + addCommas(parseFloat(response.change24h).toFixed(2)) + '%');
						}else {
							$(".change24h_label").css('color','#c2220d');
							$(".change24h_label").html(addCommas(parseFloat(response.change24h).toFixed(2) + '%'));
						}
						// $("#change24h_label").html(parseFloat(response.change24h).toFixed(2) + '%');

						if(response.change7d > 0){
							$(".change7d_label").css('color','#4b8800');							
							$(".change7d_label").html('+' + addCommas(parseFloat(response.change7d).toFixed(2)) + '%');
						}else {
							$(".change7d_label").css('color','#c2220d');
							$(".change7d_label").html(addCommas(parseFloat(response.change7d).toFixed(2) + '%'));
						}
						// $("#change7d_label").html(parseFloat(response.change7d).toFixed(2) + '%');
					});
				});
			</script>
			<div class="csr_centeral_info">
				<ul class="p-0 m-0 list-unstyled">
					<li><div>Pair:</div><span class="pair_label">-</span></li>
					<li><div>Last Price:</div><span class="lastPrice_label">-</span></li>
					<li><div>24 hour volume:</div><span class="volume24h_label">-</span></li>
					<li><div>7 Day volume:</div><span class="volume7d_label">-</span></li>
					<li><div>24 hour price change %:</div><span class="change24h_label">-</span></li>
					<li><div>7 day price change %:</div><span class="change7d_label">-</span></li>
				</ul>
			</div>
		</div>
    <?php
    $html .= ob_get_clean();
    return $html;
}
add_action('wp_footer', 'front_end_script_callback', 99);
function front_end_script_callback() {
    if( is_page( 6630 ) ){ ?><script type="text/javascript" src="https://files.coinmarketcap.com/static/widget/coinMarquee.js"></script><?php }
    
	if( is_page( 6630 ) ){
    ?>
	<script>
	let isMobile = window.matchMedia("only screen and (max-width: 760px)").matches;
	var script_coin =' <div id="coinmarketcap-widget-marquee" coins="1,1027,825,20642" currency="USD" theme="light" transparent="false" show-symbol-logo="true"></div>';
	if (isMobile) {
		//Conditional script here
		var element = document.getElementById('coinmarketmobile');
		if( element !== null ){
			element.innerHTML += script_coin;
		}
	} else {
		var element = document.getElementById('coinmarketpc');
		if( element !== null ){
			element.innerHTML += script_coin;
		}
	}
	</script>
    <script>
		jQuery(document).ready(function(){
			jQuery('body').on("click", "#pp-advanced-tabs-title-7877", function () {
				//your code
				jQuery("#display_coincecko").html('<div id="coingecko"><coingecko-coin-price-marquee-widget coin-ids="bitcoin,ethereum,csr" currency="usd" background-color="#ffffff" locale="en"></coingecko-coin-price-marquee-widget><coingecko-coin-price-chart-widget coin-id="csr" currency="usd" height="400" locale="en"></coingecko-coin-price-chart-widget></div>');
			});
		});
    </script>
	<script src="https://widgets.coingecko.com/coingecko-coin-price-marquee-widget.js"></script>
	<script src="https://widgets.coingecko.com/coingecko-coin-price-chart-widget.js"></script>

	<script>
		jQuery(document).ready(function($){
			jQuery( ".toggle_menu" ).click(function(){
				jQuery('.pp-advanced-tabs').toggleClass('hb');
			});
		});
	</script>

	<script>
		jQuery(document).ready(function($){
			jQuery( ".toggle_transaction_history_deposit" ).click(function(){
				jQuery('.deposit_section').addClass('active');
				jQuery('.withdrawals_section').removeClass('active');
				jQuery('.toggle_transaction_history_deposit').addClass('active');
				jQuery('.toggle_transaction_history_withdrawals').removeClass('active');
			});
			jQuery( ".toggle_transaction_history_withdrawals" ).click(function(){
				jQuery('.withdrawals_section').addClass('active');
				jQuery('.deposit_section').removeClass('active');
				jQuery('.toggle_transaction_history_withdrawals').addClass('active');
				jQuery('.toggle_transaction_history_deposit').removeClass('active');
			});
		});
	</script>
	<?php } ?>

	<script>
		$(window).bind('beforeunload', function(){
			var block_config_spinner = { css: { backgroundColor: 'transparent', border: 'none' }, message: '<div class="blockUIspinner"></div>', baseZ: 1500, overlayCSS: { backgroundColor: '#FFFFFF', opacity: 0.8, cursor: 'default' } };
		 	$.blockUI(block_config_spinner);
		});
    </script>
<?php
}

// Bottom Popup
// add_shortcode( 'BOTTOM-POPUP-AREA', 'bottom_popup_area_cb' );
function bottom_popup_area_cb(){
    $html = "";
    ob_start();
    ?>
		<div id="info_br_popup" class="bottom_right_popup">
			<p>Siddharth retired 100 CSR representing 1,000 KGs removed from the environment.</p>
		</div>
    <?php
    $html .= ob_get_clean();
    return $html;
}
add_shortcode('CSR-WITHDRAWAL-SETTING', 'csr_withdrawal_setting_callback');
function csr_withdrawal_setting_callback(){
	global $wpdb;
	$html = "";
	$minimum_withdrawal_amount = ( !empty( get_option('minimum_withdrawal_amount') ) ) ? get_option('minimum_withdrawal_amount') : '' ;
	$withdrawal_fee = ( !empty( get_option('withdrawal_fee') ) ) ? get_option('withdrawal_fee') : '' ;
	$withdrawal_fee_csr25 = ( !empty( get_option('withdrawal_fee_csr25') ) ) ? get_option('withdrawal_fee_csr25') : '' ;
	
	$csr_fee_useremail = ( !empty( get_option('csr_fee_useremail') ) ) ? get_option('csr_fee_useremail') : '' ;

	$tableWithdraw = $wpdb->prefix.'withdraw_data_pending';
	$tableCsrDeliveryTransactionHistory = $wpdb->prefix.'csr_delivery_transaction_history';

	$csrFeeUserEmail = ( !empty( get_option('csr_fee_useremail') ) ) ? get_option('csr_fee_useremail') : 'wayne@corsairnow.com';
	$withdrawalReviewLimit = ( !empty( get_option('withdrawal_review_limit') ) ) ? get_option('withdrawal_review_limit') : '10000';

	$feesUserData = get_user_by('email', $csrFeeUserEmail);
	$fees_user_id = 0;
	if( $feesUserData ){
		$fees_user_id = $feesUserData->ID;
	}

	$whereEmail = "`email` = '".$csrFeeUserEmail."' AND `email` IS NOT NULL AND `email` != ''";

	$totalFeeWalletBalanceResult = get_user_csr_balance( $csrFeeUserEmail, 'total' );
	$totalFeeWalletBalanceResultCsr25 = get_user_csr_balance( $csrFeeUserEmail, 'total', 'csr25' );
	
	$totalFeesReceivedResult = $wpdb->get_row("SELECT COALESCE(SUM(`withdrawal_fee`)) as `total_fees_received` FROM `$tableCsrDeliveryTransactionHistory` WHERE `type`='withdrawal' AND `status`!=-1 AND `token`='CSR'");
	$totalFeesReceivedResultCsr25 = $wpdb->get_row("SELECT COALESCE(SUM(`withdrawal_fee`)) as `total_fees_received` FROM `$tableCsrDeliveryTransactionHistory` WHERE `type`='withdrawal' AND `status`!=-1 AND `token`='CSR25'");
	
	$totalWithdrawalsFeeManagersWalletResult = $wpdb->get_row("SELECT COALESCE(SUM(`received_amount`)) as `total_withdrawals_from_fee_managers_wallet` FROM `$tableCsrDeliveryTransactionHistory` WHERE $whereEmail AND `type`='withdrawal' AND `status`!=-1 AND `token`='CSR'");
	$totalWithdrawalsFeeManagersWalletResultCsr25 = $wpdb->get_row("SELECT COALESCE(SUM(`received_amount`)) as `total_withdrawals_from_fee_managers_wallet` FROM `$tableCsrDeliveryTransactionHistory` WHERE $whereEmail AND `type`='withdrawal' AND `status`!=-1 AND `token`='CSR25'");
	
	ob_start();
	if( current_user_can( 'supportmanager' ) || current_user_can( 'supportagent' ) ){
	?>
	<div class="row csr_withdrawal_setting">
		<div class="col-lg-5">
			<div class="cws_left_col">
				<h2 class="cws_title">Fee Setting</h2>
				<form name="sa_csr_withdrawal_setting" id="sa_csr_withdrawal_setting">
					<div class="form-group">
						<label for="minimum_withdrawal_amount"><?php _e('Minimum withdrawal amount *', CIP_TXTDOMAIN); ?></label>
						<input type="text" class="form-control" name="minimum_withdrawal_amount" id="minimum_withdrawal_amount" value="<?php echo $minimum_withdrawal_amount; ?>" step="0.01" />
					</div>
					<div class="form-group">
						<label for="withdrawal_fee"><?php _e('Withdrawal fee *', CIP_TXTDOMAIN); ?></label>
						<input type="text" class="form-control" name="withdrawal_fee" id="withdrawal_fee" value="<?php echo $withdrawal_fee; ?>" step="0.01" />
					</div>
					<div class="form-group">
						<label for="withdrawal_fee_csr25"><?php _e('Withdrawal fee CSR25*', CIP_TXTDOMAIN); ?></label>
						<input type="text" class="form-control" name="withdrawal_fee_csr25" id="withdrawal_fee_csr25" value="<?php echo $withdrawal_fee_csr25; ?>" step="0.01" />
					</div>
					<div class="form-group">
						<label for="csr_fee_useremail"><?php _e('Fee receive email *', CIP_TXTDOMAIN); ?></label>
						<input type="text" class="form-control" name="csr_fee_useremail" id="csr_fee_useremail" value="<?php echo $csr_fee_useremail; ?>" />
					</div>
					<div class="form-group">
						<label for="withdrawal_review_limit"><?php _e('Withdrawal review limit *', CIP_TXTDOMAIN); ?></label>
						<input type="text" class="form-control" name="withdrawal_review_limit" id="withdrawal_review_limit" value="<?php echo $withdrawalReviewLimit; ?>" />
					</div>
					<input type="submit" name="submit" value="<?php _e('Save', CIP_TXTDOMAIN); ?>" />
					<input type="hidden" name="action" value="csr_withdrawal_setting_act" />
					<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_CsrWithdrawalSettingsrsC_'); ?>" />
				</form>
			</div>

		</div>
		<div class="col-lg-7">
			<div class="cws_right_col">
				<div class="text-left mb-4">
					<button type="button" class="toggle_csr_fee_deposit active"><?php _e('CSR', CIP_TXTDOMAIN); ?></button>
					<button type="button" class="toggle_csr25_fee_deposit"><?php _e('CSR25', CIP_TXTDOMAIN); ?></button>
				</div>
				<div class="csr_fee_section active">
					<h2 class="cws_title">Fee Summary (CSR)</h2>
					<div class="cws_right_col_list">
						<h5><span><?php _e('Fee Managers Wallet Balance', CIP_TXTDOMAIN); ?> :</span> <span><?php echo number_format( $totalFeeWalletBalanceResult ); ?></span></h5>	
						<h5><span><?php _e('Total Fees Received', CIP_TXTDOMAIN); ?> :</span> <span><?php echo number_format( $totalFeesReceivedResult->total_fees_received ); ?></span></h5>
						<h5><span><?php _e('Total Withdrawals from Fee Managers Wallet', CIP_TXTDOMAIN); ?> :</span> <span><?php echo number_format( $totalWithdrawalsFeeManagersWalletResult->total_withdrawals_from_fee_managers_wallet ); ?></span></h5>
					</div>
				</div>
				<div class="csr25_fee_section">
					<h2 class="cws_title">Fee Summary (CSR25)</h2>
					<div class="cws_right_col_list">
						<h5><span><?php _e('Fee Managers Wallet Balance', CIP_TXTDOMAIN); ?> :</span> <span><?php echo number_format( $totalFeeWalletBalanceResultCsr25 ); ?></span></h5>	
						<h5><span><?php _e('Total Fees Received', CIP_TXTDOMAIN); ?> :</span> <span><?php echo number_format( $totalFeesReceivedResultCsr25->total_fees_received ); ?></span></h5>
						<h5><span><?php _e('Total Withdrawals from Fee Managers Wallet', CIP_TXTDOMAIN); ?> :</span> <span><?php echo number_format( $totalWithdrawalsFeeManagersWalletResultCsr25->total_withdrawals_from_fee_managers_wallet ); ?></span></h5>
					</div>
				</div>
			</div>
		</div>
	</div>
	<script>
		jQuery(document).ready(function($){
			jQuery( ".toggle_csr_fee_deposit" ).click(function(){
				jQuery('.csr_fee_section').addClass('active');
				jQuery('.csr25_fee_section').removeClass('active');
				jQuery('.toggle_csr_fee_deposit').addClass('active');
				jQuery('.toggle_csr25_fee_deposit').removeClass('active');
			});
			jQuery( ".toggle_csr25_fee_deposit" ).click(function(){
				jQuery('.csr25_fee_section').addClass('active');
				jQuery('.csr_fee_section').removeClass('active');
				jQuery('.toggle_csr25_fee_deposit').addClass('active');
				jQuery('.toggle_csr_fee_deposit').removeClass('active');
			});
		});
	</script>
	<?php
	}
	$html .= ob_get_clean();
	return $html;
}

add_shortcode( 'CSR-CENTRAL-DB-AREA', 'csr_central_db_area_cb' );
function csr_central_db_area_cb(){
	$html = "";
	ob_start();
	?>
		<!-- <div class="desktop_csr_central">
			<?php //echo do_shortcode('[elementor-template id="7283"]'); ?>
		</div>	
		<div class="mobile_csr_central">
			<?php //echo do_shortcode('[elementor-template id="6902"]'); ?>
		</div>	  -->

		<?php
			// Check if the "mobile" word exists in User-Agent 
			$isMob = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "mobile")); 
			
			// Check if the "tablet" word exists in User-Agent 
			$isTab = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "tablet")); 
			
			// Platform check  
			$isWin = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "windows")); 
			$isAndroid = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "android")); 
			$isIPhone = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "iphone")); 
			$isIPad = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "ipad")); 
			$isIOS = $isIPhone || $isIPad; 
			
			if($isMob){ 
				if($isTab || $isIPad){ 
					echo do_shortcode('[elementor-template id="7283"]');
				}else{ 
					echo do_shortcode('[elementor-template id="6902"]');
				} 
			}else{ 
				echo do_shortcode('[elementor-template id="7283"]'); 
			} 
			
			// if($isIOS){ 
			// 	echo 'iOS'; 
			// }elseif($isAndroid){ 
			// 	echo 'ANDROID'; 
			// }elseif($isWin){ 
			// 	echo 'WINDOWS'; 
			// }
		 
		?>
	<?php
	$html .= ob_get_clean();
	return $html;
}

add_shortcode( 'CSR-MY-PROFILE-AREA', 'csr_my_profile_central_db_area_cb' );
function csr_my_profile_central_db_area_cb(){
	$html = "";
	ob_start();
	?>
		<?php
			// Check if the "mobile" word exists in User-Agent 
			$isMob = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "mobile")); 
			
			// Check if the "tablet" word exists in User-Agent 
			$isTab = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "tablet")); 
			
			// Platform check  
			$isWin = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "windows")); 
			$isAndroid = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "android")); 
			$isIPhone = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "iphone")); 
			$isIPad = is_numeric(strpos(strtolower($_SERVER["HTTP_USER_AGENT"]), "ipad")); 
			$isIOS = $isIPhone || $isIPad; 
			
			if($isMob){ 
				if($isTab || $isIPad){ 
					echo do_shortcode('[elementor-template id="8926"]');
				}else{ 
					echo do_shortcode('[elementor-template id="8914"]');
				} 
			}else{ 
				echo do_shortcode('[elementor-template id="8926"]'); 
			} 
			
			// if($isIOS){ 
			// 	echo 'iOS'; 
			// }elseif($isAndroid){ 
			// 	echo 'ANDROID'; 
			// }elseif($isWin){ 
			// 	echo 'WINDOWS'; 
			// }
		 
		?>
	<?php
	$html .= ob_get_clean();
	return $html;
}