<?php
add_shortcode('CSR-TOKEN-HOLDER2', 'csr_token_holder2_callback');
function csr_token_holder2_callback(){
	$html = "";
	if( is_user_logged_in() && ( current_user_can('supportmanager') || current_user_can('supportagent') ) ){
		global $wpdb;
        $tableName = $wpdb->prefix.'token_holder';
        $user_id = get_current_user_id();
        $getCurrentMembers = $wpdb->get_results("SELECT * FROM $tableName WHERE 1 ORDER BY `id` DESC LIMIT 1");
		wp_enqueue_style( 'cip-css' );
		wp_enqueue_style( 'bs-table' );
        wp_enqueue_style( 'bs-datepicker' );
		wp_enqueue_style( 'bs-sticky-header' );
		wp_enqueue_style( 'daterangepicker-style' );
		wp_enqueue_script('bs-table');
        wp_enqueue_script('bs-datepicker');
		wp_enqueue_script('bs-sticky-header');
		wp_enqueue_script('bs-table-filter-control');
		wp_enqueue_script('dr-moment');
		wp_enqueue_script('daterangepicker-script');
		wp_enqueue_style( 'select2' );
		wp_enqueue_script('select2');
		ob_start();
		if( ( isset($_GET['action']) && $_GET['action'] === 'edit' ) && ( isset($_GET['id']) && is_numeric( $_GET['id'] ) ) ){
			global $wpdb;
			$getMember = $wpdb->get_row("SELECT * FROM $tableName WHERE id = ".$_GET['id']."");
			if( $getMember ){
				global $defaultColumnsArr;
				unset( $defaultColumnsArr['imported_by'] );
				unset( $defaultColumnsArr['import_at'] );
				unset( $defaultColumnsArr['last_update_at'] );
				$columnOrders = get_option('cip_sm_column_order');
				$columnsArr = array();
				if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
					foreach( $columnOrders as $columnOrder ){
						$columnsArr[$columnOrder] = $defaultColumnsArr[$columnOrder];
					}
				}
				if( empty( $columnsArr ) ){
					$columnsArr = $defaultColumnsArr;
				}
				$saEditColOption = (array)get_option('cip_column_sa_toggle_columns');
			?>
			<div class="container">
			<form name="sa_member_update" id="sa_member_update">
				<div class="row">
				<?php
				if( $columnsArr ){
					$column_count = 0;
					foreach( $columnsArr as $columnKey => $columnLbl ){
						if( isset( $defaultColumnsArr[ $columnKey ] ) ){
							$attr = "readonly disabled";
							if( isset( $saEditColOption[ $columnKey ] ) ){
								$attr = 'id="'.$columnKey.'" name="'.$columnKey.'"';
							}else{
								continue;
							}
						?>
						<div class="col-md-4">
							<div class="form-group">
						    	<label for="<?php echo $columnKey ?>"><?php echo $columnKey; ?></label>
						    	<?php if( $columnKey == 'notes_internal' || $columnKey == 'notes_external' ){ ?>
						    		<textarea <?php echo $attr; ?>><?php echo $getMember->$columnKey; ?></textarea>
						    	<?php }else{ ?>
						    		<input type="text" class="form-control" <?php echo $attr; ?> value="<?php echo $getMember->$columnKey; ?>" />
						    	<?php } ?>
						  	</div>
						</div>
						<?php
						}
					}
				}
				?>
				</div>
				<div class="row">
				<div class="col-md-4">
					<div class="form-check">
						<input class="form-check-input" type="checkbox" value="1" name="update_all_match" id="update_all_match">
						<label class="form-check-label" for="update_all_match" style="margin-bottom: 0.5rem;padding-top: 0px !important;"><?php _e('Update all',CIP_TXTDOMAIN); ?></label>
					</div>
					<div class="form-group update_all_option_section" style="display: none;">
						<label for="update_all_option"><?php _e('Update all options', CIP_TXTDOMAIN); ?></label>
						<select class="form-control" name="update_all_option" id="update_all_option">
							<option value="single_row_update"><?php _e('Single row update', CIP_TXTDOMAIN); ?></option>
							<option value="all_username_update"><?php _e('All rows with this username', CIP_TXTDOMAIN); ?></option>
							<option value="all_email_update"><?php _e('All rows with this email', CIP_TXTDOMAIN); ?></option>
							<option value="all_reference_update"><?php _e('All rows with this reference number', CIP_TXTDOMAIN); ?></option>
							<option value="all_wallet_address_update"><?php _e('All rows with this wallet address', CIP_TXTDOMAIN); ?></option>
						</select>
					</div>
					<div class="form-group reference_update_section" style="display: none;">
						<label for="reference_update_field"><?php _e('Reference*', CIP_TXTDOMAIN); ?></label>
						<input type="text" class="form-control" name="reference_update_field" id="reference_update_field" />
					</div>
				</div>
				</div>
				<input type="hidden" name="action" value="sa_update_th_tp1_act" />
				<input type="hidden" name="_micro" value="<?php echo wp_create_nonce('_Xupdatethtp1X_'); ?>" />
				<input type="hidden" name="sathid" value="<?php echo $_GET['id']; ?>">
		  		<button type="button" class="btn btn-primary" data-toggle="modal" data-target="#smEditTokenHolderG2FAModal"><?php _e('Update',CIP_TXTDOMAIN); ?></button>
		  		<p><span class="form_response"></span></p>
				<div class="modal fade" id="smEditTokenHolderG2FAModal" tabindex="-1" role="dialog" aria-labelledby="smEditTokenHolderG2FAModalTitle" aria-hidden="true">
					<div class="modal-dialog modal-dialog-centered" role="document">
						<div class="modal-content">
							<div class="modal-body">
								<div class="otp_section pb-3">
									<label for="sasm_ga_otp"><?php echo __('Please enter the authentication code', CIP_TXTDOMAIN); ?></label>
									<input type="text" name="sm_editth_ga_otp" id="sm_editth_ga_otp" class="input mb-1" maxlength="6" pattern="{0-9}+" />
									<small class="form-text text-muted"><?php _e('Enter the 6-digit code generated by the Authenticator App.') ?></small>
								</div>
								<button type="submit" class="btn btn-primary"><?php _e('Submit',CIP_TXTDOMAIN); ?></button>
								<input type="button" name="cancel" class="btn btn-primary" data-dismiss="modal" value="<?php _e('Cancel', CIP_TXTDOMAIN); ?>" />
							</div>
						</div>
					</div>
				</div>
			</form>
			</div>
			<div class="modal fade" id="update_warning" tabindex="-1" role="dialog" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered" role="document">
				<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title"><span class="fa fa-exclamation-circle"></span> <?php _e('Warning', CIP_TXTDOMAIN); ?></h5>
				</div>
				<div class="modal-body">
					<h5><?php _e('Exercise caution and double check any updates',CIP_TXTDOMAIN); ?></h5>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-secondary" data-dismiss="modal"><?php _e('Close',CIP_TXTDOMAIN); ?></button>
				</div>
				</div>
			</div>
			</div>
			<?php
			}
		}else{
        ?>
            <div class="container-fluid tokenholder_list2_frm">
                <div class="text-left sa_csr_holder_btns">
                    <button type="button" class="btn clear_all_csr_holder token-holder-list-clear-button" style="display: none;" onclick="window.location.href='<?php echo get_the_permalink( 9066 ); ?>'"><?php _e('Clear', CIP_TXTDOMAIN); ?></button>
                    <style>
                        .token-holder-list-clear-button{
                            position: absolute;
                            top: 25px;
                        }
                        .table-responsive,.tokenholder_list2_frm{
                            position: relative;
                        }
                        #toggle_csr_token_holder_advance_filter{
                            display: none;
                            position: absolute;
                            background: #fff;
                            padding: 20px;
                            z-index: 99;
                            width: calc(100% - 30px);
                            box-shadow: rgba(99, 99, 99, 0.2) 0px 2px 8px 0px;
                        }
                        #csrtokenholderadvanceFilterModal select{
                            width: 100% !important;
                        }
                        .ad_filter_body{
                            display: none;
                        }
                        .ad_filter_body.show{
                            display: block;
                        }
                        .ad_filter_body_container{
                            border-left: 1px solid #dee2e6;
                        }
                        .ad_filter_body .heading-ad-filter {
                            width: calc(100% + 30px);
                            border-bottom: 1px solid #dee2e6;
                            padding: 0 15px 15px 15px !important;
                            margin-left: -15px;
                            margin-right: 0 !important;
                            margin-bottom: 20px;
                            font-size: 18px !important;
                            font-weight: 600;
                        }
                        .ad_filter_label.value div:after {
                            content: "*";
                            position: absolute;
                            top: 50%;
                            left: 100%;
                            transform: translateY(-50%);
                            padding-left: 5px;
                        }
                        .ad_filter_label.value div {
                            position: relative;
                        }
                        #csrtokenholderadvanceFilterModal #csr_advancefilter {
                            width: 100%;
                        }
                        #csrtokenholderadvanceFilterModal span.select2.select2-container.select2-container--default {
                            width: 100% !important;
                        }
                        #csrtokenholderadvanceFilterModal button.close {
                            float: none;
                            margin: 0;
                            background: transparent;
                            color: #000;
                            opacity: 1;
                            font-size: 30px;
                            line-height: 25px;
                        }
                        #csrtokenholderadvanceFilterModal .ad_filter_label {
                            padding: 7px 12px;
                            margin-bottom: 6px;
                            color: #000 !important;
                            border-radius: 10px;
                        }
                        #csrtokenholderadvanceFilterModal .ad_filter_label.active {
                            background: #7d38ab !important;
                            color: #fff !important;
                        }
                        #csrtokenholderadvanceFilterModal .modal-body {
                            padding: 0 !important;
                        }
                        .tokenholder_list2_frm .btn.btn-primary.csr_token_holder_download {
                            position: absolute;
                            top: 10px;
                            right: 1px;
                            padding: 6px 12px !important;
                            margin: 0;
                            height: 38px;
                            border: 1px solid #572181 ! IMPORTANT;
                            border-left: none !important;
                            border-radius: 0 3px 3px 0;
                            z-index: 1;
                        }
                        .tokenholder_list2_frm .btn.btn-secondary.dropdown-toggle {
                            margin-right: 42px;
                            border-right: 0;
                        }
                    </style>
                </div>
            <button type="button" class="btn btn-primary csr_token_holder_advance_filter"><i class="fa fa-filter"></i></button>
            <!-- <div class="col-12" id="toggle_csr_token_holder_advance_filter">
                <div class="row">
                    <?php
                    global $defaultColumnsArr;
                    $needColumns = array('username', 'email', 'pool_ref', 'corp_approved');
                    $columnOrders = (array)get_option('cip_sm_column_order');
                    $columnsLabelArr = (array)get_option('cip_sm_column_labels');
                    $columnsArr = array();
                    if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
                        foreach( $columnOrders as $columnOrder ){
                            $columnsArr[$columnOrder] = $defaultColumnsArr[$columnOrder];
                        }
                    }
                    if( empty( $columnsArr ) ){
                        $columnsArr = $defaultColumnsArr;
                    }
                    foreach( $columnsArr as $columnKey => $columnLabel ){
                        if( in_array( $columnKey, $needColumns ) ){
                        $cLabel = ( !empty( $columnsLabelArr[ $columnKey ] ) ) ? $columnsLabelArr[ $columnKey ] : $columnLabel;
                        // $cLabel = ( !empty( $columnsLabelArr[ $columnKey ] ) ) ? $columnsLabelArr[ $columnKey ] .' ('.$columnKey.')' : $columnLabel;
                        ?>
                        <div class="col-sm-3">
                        <div class="form-group">
                            <label for="<?php echo $columnKey; ?>" class="mr-sm-2"><?php echo $cLabel; ?></label>
                            <?php if( $columnKey == 'pool_ref' || $columnKey == 'corp_approved' || $columnKey == 'username' ){ ?>
                                    <select class="mb-2 mr-sm-2" name="<?php echo $columnKey; ?>[]" id="<?php echo $columnKey; ?>" multiple>
                                        <?php if( $columnKey == 'corp_approved' ){ ?>
                                            <option selected>Hold</option>
                                            <option selected>Issued</option>
                                            <option selected>Delivered</option>
                                            <option selected>Deleted</option>
                                            <option selected>Saved CSR</option>
                                            <option selected>Security Hold</option>
                                            <option selected>Rejected</option>
                                            <option selected>Pending</option>
                                            <option selected>Under review</option>
                                            <option selected>Application received</option>
                                            <option selected>In Process</option>
                                            <option selected>Partially Delivered</option>
                                            <option selected>CSR Retirement</option>
                                        <?php } ?>
                                        <?php
                                        global $wpdb;
                                        $tableName = $wpdb->prefix.'token_holder';
                                            if( $columnKey == 'username' ){
                                                $fillterusernames = $wpdb->get_results("SELECT DISTINCT `username` FROM $tableName WHERE 1", ARRAY_A); // Fetching as an associative array
                                                // print_r($fillterusernames);
                                                array_unique($fillterusernames);
                                                // Check if fillterusernames were found
                                                if (!empty($fillterusernames)) {
                                                    foreach ($fillterusernames as $fillteruser) {
                                                        // Process each username. $user['username'] is your distinct username
                                                        echo "<option>" . $fillteruser['username'] . "</option>";
                                                        // Your option processing logic here
                                                    }
                                                }
                                            }
                                        ?>
                                        <?php
                                            if( $columnKey == 'pool_ref' ){
                
                                                $fillterpool_refs = $wpdb->get_results("SELECT DISTINCT `pool_ref` FROM $tableName WHERE 1", ARRAY_A); // Fetching as an associative array
                                                // print_r($fillterpool_refs);
                                                array_unique($fillterpool_refs);
                                                // Check if fillterpool_refs were found
                                                if (!empty($fillterpool_refs)) {
                                                    foreach ($fillterpool_refs as $fillteruser) {
                                                        // Process each pool_ref. $user['pool_ref'] is your distinct pool_ref
                                                        echo "<option>" . $fillteruser['pool_ref'] . "</option>";
                                                        // Your option processing logic here
                                                    }
                                                }
                                            }
                                        ?>
                                    </select>
                            <?php }else{ ?>
                            <input type="text" class="form-control-plaintext mb-2 mr-sm-2" name="<?php echo $columnKey; ?>" id="<?php echo $columnKey; ?>" />
                            <?php } ?>
                        </div>
                        </div>
                        <?php
                        }
                    }
                    ?>
                    </div>
            </div> -->
            <div class="table-responsive">
            <?php
                $user_id = get_current_user_id();
                if( !metadata_exists( 'user', $user_id, 'cip_sagent_toggle_columns' ) ){
                    $columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
                    update_user_meta( $user_id, 'cip_sagent_toggle_columns', $columnsSAColumnOption );
                }
                $saUserData = get_user_by( 'id', $user_id );
                global $defaultColumnsArr;
                if( $saUserData && ( in_array( "supportagent", $saUserData->roles ) || in_array( "supportmanager", $saUserData->roles ) ) ){
                    $columnOrders = (array)get_option('cip_sm_column_order');
                    $columnsLabelArr = (array)get_option('cip_sm_column_labels');
                    $columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
                    $columnsSAToggleArr = (array)get_user_meta( $user_id, 'cip_sagent_toggle_columns', true );
                    $columnsArr = array();
                    if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
                        foreach( $columnOrders as $columnOrder ){
                            if( isset( $columnsSAToggleArr[$columnOrder] ) ){
                                $columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
                            }
                        }
                        if( empty( $columnsArr ) ){
                            foreach( $columnOrders as $columnOrder ){
                                if( isset( $columnsSAColumnOption[$columnOrder] ) ){
                                    $columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
                                }
                            }
                        }
                    }else{
                        unset( $defaultColumnsArr['imported_by'] );
                        unset( $defaultColumnsArr['import_at'] );
                        unset( $defaultColumnsArr['last_update_at'] );
                        $columnsArr = $defaultColumnsArr;
                    }
                }else{
                    unset( $defaultColumnsArr['imported_by'] );
                    unset( $defaultColumnsArr['import_at'] );
                    unset( $defaultColumnsArr['last_update_at'] );
                    $columnsArr = $defaultColumnsArr;
                }
            ?>
            <button type="button" class="btn btn-primary csr_token_holder_download"><i class="fa fa-download"></i></button>
            <table id="tokenholder_list2" data-toolbar="false" data-filter-control="true" data-show-search-clear-button="false" data-pagination="true" data-toggle="table" data-show-columns="true" data-show-toggle="false" data-click-to-select="false" data-show-columns-toggle-all="false" data-show-export="false" class="table table-bordered" data-side-pagination="server" data-page-size="20" data-page-list="[20, 30, 50, 100]" data-query-params="queryParams">
                <thead>
                <tr>
                    <th data-field="id" class="id"><?php _e('Id',CIP_TXTDOMAIN); ?></th>
                    <?php
                    $part1 = array_slice($columnsArr, 0, array_search('notes_external', array_keys($columnsArr)));
                    $part2 = array_slice($columnsArr, array_search('notes_external', array_keys($columnsArr)));
                    $part1['token'] = 'Token';
                    $columnsArr = $part1 + $part2;
                    if( $columnsArr ){
                        foreach( $columnsArr as $columnKey => $columnsVal ){
                            $filter_attr = 'data-filter-control="input"';
                            $filterData_attr = '';
                            if( $columnKey == '_user_status' || $columnKey == 'kyc_status' || $columnKey == 'corp_approved' || $columnKey == 'token' ){
                                if( $columnKey == '_user_status' ){
                                    $filterData_attr = ' data-filter-data="var:filterUserStatus"';
                                }
                                if( $columnKey == 'kyc_status' ){
                                    $filterData_attr = ' data-filter-data="var:filterKycStatus"';
                                }
                                if( $columnKey == 'corp_approved' ){
                                    $filterData_attr = ' data-filter-data="var:filterCorpApproved"';
                                }
                                if( $columnKey == 'token' ){?>
                                    <script>
                                    var filterToken = {
                                        csr: "CSR",
                                        csr25: "CSR25"
                                    };
                                    </script>
                                    <?php
                                    $filterData_attr = ' data-filter-data="var:filterToken"';
                                }
                                $filter_attr = 'data-filter-control="select" class="status" data-filter-custom-search="BsTableFilterStatus"'.$filterData_attr;
                            }
                        ?>
                        <th data-field="<?php echo $columnKey ?>" data-sortable="true" <?php echo $filter_attr; ?> class="<?php echo $columnKey ?>"><?php echo $columnsVal; ?></th>
                        <?php
                        }
                        ?>
                        <th data-field="action" class="action"><?php _e('Action',CIP_TXTDOMAIN); ?></th>
                        <?php
                    }
                    ?>
                </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
            <div class="modal fade" id="notesFilterModal" tabindex="-1" role="dialog" aria-labelledby="notesFilterModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                <form class="filter_by_notes" name="filter_by_notes" id="filter_by_notes">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="filter_by_condition">Filter by condition</label>
                            <select class="form-control" name="filter_condition_type" id="filter_condition_value">
                                <option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
                                <option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="contains_text"><?php _e('Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="does_not_contains_text"><?php _e('Does not Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="starts_with"><?php _e('Starts with', CIP_TXTDOMAIN); ?></option>
                                <option value="ends_with"><?php _e('Ends with', CIP_TXTDOMAIN); ?></option>
                                <option value="is_exactly"><?php _e('Is exactly', CIP_TXTDOMAIN); ?></option>
                            </select>
                            <input type="text" class="form-control mt-2" name="filter_condition_value" id="filter_condition_value" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
                        <button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
                    </div>
                </form>
                </div>
            </div>
            </div>
            <div class="modal fade" id="notesinternalFilterModal" tabindex="-1" role="dialog" aria-labelledby="notesinternalFilterModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                <form class="filter_by_internalnotes" name="filter_by_internalnotes" id="filter_by_internalnotes">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="filter_by_condition">Filter by condition</label>
                            <select class="form-control" name="filter_condition_type" id="filter_condition_value">
                                <option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
                                <option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="contains_text"><?php _e('Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="does_not_contains_text"><?php _e('Does not Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="starts_with"><?php _e('Starts with', CIP_TXTDOMAIN); ?></option>
                                <option value="ends_with"><?php _e('Ends with', CIP_TXTDOMAIN); ?></option>
                                <option value="is_exactly"><?php _e('Is exactly', CIP_TXTDOMAIN); ?></option>
                            </select>
                            <input type="text" class="form-control mt-2" name="filter_condition_value" id="filter_condition_value" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
                        <button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
                    </div>
                </form>
                </div>
            </div>
            </div>
            <div class="modal fade" id="referenceFilterModal" tabindex="-1" role="dialog" aria-labelledby="referenceFilterModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                <form class="filter_by_reference" name="filter_by_reference" id="filter_by_reference">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="filter_by_condition">Filter by condition</label>
                            <select class="form-control" name="filter_condition_type" id="filter_condition_value">
                                <option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
                                <option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="contains_text"><?php _e('Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="does_not_contains_text"><?php _e('Does not Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="starts_with"><?php _e('Starts with', CIP_TXTDOMAIN); ?></option>
                                <option value="ends_with"><?php _e('Ends with', CIP_TXTDOMAIN); ?></option>
                                <option value="is_exactly"><?php _e('Is exactly', CIP_TXTDOMAIN); ?></option>
                            </select>
                            <input type="text" class="form-control mt-2" name="filter_condition_value" id="filter_condition_value" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
                        <button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
                    </div>
                </form>
                </div>
            </div>
            </div>
            <div class="modal fade" id="eth_addressFilterModal" tabindex="-1" role="dialog" aria-labelledby="eth_addressFilterModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                <form class="filter_by_eth_address" name="filter_by_eth_address" id="filter_by_eth_address">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="filter_by_condition">Filter by condition</label>
                            <select class="form-control" name="filter_condition_type" id="filter_condition_value">
                                <option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
                                <option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="contains_text"><?php _e('Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="does_not_contains_text"><?php _e('Does not Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="starts_with"><?php _e('Starts with', CIP_TXTDOMAIN); ?></option>
                                <option value="ends_with"><?php _e('Ends with', CIP_TXTDOMAIN); ?></option>
                                <option value="is_exactly"><?php _e('Is exactly', CIP_TXTDOMAIN); ?></option>
                            </select>
                            <input type="text" class="form-control mt-2" name="filter_condition_value" id="filter_condition_value" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
                        <button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
                    </div>
                </form>
                </div>
            </div>
            </div>
            <div class="modal fade" id="csr_amount_initialFilterModal" tabindex="-1" role="dialog" aria-labelledby="csr_amount_initialFilterModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                <form class="filter_by_csr_amount_initial" name="filter_by_csr_amount_initial" id="filter_by_csr_amount_initial">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="filter_by_condition">Filter by condition</label>
                            <select class="form-control" name="filter_condition_type" id="filter_condition_value">
                                <option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
                                <option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="contains_text"><?php _e('Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="does_not_contains_text"><?php _e('Does not Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="starts_with"><?php _e('Starts with', CIP_TXTDOMAIN); ?></option>
                                <option value="ends_with"><?php _e('Ends with', CIP_TXTDOMAIN); ?></option>
                                <option value="is_exactly"><?php _e('Is exactly', CIP_TXTDOMAIN); ?></option>
                            </select>
                            <input type="text" class="form-control mt-2" name="filter_condition_value" id="filter_condition_value" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
                        <button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
                    </div>
                </form>
                </div>
            </div>
            </div>
            <div class="modal fade" id="csr_amount_issuedFilterModal" tabindex="-1" role="dialog" aria-labelledby="csr_amount_issuedFilterModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                <form class="filter_by_csr_amount_issued" name="filter_by_csr_amount_issued" id="filter_by_csr_amount_issued">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="filter_by_condition">Filter by condition</label>
                            <select class="form-control" name="filter_condition_type" id="filter_condition_value">
                                <option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
                                <option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="contains_text"><?php _e('Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="does_not_contains_text"><?php _e('Does not Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="starts_with"><?php _e('Starts with', CIP_TXTDOMAIN); ?></option>
                                <option value="ends_with"><?php _e('Ends with', CIP_TXTDOMAIN); ?></option>
                                <option value="is_exactly"><?php _e('Is exactly', CIP_TXTDOMAIN); ?></option>
                            </select>
                            <input type="text" class="form-control mt-2" name="filter_condition_value" id="filter_condition_value" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
                        <button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
                    </div>
                </form>
                </div>
            </div>
            </div>
            <div class="modal fade" id="amount_dueFilterModal" tabindex="-1" role="dialog" aria-labelledby="amount_dueFilterModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                <form class="filter_by_amount_due" name="filter_by_amount_due" id="filter_by_amount_due">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="filter_by_condition">Filter by condition</label>
                            <select class="form-control" name="filter_condition_type" id="filter_condition_value">
                                <option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
                                <option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="contains_text"><?php _e('Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="does_not_contains_text"><?php _e('Does not Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="starts_with"><?php _e('Starts with', CIP_TXTDOMAIN); ?></option>
                                <option value="ends_with"><?php _e('Ends with', CIP_TXTDOMAIN); ?></option>
                                <option value="is_exactly"><?php _e('Is exactly', CIP_TXTDOMAIN); ?></option>
                            </select>
                            <input type="text" class="form-control mt-2" name="filter_condition_value" id="filter_condition_value" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
                        <button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
                    </div>
                </form>
                </div>
            </div>
            </div>
            <div class="modal fade" id="first_nameFilterModal" tabindex="-1" role="dialog" aria-labelledby="first_nameFilterModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                <form class="filter_by_first_name" name="filter_by_first_name" id="filter_by_first_name">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="filter_by_condition">Filter by condition</label>
                            <select class="form-control" name="filter_condition_type" id="filter_condition_value">
                                <option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
                                <option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="contains_text"><?php _e('Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="does_not_contains_text"><?php _e('Does not Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="starts_with"><?php _e('Starts with', CIP_TXTDOMAIN); ?></option>
                                <option value="ends_with"><?php _e('Ends with', CIP_TXTDOMAIN); ?></option>
                                <option value="is_exactly"><?php _e('Is exactly', CIP_TXTDOMAIN); ?></option>
                            </select>
                            <input type="text" class="form-control mt-2" name="filter_condition_value" id="filter_condition_value" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
                        <button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
                    </div>
                </form>
                </div>
            </div>
            </div>
            <div class="modal fade" id="last_nameFilterModal" tabindex="-1" role="dialog" aria-labelledby="last_nameFilterModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                <form class="filter_by_last_name" name="filter_by_last_name" id="filter_by_last_name">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="filter_by_condition">Filter by condition</label>
                            <select class="form-control" name="filter_condition_type" id="filter_condition_value">
                                <option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
                                <option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="contains_text"><?php _e('Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="does_not_contains_text"><?php _e('Does not Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="starts_with"><?php _e('Starts with', CIP_TXTDOMAIN); ?></option>
                                <option value="ends_with"><?php _e('Ends with', CIP_TXTDOMAIN); ?></option>
                                <option value="is_exactly"><?php _e('Is exactly', CIP_TXTDOMAIN); ?></option>
                            </select>
                            <input type="text" class="form-control mt-2" name="filter_condition_value" id="filter_condition_value" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
                        <button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
                    </div>
                </form>
                </div>
            </div>
            </div>
            <div class="modal fade" id="emailFilterModal" tabindex="-1" role="dialog" aria-labelledby="emailFilterModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                <form class="filter_by_email" name="filter_by_email" id="filter_by_email">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="filter_by_condition">Filter by condition</label>
                            <select class="form-control" name="filter_condition_type" id="filter_condition_value">
                                <option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
                                <option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="contains_text"><?php _e('Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="does_not_contains_text"><?php _e('Does not Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="starts_with"><?php _e('Starts with', CIP_TXTDOMAIN); ?></option>
                                <option value="ends_with"><?php _e('Ends with', CIP_TXTDOMAIN); ?></option>
                                <option value="is_exactly"><?php _e('Is exactly', CIP_TXTDOMAIN); ?></option>
                            </select>
                            <input type="text" class="form-control mt-2" name="filter_condition_value" id="filter_condition_value" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
                        <button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
                    </div>
                </form>
                </div>
            </div>
            </div>
            <div class="modal fade" id="text_9FilterModal" tabindex="-1" role="dialog" aria-labelledby="text_9FilterModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                <form class="filter_by_text_9" name="filter_by_text_9" id="filter_by_text_9">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="filter_by_condition">Filter by condition</label>
                            <select class="form-control" name="filter_condition_type" id="filter_condition_value">
                                <option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
                                <option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
                                <option value="contains_text"><?php _e('Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="does_not_contains_text"><?php _e('Does not Contains Text', CIP_TXTDOMAIN); ?></option>
                                <option value="starts_with"><?php _e('Starts with', CIP_TXTDOMAIN); ?></option>
                                <option value="ends_with"><?php _e('Ends with', CIP_TXTDOMAIN); ?></option>
                                <option value="is_exactly"><?php _e('Is exactly', CIP_TXTDOMAIN); ?></option>
                            </select>
                            <input type="text" class="form-control mt-2" name="filter_condition_value" id="filter_condition_value" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
                        <button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
                    </div>
                </form>
                </div>
            </div>
            </div>
            <div class="modal fade" id="poolRefFilterModal" tabindex="-1" role="dialog" aria-labelledby="poolRefFilterModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                <form class="filter_by_pool_ref" name="filter_by_pool_ref" id="filter_by_pool_ref">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="filter_by_condition_pool_ref">Filter by condition</label>
                            <select class="form-control" name="filter_condition_type_pool_ref" id="filter_condition_type_pool_ref">
                                <option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
                                <option value="is_exactly_simple"><?php _e('Is exactly (multiple)', CIP_TXTDOMAIN); ?></option>
                                <option value="is_exactly"><?php _e('Is exactly adv. (multiple)', CIP_TXTDOMAIN); ?></option>
                            </select>
                            <textarea name="filter_condition_value_pool_ref_bulk" id="filter_condition_value_pool_ref_bulk" class="form-control mt-2" style="display: none;" rows="3" placeholder="<?php _e('Bulk Pool Reference', CIP_TXTDOMAIN ); ?>"></textarea>
                            <select class="form-control mt-2" style="width:100%" name="filter_condition_value_pool_ref[]" id="filter_condition_value_pool_ref" multiple></select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
                        <button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
                    </div>
                </form>
                </div>
            </div>
            </div>
            <div class="modal fade" id="DistributionWeekFilterModal" tabindex="-1" role="dialog" aria-labelledby="DistributionWeekFilterModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <form class="filter_by_distribution_week" name="filter_by_distribution_week" id="filter_by_distribution_week">
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="filter_by_condition_distribution_week">Filter by condition</label>
                                <select class="form-control" name="filter_condition_type_distribution_week" id="filter_condition_type_distribution_week">
                                    <option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
                                    <option value="weeks_before"><?php _e('Weeks Before', CIP_TXTDOMAIN); ?></option>
                                    <option value="is_exactly_simple"><?php _e('Is exactly (multiple)', CIP_TXTDOMAIN); ?></option>
                                    <option value="is_exactly"><?php _e('Is exactly adv. (multiple)', CIP_TXTDOMAIN); ?></option>
                                </select>
                                <input type="text" class="form-control mt-2" name="filter_condition_value_distribution_week_before" id="filter_condition_value_distribution_week_before" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
                                <textarea name="filter_condition_value_distribution_bulk" id="filter_condition_value_distribution_bulk" class="form-control mt-2" style="display: none;" rows="3" placeholder="<?php _e('Bulk Distribution Week', CIP_TXTDOMAIN ); ?>"></textarea>
                                <select class="form-control mt-2" style="width:100%" name="filter_condition_value_distribution_week[]" id="filter_condition_value_distribution_week" multiple></select>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
                            <button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
                        </div>
                    </form>
                </div>
            </div>
            </div>
            <div class="modal fade" id="UsernameFilterModal" tabindex="-1" role="dialog" aria-labelledby="UsernameFilterModal" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <form class="filter_by_username" name="filter_by_username" id="filter_by_username">
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="filter_by_condition_username">Filter by condition</label>
                                <select class="form-control" name="filter_condition_type_username" id="filter_condition_type_username">
                                    <option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
                                    <option value="is_exactly_simple"><?php _e('Is exactly (multiple)', CIP_TXTDOMAIN); ?></option>
                                    <option value="is_exactly"><?php _e('Is exactly adv. (multiple)', CIP_TXTDOMAIN); ?></option>
                                </select>
                                <textarea name="filter_condition_value_username_bulk" id="filter_condition_value_username_bulk" class="form-control mt-2" style="display: none;" rows="3" placeholder="<?php _e('Bulk Usernames', CIP_TXTDOMAIN ); ?>"></textarea>
                                <select class="form-control mt-2" style="width:100%" name="filter_condition_value_username[]" id="filter_condition_value_username" multiple></select>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Ok', CIP_TXTDOMAIN); ?></button>
                            <button type="button" class="btn btn-secondary filter_csr_cancel"><?php _e('Cancel', CIP_TXTDOMAIN); ?></button>
                        </div>
                    </form>
                </div>
            </div>
            </div>
            <div class="modal fade" id="csrDeliveryModal" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="container-fluid">
                                <span class="withdrawal_close_btn close" data-dismiss="modal">&times;</span>
                                <div class="csrDeliveryBody"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="csrDeliveryToSavingModal" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="container-fluid">
                                <span class="withdrawal_close_btn close" data-dismiss="modal">&times;</span>
                                <div class="csrDeliveryToSavingBody"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal fade" id="viewMoreModal" tabindex="-1" role="dialog" aria-labelledby="viewMoreModalTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                <div class="modal-body">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
                </div>
            </div>
            </div>
            <div class="modal fade" id="csrtokenholderadvanceFilterModal" tabindex="-1" role="dialog" aria-labelledby="csrtokenholderadvanceFilterModal" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="modal-header p-3 d-flex justify-content-between align-self-center"><h3>Additional Filter</h3> <div class="d-flex justify-content-between align-self-center"><button type="button" class="btn btn-secondary filter_csr_clear mr-2"><?php _e('Clean Filters', CIP_TXTDOMAIN); ?></button><button type="button" class="btn btn-secondary filter_csr_ok"><?php _e('Apply Filters', CIP_TXTDOMAIN); ?></button><button type="button" class="close" data-dismiss="modal">×</button></div></div>
                            <div class="form-group m-0">
                            
                                <div id="csr_advancefilter" class="px-3">
                                    <div class="row">
                                        <?php
                                        global $defaultColumnsArr;
                                        $needColumns = array('username', 'email', 'pool_ref', 'corp_approved', 'reference', 'eth_address', 'csr_amount_initial', 'csr_amount_issued', 'amount_due', 'notes_external', 'notes_internal');
                                        $columnOrders = (array)get_option('cip_sm_column_order');
                                        $columnsLabelArr = (array)get_option('cip_sm_column_labels');
                                        $columnsArr = array();
                                        $i = 0;
                                        if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
                                            foreach( $columnOrders as $columnOrder ){
                                                $columnsArr[$columnOrder] = $defaultColumnsArr[$columnOrder];
                                            }
                                        }
                                        if( empty( $columnsArr ) ){
                                            $columnsArr = $defaultColumnsArr;
                                        }
                                        ?>
                                        <div class="col-12 col-lg-4 py-3  ">
                                            <?php
                                            foreach( $columnsArr as $columnKey => $columnLabel ){
                                                if( in_array( $columnKey, $needColumns ) ){
                                                $cLabel = ( !empty( $columnsLabelArr[ $columnKey ] ) ) ? $columnsLabelArr[ $columnKey ] : $columnLabel;
                                                ?>
                                                <a href="javascript:void(0);" class="ad_filter_label bg-light d-flex justify-content-between align-items-center <?php echo ($i == 0) ? 'active' : '' ; ?>" advance-filter="accodian_<?php echo $columnKey; ?>"><div><?php echo $cLabel; ?></div><i class="fa fa-angle-right"></i></a>
                                                <?php
                                                $i++;
                                                }
                                            }
                                            ?>
                                        </div>
                                        <div class="col-12 col-lg-8 py-3 ad_filter_body_container bg-light">
                                            <?php
                                                $i = 0;
                                                global $wpdb;
                                                $tableName = $wpdb->prefix.'token_holder';
                                                foreach( $columnsArr as $columnKey => $columnLabel ){
                                                    if( in_array( $columnKey, $needColumns ) ){
                                                    $cLabel = ( !empty( $columnsLabelArr[ $columnKey ] ) ) ? $columnsLabelArr[ $columnKey ] : $columnLabel;
                                                    // $cLabel = ( !empty( $columnsLabelArr[ $columnKey ] ) ) ? $columnsLabelArr[ $columnKey ] .' ('.$columnKey.')' : $columnLabel;
                                                    ?>
                                                    <div id="accodian_<?php echo $columnKey; ?>" class="ad_filter_body <?php echo ($i == 0) ? 'show' : '' ; ?>">
                                                        <div class="form-group">
                                                            <label for="<?php echo $columnKey; ?>" class="heading-ad-filter mr-sm-2"><?php echo $cLabel; ?></label>
                                                            <?php if( $columnKey == 'pool_ref' || $columnKey == 'corp_approved' || $columnKey == 'username' || $columnKey == 'email' ){ ?>
                                                                    <select class="mb-2 mr-sm-2" name="<?php echo $columnKey; ?>[]" id="<?php echo $columnKey; ?>" multiple>
                                                                        <?php if( $columnKey == 'corp_approved' ){ 
                                                                            if( $columnKey == 'corp_approved' ){
                                                                                $filltercorp_approveds = $wpdb->get_results("SELECT DISTINCT `corp_approved` FROM $tableName WHERE 1", ARRAY_A); // Fetching as an associative array
                                                                                // print_r($filltercorp_approveds);
                                                                                array_unique($filltercorp_approveds);
                                                                                // Check if filltercorp_approveds were found
                                                                                if (!empty($filltercorp_approveds)) {
                                                                                    foreach ($filltercorp_approveds as $fillteruser) {
                                                                                        // Process each corp_approved. $user['corp_approved'] is your distinct corp_approved
                                                                                        echo "<option>" . $fillteruser['corp_approved'] . "</option>";
                                                                                        // Your option processing logic here
                                                                                    }
                                                                                }
                                                                            }
                                                                         } ?>
                                                                        <?php
                                                                        
                                                                            if( $columnKey == 'username' ){
                                                                                $fillterusernames = $wpdb->get_results("SELECT DISTINCT `username` FROM $tableName WHERE 1", ARRAY_A); // Fetching as an associative array
                                                                                // print_r($fillterusernames);
                                                                                array_unique($fillterusernames);
                                                                                // Check if fillterusernames were found
                                                                                if (!empty($fillterusernames)) {
                                                                                    foreach ($fillterusernames as $fillteruser) {
                                                                                        // Process each username. $user['username'] is your distinct username
                                                                                        echo "<option>" . $fillteruser['username'] . "</option>";
                                                                                        // Your option processing logic here
                                                                                    }
                                                                                }
                                                                            }
                                                                        ?>
                                                                        <?php
                                                                            if( $columnKey == 'pool_ref' ){
                                                
                                                                                $fillterpool_refs = $wpdb->get_results("SELECT DISTINCT `pool_ref` FROM $tableName WHERE 1", ARRAY_A); // Fetching as an associative array
                                                                                // print_r($fillterpool_refs);
                                                                                array_unique($fillterpool_refs);
                                                                                // Check if fillterpool_refs were found
                                                                                if (!empty($fillterpool_refs)) {
                                                                                    foreach ($fillterpool_refs as $fillteruser) {
                                                                                        // Process each pool_ref. $user['pool_ref'] is your distinct pool_ref
                                                                                        echo "<option>" . $fillteruser['pool_ref'] . "</option>";
                                                                                        // Your option processing logic here
                                                                                    }
                                                                                }
                                                                            }
                                                                            if( $columnKey == 'email' ){
                                                
                                                                                $fillteremails = $wpdb->get_results("SELECT DISTINCT `email` FROM $tableName WHERE 1", ARRAY_A); // Fetching as an associative array
                                                                                // print_r($fillteremails);
                                                                                array_unique($fillteremails);
                                                                                // Check if fillteremails were found
                                                                                if (!empty($fillteremails)) {
                                                                                    foreach ($fillteremails as $fillteruser) {
                                                                                        // Process each email. $user['email'] is your distinct email
                                                                                        echo "<option>" . $fillteruser['email'] . "</option>";
                                                                                        // Your option processing logic here
                                                                                    }
                                                                                }
                                                                            }
                                                                        ?>
                                                                    </select>
                                                            <?php }else{ ?>
                                                            <!-- <input type="text" class="form-control-plaintext mb-2 mr-sm-2" name="<?php echo $columnKey; ?>" id="<?php echo $columnKey; ?>" /> -->
                                                            <form class="filter_by_<?php echo $columnKey; ?>" name="filter_by_<?php echo $columnKey; ?>" id="filter_by_<?php echo $columnKey; ?>">
                                                                <div class="form-group">
                                                                    <label for="filter_by_condition">Filter by condition</label>
                                                                    <select class="form-control" name="filter_condition_type" id="filter_condition_value">
                                                                        <option value="none"><?php _e('None', CIP_TXTDOMAIN); ?></option>
                                                                        <option value="is_empty"><?php _e('Is Empty', CIP_TXTDOMAIN); ?></option>
                                                                        <option value="is_not_empty"><?php _e('Is Not Empty', CIP_TXTDOMAIN); ?></option>
                                                                        <option value="contains_text"><?php _e('Contains Text', CIP_TXTDOMAIN); ?></option>
                                                                        <option value="does_not_contains_text"><?php _e('Does not Contains Text', CIP_TXTDOMAIN); ?></option>
                                                                        <option value="starts_with"><?php _e('Starts with', CIP_TXTDOMAIN); ?></option>
                                                                        <option value="ends_with"><?php _e('Ends with', CIP_TXTDOMAIN); ?></option>
                                                                        <option value="is_exactly"><?php _e('Is exactly', CIP_TXTDOMAIN); ?></option>
                                                                    </select>
                                                                    <input type="text" class="form-control mt-2" name="filter_condition_value" id="filter_condition_value" placeholder="<?php _e('Value', CIP_TXTDOMAIN); ?>" style="display: none;" />
                                                                </div>
                                                            </form>
                                                            <?php } ?>
                                                        </div>
                                                    </div>
                                                    <?php
                                                    $i++;
                                                    }
                                                }
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </div>
        <?php
        }
	}else{
	}
	$html .= ob_get_clean();
	return $html;
}
add_action('wp_footer','cip_token_holder2_script');
function cip_token_holder2_script(){
    $tokenholder_list2_url = add_query_arg( [
		'action'	=>	'tokenholder_list2_loader',
		'pageid'	=>	get_the_ID(),
	], admin_url( 'admin-ajax.php' ) );
?>
    <script>
        jQuery(document).ready(function($){
            $(document).on('click','.csr_token_holder_advance_filter',function(){
                $('#csrtokenholderadvanceFilterModal').modal({backdrop: 'static',keyboard: false});
            });
            if( $('#tokenholder_list2').length > 0 ){
                // $('#csr_advancefilter').collapse()
                if( $('#csrtokenholderadvanceFilterModal #username').length > 0 ){
                    $('#csrtokenholderadvanceFilterModal #username').select2({placeholder: 'Username',tags: true});
                }
                if( $('#csrtokenholderadvanceFilterModal #pool_ref').length > 0 ){
                    $('#csrtokenholderadvanceFilterModal #pool_ref').select2({placeholder: 'Pool Reference',tags: true});
                }
                if( $('#csrtokenholderadvanceFilterModal #corp_approved').length > 0 ){
                    $('#csrtokenholderadvanceFilterModal #corp_approved').select2({placeholder: 'Status',tags: true});
                }
                if( $('#csrtokenholderadvanceFilterModal #email').length > 0 ){
                    $('#csrtokenholderadvanceFilterModal #email').select2({placeholder: 'Email',tags: true});
                }
                $(document).on("change","#csrtokenholderadvanceFilterModal .ad_filter_body_container #filter_condition_value",function(){
                    var select_parent = $(this).closest(".ad_filter_body").attr('id');
                    if($(this).val() != 'none'){
                        $('[advance-filter="'+select_parent+'"]').addClass("value");
                    }else{
                        $('[advance-filter="'+select_parent+'"]').removeClass("value");
                    }
                });
                $(document).on("change","#csrtokenholderadvanceFilterModal #username,#csrtokenholderadvanceFilterModal #pool_ref,#csrtokenholderadvanceFilterModal #corp_approved,#csrtokenholderadvanceFilterModal #email",function(){
                    var select_parent = $(this).attr('id');
                    console.log(select_parent);
                    console.log($(this).val());
                    if($(this).val()){
                        $('[advance-filter="accodian_'+select_parent+'"]').addClass("value");
                    }else{
                        $('[advance-filter="accodian_'+select_parent+'"]').removeClass("value");
                    }
                });
                $(document).on('click','#csrtokenholderadvanceFilterModal .filter_csr_clear',function(e) {
                    $('#csrtokenholderadvanceFilterModal').find('input, select').each(function() {
                        if ($(this).is('input')) {
                            $(this).val('');
                        } else if ($(this).is('select')) {
                            if ($(this).find('option[value="none"]').length > 0) {
                                $(this).val('none');
                            } else {
                                $(this).val('');
                            }
                        }
                        
                        $(this).trigger('change');
                        $('[advance-filter]').removeClass("value");
                    });
                });
                $(document).on('click','.ad_filter_label',function(e) {
                    e.preventDefault(); // Prevent default link behavior
                    var target = $(this).attr('advance-filter'); // Get the target accordion ID
                    // Hide all accordion bodies and remove the 'show' class
                    $('.ad_filter_body').removeClass('show');
                    $('.ad_filter_label').removeClass('active');
                    // Show the selected accordion body
                    $('#' + target).addClass('show');
                    $(this).addClass('active');
                });
                var tokenholder_list2_url = "<?php echo $tokenholder_list2_url ?>";
                var wpadminbar = isNaN( parseInt( $('#wpadminbar').height() ) ) ? 0 : parseInt( $('#wpadminbar').height() ) ;
                stickyHeaderOffset = wpadminbar;
                var $tableWithdrawRequests = $('#tokenholder_list2');
                var params = {};
                var filterByCondition = {};
                var filterByConditionPoolRef = {};
                var filterByConditionDistributionWeek = {};
                var filterByConditionUsername = {};
                var thisRows = [];
                $tableWithdrawRequests.bootstrapTable({
                    method: 'post',
                    contentType: 'application/x-www-form-urlencoded',
                    url: tokenholder_list2_url,
                    searchOnEnterKey: true,
                    queryParams: function (p) {
                        params = p.filter;
                        filterByCondition = convertFormToJSON( '#filter_by_notes' );
                        filterByConditioninternalnotes = convertFormToJSON( '#filter_by_internalnotes' );
                        filterByConditionreference = convertFormToJSON( '#filter_by_reference' );
                        filterByConditioneth_address = convertFormToJSON( '#filter_by_eth_address' );
                        filterByConditioncsr_amount_initial = convertFormToJSON( '#filter_by_csr_amount_initial' );
                        filterByConditioncsr_amount_issued = convertFormToJSON( '#filter_by_csr_amount_issued' );
                        filterByConditionamount_due = convertFormToJSON( '#filter_by_amount_due' );
                        filterByConditionfirst_name = convertFormToJSON( '#filter_by_first_name' );
                        filterByConditionlast_name = convertFormToJSON( '#filter_by_last_name' );
                        filterByConditionemail = convertFormToJSON( '#filter_by_email' );
                        filterByConditiontext_9 = convertFormToJSON( '#filter_by_text_9' );
                        filterByConditionPoolRef = convertFormToJSON( '#filter_by_pool_ref' );
                        filterByConditionDistributionWeek = convertFormToJSON( '#filter_by_distribution_week' );
                        filterByConditionUsername = convertFormToJSON( '#filter_by_username' );
                        filterByConditionParsed = JSON.parse( filterByCondition );
                        if( filterByConditionParsed.filter_condition_type === 'none' && typeof params === "undefined" ){
                            $('.clear_all_csr_holder').hide();
                        }
                        return {
                            columnfilter: p.filter,
                            limit: p.limit,
                            offset: p.offset,
                            sort: p.sort,
                            order: p.order,
                            'filterByCondition': filterByCondition,
                            'filterByConditioninternalnotes': filterByConditioninternalnotes,
                            'filterByConditionreference': filterByConditionreference,
                            'filterByConditioneth_address': filterByConditioneth_address,
                            'filterByConditioncsr_amount_initial': filterByConditioncsr_amount_initial,
                            'filterByConditioncsr_amount_issued': filterByConditioncsr_amount_issued,
                            'filterByConditionamount_due': filterByConditionamount_due,
                            'filterByConditionfirst_name': filterByConditionfirst_name,
                            'filterByConditionlast_name': filterByConditionlast_name,
                            'filterByConditionemail': filterByConditionemail,
                            'filterByConditiontext_9': filterByConditiontext_9,
                            'filterByConditionPoolRef': filterByConditionPoolRef,
                            'filterByConditionDistributionWeek': filterByConditionDistributionWeek,
                            'filterByConditionUsername': filterByConditionUsername,
                        };
                    },
                    stickyHeader: false,
                    // stickyHeaderOffsetY: stickyHeaderOffset,
                    onPostBody: function (){
                        if( $('[data-toggle-tt="tooltip"]').length > 0 ){
                            $('[data-toggle-tt="tooltip"]').tooltip();
                        }
                        $('.filter-control input.search-input').prop('readonly',false);
                        $('.filter-control select.form-control').removeClass('pointerEno');
                        $('.csr_delivery').removeClass('disabled').prop('disabled', false);
                        $('.csr_delivery_to_saving').removeClass('disabled').prop('disabled', false);
                        if( $('body').find('#tokenholder_list2 thead th.notes_external .note_filter_info').length <= 0 ){
                            $('body').find('#tokenholder_list2 thead th.notes_external .th-inner').after('<div class="note_filter_info"></div>');
                        }
                        if( $('body').find('#tokenholder_list2 thead th.notes_internal .noteinternal_filter_info').length <= 0 ){
                            $('body').find('#tokenholder_list2 thead th.notes_internal .th-inner').after('<div class="noteinternal_filter_info"></div>');
                        }
                        if( $('body').find('#tokenholder_list2 thead th.reference .reference_filter_info').length <= 0 ){
                            $('body').find('#tokenholder_list2 thead th.reference .th-inner').after('<div class="reference_filter_info"></div>');
                        }
                        if( $('body').find('#tokenholder_list2 thead th.eth_address .eth_address_filter_info').length <= 0 ){
                            $('body').find('#tokenholder_list2 thead th.eth_address .th-inner').after('<div class="eth_address_filter_info"></div>');
                        }
                        if( $('body').find('#tokenholder_list2 thead th.csr_amount_initial .csr_amount_initial_filter_info').length <= 0 ){
                            $('body').find('#tokenholder_list2 thead th.csr_amount_initial .th-inner').after('<div class="csr_amount_initial_filter_info"></div>');
                        }
                        if( $('body').find('#tokenholder_list2 thead th.csr_amount_issued .csr_amount_issued_filter_info').length <= 0 ){
                            $('body').find('#tokenholder_list2 thead th.csr_amount_issued .th-inner').after('<div class="csr_amount_issued_filter_info"></div>');
                        }
                        if( $('body').find('#tokenholder_list2 thead th.amount_due .amount_due_filter_info').length <= 0 ){
                            $('body').find('#tokenholder_list2 thead th.amount_due .th-inner').after('<div class="amount_due_filter_info"></div>');
                        }
                        if( $('body').find('#tokenholder_list2 thead th.first_name .first_name_filter_info').length <= 0 ){
                            $('body').find('#tokenholder_list2 thead th.first_name .th-inner').after('<div class="first_name_filter_info"></div>');
                        }
                        if( $('body').find('#tokenholder_list2 thead th.last_name .last_name_filter_info').length <= 0 ){
                            $('body').find('#tokenholder_list2 thead th.last_name .th-inner').after('<div class="last_name_filter_info"></div>');
                        }
                        if( $('body').find('#tokenholder_list2 thead th.email .email_filter_info').length <= 0 ){
                            $('body').find('#tokenholder_list2 thead th.email .th-inner').after('<div class="email_filter_info"></div>');
                        }
                        if( $('body').find('#tokenholder_list2 thead th.text_9 .text_9_filter_info').length <= 0 ){
                            $('body').find('#tokenholder_list2 thead th.text_9 .th-inner').after('<div class="text_9_filter_info"></div>');
                        }
                        if( $('body').find('#tokenholder_list2 thead th.pool_ref .pool_ref_filter_info').length <= 0 ){
                            $('body').find('#tokenholder_list2 thead th.pool_ref .th-inner').after('<div class="pool_ref_filter_info"></div>');
                        }
                        if( $('body').find('#tokenholder_list2 thead th.text_10 .distribution_week_filter_info').length <= 0 ){
                            $('body').find('#tokenholder_list2 thead th.text_10 .th-inner').after('<div class="distribution_week_filter_info"></div>');
                        }
                        if( $('body').find('#tokenholder_list2 thead th.username .username_filter_info').length <= 0 ){
                            $('body').find('#tokenholder_list2 thead th.username .th-inner').after('<div class="username_filter_info"></div>');
                        }
                    },
                    onSearch: function( search ){
                        $('.filter-control input.search-input').prop('readonly',true);
                        $('.filter-control select.form-control').addClass('pointerEno');
                        $('.csr_delivery').addClass('disabled').prop('disabled', true);
                        $('.csr_delivery_to_saving').addClass('disabled').prop('disabled', true);
                        $('.csr_partial_delivery').addClass('disabled').prop('disabled', true);
                        filterByConditionParsed = JSON.parse( filterByCondition );
                        filterByConditioninternalnotesParsed = JSON.parse( filterByConditioninternalnotes );
                        filterByConditionreferenceParsed = JSON.parse( filterByConditionreference );
                        filterByConditioneth_addressParsed = JSON.parse( filterByConditioneth_address );
                        filterByConditioncsr_amount_initialParsed = JSON.parse( filterByConditioncsr_amount_initial );
                        filterByConditioncsr_amount_issuedParsed = JSON.parse( filterByConditioncsr_amount_issued );
                        filterByConditionamount_dueParsed = JSON.parse( filterByConditionamount_due );
                        filterByConditionfirst_nameParsed = JSON.parse( filterByConditionfirst_name );
                        filterByConditionlast_nameParsed = JSON.parse( filterByConditionlast_name );
                        filterByConditionemailParsed = JSON.parse( filterByConditionemail );
                        filterByConditiontext_9Parsed = JSON.parse( filterByConditiontext_9 );
                        filterByConditionPoolRefParsed = JSON.parse( filterByConditionPoolRef );
                        filterByConditionDistributionWeekParsed = JSON.parse( filterByConditionDistributionWeek );
                        filterByConditionUsernameParsed = JSON.parse( filterByConditionUsername );
                        if( filterByConditionParsed.filter_condition_type === 'none' &&
                            filterByConditioninternalnotesParsed.filter_condition_type === 'none' &&
                            filterByConditionreferenceParsed.filter_condition_type === 'none' &&
                            filterByConditioneth_addressParsed.filter_condition_type === 'none' &&
                            filterByConditioncsr_amount_initialParsed.filter_condition_type === 'none' &&
                            filterByConditioncsr_amount_issuedParsed.filter_condition_type === 'none' &&
                            filterByConditionamount_dueParsed.filter_condition_type === 'none' &&
                            filterByConditionfirst_nameParsed.filter_condition_type === 'none' &&
                            filterByConditionlast_nameParsed.filter_condition_type === 'none' &&
                            filterByConditionemailParsed.filter_condition_type === 'none' &&
                            filterByConditiontext_9Parsed.filter_condition_type === 'none' &&
                            filterByConditionPoolRefParsed.filter_condition_type_pool_ref === 'none' &&
                            filterByConditionDistributionWeekParsed.filter_condition_type_distribution_week === 'none' &&
                            filterByConditionUsernameParsed.filter_condition_type_username === 'none' &&
                            typeof params === 'undefined'
                        ){
                            $('.clear_all_csr_holder').hide();
                        }else{
                            $('.clear_all_csr_holder').show();
                        }
                    },
                    onLoadSuccess: function( search ){
                    }
                });
                //store toggle column
                let lsname = '-hideColumn-tokenholder_list2'
                let hideColumn = JSON.parse(localStorage.getItem(lsname)) || [];
                let th = $tableWithdrawRequests.find('thead tr th');
                th.each(function (index) {
                    let attrTitle = $(this).attr('data-field')
                    if (hideColumn.includes(attrTitle)) {
                        $tableWithdrawRequests.bootstrapTable('hideColumn', attrTitle);
                    }
                })
                $tableWithdrawRequests.on("column-switch.bs.table", function (e, field, checked) {
                    if (checked && hideColumn.includes(field)) {
                        // remove form local storage
                        const index = hideColumn.indexOf(field);
                        if (index > -1) {
                            hideColumn.splice(index, 1);
                            localStorage.setItem(lsname, JSON.stringify(hideColumn))
                        }
                    } else if (!checked) {
                        if (hideColumn.includes(field)) {} else {
                            hideColumn.push(field);
                            localStorage.setItem(lsname, JSON.stringify(hideColumn))
                        }
                    }
                });
                $("body").on("change", ".toggle-all", function () {
                    let $this = $(this);
                    let div = $this.parent().parent()[0];
                    $(div).find("input[type=checkbox]").each(function (index) {
                        let checked = $(this).is(":checked");
                        let field = $(this).attr("data-field");
                        if (checked && hideColumn.includes(field)) {
                            // remove form local storage
                            const index = hideColumn.indexOf(field);
                            if (index > -1) {
                                hideColumn.splice(index, 1);
                                localStorage.setItem(
                                    lsname,
                                    JSON.stringify(hideColumn)
                                );
                            }
                        } else if (!checked) {
                            if (hideColumn.includes(field)) {
                                // hands up nothing needed
                            } else {
                                // add in LS for nexttime
                                hideColumn.push(field);
                                localStorage.setItem(
                                    lsname,
                                    JSON.stringify(hideColumn)
                                );
                            }
                        }
                    });
                });
                //store toggle column
                $('select[name="filter_condition_type"]').on('change', function(){
                    var condition_type = $(this).val();
                    var $filter_condition_value = $(this).parents('form').find('input[name="filter_condition_value"]');
                    if( condition_type == 'none' || condition_type == 'is_empty' || condition_type == 'is_not_empty' ){
                        $filter_condition_value.hide();
                        $filter_condition_value.val('');
                    }else{
                        $filter_condition_value.show();
                    }
                });
                $('select[name="filter_condition_type_pool_ref"]').on('change', function(){
                    var condition_type = $(this).val();
                    var $filter_condition_value = $('select#filter_condition_value_pool_ref');
                    if( condition_type == 'none' ){
                        $('body').find('.select2_pool_ref').addClass('hide');
                        $filter_condition_value.val(null).trigger('change');
                        $('#filter_condition_value_pool_ref_bulk').val('').hide();
                    }else if( condition_type == 'is_exactly_simple' ){
                        $('body').find('.select2_pool_ref').addClass('hide');
                        $('#filter_condition_value_pool_ref_bulk').show();
                    }else if( condition_type == 'is_exactly' ){
                        $('body').find('.select2_pool_ref').removeClass('hide');
                        $('#filter_condition_value_pool_ref_bulk').hide();
                    }
                });
                $('select[name="filter_condition_type_distribution_week"]').on('change', function(){
                    var condition_type = $(this).val();
                    var $filter_condition_value = $('select#filter_condition_value_distribution_week');
                    if( condition_type == 'none' ){
                        $('body').find('.select2_distribution_week').addClass('hide');
                        $filter_condition_value.val(null).trigger('change');
                        $('#filter_condition_value_distribution_week_before').val('');
                        $('#filter_condition_value_distribution_bulk').val('');
                    }else if( condition_type == 'weeks_before' ){
                        $('#filter_condition_value_distribution_week_before').show();
                        $('#filter_condition_value_distribution_bulk').hide();
                        $('body').find('.select2_distribution_week').addClass('hide');
                    }else if( condition_type == 'is_exactly_simple' ){
                        $('#filter_condition_value_distribution_week_before').hide();
                        $('#filter_condition_value_distribution_bulk').show();
                        $('body').find('.select2_distribution_week').addClass('hide');
                    }else if( condition_type == 'is_exactly' ){
                        $('body').find('.select2_distribution_week').removeClass('hide');
                        $('#filter_condition_value_distribution_week_before').hide();
                        $('#filter_condition_value_distribution_bulk').hide();
                    }
                });
                $('select[name="filter_condition_type_username"]').on('change', function(){
                    var condition_type = $(this).val();
                    var $filter_condition_value = $('select#filter_condition_value_username');
                    if( condition_type == 'none' ){
                        $('body').find('.select2_username').addClass('hide');
                        $filter_condition_value.val(null).trigger('change');
                        $('#filter_condition_value_username_bulk').val('').hide();
                    }else if( condition_type == 'is_exactly_simple' ){
                        $('#filter_condition_value_username_bulk').show();
                        $('body').find('.select2_username').addClass('hide');
                    }else if( condition_type == 'is_exactly' ){
                        $('body').find('.select2_username').removeClass('hide');
                        $('#filter_condition_value_username_bulk').hide();
                    }
                });
                $('body').on('click', 'button.csr_token_holder_download', function(){
                    var block_config = { css: { backgroundColor: 'transparent', border: 'none' }, message: '<div class="blockUIspinner"></div>', baseZ: 1500, overlayCSS: { backgroundColor: '#FFFFFF', opacity: 0.8, cursor: 'wait' } };
                    var data = {
                        'action' : 'downloadingCsrtokenholder',
                        'thisParams' : params,
                        'filterByCondition': filterByCondition,
                        'filterByConditionPoolRef': filterByConditionPoolRef,
                        'filterByConditionDistributionWeek': filterByConditionDistributionWeek,
                        'filterByConditionUsername': filterByConditionUsername,
                        'filterByConditioninternalnotes':filterByConditioninternalnotes,
                        'filterByConditionreference': filterByConditionreference,
                        'filterByConditioneth_address': filterByConditioneth_address,
                        'filterByConditioncsr_amount_initial': filterByConditioncsr_amount_initial,
                        'filterByConditioncsr_amount_issued': filterByConditioncsr_amount_issued,
                        'filterByConditionamount_due': filterByConditionamount_due,
                        'filterByConditionfirst_name': filterByConditionfirst_name,
                        'filterByConditionlast_name': filterByConditionlast_name,
                        'filterByConditionemail': filterByConditionemail,
                        'filterByConditiontext_9':filterByConditiontext_9,
                        '_micro' : "<?php echo wp_create_nonce('_XyCheckCSRTokenHolderdownloadX_'); ?>" };
                    $.blockUI(block_config);
                    $.post(cipscript.ajax_url, data, function(response) {
                        var today = new Date();
                        var date = today.getDate() + "-" + (today.getMonth()+1) + "-" + today.getFullYear();
                        var time = today.getHours() + "-" + today.getMinutes() + "-" + today.getSeconds();
                        var downloadLink = document.createElement("a");
                        var fileData = ['\ufeff'+response];
                        var blobObject = new Blob([response],{
                            type: "application/csv;charset=UTF-8;"
                        });
                        var url = URL.createObjectURL(blobObject);
                        downloadLink.href = url;
                        downloadLink.download = "CSRHolder-" + date + " " + time + ".csv";
                        document.body.appendChild(downloadLink);
                        downloadLink.click();
                        document.body.removeChild(downloadLink);
                        $.unblockUI();
                    });
                    return false;
                });
                $('#tokenholder_list2').on('search.bs.table',function(event, searchText){
                    "use strict";
                    var data = {};
                    $('.filter-control .form-control').each(function(){
                        var mainClass = $(this).attr('class').split(' ')
                        mainClass.pop();
                        mainClass = mainClass.join(' ');
                        if($(this).val())
                        {
                            data[''+mainClass+''] = $(this).val();
                        }else
                        {
                            data[''+mainClass+''] = '';
                        }
                    })
                    var filterNoteForm = $('#filter_by_notes');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').attr('value');
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    if(condition_type_text != '' ||  condition_type_value != '')
                    {
                        var filterNoteForm = {};
                        filterNoteForm['condition_type_text'] = condition_type_text;
                        filterNoteForm['condition_type_value'] = condition_type_value;
                        data['filter_by_notes'] = filterNoteForm;
                    }
                    var filterNoteForm = $('#filter_by_internalnotes');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').attr('value');
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    if(condition_type_text != '' ||  condition_type_value != '')
                    {
                        var filterNoteForm = {};
                        filterNoteForm['condition_type_text'] = condition_type_text;
                        filterNoteForm['condition_type_value'] = condition_type_value;
                        data['filter_by_internalnotes'] = filterNoteForm;
                    }
                    var filterrefrenceForm = $('#filter_by_reference');
                    var condition_type_text = filterrefrenceForm.find('select[name="filter_condition_type"] option:selected').attr('value');
                    var condition_type_value = filterrefrenceForm.find('input[name="filter_condition_value"]').val();
                    if(condition_type_text != '' ||  condition_type_value != '')
                    {
                        var filterrefrenceForm = {};
                        filterrefrenceForm['condition_refrence_type_text'] = condition_type_text;
                        filterrefrenceForm['condition_refrence_type_value'] = condition_type_value;
                        data['filter_by_reference'] = filterrefrenceForm;
                    }
                    var filterNoteForm = $('#filter_by_eth_address');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').attr('value');
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    if(condition_type_text != '' ||  condition_type_value != '')
                    {
                        var filterNoteForm = {};
                        filterNoteForm['condition_type_text'] = condition_type_text;
                        filterNoteForm['condition_type_value'] = condition_type_value;
                        data['filter_by_eth_address'] = filterNoteForm;
                    }
                    var filterNoteForm = $('#filter_by_csr_amount_initial');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').attr('value');
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    if(condition_type_text != '' ||  condition_type_value != '')
                    {
                        var filterNoteForm = {};
                        filterNoteForm['condition_type_text'] = condition_type_text;
                        filterNoteForm['condition_type_value'] = condition_type_value;
                        data['filter_by_csr_amount_initial'] = filterNoteForm;
                    }
                    var filterNoteForm = $('#filter_by_csr_amount_issued');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').attr('value');
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    if(condition_type_text != '' ||  condition_type_value != '')
                    {
                        var filterNoteForm = {};
                        filterNoteForm['condition_type_text'] = condition_type_text;
                        filterNoteForm['condition_type_value'] = condition_type_value;
                        data['filter_by_csr_amount_issued'] = filterNoteForm;
                    }
                    var filterNoteForm = $('#filter_by_amount_due');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').attr('value');
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    if(condition_type_text != '' ||  condition_type_value != '')
                    {
                        var filterNoteForm = {};
                        filterNoteForm['condition_type_text'] = condition_type_text;
                        filterNoteForm['condition_type_value'] = condition_type_value;
                        data['filter_by_amount_due'] = filterNoteForm;
                    }
                    var filterNoteForm = $('#filter_by_first_name');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').attr('value');
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    if(condition_type_text != '' ||  condition_type_value != '')
                    {
                        var filterNoteForm = {};
                        filterNoteForm['condition_type_text'] = condition_type_text;
                        filterNoteForm['condition_type_value'] = condition_type_value;
                        data['filter_by_first_name'] = filterNoteForm;
                    }
                    var filterNoteForm = $('#filter_by_last_name');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').attr('value');
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    if(condition_type_text != '' ||  condition_type_value != '')
                    {
                        var filterNoteForm = {};
                        filterNoteForm['condition_type_text'] = condition_type_text;
                        filterNoteForm['condition_type_value'] = condition_type_value;
                        data['filter_by_last_name'] = filterNoteForm;
                    }
                    var filterNoteForm = $('#filter_by_email');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').attr('value');
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    if(condition_type_text != '' ||  condition_type_value != '')
                    {
                        var filterNoteForm = {};
                        filterNoteForm['condition_type_text'] = condition_type_text;
                        filterNoteForm['condition_type_value'] = condition_type_value;
                        data['filter_by_email'] = filterNoteForm;
                    }
                    var filterNoteForm = $('#filter_by_text_9');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').attr('value');
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    if(condition_type_text != '' ||  condition_type_value != '')
                    {
                        var filterNoteForm = {};
                        filterNoteForm['condition_type_text'] = condition_type_text;
                        filterNoteForm['condition_type_value'] = condition_type_value;
                        data['filter_by_text_9'] = filterNoteForm;
                    }
                    var filterUsereForm = $('#filter_by_username');
                    var filter_condition_type_username = filterUsereForm.find('select[name="filter_condition_type_username"] option:selected').attr('value');
                    var filter_condition_value_username = filterUsereForm.find('#filter_condition_value_username').val();
                    var filter_condition_value_username_bulk = filterUsereForm.find('[name="filter_condition_value_username_bulk"]').val();
                    if(filter_condition_type_username != '' ||  filter_condition_value_username != '')
                    {
                        var filterUsereForm = {};
                        filterUsereForm['filter_condition_type_username'] = filter_condition_type_username;
                        filterUsereForm['filter_condition_value_username'] = filter_condition_value_username;
                        filterUsereForm['filter_condition_value_username_bulk'] = filter_condition_value_username_bulk;
                        data['filter_by_username'] = filterUsereForm;
                    }
                    var filterPoolrefForm = $('#filter_by_pool_ref');
                    var filter_condition_type_pool_ref = filterPoolrefForm.find('select[name="filter_condition_type_pool_ref"] option:selected').attr('value');
                    var filter_condition_value_pool_ref = filterPoolrefForm.find('#filter_condition_value_pool_ref').val();
                    var filter_condition_value_pool_ref_bulk = filterPoolrefForm.find('[name="filter_condition_value_pool_ref_bulk"]').val();
                    if(filter_condition_type_pool_ref != '' ||  filter_condition_value_pool_ref != '')
                    {
                        var filterPoolrefForm = {};
                        filterPoolrefForm['filter_condition_type_pool_ref'] = filter_condition_type_pool_ref;
                        filterPoolrefForm['filter_condition_value_pool_ref'] = filter_condition_value_pool_ref;
                        filterPoolrefForm['filter_condition_value_pool_ref_bulk'] = filter_condition_value_pool_ref_bulk;
                        data['filter_by_pool_ref'] = filterPoolrefForm;
                    }
                    var filterdistribution_week = $('#filter_by_distribution_week');
                    var filter_condition_type_distribution_week = filterdistribution_week.find('select[name="filter_condition_type_distribution_week"] option:selected').attr('value');
                    var filter_condition_value_distribution_week_before = filterdistribution_week.find('#filter_condition_value_distribution_week_before').val();
                    var filter_condition_value_distribution_bulk = filterdistribution_week.find('#filter_condition_value_distribution_bulk').val();
                    var filter_condition_value_distribution_week = filterdistribution_week.find('#filter_condition_value_distribution_week').val();
                    if(filter_condition_type_distribution_week != '' ||  filter_condition_value_distribution_week_before != '' ||  filter_condition_value_distribution_bulk != '' ||  filter_condition_value_distribution_week != '')
                    {
                        var filterdistribution_week = {};
                        filterdistribution_week['filter_condition_type_distribution_week'] = filter_condition_type_distribution_week;
                        filterdistribution_week['filter_condition_value_distribution_week_before'] = filter_condition_value_distribution_week_before;
                        filterdistribution_week['filter_condition_value_distribution_bulk'] = filter_condition_value_distribution_bulk;
                        filterdistribution_week['filter_condition_value_distribution_week'] = filter_condition_value_distribution_week;
                        data['filter_by_distribution_week'] = filterdistribution_week;
                    }
                    sessionStorage.setItem( "tokenholder_list2_filter", JSON.stringify(data) );
                });
                var filterCookie = sessionStorage.getItem("tokenholder_list2_filter");
                if( filterCookie != "" && filterCookie != null ){
                    $(window).on('load', function() {
                    var filterCookieArray = jQuery.parseJSON(filterCookie);
                    $.each(filterCookieArray,function(index,value){
                        var classNames = index.replaceAll(' ','.')
                        if(value)
                        {
                            if(classNames == 'form-control.bootstrap-table-filter-control-corp_approved')
                            {
                                $('.'+classNames).val(value);
                                $('.'+classNames).trigger('change')
                            }
                            if(classNames == 'form-control.bootstrap-table-filter-control-token')
                            {
                                $('.'+classNames).val(value);
                                $('.'+classNames).trigger('change')
                            }
                            if( classNames == 'form-control.bootstrap-table-filter-control-text_2' || classNames == 'form-control.bootstrap-table-filter-control-text_10' || classNames == 'form-control.bootstrap-table-filter-control-reference' || classNames == 'form-control.bootstrap-table-filter-control-eth_address' || classNames == 'form-control.bootstrap-table-filter-control-csr_amount_initial' || classNames == 'form-control.bootstrap-table-filter-control-amount_due' || classNames == 'form-control.bootstrap-table-filter-control-csr_amount_issued' || classNames == 'form-control.bootstrap-table-filter-control-first_name' || classNames == 'form-control.bootstrap-table-filter-control-last_name' || classNames == 'form-control.bootstrap-table-filter-control-email' || classNames == 'form-control.bootstrap-table-filter-control-notes_internal' || classNames == 'form-control.bootstrap-table-filter-control-notes_internal' || classNames == 'form-control.bootstrap-table-filter-control-text_1' || classNames == 'form-control.bootstrap-table-filter-control-saved_amount' || classNames == 'form-control.bootstrap-table-filter-control-saved_amount' || classNames == 'form-control.bootstrap-table-filter-control-saving_interest' || classNames == 'form-control.bootstrap-table-filter-control-saving_periods' || classNames == 'form-control.bootstrap-table-filter-control-redemption_date' || classNames == 'form-control.bootstrap-table-filter-control-claim_date' || classNames == 'form-control.bootstrap-table-filter-control-date_1' || classNames == 'form-control.bootstrap-table-filter-control-saving_date' || classNames == 'form-control.bootstrap-table-filter-control-saving_start_date')
                            {
                                $('.'+classNames).val(value);
                                let eve = jQuery.Event("keyup");
                                eve.which = 13
                                eve.keyCode = 13
                                $('.'+classNames).trigger(eve)
                            }
                            if(classNames == 'filter_by_notes')
                            {
                                if(value.condition_type_text != '')
                                {
                                    $("#filter_by_notes select[name=filter_condition_type]").val(value.condition_type_text)
                                    $("#filter_by_notes select[name=filter_condition_type]").trigger('change')
                                }
                                if(value.condition_type_value != '')
                                {
                                    $("#filter_by_notes input[name=filter_condition_value]").val(value.condition_type_value)
                                }
                                $('.filter_by_notes .filter_csr_ok').trigger('click')
                            }
                            if(classNames == 'filter_by_internalnotes')
                            {
                                if(value.condition_type_text != '')
                                {
                                    $("#filter_by_internalnotes select[name=filter_condition_type]").val(value.condition_type_text)
                                    $("#filter_by_internalnotes select[name=filter_condition_type]").trigger('change')
                                }
                                if(value.condition_type_value != '')
                                {
                                    $("#filter_by_internalnotes input[name=filter_condition_value]").val(value.condition_type_value)
                                }
                                $('.filter_by_internalnotes .filter_csr_ok').trigger('click')
                            }
                            if(classNames == 'filter_by_reference')
                            {
                                if(value.condition_refrence_type_text != '')
                                {
                                    $("#filter_by_reference select[name=filter_condition_type]").val(value.condition_refrence_type_text)
                                    $("#filter_by_reference select[name=filter_condition_type]").trigger('change')
                                }
                                if(value.condition_refrence_type_value != '')
                                {
                                    $("#filter_by_reference input[name=filter_condition_value]").val(value.condition_refrence_type_value)
                                }
                                $('.filter_by_reference .filter_csr_ok').trigger('click')
                            }
                            if(classNames == 'filter_by_eth_address')
                            {
                                if(value.condition_type_text != '')
                                {
                                    $("#filter_by_eth_address select[name=filter_condition_type]").val(value.condition_type_text)
                                    $("#filter_by_eth_address select[name=filter_condition_type]").trigger('change')
                                }
                                if(value.condition_type_value != '')
                                {
                                    $("#filter_by_eth_address input[name=filter_condition_value]").val(value.condition_type_value)
                                }
                                $('.filter_by_eth_address .filter_csr_ok').trigger('click')
                            }
                            if(classNames == 'filter_by_csr_amount_initial')
                            {
                                if(value.condition_type_text != '')
                                {
                                    $("#filter_by_csr_amount_initial select[name=filter_condition_type]").val(value.condition_type_text)
                                    $("#filter_by_csr_amount_initial select[name=filter_condition_type]").trigger('change')
                                }
                                if(value.condition_type_value != '')
                                {
                                    $("#filter_by_csr_amount_initial input[name=filter_condition_value]").val(value.condition_type_value)
                                }
                                $('.filter_by_csr_amount_initial .filter_csr_ok').trigger('click')
                            }
                            if(classNames == 'filter_by_csr_amount_issued')
                            {
                                if(value.condition_type_text != '')
                                {
                                    $("#filter_by_csr_amount_issued select[name=filter_condition_type]").val(value.condition_type_text)
                                    $("#filter_by_csr_amount_issued select[name=filter_condition_type]").trigger('change')
                                }
                                if(value.condition_type_value != '')
                                {
                                    $("#filter_by_csr_amount_issued input[name=filter_condition_value]").val(value.condition_type_value)
                                }
                                $('.filter_by_csr_amount_issued .filter_csr_ok').trigger('click')
                            }
                            if(classNames == 'filter_by_amount_due')
                            {
                                if(value.condition_type_text != '')
                                {
                                    $("#filter_by_amount_due select[name=filter_condition_type]").val(value.condition_type_text)
                                    $("#filter_by_amount_due select[name=filter_condition_type]").trigger('change')
                                }
                                if(value.condition_type_value != '')
                                {
                                    $("#filter_by_amount_due input[name=filter_condition_value]").val(value.condition_type_value)
                                }
                                $('.filter_by_amount_due .filter_csr_ok').trigger('click')
                            }
                            if(classNames == 'filter_by_first_name')
                            {
                                if(value.condition_type_text != '')
                                {
                                    $("#filter_by_first_name select[name=filter_condition_type]").val(value.condition_type_text)
                                    $("#filter_by_first_name select[name=filter_condition_type]").trigger('change')
                                }
                                if(value.condition_type_value != '')
                                {
                                    $("#filter_by_first_name input[name=filter_condition_value]").val(value.condition_type_value)
                                }
                                $('.filter_by_first_name .filter_csr_ok').trigger('click')
                            }
                            if(classNames == 'filter_by_last_name')
                            {
                                if(value.condition_type_text != '')
                                {
                                    $("#filter_by_last_name select[name=filter_condition_type]").val(value.condition_type_text)
                                    $("#filter_by_last_name select[name=filter_condition_type]").trigger('change')
                                }
                                if(value.condition_type_value != '')
                                {
                                    $("#filter_by_last_name input[name=filter_condition_value]").val(value.condition_type_value)
                                }
                                $('.filter_by_last_name .filter_csr_ok').trigger('click')
                            }
                            if(classNames == 'filter_by_email')
                            {
                                if(value.condition_type_text != '')
                                {
                                    $("#filter_by_email select[name=filter_condition_type]").val(value.condition_type_text)
                                    $("#filter_by_email select[name=filter_condition_type]").trigger('change')
                                }
                                if(value.condition_type_value != '')
                                {
                                    $("#filter_by_email input[name=filter_condition_value]").val(value.condition_type_value)
                                }
                                $('.filter_by_email .filter_csr_ok').trigger('click')
                            }
                            if(classNames == 'filter_by_text_9')
                            {
                                if(value.condition_type_text != '')
                                {
                                    $("#filter_by_text_9 select[name=filter_condition_type]").val(value.condition_type_text)
                                    $("#filter_by_text_9 select[name=filter_condition_type]").trigger('change')
                                }
                                if(value.condition_type_value != '')
                                {
                                    $("#filter_by_text_9 input[name=filter_condition_value]").val(value.condition_type_value)
                                }
                                $('.filter_by_text_9 .filter_csr_ok').trigger('click')
                            }
                            if(classNames == 'filter_by_username')
                            {
                                if(value.filter_condition_type_username != '')
                                {
                                    $("#filter_by_username select[name=filter_condition_type_username]").val(value.filter_condition_type_username)
                                    $("#filter_by_username select[name=filter_condition_type_username]").trigger('change');
                                }
                                if(value.filter_condition_type_username == 'is_exactly'){
                                    if(value.filter_condition_value_username != ''){
                                        var optionvalues = value.filter_condition_value_username;
                                        optionvalues.forEach(function(value) {
                                            var newOption = new Option(value, value, true, true);
                                            $('#filter_by_username #filter_condition_value_username').append(newOption);
                                            $('#filter_by_username #filter_condition_value_username').trigger('change');
                                        });
                                    }
                                }else{
                                    if(value.filter_condition_value_username_bulk != ''){
                                        $("#filter_by_username [name=filter_condition_value_username_bulk]").val(value.filter_condition_value_username_bulk)
                                    }
                                }
                                $('#filter_by_username .filter_csr_ok').trigger('click')
                            }
                            if(classNames == 'filter_by_pool_ref')
                            {
                                if(value.filter_condition_type_pool_ref != '')
                                {
                                    $("#filter_by_pool_ref select[name=filter_condition_type_pool_ref]").val(value.filter_condition_type_pool_ref)
                                    $("#filter_by_pool_ref select[name=filter_condition_type_pool_ref]").trigger('change');
                                }
                                if(value.filter_condition_type_pool_ref == 'is_exactly'){
                                    if(value.filter_condition_value_pool_ref != ''){
                                        var optionvalues = value.filter_condition_value_pool_ref;
                                        optionvalues.forEach(function(value) {
                                            var newOption = new Option(value, value, true, true);
                                            $('#filter_by_pool_ref #filter_condition_value_pool_ref').append(newOption);
                                        });
                                        $('#filter_by_pool_ref #filter_condition_value_pool_ref').trigger('change');
                                    }
                                }else{
                                    if(value.filter_condition_value_pool_ref_bulk != ''){
                                        $("#filter_by_pool_ref [name=filter_condition_value_pool_ref_bulk]").val(value.filter_condition_value_pool_ref_bulk)
                                    }
                                }
                                $('#filter_by_pool_ref .filter_csr_ok').trigger('click')
                            }
                            if(classNames == 'filter_by_distribution_week')
                            {
                                if(value.filter_condition_type_distribution_week != '')
                                {
                                    $("#filter_by_distribution_week select[name=filter_condition_type_distribution_week]").val(value.filter_condition_type_distribution_week)
                                    $("#filter_by_distribution_week select[name=filter_condition_type_distribution_week]").trigger('change');
                                }
                                if(value.filter_condition_type_distribution_week == 'weeks_before'){
                                    if(value.filter_condition_value_distribution_week_before != ''){
                                        $("#filter_by_distribution_week [name=filter_condition_value_distribution_week_before]").val(value.filter_condition_value_distribution_week_before)
                                    }
                                }
                                if(value.filter_condition_type_distribution_week == 'is_exactly_simple'){
                                    if(value.filter_condition_value_distribution_bulk != ''){
                                        $("#filter_by_distribution_week [name=filter_condition_value_distribution_bulk]").val(value.filter_condition_value_distribution_bulk)
                                    }
                                }
                                if(value.filter_condition_type_distribution_week == 'is_exactly'){
                                    if(value.filter_condition_value_distribution_week != ''){
                                        var optionvalues = value.filter_condition_value_distribution_week;
                                        optionvalues.forEach(function(value) {
                                            var newOption = new Option(value, value, true, true);
                                            $('#filter_by_distribution_week #filter_condition_value_distribution_week').append(newOption);
                                        });
                                        $('#filter_by_distribution_week #filter_condition_value_distribution_week').trigger('change');
                                    }
                                }
                                $('#filter_by_distribution_week .filter_csr_ok').trigger('click')
                            }
                        }
                    })
                    });
                }
            }
            /* js script */
            if( $('#tokenholder_list2').length > 0 ){
                var $notes_external = $('input.bootstrap-table-filter-control-notes_external[type="search"]');
                $notes_external.on('click', function(){
                    $('#notesFilterModal').modal({backdrop: 'static',keyboard: false});
                });
                var $notes_internal = $('input.bootstrap-table-filter-control-notes_internal[type="search"]');
                $notes_internal.on('click', function(){
                    $('#notesinternalFilterModal').modal({backdrop: 'static',keyboard: false});
                });
                var $reference = $('input.bootstrap-table-filter-control-reference[type="search"]');
                $reference.on('click', function(){
                    $('#referenceFilterModal').modal({backdrop: 'static',keyboard: false});
                });
                var $eth_address = $('input.bootstrap-table-filter-control-eth_address[type="search"]');
                $eth_address.on('click', function(){
                    $('#eth_addressFilterModal').modal({backdrop: 'static',keyboard: false});
                });
                var $csr_amount_initial = $('input.bootstrap-table-filter-control-csr_amount_initial[type="search"]');
                $csr_amount_initial.on('click', function(){
                    $('#csr_amount_initialFilterModal').modal({backdrop: 'static',keyboard: false});
                });
                var $csr_amount_issued = $('input.bootstrap-table-filter-control-csr_amount_issued[type="search"]');
                $csr_amount_issued.on('click', function(){
                    $('#csr_amount_issuedFilterModal').modal({backdrop: 'static',keyboard: false});
                });
                var $amount_due = $('input.bootstrap-table-filter-control-amount_due[type="search"]');
                $amount_due.on('click', function(){
                    $('#amount_dueFilterModal').modal({backdrop: 'static',keyboard: false});
                });
                var $first_name = $('input.bootstrap-table-filter-control-first_name[type="search"]');
                $first_name.on('click', function(){
                    $('#first_nameFilterModal').modal({backdrop: 'static',keyboard: false});
                });
                var $last_name = $('input.bootstrap-table-filter-control-last_name[type="search"]');
                $last_name.on('click', function(){
                    $('#last_nameFilterModal').modal({backdrop: 'static',keyboard: false});
                });
                var $email = $('input.bootstrap-table-filter-control-email[type="search"]');
                $email.on('click', function(){
                    $('#emailFilterModal').modal({backdrop: 'static',keyboard: false});
                });
                var $text_9 = $('input.bootstrap-table-filter-control-text_9[type="search"]');
                $text_9.on('click', function(){
                    $('#text_9FilterModal').modal({backdrop: 'static',keyboard: false});
                });
                var $pool_ref = $('input.bootstrap-table-filter-control-pool_ref[type="search"]');
                $pool_ref.on('click', function(){
                    $('#poolRefFilterModal').modal({backdrop: 'static',keyboard: false});
                });
                var $distribution_week = $('input.bootstrap-table-filter-control-text_10[type="search"]');
                $distribution_week.on('click', function(){
                    $('#DistributionWeekFilterModal').modal({backdrop: 'static',keyboard: false});
                });
                var $username = $('input.bootstrap-table-filter-control-username[type="search"]');
                $username.on('click', function(){
                    $('#UsernameFilterModal').modal({backdrop: 'static',keyboard: false});
                });
                $('.filter_by_notes .filter_csr_ok').on('click', function(){ //notes
                    let eve = jQuery.Event("keyup");
                    eve.which = 13
                    eve.keyCode = 13
                    $notes_external.trigger(eve);
                    $('#notesFilterModal').modal('hide');
                    var filterNoteForm = $('#filter_by_notes');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').text();
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    var filterText = condition_type_text;
                    if( condition_type_value != "" ){
                        filterText += ': '+condition_type_value;
                    }
                    if( condition_type_text == 'None' ){
                        filterText = "";
                    }
                    $('body').find('.note_filter_info').text( filterText );
                });
                $('.filter_by_internalnotes .filter_csr_ok').on('click', function(){ //notes
                    let eve = jQuery.Event("keyup");
                    eve.which = 13
                    eve.keyCode = 13
                    $notes_internal.trigger(eve);
                    $('#notesinternalFilterModal').modal('hide');
                    var filterNoteForm = $('#filter_by_internalnotes');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').text();
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    var filterText = condition_type_text;
                    if( condition_type_value != "" ){
                        filterText += ': '+condition_type_value;
                    }
                    if( condition_type_text == 'None' ){
                        filterText = "";
                    }
                    $('body').find('.noteinternal_filter_info').text( filterText );
                });
                $('.filter_by_reference .filter_csr_ok').on('click', function(){ //notes
                    let eve = jQuery.Event("keyup");
                    eve.which = 13
                    eve.keyCode = 13
                    $notes_internal.trigger(eve);
                    $('#referenceFilterModal').modal('hide');
                    var filterNoteForm = $('#filter_by_reference');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').text();
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    var filterText = condition_type_text;
                    if( condition_type_value != "" ){
                        filterText += ': '+condition_type_value;
                    }
                    if( condition_type_text == 'None' ){
                        filterText = "";
                    }
                    $('body').find('.reference_filter_info').text( filterText );
                });
                $('.filter_by_eth_address .filter_csr_ok').on('click', function(){ //notes
                    let eve = jQuery.Event("keyup");
                    eve.which = 13
                    eve.keyCode = 13
                    $notes_internal.trigger(eve);
                    $('#eth_addressFilterModal').modal('hide');
                    var filterNoteForm = $('#filter_by_eth_address');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').text();
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    var filterText = condition_type_text;
                    if( condition_type_value != "" ){
                        filterText += ': '+condition_type_value;
                    }
                    if( condition_type_text == 'None' ){
                        filterText = "";
                    }
                    $('body').find('.eth_address_filter_info').text( filterText );
                });
                $('.filter_by_csr_amount_initial .filter_csr_ok').on('click', function(){ //notes
                    let eve = jQuery.Event("keyup");
                    eve.which = 13
                    eve.keyCode = 13
                    $notes_internal.trigger(eve);
                    $('#csr_amount_initialFilterModal').modal('hide');
                    var filterNoteForm = $('#filter_by_csr_amount_initial');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').text();
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    var filterText = condition_type_text;
                    if( condition_type_value != "" ){
                        filterText += ': '+condition_type_value;
                    }
                    if( condition_type_text == 'None' ){
                        filterText = "";
                    }
                    $('body').find('.csr_amount_initial_filter_info').text( filterText );
                });
                $('.filter_by_csr_amount_issued .filter_csr_ok').on('click', function(){ //notes
                    let eve = jQuery.Event("keyup");
                    eve.which = 13
                    eve.keyCode = 13
                    $notes_internal.trigger(eve);
                    $('#csr_amount_issuedFilterModal').modal('hide');
                    var filterNoteForm = $('#filter_by_csr_amount_issued');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').text();
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    var filterText = condition_type_text;
                    if( condition_type_value != "" ){
                        filterText += ': '+condition_type_value;
                    }
                    if( condition_type_text == 'None' ){
                        filterText = "";
                    }
                    $('body').find('.csr_amount_issued_filter_info').text( filterText );
                });
                $('.filter_by_amount_due .filter_csr_ok').on('click', function(){ //notes
                    let eve = jQuery.Event("keyup");
                    eve.which = 13
                    eve.keyCode = 13
                    $notes_internal.trigger(eve);
                    $('#amount_dueFilterModal').modal('hide');
                    var filterNoteForm = $('#filter_by_amount_due');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').text();
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    var filterText = condition_type_text;
                    if( condition_type_value != "" ){
                        filterText += ': '+condition_type_value;
                    }
                    if( condition_type_text == 'None' ){
                        filterText = "";
                    }
                    $('body').find('.amount_due_filter_info').text( filterText );
                });
                $('.filter_by_first_name .filter_csr_ok').on('click', function(){ //notes
                    let eve = jQuery.Event("keyup");
                    eve.which = 13
                    eve.keyCode = 13
                    $notes_internal.trigger(eve);
                    $('#first_nameFilterModal').modal('hide');
                    var filterNoteForm = $('#filter_by_first_name');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').text();
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    var filterText = condition_type_text;
                    if( condition_type_value != "" ){
                        filterText += ': '+condition_type_value;
                    }
                    if( condition_type_text == 'None' ){
                        filterText = "";
                    }
                    $('body').find('.first_name_filter_info').text( filterText );
                });
                $('.filter_by_last_name .filter_csr_ok').on('click', function(){ //notes
                    let eve = jQuery.Event("keyup");
                    eve.which = 13
                    eve.keyCode = 13
                    $notes_internal.trigger(eve);
                    $('#last_nameFilterModal').modal('hide');
                    var filterNoteForm = $('#filter_by_last_name');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').text();
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    var filterText = condition_type_text;
                    if( condition_type_value != "" ){
                        filterText += ': '+condition_type_value;
                    }
                    if( condition_type_text == 'None' ){
                        filterText = "";
                    }
                    $('body').find('.last_name_filter_info').text( filterText );
                });
                $('.filter_by_email .filter_csr_ok').on('click', function(){ //notes
                    let eve = jQuery.Event("keyup");
                    eve.which = 13
                    eve.keyCode = 13
                    $notes_internal.trigger(eve);
                    $('#emailFilterModal').modal('hide');
                    var filterNoteForm = $('#filter_by_email');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').text();
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    var filterText = condition_type_text;
                    if( condition_type_value != "" ){
                        filterText += ': '+condition_type_value;
                    }
                    if( condition_type_text == 'None' ){
                        filterText = "";
                    }
                    $('body').find('.email_filter_info').text( filterText );
                });
                $('.filter_by_text_9 .filter_csr_ok').on('click', function(){ //notes
                    let eve = jQuery.Event("keyup");
                    eve.which = 13
                    eve.keyCode = 13
                    $text_9.trigger(eve);
                    $('#text_9FilterModal').modal('hide');
                    var filterNoteForm = $('#filter_by_text_9');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type"] option:selected').text();
                    var condition_type_value = filterNoteForm.find('input[name="filter_condition_value"]').val();
                    var filterText = condition_type_text;
                    if( condition_type_value != "" ){
                        filterText += ': '+condition_type_value;
                    }
                    if( condition_type_text == 'None' ){
                        filterText = "";
                    }
                    $('body').find('.text_9_filter_info').text( filterText );
                });
                $('.filter_by_pool_ref .filter_csr_ok').on('click', function(){ //pool ref
                    let eve = jQuery.Event("keyup");
                    eve.which = 13
                    eve.keyCode = 13
                    $pool_ref.trigger(eve);
                    $('#poolRefFilterModal').modal('hide');
                    var filterNoteForm = $('#filter_by_pool_ref');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type_pool_ref"] option:selected').text();
                    var condition_type = filterNoteForm.find('select[name="filter_condition_type_pool_ref"] option:selected').val();
                    var condition_type_value = filterNoteForm.find('select#filter_condition_value_pool_ref').val();
                    var condition_type_value_bulk = filterNoteForm.find('textarea#filter_condition_value_pool_ref_bulk').val();
                    var filterText = condition_type_text;
                    if( condition_type_value != "" || condition_type_value_bulk != '' ){
                        if( condition_type == 'is_exactly_simple' ){
                            filterText += ': '+condition_type_value_bulk;
                        }else{
                            filterText += ': '+condition_type_value;
                        }
                    }
                    if( condition_type_text == 'None' ){
                        filterText = "";
                    }
                    $('body').find('.pool_ref_filter_info').text( filterText );
                });
                $('.filter_by_distribution_week .filter_csr_ok').on('click', function(){ //distribution_week text_10
                    let eve = jQuery.Event("keyup");
                    eve.which = 13
                    eve.keyCode = 13
                    $pool_ref.trigger(eve);
                    $('#DistributionWeekFilterModal').modal('hide');
                    var filterNoteForm = $('#filter_by_distribution_week');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type_distribution_week"] option:selected').text();
                    var condition_type = filterNoteForm.find('select[name="filter_condition_type_distribution_week"] option:selected').val();
                    var condition_type_value = filterNoteForm.find('select#filter_condition_value_distribution_week').val();
                    var condition_type_value_before = filterNoteForm.find('#filter_condition_value_distribution_week_before').val();
                    var condition_type_value_bulk = filterNoteForm.find('textarea#filter_condition_value_distribution_bulk').val();
                    var filterText = condition_type_text;
                    if( condition_type_value != "" || condition_type_value_bulk != '' || condition_type_value_before != "" ){
                        if( condition_type == 'weeks_before' ){
                            filterText += ': '+condition_type_value_before;
                        }else if( condition_type == 'is_exactly_simple' ){
                            filterText += ': '+condition_type_value_bulk;
                        }else{
                            filterText += ': '+condition_type_value;
                        }
                    }
                    if( condition_type_text == 'None' ){
                        filterText = "";
                    }
                    $('body').find('.distribution_week_filter_info').text( filterText );
                });
                $('.filter_by_username .filter_csr_ok').on('click', function(){ //username
                    let eve = jQuery.Event("keyup");
                    eve.which = 13
                    eve.keyCode = 13
                    $pool_ref.trigger(eve);
                    $('#UsernameFilterModal').modal('hide');
                    var filterNoteForm = $('#filter_by_username');
                    var condition_type_text = filterNoteForm.find('select[name="filter_condition_type_username"] option:selected').text();
                    var condition_type = filterNoteForm.find('select[name="filter_condition_type_username"] option:selected').val();
                    var condition_type_value = filterNoteForm.find('select#filter_condition_value_username').val();
                    var condition_type_value_bulk = filterNoteForm.find('textarea#filter_condition_value_username_bulk').val();
                    var filterText = condition_type_text;
                    if( condition_type_value != "" || condition_type_value_bulk != "" ){
                        if( condition_type == 'is_exactly_simple' ){
                            filterText += ': '+condition_type_value_bulk;
                        }else{
                            filterText += ': '+condition_type_value;
                        }
                    }
                    if( condition_type_text == 'None' ){
                        filterText = "";
                    }
                    $('body').find('.username_filter_info').text( filterText );
                });
                $('form#filter_by_notes, form#filter_by_internalnotes,form#referenceFilterModal,form#eth_addressFilterModal,form#csr_amount_initialFilterModal,form#csr_amount_issuedFilterModal,form#amount_dueFilterModal,form#first_nameFilterModal,form#last_nameFilterModal,form#emailFilterModal, form#filter_by_text_9, form#filter_by_pool_ref, form#filter_by_distribution_week, form#filter_by_username').keydown(function (e) {
                    if (e.keyCode == 13) {
                        $('.filter_csr_ok').trigger('click');
                        e.preventDefault();
                        return false;
                    }
                });
                $('.filter_by_notes .filter_csr_cancel').on('click', function(){
                    $('#notesFilterModal').modal('hide');
                });
                $('.filter_by_internalnotes .filter_csr_cancel').on('click', function(){
                    $('#notesinternalFilterModal').modal('hide');
                });
                $('.filter_by_reference .filter_csr_cancel').on('click', function(){
                    $('#referenceFilterModal').modal('hide');
                });
                $('.filter_by_eth_address .filter_csr_cancel').on('click', function(){
                    $('#eth_addressFilterModal').modal('hide');
                });
                $('.filter_by_csr_amount_initial .filter_csr_cancel').on('click', function(){
                    $('#csr_amount_initialFilterModal').modal('hide');
                });
                $('.filter_by_csr_amount_issued .filter_csr_cancel').on('click', function(){
                    $('#csr_amount_issuedFilterModal').modal('hide');
                });
                $('.filter_by_amount_due .filter_csr_cancel').on('click', function(){
                    $('#amount_dueFilterModal').modal('hide');
                });
                $('.filter_by_first_name .filter_csr_cancel').on('click', function(){
                    $('#first_nameFilterModal').modal('hide');
                });
                $('.filter_by_last_name .filter_csr_cancel').on('click', function(){
                    $('#last_nameFilterModal').modal('hide');
                });
                $('.filter_by_email .filter_csr_cancel').on('click', function(){
                    $('#emailFilterModal').modal('hide');
                });
                $('.filter_by_text_9 .filter_csr_cancel').on('click', function(){
                    $('#text_9FilterModal').modal('hide');
                });
                $('.filter_by_pool_ref .filter_csr_cancel').on('click', function(){
                    $('#poolRefFilterModal').modal('hide');
                });
                $('.filter_by_distribution_week .filter_csr_cancel').on('click', function(){
                    $('#DistributionWeekFilterModal').modal('hide');
                });
                $('.filter_by_username .filter_csr_cancel').on('click', function(){
                    $('#UsernameFilterModal').modal('hide');
                });
                $('.filter_by_pool_ref #filter_condition_value_pool_ref').select2({placeholder: 'Pool Reference',tags: true, selectionCssClass: 'select2_pool_ref hide mt-2', dropdownParent: $('#poolRefFilterModal')});
                $('.filter_by_distribution_week #filter_condition_value_distribution_week').select2({placeholder: 'Distribution Week',tags: true, selectionCssClass: 'select2_distribution_week hide mt-2', dropdownParent: $('#DistributionWeekFilterModal')});
                $('.filter_by_username #filter_condition_value_username').select2({
                    // placeholder: 'Username',tags: true, selectionCssClass: 'select2_username hide mt-2', dropdownParent: $('#UsernameFilterModal')
                    placeholder: 'Username',
                    minimumInputLength: 2,
                    ajax: {
                        url: cipscript.ajax_url,
                        dataType: 'json',
                        data: function (params) {
                            var query = {
                                search: params.term,
                                action: 'username_fetch_act'
                            }
                            return query;
                        }
                    },
                    processResults: function (response) {
                        return {
                        results: response
                        };
                    },
                    selectionCssClass: 'select2_username hide mt-2',
                    dropdownParent: $('#UsernameFilterModal')
                });
                if( $('#tokenholder_list2 .redemption_date').length > 0 ){
                    let dateFormatWD = 'DD/MM/YYYY';
                    $('input.bootstrap-table-filter-control-redemption_date[type="search"]')
                    .daterangepicker({
                            autoUpdateInput: false,
                            locale: {
                                format: dateFormatWD,
                                separator: ' - ',
                                firstDay: 1
                            },
                            opens: 'left',
                            cancelButtonClasses: 'btn-default'
                        },
                    );
                    jQuery('input.bootstrap-table-filter-control-redemption_date[type="search"]').on('apply.daterangepicker', function(ev, picker) {
                        $(this).val(picker.startDate.format(dateFormatWD) + ' - ' + picker.endDate.format(dateFormatWD));
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-redemption_date').trigger(eve);
                    });
                    $('input.bootstrap-table-filter-control-redemption_date[type="search"]').on('cancel.daterangepicker', function(ev, picker) {
                        $(this).val('');
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-redemption_date').trigger(eve);
                    });
                }
                if( $('#tokenholder_list2 .claim_date').length > 0 ){
                    let dateFormatWD = 'DD/MM/YYYY';
                    $('input.bootstrap-table-filter-control-claim_date[type="search"]')
                    .daterangepicker({
                            autoUpdateInput: false,
                            locale: {
                                format: dateFormatWD,
                                separator: ' - ',
                                firstDay: 1
                            },
                            opens: 'left',
                            cancelButtonClasses: 'btn-default'
                        },
                    );
                    jQuery('input.bootstrap-table-filter-control-claim_date[type="search"]').on('apply.daterangepicker', function(ev, picker) {
                        $(this).val(picker.startDate.format(dateFormatWD) + ' - ' + picker.endDate.format(dateFormatWD));
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-claim_date').trigger(eve);
                    });
                    $('input.bootstrap-table-filter-control-claim_date[type="search"]').on('cancel.daterangepicker', function(ev, picker) {
                        $(this).val('');
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-claim_date').trigger(eve);
                    });
                }
                if( $('#tokenholder_list2 .date_1').length > 0 ){
                    let dateFormatWD = 'DD/MM/YYYY';
                    $('input.bootstrap-table-filter-control-date_1[type="search"]')
                    .daterangepicker({
                            autoUpdateInput: false,
                            locale: {
                                format: dateFormatWD,
                                separator: ' - ',
                                firstDay: 1
                            },
                            opens: 'left',
                            cancelButtonClasses: 'btn-default'
                        },
                    );
                    jQuery('input.bootstrap-table-filter-control-date_1[type="search"]').on('apply.daterangepicker', function(ev, picker) {
                        $(this).val(picker.startDate.format(dateFormatWD) + ' - ' + picker.endDate.format(dateFormatWD));
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-date_1').trigger(eve);
                    });
                    $('input.bootstrap-table-filter-control-date_1[type="search"]').on('cancel.daterangepicker', function(ev, picker) {
                        $(this).val('');
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-date_1').trigger(eve);
                    });
                }
                if( $('#tokenholder_list2 .date_2').length > 0 ){
                    let dateFormatWD = 'DD/MM/YYYY';
                    $('input.bootstrap-table-filter-control-date_2[type="search"]')
                    .daterangepicker({
                            autoUpdateInput: false,
                            locale: {
                                format: dateFormatWD,
                                separator: ' - ',
                                firstDay: 1
                            },
                            opens: 'left',
                            cancelButtonClasses: 'btn-default'
                        },
                    );
                    jQuery('input.bootstrap-table-filter-control-date_2[type="search"]').on('apply.daterangepicker', function(ev, picker) {
                        $(this).val(picker.startDate.format(dateFormatWD) + ' - ' + picker.endDate.format(dateFormatWD));
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-date_2').trigger(eve);
                    });
                    $('input.bootstrap-table-filter-control-date_2[type="search"]').on('cancel.daterangepicker', function(ev, picker) {
                        $(this).val('');
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-date_2').trigger(eve);
                    });
                }
                if( $('#tokenholder_list2 .date_3').length > 0 ){
                    let dateFormatWD = 'DD/MM/YYYY';
                    $('input.bootstrap-table-filter-control-date_3[type="search"]')
                    .daterangepicker({
                            autoUpdateInput: false,
                            locale: {
                                format: dateFormatWD,
                                separator: ' - ',
                                firstDay: 1
                            },
                            opens: 'left',
                            cancelButtonClasses: 'btn-default'
                        },
                    );
                    jQuery('input.bootstrap-table-filter-control-date_3[type="search"]').on('apply.daterangepicker', function(ev, picker) {
                        $(this).val(picker.startDate.format(dateFormatWD) + ' - ' + picker.endDate.format(dateFormatWD));
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-date_3').trigger(eve);
                    });
                    $('input.bootstrap-table-filter-control-date_3[type="search"]').on('cancel.daterangepicker', function(ev, picker) {
                        $(this).val('');
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-date_3').trigger(eve);
                    });
                }
                if( $('#tokenholder_list2 .date_4').length > 0 ){
                    let dateFormatWD = 'DD/MM/YYYY';
                    $('input.bootstrap-table-filter-control-date_4[type="search"]')
                    .daterangepicker({
                            autoUpdateInput: false,
                            locale: {
                                format: dateFormatWD,
                                separator: ' - ',
                                firstDay: 1
                            },
                            opens: 'left',
                            cancelButtonClasses: 'btn-default'
                        },
                    );
                    jQuery('input.bootstrap-table-filter-control-date_4[type="search"]').on('apply.daterangepicker', function(ev, picker) {
                        $(this).val(picker.startDate.format(dateFormatWD) + ' - ' + picker.endDate.format(dateFormatWD));
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-date_4').trigger(eve);
                    });
                    $('input.bootstrap-table-filter-control-date_4[type="search"]').on('cancel.daterangepicker', function(ev, picker) {
                        $(this).val('');
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-date_4').trigger(eve);
                    });
                }
                if( $('#tokenholder_list2 .date_5').length > 0 ){
                    let dateFormatWD = 'DD/MM/YYYY';
                    $('input.bootstrap-table-filter-control-date_5[type="search"]')
                    .daterangepicker({
                            autoUpdateInput: false,
                            locale: {
                                format: dateFormatWD,
                                separator: ' - ',
                                firstDay: 1
                            },
                            opens: 'left',
                            cancelButtonClasses: 'btn-default'
                        },
                    );
                    jQuery('input.bootstrap-table-filter-control-date_5[type="search"]').on('apply.daterangepicker', function(ev, picker) {
                        $(this).val(picker.startDate.format(dateFormatWD) + ' - ' + picker.endDate.format(dateFormatWD));
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-date_5').trigger(eve);
                    });
                    $('input.bootstrap-table-filter-control-date_5[type="search"]').on('cancel.daterangepicker', function(ev, picker) {
                        $(this).val('');
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-date_5').trigger(eve);
                    });
                }
                if( $('#tokenholder_list2 .saving_date').length > 0 ){
                    let dateFormatWD = 'DD/MM/YYYY';
                    $('input.bootstrap-table-filter-control-saving_date[type="search"]')
                    .daterangepicker({
                            autoUpdateInput: false,
                            locale: {
                                format: dateFormatWD,
                                separator: ' - ',
                                firstDay: 1
                            },
                            opens: 'left',
                            cancelButtonClasses: 'btn-default'
                        },
                    );
                    jQuery('input.bootstrap-table-filter-control-saving_date[type="search"]').on('apply.daterangepicker', function(ev, picker) {
                        $(this).val(picker.startDate.format(dateFormatWD) + ' - ' + picker.endDate.format(dateFormatWD));
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-saving_date').trigger(eve);
                    });
                    $('input.bootstrap-table-filter-control-saving_date[type="search"]').on('cancel.daterangepicker', function(ev, picker) {
                        $(this).val('');
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-saving_date').trigger(eve);
                    });
                }
                if( $('#tokenholder_list2 .saving_start_date').length > 0 ){
                    let dateFormatWD = 'DD/MM/YYYY';
                    $('input.bootstrap-table-filter-control-saving_start_date[type="search"]')
                    .daterangepicker({
                            autoUpdateInput: false,
                            locale: {
                                format: dateFormatWD,
                                separator: ' - ',
                                firstDay: 1
                            },
                            opens: 'left',
                            cancelButtonClasses: 'btn-default'
                        },
                    );
                    jQuery('input.bootstrap-table-filter-control-saving_start_date[type="search"]').on('apply.daterangepicker', function(ev, picker) {
                        $(this).val(picker.startDate.format(dateFormatWD) + ' - ' + picker.endDate.format(dateFormatWD));
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-saving_start_date').trigger(eve);
                    });
                    $('input.bootstrap-table-filter-control-saving_start_date[type="search"]').on('cancel.daterangepicker', function(ev, picker) {
                        $(this).val('');
                        let eve = jQuery.Event("keyup");
                        eve.which = 13
                        eve.keyCode = 13
                        $('.bootstrap-table-filter-control-saving_start_date').trigger(eve);
                    });
                }
                $(document).on('click','.clear_all_csr_holder',function(e){
                    e.preventDefault;
                    sessionStorage.removeItem("tokenholder_list2_filter");
                    window.location.reload(true)
                })
            }
        });
    </script>
<?php
}
add_action('wp_ajax_tokenholder_list2_loader','cip_tokenholder_list2_loader_cb');
function cip_tokenholder_list2_loader_cb(){
	global $wpdb;
	$tableName = $wpdb->prefix.'token_holder';
	$user_id = get_current_user_id();
	$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableName WHERE 1 ORDER BY `id` DESC");
	$limit = isset( $_POST['limit'] ) ? $_POST['limit'] : 500;
	$offset = isset( $_POST['offset'] ) ? $_POST['offset'] : 0;
	$orderby = isset( $_POST['sort'] ) ? $_POST['sort'] : 'id';
	$order = (isset($_POST['order']) && in_array($_POST['order'], array('asc', 'desc'))) ? $_POST['order'] : 'asc';
	$filter_qry = "";
	$filterByConditions = json_decode( stripslashes( $_REQUEST['filterByCondition'] ), true );
	$filterBy = "";
	$filterByValue = "";
	if( !empty( $filterByConditions ) ){
		$filterBy = $filterByConditions['filter_condition_type'];
		$filterByValue = $filterByConditions['filter_condition_value'];
	}
	$filterByConditioninternalnotes = json_decode( stripslashes( $_REQUEST['filterByConditioninternalnotes'] ), true );
	$internalfilterBy = "";
	$internalfilterByValue = "";
	if( !empty( $filterByConditioninternalnotes ) ){
		$internalfilterBy = $filterByConditioninternalnotes['filter_condition_type'];
		$internalfilterByValue = $filterByConditioninternalnotes['filter_condition_value'];
	}
    $filterByConditionreference = json_decode( stripslashes( $_REQUEST['filterByConditionreference'] ), true );
	$referencefilterBy = "";
	$referencefilterByValue = "";
	if( !empty( $filterByConditionreference ) ){
		$referencefilterBy = $filterByConditionreference['filter_condition_type'];
		$referencefilterByValue = $filterByConditionreference['filter_condition_value'];
	}
    $filterByConditioneth_address = json_decode( stripslashes( $_REQUEST['filterByConditioneth_address'] ), true );
	$eth_addressfilterBy = "";
	$eth_addressfilterByValue = "";
	if( !empty( $filterByConditioneth_address ) ){
		$eth_addressfilterBy = $filterByConditioneth_address['filter_condition_type'];
		$eth_addressfilterByValue = $filterByConditioneth_address['filter_condition_value'];
	}
    $filterByConditioncsr_amount_initial = json_decode( stripslashes( $_REQUEST['filterByConditioncsr_amount_initial'] ), true );
	$csr_amount_initialfilterBy = "";
	$csr_amount_initialfilterByValue = "";
	if( !empty( $filterByConditioncsr_amount_initial ) ){
		$csr_amount_initialfilterBy = $filterByConditioncsr_amount_initial['filter_condition_type'];
		$csr_amount_initialfilterByValue = $filterByConditioncsr_amount_initial['filter_condition_value'];
	}
    $filterByConditioncsr_amount_issued = json_decode( stripslashes( $_REQUEST['filterByConditioncsr_amount_issued'] ), true );
	$csr_amount_issuedfilterBy = "";
	$csr_amount_issuedfilterByValue = "";
	if( !empty( $filterByConditioncsr_amount_issued ) ){
		$csr_amount_issuedfilterBy = $filterByConditioncsr_amount_issued['filter_condition_type'];
		$csr_amount_issuedfilterByValue = $filterByConditioncsr_amount_issued['filter_condition_value'];
	}
    $filterByConditionamount_due = json_decode( stripslashes( $_REQUEST['filterByConditionamount_due'] ), true );
	$amount_duefilterBy = "";
	$amount_duefilterByValue = "";
	if( !empty( $filterByConditionamount_due ) ){
		$amount_duefilterBy = $filterByConditionamount_due['filter_condition_type'];
		$amount_duefilterByValue = $filterByConditionamount_due['filter_condition_value'];
	}
    $filterByConditionfirst_name = json_decode( stripslashes( $_REQUEST['filterByConditionfirst_name'] ), true );
	$first_namefilterBy = "";
	$first_namefilterByValue = "";
	if( !empty( $filterByConditionfirst_name ) ){
		$first_namefilterBy = $filterByConditionfirst_name['filter_condition_type'];
		$first_namefilterByValue = $filterByConditionfirst_name['filter_condition_value'];
	}
    $filterByConditionlast_name = json_decode( stripslashes( $_REQUEST['filterByConditionlast_name'] ), true );
	$last_namefilterBy = "";
	$last_namefilterByValue = "";
	if( !empty( $filterByConditionlast_name ) ){
		$last_namefilterBy = $filterByConditionlast_name['filter_condition_type'];
		$last_namefilterByValue = $filterByConditionlast_name['filter_condition_value'];
	}
    $filterByConditionemail = json_decode( stripslashes( $_REQUEST['filterByConditionemail'] ), true );
	$emailfilterBy = "";
	$emailfilterByValue = "";
	if( !empty( $filterByConditionemail ) ){
		$emailfilterBy = $filterByConditionemail['filter_condition_type'];
		$emailfilterByValue = $filterByConditionemail['filter_condition_value'];
	}
    $filterByConditiontext_9 = json_decode( stripslashes( $_REQUEST['filterByConditiontext_9'] ), true );
	$text_9By = "";
	$text_9ByValue = "";
	if( !empty( $filterByConditiontext_9 ) ){
		$text_9By = $filterByConditiontext_9['filter_condition_type'];
		$text_9ByValue = $filterByConditiontext_9['filter_condition_value'];
	}
	$filterByConditionsPoolRef = json_decode( stripslashes( $_REQUEST['filterByConditionPoolRef'] ), true );
	$filterByPoolRef = "";
	$filterByValuePoolRef = "";
	if( !empty( $filterByConditionsPoolRef ) ){
		$filterByPoolRef = $filterByConditionsPoolRef['filter_condition_type_pool_ref'];
		if( $filterByPoolRef == 'is_exactly_simple' ){
			$filterByValuePoolRef = array_filter( explode(',', $filterByConditionsPoolRef['filter_condition_value_pool_ref_bulk'] ) );
		}else{
			$filterByValuePoolRef = $filterByConditionsPoolRef['filter_condition_value_pool_ref'];
		}
	}
	$filterByConditionsDistributionWeek = json_decode( stripslashes( $_REQUEST['filterByConditionDistributionWeek'] ), true );
	$filterByDistributionWeek = "";
	$filterByValueDistributionWeek = "";
	if( !empty( $filterByConditionsDistributionWeek ) ){
		$filterByDistributionWeek = $filterByConditionsDistributionWeek['filter_condition_type_distribution_week'];
		if( $filterByDistributionWeek == 'weeks_before' ){
			$filterByValueDistributionWeek = array();
			$givenWeeks = explode('/', $filterByConditionsDistributionWeek['filter_condition_value_distribution_week_before']);
			$fromweek = 1;
			$fromyear = 2022;
			$toweek = $givenWeeks[1];
			$toyear = $givenWeeks[0];
			$interval = new DateInterval('P7D');
			$start = (new \DateTime())->setISODate($fromyear, $fromweek);
  			$end = (new \DateTime())->setISODate($toyear, $toweek);
			$period = new \DatePeriod($start, $interval, $end->add($interval));
			foreach($period as $date){
				$filterByValueDistributionWeek[] = $date->format('Y/W');
			}
		}else if( $filterByDistributionWeek == 'is_exactly_simple' ){
			$filterByValueDistributionWeek = array_filter( explode(',', $filterByConditionsDistributionWeek['filter_condition_value_distribution_bulk'] ) );
		}else{
			$filterByValueDistributionWeek = $filterByConditionsDistributionWeek['filter_condition_value_distribution_week'];
		}
	}
	$filterByConditionsUsername = json_decode( stripslashes( $_REQUEST['filterByConditionUsername'] ), true );
	$filterByUsername = "";
	$filterByValueUsername = "";
	if( !empty( $filterByConditionsUsername ) ){
		$filterByUsername = $filterByConditionsUsername['filter_condition_type_username'];
		if( $filterByUsername == 'is_exactly_simple' ){
			$filterByValueUsername = array_filter( explode(',', $filterByConditionsUsername['filter_condition_value_username_bulk'] ) );
		}else{
			$filterByValueUsername = $filterByConditionsUsername['filter_condition_value_username'];
		}
	}
	$filters = json_decode( stripslashes( $_REQUEST['columnfilter'] ), true );
	if( $filterBy != 'none' ){
		$filters['notes_external'] = trim( $filterByValue );
	}
    if( $internalfilterBy != 'none' ){
		$filters['notes_internal'] = trim( $internalfilterByValue );
	}
    if( $csr_amount_initialfilterBy != 'none' ){
		$filters['csr_amount_initial'] = trim( $csr_amount_initialfilterByValue );
	}
    if( $referencefilterBy != 'none' ){
		$filters['reference'] = trim( $referencefilterByValue );
	}
    if( $eth_addressfilterBy != 'none' ){
		$filters['eth_address'] = trim( $eth_addressfilterByValue );
	}
    if( $csr_amount_issuedfilterBy != 'none' ){
		$filters['csr_amount_issued'] = trim( $csr_amount_issuedfilterByValue );
	}
    if( $amount_duefilterBy != 'none' ){
		$filters['amount_due'] = trim( $amount_duefilterByValue );
	}
    if( $first_namefilterBy != 'none' ){
		$filters['first_name'] = trim( $first_namefilterByValue );
	}
    if( $last_namefilterBy != 'none' ){
		$filters['last_name'] = trim( $last_namefilterByValue );
	}
    if( $emailfilterBy != 'none' ){
		$filters['email'] = trim( $emailfilterByValue );
	}
    if( $text_9By != 'none' ){
		$filters['text_9'] = trim( $text_9ByValue );
	}
	if( $filterByPoolRef != 'none' ){
		$filters['pool_ref'] = $filterByValuePoolRef;
	}
	if( $filterByDistributionWeek != 'none' ){
		$filters['text_10'] = $filterByValueDistributionWeek;
	}
	if( $filterByUsername != 'none' ){
		$filters['username'] = $filterByValueUsername;
	}
	if( !empty( $filters ) ){
		$isNumericColumn = array('csr_amount_initial', 'csr_amount_issued', 'amount_due', 'int_1', 'int_2', 'int_3', 'int_4', 'int_5', 'int_6', 'int_7', 'int_8', 'int_9', 'int_10', 'saved_amount');
		$isDateColumn = array('redemption_date', 'claim_date', 'date_1', 'date_2', 'date_3', 'date_4', 'date_5', 'date_6', 'date_7', 'date_8', 'date_9', 'date_10', 'saving_date', 'saving_start_date');
		foreach( $filters as $filterKey => $filterData ){
			if( $filterKey == '_user_status' || $filterKey == 'kyc_status' || $filterKey == 'corp_approved' || $filterKey == 'token' ){
				$filter_qry .= " AND `$filterKey` = '" . $filterData . "'";
			}/* else if( $filterKey == 'username' ){
				$filter_qry .= " AND `$filterKey` like '" . $filterData . "%'";
			} */else if( in_array( $filterKey, $isNumericColumn ) ){ //numeric filter
				if( str_contains($filterData, '-') ){ //between
					$filterDataMinMax = explode('-', $filterData);
					$filter_qry .= " AND `$filterKey` BETWEEN $filterDataMinMax[0] AND $filterDataMinMax[1]";
				}else if( str_contains($filterData, '>') || str_contains($filterData, '>=') || str_contains($filterData, '<') || str_contains($filterData, '<=') || str_contains($filterData, '!=') ){ //Greater than or equal to AND Less than or equal to
					$filter_qry .= " AND `$filterKey` $filterData";
				}else{
					$filter_qry .= " AND `$filterKey` = " . $filterData . "";
				}
			}else if( in_array( $filterKey, $isDateColumn ) ){ //date filter
				if( str_contains($filterData, ' - ') ){
					$filterDataMinMax = explode(' - ', $filterData);
					$filter_qry .= " AND STR_TO_DATE(`$filterKey`,'%d/%m/%Y') BETWEEN STR_TO_DATE('$filterDataMinMax[0]','%d/%m/%Y') AND STR_TO_DATE('$filterDataMinMax[1]','%d/%m/%Y')";
				}else{
					$filter_qry .= " AND STR_TO_DATE(`$filterKey`,'%d/%m/%Y') = STR_TO_DATE('$filterData','%d/%m/%Y')";
				}
			}else if( $filterKey == 'notes_external' ){
				if( $filterBy != 'none' ){
					if( $filterBy == 'is_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
					}else if( $filterBy == 'is_not_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
					}else if( $filterBy == 'contains_text' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}else if( $filterBy == 'does_not_contains_text' ){
						$filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
					}else if( $filterBy == 'starts_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '%| " . $filterData . " %'";
					}else if( $filterBy == 'ends_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '% " . $filterData . " |%'";
					}else if( $filterBy == 'is_exactly' ){
						$filter_qry .= " AND `$filterKey` LIKE '%| " . $filterData . " |%'";
					}
				}
			}else if( $filterKey == 'notes_internal' ){
				if( $internalfilterBy != 'none' ){
					if( $internalfilterBy == 'is_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
					}else if( $internalfilterBy == 'is_not_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
					}else if( $internalfilterBy == 'contains_text' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}else if( $internalfilterBy == 'does_not_contains_text' ){
						$filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
					}else if( $internalfilterBy == 'starts_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
					}else if( $internalfilterBy == 'ends_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
					}else if( $internalfilterBy == 'is_exactly' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}
				}
			}else if( $filterKey == 'csr_amount_initial' ){
				if( $csr_amount_initialfilterBy != 'none' ){
					if( $csr_amount_initialfilterBy == 'is_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
					}else if( $csr_amount_initialfilterBy == 'is_not_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
					}else if( $csr_amount_initialfilterBy == 'contains_text' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}else if( $csr_amount_initialfilterBy == 'does_not_contains_text' ){
						$filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
					}else if( $csr_amount_initialfilterBy == 'starts_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
					}else if( $csr_amount_initialfilterBy == 'ends_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
					}else if( $csr_amount_initialfilterBy == 'is_exactly' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}
				}
			}else if( $filterKey == 'reference' ){
				if( $referencefilterBy != 'none' ){
					if( $referencefilterBy == 'is_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
					}else if( $referencefilterBy == 'is_not_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
					}else if( $referencefilterBy == 'contains_text' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}else if( $referencefilterBy == 'does_not_contains_text' ){
						$filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
					}else if( $referencefilterBy == 'starts_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
					}else if( $referencefilterBy == 'ends_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
					}else if( $referencefilterBy == 'is_exactly' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}
				}
			}else if( $filterKey == 'eth_address' ){
				if( $eth_addressfilterBy != 'none' ){
					if( $eth_addressfilterBy == 'is_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
					}else if( $eth_addressfilterBy == 'is_not_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
					}else if( $eth_addressfilterBy == 'contains_text' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}else if( $eth_addressfilterBy == 'does_not_contains_text' ){
						$filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
					}else if( $eth_addressfilterBy == 'starts_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
					}else if( $eth_addressfilterBy == 'ends_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
					}else if( $eth_addressfilterBy == 'is_exactly' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}
				}
			}else if( $filterKey == 'csr_amount_issued' ){
				if( $csr_amount_issuedfilterBy != 'none' ){
					if( $csr_amount_issuedfilterBy == 'is_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
					}else if( $csr_amount_issuedfilterBy == 'is_not_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
					}else if( $csr_amount_issuedfilterBy == 'contains_text' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}else if( $csr_amount_issuedfilterBy == 'does_not_contains_text' ){
						$filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
					}else if( $csr_amount_issuedfilterBy == 'starts_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
					}else if( $csr_amount_issuedfilterBy == 'ends_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
					}else if( $csr_amount_issuedfilterBy == 'is_exactly' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}
				}
			}else if( $filterKey == 'amount_due' ){
				if( $amount_duefilterBy != 'none' ){
					if( $amount_duefilterBy == 'is_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
					}else if( $amount_duefilterBy == 'is_not_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
					}else if( $amount_duefilterBy == 'contains_text' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}else if( $amount_duefilterBy == 'does_not_contains_text' ){
						$filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
					}else if( $amount_duefilterBy == 'starts_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
					}else if( $amount_duefilterBy == 'ends_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
					}else if( $amount_duefilterBy == 'is_exactly' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}
				}
			}else if( $filterKey == 'first_name' ){
				if( $first_namefilterBy != 'none' ){
					if( $first_namefilterBy == 'is_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
					}else if( $first_namefilterBy == 'is_not_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
					}else if( $first_namefilterBy == 'contains_text' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}else if( $first_namefilterBy == 'does_not_contains_text' ){
						$filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
					}else if( $first_namefilterBy == 'starts_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
					}else if( $first_namefilterBy == 'ends_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
					}else if( $first_namefilterBy == 'is_exactly' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}
				}
			}else if( $filterKey == 'last_name' ){
				if( $last_namefilterBy != 'none' ){
					if( $last_namefilterBy == 'is_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
					}else if( $last_namefilterBy == 'is_not_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
					}else if( $last_namefilterBy == 'contains_text' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}else if( $last_namefilterBy == 'does_not_contains_text' ){
						$filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
					}else if( $last_namefilterBy == 'starts_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
					}else if( $last_namefilterBy == 'ends_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
					}else if( $last_namefilterBy == 'is_exactly' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}
				}
			}else if( $filterKey == 'email' ){
				if( $emailfilterBy != 'none' ){
					if( $emailfilterBy == 'is_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
					}else if( $emailfilterBy == 'is_not_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
					}else if( $emailfilterBy == 'contains_text' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}else if( $emailfilterBy == 'does_not_contains_text' ){
						$filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
					}else if( $emailfilterBy == 'starts_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
					}else if( $emailfilterBy == 'ends_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
					}else if( $emailfilterBy == 'is_exactly' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}
				}
			}else if( $filterKey == 'text_9' ){
				if( $text_9By != 'none' ){
					if( $text_9By == 'is_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
					}else if( $text_9By == 'is_not_empty' ){
						$filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
					}else if( $text_9By == 'contains_text' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}else if( $text_9By == 'does_not_contains_text' ){
						$filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
					}else if( $text_9By == 'starts_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
					}else if( $text_9By == 'ends_with' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
					}else if( $text_9By == 'is_exactly' ){
						$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
					}
				}
			}else if( $filterKey == 'pool_ref' ){
				if( $filterByPoolRef != 'none' ){
					if( $filterByPoolRef == 'is_exactly' || $filterByPoolRef == 'is_exactly_simple' && !empty( $filterData ) ){
						$filter_qry .= " AND `$filterKey` IN ('" . implode("','", $filterData) . "')";
					}
				}
			}else if( $filterKey == 'text_10' ){
				if( $filterByDistributionWeek != 'none' ){
					if( $filterByDistributionWeek == 'is_exactly' || $filterByDistributionWeek == 'weeks_before' || $filterByDistributionWeek == 'is_exactly_simple' && !empty( $filterData ) ){
						$filter_qry .= " AND `$filterKey` IN ('" . implode("','", $filterData) . "')";
					}
				}
			}else if( $filterKey == 'username' ){
				if( $filterByUsername != 'none' ){
					if( ( $filterByUsername == 'is_exactly' || $filterByUsername == 'is_exactly_simple' ) && !empty( $filterData ) ){
						$filter_qry .= " AND `$filterKey` IN ('" . implode("','", $filterData) . "')";
					}
				}
			}else{
				$filter_qry .= " AND `$filterKey` like '%" . $filterData . "%'";
			}
		}
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableName WHERE 1 $filter_qry ORDER BY `id` DESC");
	}
	if( in_array( $orderby, $isDateColumn ) ){
		$orderby = "STR_TO_DATE(`$orderby`,'%d/%m/%Y')";
	}
	$getCurrentMembers = $wpdb->get_results("SELECT * FROM $tableName WHERE 1 $filter_qry ORDER BY $orderby $order LIMIT $limit OFFSET $offset");
	$saUserData = get_user_by( 'id', $user_id );
	global $defaultColumnsArr;
	if( $saUserData && ( in_array( "supportagent", $saUserData->roles ) || in_array( "supportmanager", $saUserData->roles ) ) ){
		$columnOrders = (array)get_option('cip_sm_column_order');
		$columnsLabelArr = (array)get_option('cip_sm_column_labels');
		$columnsSAColumnOption = (array)get_option('cip_column_sa_toggle_columns');
		$columnsSAToggleArr = (array)get_user_meta( $user_id, 'cip_sagent_toggle_columns', true );
		$columnsArr = array();
		if( !empty( $columnOrders ) && is_array( $columnOrders ) ){
			foreach( $columnOrders as $columnOrder ){
				if( isset( $columnsSAToggleArr[$columnOrder] ) ){
					$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
				}
			}
			if( empty( $columnsArr ) ){
				foreach( $columnOrders as $columnOrder ){
					if( isset( $columnsSAColumnOption[$columnOrder] ) ){
						$columnsArr[$columnOrder] = ( isset( $columnsLabelArr[$columnOrder] ) && !empty( $columnsLabelArr[$columnOrder] ) ) ? $columnsLabelArr[$columnOrder] : $defaultColumnsArr[$columnOrder];
					}
				}
			}
		}else{
			unset( $defaultColumnsArr['imported_by'] );
			unset( $defaultColumnsArr['import_at'] );
			unset( $defaultColumnsArr['last_update_at'] );
			$columnsArr = $defaultColumnsArr;
		}
	}else{
		unset( $defaultColumnsArr['imported_by'] );
		unset( $defaultColumnsArr['import_at'] );
		unset( $defaultColumnsArr['last_update_at'] );
		$columnsArr = $defaultColumnsArr;
	}
	$rows = array();
	$partialDeliverIds = array();
	if( $getCurrentMembers ){
		$sno= $_REQUEST['offset'] + 1;
		foreach( $getCurrentMembers as $getCurrentMember ){
			$row = array();
			$row['id'] = $sno;
			$rowEncryptId = base64_encode( $getCurrentMember->id . md5('CIP_WDSELECTION_PIC') );
			$partialDeliverIds[] = $rowEncryptId;
			if( $columnsArr ){
                $columnsArr['token'] = 'Token  ';
				foreach( $columnsArr as $columnKey => $columnsVal ){
					$columnsDataVal = $getCurrentMember->$columnKey;
					$verified = ( $getCurrentMember->sign_verify == 1 ) ? true : false;
					if( $columnKey == 'eth_address' ){
						if( !empty( $columnsDataVal ) ){
							$columnsDataValMask = substr($columnsDataVal, 0, 6) . '...' . substr($columnsDataVal, -6);
							$columnsDataVal = '<a href="https://etherscan.io/address/'. $columnsDataVal . '#tokentxns" target="_blank" data-toggle-tt="tooltip" data-placement="top" title="'.$columnsDataVal.'" >'. $columnsDataValMask . '</a>';
							if( $verified ){ $columnsDataVal .= '<img src="'.CIP_PLUGIN_FOLDER.'/images/verified.png" class="verified_address_sticker" />'; }
						}else{
							$columnsDataVal = '—';
						}
					}
					if( $columnKey == 'notes_internal' || $columnKey == 'notes_external' ){
						$columnsDataVal = cip_trim_notes( $columnsDataVal );
						$columnsDataVal150 = wp_html_excerpt( strip_shortcodes( $columnsDataVal ), 150, '......');
						$columnsDataVal = wp_html_excerpt( strip_shortcodes( $columnsDataVal ), 20, '<a href="javascript:void(0);" class="modelpop_notes" data-toggle="modal" data-target="#viewMoreModal" data-id="'.$getCurrentMember->id.'" data-viewmore="'.wpautop( $columnsDataVal ).'" data-toggle-tt1="tooltip" data-placement1="top" title="'.$columnsDataVal150.'" ><img src="'.CIP_PLUGIN_FOLDER.'/images/view-more.png" class="view-more-notes" /></a>' );
						if( !empty( $columnsDataVal ) ){
							$columnsDataVal = '<div class="width_length_20_hr">' . $columnsDataVal . '</div>';
						}
					}
					if( $columnKey == 'position' ){
						$positionVal = '—';
						$positionText = __('Distribution Position not set... Try back later',CIP_TXTDOMAIN);
						if( $columnsDataVal ){
							$positionVal = $columnsDataVal;
							$positionText = sprintf( __('Distribution Position is set... congratulations you are at position %s in the distribution list',CIP_TXTDOMAIN), $columnsDataVal );
						}
						$columnsDataVal = '<a href="javascript:void(0);" data-id="'.$getCurrentMember->id.'" data-toggle-tt="tooltip" data-placement="top" title="'.$positionText.'" >'.$positionVal.'</a>';
					}
					if($columnKey == 'csr_amount_initial' || $columnKey == 'csr_amount_issued' || $columnKey == 'amount_due' || $columnKey == 'saved_amount'){
						$row[$columnKey] =  cip_number_format($columnsDataVal,false);
					}else{
						$row[$columnKey] = $columnsDataVal;
					}
				}
			}
            $editLink = add_query_arg( array(
				'action' => 'edit',
				'id' => $getCurrentMember->id,
			), get_the_permalink( $_REQUEST['pageid'] ) );
			$unVerifyLink = "";
			if( $verified ){
				$unVerifyLink = '<a href="javascript:void(0);" class="unverify_cth ml-2" data-toggle-tt="tooltip" data-placement="top" title="Unverify" data-eth="'.$getCurrentMember->id.'"><i class="fas fa-undo"></i></a>';
			}
			$row['action'] = '<a href="'.$editLink.'" title="edit"><i class="fas fa-edit"></i></a>'.$unVerifyLink;
			$rows[] = $row;
			$sno=$sno+1;
		}
	}
	$out = array(
		'total'		=>	$total_items,
		'rows'		=>	$rows,
        "test"      =>  "SELECT * FROM $tableName WHERE 1 $filter_qry ORDER BY $orderby $order LIMIT $limit OFFSET $offset"
	);
	echo wp_json_encode( $out );
	exit;
}
add_action( 'wp_ajax_downloadingCsrtokenholder', 'downloadingCsrtokenholder_callback' );
function downloadingCsrtokenholder_callback(){
	$out = array( "error" => 1,'msg' => __('Something went wrong.',CIP_TXTDOMAIN) );
	if( wp_verify_nonce( $_POST['_micro'],'_XyCheckCSRTokenHolderdownloadX_' ) && ( current_user_can( 'supportmanager' ) || current_user_can( 'supportagent' ) ) ){
		$current_user = wp_get_current_user();
		$user_id = $current_user->ID;
		// $corsair_2fa_ga = get_option( 'corsair_2fa_ga' );
		$google_auth_key = get_user_meta( $user_id, 'google_auth_key', true );
		$google_auth_key_walletdelivery = get_user_meta( $user_id, 'google_auth_key_walletdelivery', true );
		$ga2fa_delivery_enabled = ( !empty( $google_auth_key ) && $google_auth_key_walletdelivery == 1 ) ? 1 : 0;
		global $wpdb;
		$tableTokenHolder = $wpdb->prefix.'token_holder';
		$filter_qry = "";
		$filterByConditions = json_decode( stripslashes( $_REQUEST['filterByCondition'] ), true );
		$filterBy = "";
		$filterByValue = "";
		if( !empty( $filterByConditions ) ){
			$filterBy = $filterByConditions['filter_condition_type'];
			$filterByValue = $filterByConditions['filter_condition_value'];
		}
		$filterByConditioninternalnotes = json_decode( stripslashes( $_REQUEST['filterByConditioninternalnotes'] ), true );
        $internalfilterBy = "";
        $internalfilterByValue = "";
        if( !empty( $filterByConditioninternalnotes ) ){
            $internalfilterBy = $filterByConditioninternalnotes['filter_condition_type'];
            $internalfilterByValue = $filterByConditioninternalnotes['filter_condition_value'];
        }
        $filterByConditionreference = json_decode( stripslashes( $_REQUEST['filterByConditionreference'] ), true );
        $referencefilterBy = "";
        $referencefilterByValue = "";
        if( !empty( $filterByConditionreference ) ){
            $referencefilterBy = $filterByConditionreference['filter_condition_type'];
            $referencefilterByValue = $filterByConditionreference['filter_condition_value'];
        }
        $filterByConditioneth_address = json_decode( stripslashes( $_REQUEST['filterByConditioneth_address'] ), true );
        $eth_addressfilterBy = "";
        $eth_addressfilterByValue = "";
        if( !empty( $filterByConditioneth_address ) ){
            $eth_addressfilterBy = $filterByConditioneth_address['filter_condition_type'];
            $eth_addressfilterByValue = $filterByConditioneth_address['filter_condition_value'];
        }
        $filterByConditioncsr_amount_initial = json_decode( stripslashes( $_REQUEST['filterByConditioncsr_amount_initial'] ), true );
        $csr_amount_initialfilterBy = "";
        $csr_amount_initialfilterByValue = "";
        if( !empty( $filterByConditioncsr_amount_initial ) ){
            $csr_amount_initialfilterBy = $filterByConditioncsr_amount_initial['filter_condition_type'];
            $csr_amount_initialfilterByValue = $filterByConditioncsr_amount_initial['filter_condition_value'];
        }
        $filterByConditioncsr_amount_issued = json_decode( stripslashes( $_REQUEST['filterByConditioncsr_amount_issued'] ), true );
        $csr_amount_issuedfilterBy = "";
        $csr_amount_issuedfilterByValue = "";
        if( !empty( $filterByConditioncsr_amount_issued ) ){
            $csr_amount_issuedfilterBy = $filterByConditioncsr_amount_issued['filter_condition_type'];
            $csr_amount_issuedfilterByValue = $filterByConditioncsr_amount_issued['filter_condition_value'];
        }
        $filterByConditionamount_due = json_decode( stripslashes( $_REQUEST['filterByConditionamount_due'] ), true );
        $amount_duefilterBy = "";
        $amount_duefilterByValue = "";
        if( !empty( $filterByConditionamount_due ) ){
            $amount_duefilterBy = $filterByConditionamount_due['filter_condition_type'];
            $amount_duefilterByValue = $filterByConditionamount_due['filter_condition_value'];
        }
        $filterByConditionfirst_name = json_decode( stripslashes( $_REQUEST['filterByConditionfirst_name'] ), true );
        $first_namefilterBy = "";
        $first_namefilterByValue = "";
        if( !empty( $filterByConditionfirst_name ) ){
            $first_namefilterBy = $filterByConditionfirst_name['filter_condition_type'];
            $first_namefilterByValue = $filterByConditionfirst_name['filter_condition_value'];
        }
        $filterByConditionlast_name = json_decode( stripslashes( $_REQUEST['filterByConditionlast_name'] ), true );
        $last_namefilterBy = "";
        $last_namefilterByValue = "";
        if( !empty( $filterByConditionlast_name ) ){
            $last_namefilterBy = $filterByConditionlast_name['filter_condition_type'];
            $last_namefilterByValue = $filterByConditionlast_name['filter_condition_value'];
        }
        $filterByConditionemail = json_decode( stripslashes( $_REQUEST['filterByConditionemail'] ), true );
        $emailfilterBy = "";
        $emailfilterByValue = "";
        if( !empty( $filterByConditionemail ) ){
            $emailfilterBy = $filterByConditionemail['filter_condition_type'];
            $emailfilterByValue = $filterByConditionemail['filter_condition_value'];
        }
        $filterByConditiontext_9 = json_decode( stripslashes( $_REQUEST['filterByConditiontext_9'] ), true );
        $text_9By = "";
        $text_9ByValue = "";
        if( !empty( $filterByConditiontext_9 ) ){
            $text_9By = $filterByConditiontext_9['filter_condition_type'];
            $text_9ByValue = $filterByConditiontext_9['filter_condition_value'];
        }
		$filterByConditionsPoolRef = json_decode( stripslashes( $_REQUEST['filterByConditionPoolRef'] ), true );
		$filterByPoolRef = "";
		$filterByValuePoolRef = "";
		if( !empty( $filterByConditionsPoolRef ) ){
			$filterByPoolRef = $filterByConditionsPoolRef['filter_condition_type_pool_ref'];
			if( $filterByPoolRef == 'is_exactly_simple' ){
				$filterByValuePoolRef = array_filter( explode(',', $filterByConditionsPoolRef['filter_condition_value_pool_ref_bulk'] ) );
			}else{
				$filterByValuePoolRef = $filterByConditionsPoolRef['filter_condition_value_pool_ref'];
			}
		}
		$filterByConditionsDistributionWeek = json_decode( stripslashes( $_REQUEST['filterByConditionDistributionWeek'] ), true );
		$filterByDistributionWeek = "";
		$filterByValueDistributionWeek = "";
		if( !empty( $filterByConditionsDistributionWeek ) ){
			$filterByDistributionWeek = $filterByConditionsDistributionWeek['filter_condition_type_distribution_week'];
			if( $filterByDistributionWeek == 'weeks_before' ){
				$filterByValueDistributionWeek = array();
				$givenWeeks = explode('/', $filterByConditionsDistributionWeek['filter_condition_value_distribution_week_before']);
				$fromweek = 1;
				$fromyear = 2022;
				$toweek = $givenWeeks[1];
				$toyear = $givenWeeks[0];
				$interval = new DateInterval('P7D');
				$start = (new \DateTime())->setISODate($fromyear, $fromweek);
				$end = (new \DateTime())->setISODate($toyear, $toweek);
				$period = new \DatePeriod($start, $interval, $end->add($interval));
				foreach($period as $date){
					$filterByValueDistributionWeek[] = $date->format('Y/W');
				}
			}else if( $filterByDistributionWeek == 'is_exactly_simple' ){
				$filterByValueDistributionWeek = array_filter( explode(',', $filterByConditionsDistributionWeek['filter_condition_value_distribution_bulk'] ) );
			}else{
				$filterByValueDistributionWeek = $filterByConditionsDistributionWeek['filter_condition_value_distribution_week'];
			}
		}
		$filterByConditionsUsername = json_decode( stripslashes( $_REQUEST['filterByConditionUsername'] ), true );
		$filterByUsername = "";
		$filterByValueUsername = "";
		if( !empty( $filterByConditionsUsername ) ){
			$filterByUsername = $filterByConditionsUsername['filter_condition_type_username'];
			if( $filterByUsername == 'is_exactly_simple' ){
				$filterByValueUsername = array_filter( explode(',', $filterByConditionsUsername['filter_condition_value_username_bulk'] ) );
			}else{
				$filterByValueUsername = $filterByConditionsUsername['filter_condition_value_username'];
			}
		}
		$filters = json_decode( stripslashes( $_REQUEST['thisParams'] ), true );
		if( $filterBy != 'none' ){
			$filters['notes_external'] = trim( $filterByValue );
		}
		if( $internalfilterBy != 'none' ){
            $filters['notes_internal'] = trim( $internalfilterByValue );
        }
        if( $csr_amount_initialfilterBy != 'none' ){
            $filters['csr_amount_initial'] = trim( $csr_amount_initialfilterByValue );
        }
        if( $referencefilterBy != 'none' ){
            $filters['reference'] = trim( $referencefilterByValue );
        }
        if( $eth_addressfilterBy != 'none' ){
            $filters['eth_address'] = trim( $eth_addressfilterByValue );
        }
        if( $csr_amount_issuedfilterBy != 'none' ){
            $filters['csr_amount_issued'] = trim( $csr_amount_issuedfilterByValue );
        }
        if( $amount_duefilterBy != 'none' ){
            $filters['amount_due'] = trim( $amount_duefilterByValue );
        }
        if( $first_namefilterBy != 'none' ){
            $filters['first_name'] = trim( $first_namefilterByValue );
        }
        if( $last_namefilterBy != 'none' ){
            $filters['last_name'] = trim( $last_namefilterByValue );
        }
        if( $emailfilterBy != 'none' ){
            $filters['email'] = trim( $emailfilterByValue );
        }
        if( $text_9By != 'none' ){
            $filters['text_9'] = trim( $text_9ByValue );
        }
		if( $filterByPoolRef != 'none' ){
			$filters['pool_ref'] = $filterByValuePoolRef;
		}
		if( $filterByDistributionWeek != 'none' ){
			$filters['text_10'] = $filterByValueDistributionWeek;
		}
		if( $filterByUsername != 'none' ){
			$filters['username'] = $filterByValueUsername;
		}
		$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableTokenHolder WHERE 1");
		$isNumericColumn = array('csr_amount_initial', 'csr_amount_issued', 'amount_due', 'int_1', 'int_2', 'int_3', 'int_4', 'int_5', 'int_6', 'int_7', 'int_8', 'int_9', 'int_10', 'saved_amount');
		$isDateColumn = array('redemption_date', 'claim_date', 'date_1', 'date_2', 'date_3', 'date_4', 'date_5', 'date_6', 'date_7', 'date_8', 'date_9', 'date_10', 'saving_date');
		if( !empty( $filters ) ){
			foreach( $filters as $filterKey => $filterData ){
				if( $filterKey == '_user_status' || $filterKey == 'kyc_status' || $filterKey == 'corp_approved' || $filterKey == 'token' ){
					$filter_qry .= " AND `$filterKey` = '" . $filterData . "'";
				}/* else if( $filterKey == 'username' ){
					$filter_qry .= " AND `$filterKey` like '" . $filterData . "%'";
				} */else if( in_array( $filterKey, $isNumericColumn ) ){ //numeric filter
					if( str_contains($filterData, '-') ){ //between
						$filterDataMinMax = explode('-', $filterData);
						$filter_qry .= " AND `$filterKey` BETWEEN $filterDataMinMax[0] AND $filterDataMinMax[1]";
					}else if( str_contains($filterData, '>') || str_contains($filterData, '>=') || str_contains($filterData, '<') || str_contains($filterData, '<=') || str_contains($filterData, '!=') ){ //Greater than or equal to AND Less than or equal to
						$filter_qry .= " AND `$filterKey` $filterData";
					}else{
						$filter_qry .= " AND `$filterKey` = " . $filterData . "";
					}
				}else if( in_array( $filterKey, $isDateColumn ) ){ //date filter
					if( str_contains($filterData, ' - ') ){
						$filterDataMinMax = explode(' - ', $filterData);
						$filter_qry .= " AND STR_TO_DATE(`$filterKey`,'%d/%m/%Y') BETWEEN STR_TO_DATE('$filterDataMinMax[0]','%d/%m/%Y') AND STR_TO_DATE('$filterDataMinMax[1]','%d/%m/%Y')";
					}else{
						$filter_qry .= " AND STR_TO_DATE(`$filterKey`,'%d/%m/%Y') = STR_TO_DATE('$filterData','%d/%m/%Y')";
					}
				}else if( $filterKey == 'notes_external' ){
					if( $filterBy != 'none' ){
						if( $filterBy == 'is_empty' ){
							$filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
						}else if( $filterBy == 'is_not_empty' ){
							$filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
						}else if( $filterBy == 'contains_text' ){
							$filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
						}else if( $filterBy == 'does_not_contains_text' ){
							$filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
						}else if( $filterBy == 'starts_with' ){
							$filter_qry .= " AND `$filterKey` LIKE '%| " . $filterData . " %'";
						}else if( $filterBy == 'ends_with' ){
							$filter_qry .= " AND `$filterKey` LIKE '% " . $filterData . " |%'";
						}else if( $filterBy == 'is_exactly' ){
							$filter_qry .= " AND `$filterKey` LIKE '%| " . $filterData . " |%'";
						}
					}
				}else if( $filterKey == 'notes_internal' ){
                    if( $internalfilterBy != 'none' ){
                        if( $internalfilterBy == 'is_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
                        }else if( $internalfilterBy == 'is_not_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
                        }else if( $internalfilterBy == 'contains_text' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }else if( $internalfilterBy == 'does_not_contains_text' ){
                            $filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
                        }else if( $internalfilterBy == 'starts_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
                        }else if( $internalfilterBy == 'ends_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
                        }else if( $internalfilterBy == 'is_exactly' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }
                    }
                }else if( $filterKey == 'csr_amount_initial' ){
                    if( $csr_amount_initialfilterBy != 'none' ){
                        if( $csr_amount_initialfilterBy == 'is_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
                        }else if( $csr_amount_initialfilterBy == 'is_not_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
                        }else if( $csr_amount_initialfilterBy == 'contains_text' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }else if( $csr_amount_initialfilterBy == 'does_not_contains_text' ){
                            $filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
                        }else if( $csr_amount_initialfilterBy == 'starts_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
                        }else if( $csr_amount_initialfilterBy == 'ends_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
                        }else if( $csr_amount_initialfilterBy == 'is_exactly' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }
                    }
                }else if( $filterKey == 'reference' ){
                    if( $referencefilterBy != 'none' ){
                        if( $referencefilterBy == 'is_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
                        }else if( $referencefilterBy == 'is_not_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
                        }else if( $referencefilterBy == 'contains_text' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }else if( $referencefilterBy == 'does_not_contains_text' ){
                            $filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
                        }else if( $referencefilterBy == 'starts_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
                        }else if( $referencefilterBy == 'ends_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
                        }else if( $referencefilterBy == 'is_exactly' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }
                    }
                }else if( $filterKey == 'eth_address' ){
                    if( $eth_addressfilterBy != 'none' ){
                        if( $eth_addressfilterBy == 'is_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
                        }else if( $eth_addressfilterBy == 'is_not_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
                        }else if( $eth_addressfilterBy == 'contains_text' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }else if( $eth_addressfilterBy == 'does_not_contains_text' ){
                            $filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
                        }else if( $eth_addressfilterBy == 'starts_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
                        }else if( $eth_addressfilterBy == 'ends_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
                        }else if( $eth_addressfilterBy == 'is_exactly' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }
                    }
                }else if( $filterKey == 'csr_amount_issued' ){
                    if( $csr_amount_issuedfilterBy != 'none' ){
                        if( $csr_amount_issuedfilterBy == 'is_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
                        }else if( $csr_amount_issuedfilterBy == 'is_not_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
                        }else if( $csr_amount_issuedfilterBy == 'contains_text' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }else if( $csr_amount_issuedfilterBy == 'does_not_contains_text' ){
                            $filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
                        }else if( $csr_amount_issuedfilterBy == 'starts_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
                        }else if( $csr_amount_issuedfilterBy == 'ends_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
                        }else if( $csr_amount_issuedfilterBy == 'is_exactly' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }
                    }
                }else if( $filterKey == 'amount_due' ){
                    if( $amount_duefilterBy != 'none' ){
                        if( $amount_duefilterBy == 'is_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
                        }else if( $amount_duefilterBy == 'is_not_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
                        }else if( $amount_duefilterBy == 'contains_text' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }else if( $amount_duefilterBy == 'does_not_contains_text' ){
                            $filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
                        }else if( $amount_duefilterBy == 'starts_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
                        }else if( $amount_duefilterBy == 'ends_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
                        }else if( $amount_duefilterBy == 'is_exactly' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }
                    }
                }else if( $filterKey == 'first_name' ){
                    if( $first_namefilterBy != 'none' ){
                        if( $first_namefilterBy == 'is_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
                        }else if( $first_namefilterBy == 'is_not_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
                        }else if( $first_namefilterBy == 'contains_text' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }else if( $first_namefilterBy == 'does_not_contains_text' ){
                            $filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
                        }else if( $first_namefilterBy == 'starts_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
                        }else if( $first_namefilterBy == 'ends_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
                        }else if( $first_namefilterBy == 'is_exactly' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }
                    }
                }else if( $filterKey == 'last_name' ){
                    if( $last_namefilterBy != 'none' ){
                        if( $last_namefilterBy == 'is_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
                        }else if( $last_namefilterBy == 'is_not_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
                        }else if( $last_namefilterBy == 'contains_text' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }else if( $last_namefilterBy == 'does_not_contains_text' ){
                            $filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
                        }else if( $last_namefilterBy == 'starts_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
                        }else if( $last_namefilterBy == 'ends_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
                        }else if( $last_namefilterBy == 'is_exactly' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }
                    }
                }else if( $filterKey == 'email' ){
                    if( $emailfilterBy != 'none' ){
                        if( $emailfilterBy == 'is_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
                        }else if( $emailfilterBy == 'is_not_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
                        }else if( $emailfilterBy == 'contains_text' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }else if( $emailfilterBy == 'does_not_contains_text' ){
                            $filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
                        }else if( $emailfilterBy == 'starts_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
                        }else if( $emailfilterBy == 'ends_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
                        }else if( $emailfilterBy == 'is_exactly' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }
                    }
                }else if( $filterKey == 'text_9' ){
                    if( $text_9By != 'none' ){
                        if( $text_9By == 'is_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NULL OR `$filterKey` = '' )";
                        }else if( $text_9By == 'is_not_empty' ){
                            $filter_qry .= " AND ( `$filterKey` IS NOT NULL AND `$filterKey` <> '' )";
                        }else if( $text_9By == 'contains_text' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }else if( $text_9By == 'does_not_contains_text' ){
                            $filter_qry .= " AND `$filterKey` NOT LIKE '%" . $filterData . "%'";
                        }else if( $text_9By == 'starts_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '" . $filterData . "%'";
                        }else if( $text_9By == 'ends_with' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "'";
                        }else if( $text_9By == 'is_exactly' ){
                            $filter_qry .= " AND `$filterKey` LIKE '%" . $filterData . "%'";
                        }
                    }
                }else if( $filterKey == 'pool_ref' ){
					if( $filterByPoolRef != 'none' ){
						if( $filterByPoolRef == 'is_exactly' || $filterByPoolRef == 'is_exactly_simple' && !empty( $filterData ) ){
							$filter_qry .= " AND `$filterKey` IN ('" . implode("','", $filterData) . "')";
						}
					}
				}else if( $filterKey == 'text_10' ){
					if( $filterByDistributionWeek != 'none' ){
						if( $filterByDistributionWeek == 'is_exactly' || $filterByDistributionWeek == 'weeks_before' || $filterByDistributionWeek == 'is_exactly_simple' && !empty( $filterData ) ){
							$filter_qry .= " AND `$filterKey` IN ('" . implode("','", $filterData) . "')";
						}
					}
				}else if( $filterKey == 'username' ){
					if( $filterByUsername != 'none' ){
						if( ( $filterByUsername == 'is_exactly' || $filterByUsername == 'is_exactly_simple' ) && !empty( $filterData ) ){
							$filter_qry .= " AND `$filterKey` IN ('" . implode("','", $filterData) . "')";
						}
					}
				}else{
					$filter_qry .= " AND `$filterKey` like '%" . $filterData . "%'";
				}
			}
			$total_items = $wpdb->get_var("SELECT COUNT(id) FROM $tableTokenHolder WHERE 1 $filter_qry");
		}
		$getCurrentMembers = $wpdb->get_results("SELECT * FROM $tableTokenHolder WHERE 1 $filter_qry");
		$exportFile = fopen('php://memory', 'w');
		$columnHeader = array( 'reference', 'eth_address', 'occurs_times', 'csr_initial', 'csramount_by_ethaddress', 'csr_issued', 'csr_due', 'username', 'csramount_byusername', 'occurs_times_user', 'first_name', 'last_name', 'redemption_date', 'claim_date', 'email', '_user_status', 'kyc_status', 'pool_ref', 'approvedkyc', 'corp_approved', 'notes_external', 'notes_internal', 'Position', 'text_1', 'text_2', 'text_3', 'text_4', 'text_5', 'text_6', 'text_7', 'text_8', 'text_9', 'text_10', 'date_1', 'date_2', 'date_3', 'date_4', 'date_5', 'date_6', 'date_7', 'date_8', 'date_9', 'date_10', 'int_1', 'int_2', 'int_3', 'int_4', 'int_5', 'int_6', 'int_7', 'int_8', 'int_9', 'int_10', 'note_1', 'note_2', 'note_3', 'note_4', 'note_5', 'note_6', 'note_7', 'note_8', 'note_9', 'note_10', 'imported_by', 'import_at', 'last_update_at', 'saved_amount', 'saving_date', 'saving_start_date', 'saving_interest', 'saving_periods', 'saving_state', 'sign_verify', 'transhash', 'contract_address', 'receiver_address', 'ma_enabled', 'token' );
		fputcsv($exportFile, $columnHeader);
		if( $getCurrentMembers ){
			foreach( $getCurrentMembers as $getCurrentMember ){
				$redemption_date_formatted = "";
				if( $getCurrentMember->redemption_date ){
					$formattedRDate = DateTime::createFromFormat( 'd/m/Y', $getCurrentMember->redemption_date );
					if( $formattedRDate ){
						$redemption_date_formatted = $formattedRDate->format('d/m/Y');
					}
				}
				$claim_date_formatted = "";
				if( $getCurrentMember->claim_date ){
					$formattedCDate = DateTime::createFromFormat( 'd/m/Y', $getCurrentMember->claim_date );
					if( $formattedCDate ){
						$claim_date_formatted = $formattedCDate->format('d/m/Y');
					}
				}
				$rowData = array( $getCurrentMember->reference, $getCurrentMember->eth_address, $getCurrentMember->occurs_times, $getCurrentMember->csr_amount_initial, $getCurrentMember->csramount_by_ethaddress, $getCurrentMember->csr_amount_issued, $getCurrentMember->amount_due, $getCurrentMember->username, $getCurrentMember->csramount_byusername, $getCurrentMember->occurs_times_user, $getCurrentMember->first_name, $getCurrentMember->last_name, $redemption_date_formatted, $claim_date_formatted, $getCurrentMember->email, $getCurrentMember->_user_status, $getCurrentMember->kyc_status, $getCurrentMember->pool_ref, $getCurrentMember->approvedkyc, $getCurrentMember->corp_approved, $getCurrentMember->notes_external, $getCurrentMember->notes_internal, $getCurrentMember->position, $getCurrentMember->text_1, $getCurrentMember->text_2, $getCurrentMember->text_3, $getCurrentMember->text_4, $getCurrentMember->text_5, $getCurrentMember->text_6, $getCurrentMember->text_7, $getCurrentMember->text_8, $getCurrentMember->text_9, $getCurrentMember->text_10, $getCurrentMember->date_1, $getCurrentMember->date_2, $getCurrentMember->date_3, $getCurrentMember->date_4, $getCurrentMember->date_5, $getCurrentMember->date_6, $getCurrentMember->date_7, $getCurrentMember->date_8, $getCurrentMember->date_9, $getCurrentMember->date_10, $getCurrentMember->int_1, $getCurrentMember->int_2, $getCurrentMember->int_3, $getCurrentMember->int_4, $getCurrentMember->int_5, $getCurrentMember->int_6, $getCurrentMember->int_7, $getCurrentMember->int_8, $getCurrentMember->int_9, $getCurrentMember->int_10, $getCurrentMember->note_1, $getCurrentMember->note_2, $getCurrentMember->note_3, $getCurrentMember->note_4, $getCurrentMember->note_5, $getCurrentMember->note_6, $getCurrentMember->note_7, $getCurrentMember->note_8, $getCurrentMember->note_9, $getCurrentMember->note_10, $getCurrentMember->imported_by, $getCurrentMember->import_at, $getCurrentMember->last_update_at, $getCurrentMember->saved_amount, $getCurrentMember->saving_date, $getCurrentMember->saving_start_date, $getCurrentMember->saving_interest, $getCurrentMember->saving_periods, $getCurrentMember->saving_state, $getCurrentMember->sign_verify, $getCurrentMember->transhash, $getCurrentMember->contract_address, $getCurrentMember->receiver_address, $getCurrentMember->ma_enabled, $getCurrentMember->token );
				fputcsv($exportFile, $rowData);
			}
		}
		$current_user = wp_get_current_user();
		$logs = sprintf( __('Token Holder`s download by %s at %s', CIP_TXTDOMAIN), $current_user->user_email, date_i18n('d/m/Y H:i A') );
		create_cip_logs_entery( $current_user->ID, 'sa', '','sa', $logs, true );
		fseek($exportFile, 0);
		$file_name = 'TokenHolder-'.date_i18n('d-m-Y H-i-s');
		header('content-type:application/csv;charset=UTF-8');
		header('Content-Disposition: attachment; filename="'.$file_name.'.csv"');
		fpassthru($exportFile);
		fclose($exportFile);
		exit;
	}
	echo wp_json_encode( $out );
	exit;
}