<?php
function sm_create_account_form(){

    wp_enqueue_style( 'bs-select-style' );
	wp_enqueue_script('bs-select-js');

    global $wpdb;
    $wpdb_prefix = $wpdb->prefix;
    $invoice= $wpdb_prefix.'cip_member_invoice';
    $invoice_record = "SELECT DISTINCT Email FROM $invoice";
    $invoice_result = $wpdb->get_results($invoice_record);
    
    ?>
    <form method="post">
        <div class="row">
            <div class="col-lg-6 col-md-6 col-12">
                <label style="color:#fff;" for="assignedTo"><?php _e('Assigned To', CIP_TXTDOMAIN); ?></label><br>
                <select class="selectpicker" data-live-search="true" name="assign_to" id="assign_to">
                    <option value=""><?php _e('Select Email', CIP_TXTDOMAIN); ?></option>
                    <?php
                        foreach($invoice_result as $row){
                            $assign_to = $row->Email;
                            ?> 
                            <option value="<?php echo $assign_to; ?>" <?php echo (isset($_POST['assign_to']) && $_POST['assign_to'] === $assign_to) ? 'selected' : ''; ?>>
                                <?php echo $assign_to; ?>
                            </option>
                        <?php 
                        }
                    ?> 
				</select>
            </div>
           
            <div class="col-lg-6 col-md-6 col-12">
                <label style="color:#fff;" for="holder"><?php _e('Account Holder', CIP_TXTDOMAIN); ?></label><br>
                
                <input type="text" name="holder" class="form-control" aria-describedby="emailHelp" placeholder="Enter Account Holder" required />
            </div>

        </div>
        <div class="row">
            <div class="col-lg-4 col-md-4 col-12 mt-3">
                <label style="color:#fff;" for="website"><?php _e('BIC', CIP_TXTDOMAIN); ?></label><br>
                <input class="form-control" type="text" placeholder="Enter BIC" name="bic">
            </div>

            <div class="col-lg-4 col-md-4 col-12 mt-3">
                <label style="color:#fff;" for="number"><?php _e('Bank Code', CIP_TXTDOMAIN); ?></label><br>
                <input class="form-control" type="number" placeholder="Enter Bank Code" name="bcode">
            </div>

            <div class="col-lg-4 col-md-4 col-12 mt-3">
                <label style="color:#fff;" for="firstname"> <?php _e('IBAN', CIP_TXTDOMAIN); ?></label><br>
                <input class="form-control" type="text" placeholder="Enter IBAN" name="iban" required />
            </div>
        </div>
		
		 <div class="row">
            <div class="col-lg-6 col-md-6 col-12 mt-3">
                 <label style="color:#fff;" for="website"><?php _e('Bank Name', CIP_TXTDOMAIN); ?></label><br>
            	 <input class="form-control" type="text" placeholder="Enter Bank Name" name="bname">
            </div>

            <div class="col-lg-6 col-md-6 col-12 mt-3">
                <label style="color:#fff;" for="number"><?php _e('Status', CIP_TXTDOMAIN); ?></label><br>
				<select name="status">
					<option><?php _e('Active', CIP_TXTDOMAIN); ?></option>
					<option><?php _e('In-Active', CIP_TXTDOMAIN); ?></option>
				</select>
            </div>
        </div>

        <div class="mt-3">
            <label style="color:#fff;" for="website"><?php _e('Bank Address', CIP_TXTDOMAIN); ?></label><br>
            <textarea class="form-control" placeholder="Enter Bank Address" name="baddress"></textarea><br>
        </div>
        
        <div>
            <input type="submit" class="btn btn-primary" name="submit" value="Submit"/>
</div>  
    </form>
    <?php
    if(isset($_POST['submit']))
	{
		require_once 'sm_add_account.php';
        //Calling Function
        sm_add_new_account_details();
	}	
}
?>